/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.test;

import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.backends.lwjgl.LwjglApplication;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.PerspectiveCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g3d.loaders.ModelLoaderRegistry;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.materials.TextureAttribute;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedAnimation;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedModel;
import com.badlogic.gdx.graphics.g3d.model.keyframe.KeyframedSubMesh;
import com.badlogic.gdx.graphics.glutils.ImmediateModeRenderer10;
import com.badlogic.gdx.math.collision.BoundingBox;

public class KeyframedModelViewer
implements ApplicationListener {
    PerspectiveCamera cam;
    KeyframedModel model;
    Texture texture = null;
    boolean hasNormals = false;
    BoundingBox bounds = new BoundingBox();
    ImmediateModeRenderer10 renderer;
    float angle = 0.0f;
    String fileName;
    String textureFileName;
    KeyframedAnimation anim;
    float animTime = 0.0f;
    SpriteBatch batch;
    BitmapFont font;
    float[] lightColor = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
    float[] lightPosition = new float[]{2.0f, 5.0f, 10.0f, 0.0f};

    public KeyframedModelViewer(String fileName, String textureFileName) {
        this.fileName = fileName;
        this.textureFileName = textureFileName;
    }

    @Override
    public void create() {
        this.model = ModelLoaderRegistry.loadKeyframedModel(Gdx.files.internal(this.fileName));
        if (this.textureFileName != null) {
            this.texture = new Texture(Gdx.files.internal(this.textureFileName), Pixmap.Format.RGB565, true);
        }
        this.model.setMaterial(new Material("default", new TextureAttribute(this.texture, 0, "skin")));
        this.hasNormals = this.hasNormals();
        this.anim = this.model.getAnimations()[0];
        this.model.getBoundingBox(this.bounds);
        float len = this.bounds.getDimensions().len();
        System.out.println("bounds: " + this.bounds);
        this.cam = new PerspectiveCamera(67.0f, Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.cam.position.set(this.bounds.getCenter().cpy().add(len, len, len));
        this.cam.lookAt(this.bounds.getCenter().x, this.bounds.getCenter().y, this.bounds.getCenter().z);
        this.cam.near = 1.0f;
        this.cam.far = 1000.0f;
        this.renderer = new ImmediateModeRenderer10();
        this.batch = new SpriteBatch();
        this.font = new BitmapFont();
    }

    private boolean hasNormals() {
        KeyframedSubMesh[] keyframedSubMeshArray = this.model.subMeshes;
        int n = this.model.subMeshes.length;
        int n2 = 0;
        while (n2 < n) {
            KeyframedSubMesh mesh = keyframedSubMeshArray[n2];
            if (mesh.mesh.getVertexAttribute(2) == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void resume() {
    }

    @Override
    public void render() {
        Gdx.gl.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
        Gdx.gl.glClear(16640);
        Gdx.gl.glEnable(2929);
        this.cam.update();
        this.cam.apply(Gdx.gl10);
        this.drawAxes();
        if (this.hasNormals) {
            Gdx.gl.glEnable(2896);
            Gdx.gl.glEnable(2903);
            Gdx.gl.glEnable(16384);
            Gdx.gl10.glLightfv(16384, 4609, this.lightColor, 0);
            Gdx.gl10.glLightfv(16384, 4611, this.lightPosition, 0);
        }
        if (this.texture != null) {
            Gdx.gl.glEnable(3553);
            this.texture.bind();
        }
        this.angle += 45.0f * Gdx.graphics.getDeltaTime();
        this.animTime += Gdx.graphics.getDeltaTime();
        if (this.animTime >= this.anim.totalDuration) {
            this.animTime = 0.0f;
        }
        this.model.setAnimation(this.anim.name, this.animTime, false);
        int i = 0;
        while (i < 20) {
            Gdx.gl10.glPushMatrix();
            Gdx.gl10.glTranslatef(0.0f, 0.0f, -100 + i * 10);
            this.model.render();
            Gdx.gl10.glPopMatrix();
            ++i;
        }
        if (this.texture != null) {
            Gdx.gl.glDisable(3553);
        }
        if (this.hasNormals) {
            Gdx.gl.glDisable(2896);
        }
        this.batch.begin();
        this.font.setColor(Color.RED);
        this.font.draw(this.batch, "fps: " + Gdx.graphics.getFramesPerSecond(), 20.0f, 30.0f);
        this.batch.end();
    }

    private void drawAxes() {
        float len = this.bounds.getDimensions().len();
        this.renderer.begin(1);
        this.renderer.color(1.0f, 0.0f, 0.0f, 1.0f);
        this.renderer.vertex(0.0f, 0.0f, 0.0f);
        this.renderer.color(1.0f, 0.0f, 0.0f, 1.0f);
        this.renderer.vertex(len, 0.0f, 0.0f);
        this.renderer.color(0.0f, 1.0f, 0.0f, 1.0f);
        this.renderer.vertex(0.0f, 0.0f, 0.0f);
        this.renderer.color(0.0f, 1.0f, 0.0f, 1.0f);
        this.renderer.vertex(0.0f, len, 0.0f);
        this.renderer.color(0.0f, 0.0f, 1.0f, 1.0f);
        this.renderer.vertex(0.0f, 0.0f, 0.0f);
        this.renderer.color(0.0f, 0.0f, 1.0f, 1.0f);
        this.renderer.vertex(0.0f, 0.0f, len);
        this.renderer.end();
        Gdx.gl10.glColor4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void resize(int width, int height) {
    }

    @Override
    public void pause() {
    }

    @Override
    public void dispose() {
    }

    public static void main(String[] argv) {
        new LwjglApplication(new KeyframedModelViewer("data/models/knight.md2", "data/models/knight.jpg"), "KeframedModel Viewer", 800, 480, false);
    }
}

