/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.model.skeleton;

import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonAnimation;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonJoint;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonKeyframe;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import java.util.HashMap;
import java.util.Map;

public class Skeleton {
    public final Array<SkeletonJoint> hierarchy = new Array();
    public final Array<String> jointNames = new Array();
    public final Map<String, Integer> namesToIndices = new HashMap<String, Integer>();
    public final Array<SkeletonKeyframe> bindPoseJoints = new Array();
    public final Array<SkeletonKeyframe> animPoseJoints = new Array();
    public final Array<Matrix4> offsetMatrices = new Array();
    public final Array<Matrix4> sceneMatrices = new Array();
    public final Array<Matrix4> combinedMatrices = new Array();
    public final ObjectMap<String, SkeletonAnimation> animations = new ObjectMap();
    private static final Matrix4 IDENTITY = new Matrix4();
    private final Matrix4 rotMatrix = new Matrix4();

    public void buildFromHierarchy() {
        this.jointNames.clear();
        this.namesToIndices.clear();
        this.bindPoseJoints.clear();
        this.animPoseJoints.clear();
        this.offsetMatrices.clear();
        this.sceneMatrices.clear();
        int i = 0;
        while (i < this.hierarchy.size) {
            this.recursiveFill(this.hierarchy.get(i));
            ++i;
        }
        this.calculateMatrices(this.bindPoseJoints);
        this.calculateOffsetMatrices();
    }

    private void recursiveFill(SkeletonJoint joint) {
        joint.index = this.bindPoseJoints.size;
        joint.parentIndex = joint.parent != null ? joint.parent.index : -1;
        SkeletonKeyframe keyFrame = new SkeletonKeyframe();
        keyFrame.position.set(joint.position);
        keyFrame.scale.set(joint.scale);
        keyFrame.rotation.set(joint.rotation);
        keyFrame.parentIndex = joint.parentIndex;
        this.jointNames.add(joint.name);
        this.namesToIndices.put(joint.name, joint.index);
        this.bindPoseJoints.add(keyFrame);
        SkeletonKeyframe animKeyframe = new SkeletonKeyframe();
        animKeyframe.parentIndex = joint.parentIndex;
        this.animPoseJoints.add(animKeyframe);
        this.offsetMatrices.add(new Matrix4());
        this.sceneMatrices.add(new Matrix4());
        this.combinedMatrices.add(new Matrix4());
        int len = joint.children.size;
        int i = 0;
        while (i < len) {
            this.recursiveFill(joint.children.get(i));
            ++i;
        }
    }

    protected void calculateOffsetMatrices() {
        int i = 0;
        while (i < this.offsetMatrices.size) {
            this.offsetMatrices.get(i).set(this.sceneMatrices.get(i)).inv();
            ++i;
        }
    }

    protected void calculateMatrices(Array<SkeletonKeyframe> joints) {
        int i = 0;
        while (i < joints.size) {
            SkeletonKeyframe joint = joints.get(i);
            Matrix4 sceneMatrix = this.sceneMatrices.get(i);
            Matrix4 parentMatrix = joint.parentIndex != -1 ? this.sceneMatrices.get(joint.parentIndex) : IDENTITY;
            Matrix4 combinedMatrix = this.combinedMatrices.get(i);
            joint.rotation.toMatrix(this.rotMatrix.val);
            this.rotMatrix.trn(joint.position);
            this.rotMatrix.scl(joint.scale);
            sceneMatrix.set(parentMatrix);
            sceneMatrix.mul(this.rotMatrix);
            combinedMatrix.set(sceneMatrix);
            combinedMatrix.mul(this.offsetMatrices.get(i));
            ++i;
        }
    }

    public void setAnimation(String name, float time) {
        SkeletonAnimation anim = this.animations.get(name);
        if (anim == null) {
            throw new IllegalArgumentException("Animation with name '" + name + "' does not exist");
        }
        if (time < 0.0f || time > anim.totalDuration) {
            throw new IllegalArgumentException("time must be 0 <= time <= animation duration");
        }
        int len = anim.perJointkeyFrames.length;
        int i = 0;
        while (i < len) {
            SkeletonKeyframe[] jointTrack = anim.perJointkeyFrames[i];
            int idx = 0;
            int len2 = jointTrack.length;
            int j = 0;
            while (j < len2) {
                SkeletonKeyframe jointFrame = jointTrack[j];
                if (jointFrame.timeStamp >= time) {
                    idx = Math.max(0, j - 1);
                    break;
                }
                ++j;
            }
            SkeletonKeyframe startFrame = jointTrack[idx];
            SkeletonKeyframe endFrame = idx + 1 == len2 ? startFrame : jointTrack[idx + 1];
            float alpha = 0.0f;
            if (startFrame != endFrame) {
                alpha = Math.min(1.0f, (time - startFrame.timeStamp) / (endFrame.timeStamp - startFrame.timeStamp));
            }
            SkeletonKeyframe animFrame = this.animPoseJoints.get(i);
            animFrame.position.set(startFrame.position).lerp(endFrame.position, alpha);
            animFrame.scale.set(startFrame.scale).lerp(endFrame.scale, alpha);
            animFrame.rotation.set(startFrame.rotation).slerp(endFrame.rotation, alpha);
            ++i;
        }
        this.calculateMatrices(this.animPoseJoints);
    }

    public void setBindPose() {
        this.calculateMatrices(this.bindPoseJoints);
    }
}

