/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.materials;

import com.badlogic.gdx.graphics.g3d.experimental.MaterialShaderHandler;
import com.badlogic.gdx.graphics.g3d.materials.BlendingAttribute;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Array;

public class Material {
    protected String name;
    public Array<MaterialAttribute> attributes;
    protected boolean needBlending;
    protected ShaderProgram shader;

    public ShaderProgram getShader() {
        return this.shader;
    }

    public Material() {
        this.attributes = new Array(2);
    }

    public Material(String name, Array<MaterialAttribute> attributes) {
        this.name = name;
        this.attributes = attributes;
        this.needBlending = false;
        int i = 0;
        while (i < this.attributes.size) {
            if (this.attributes.get(i) instanceof BlendingAttribute) {
                this.needBlending = true;
                break;
            }
            ++i;
        }
    }

    public Material(String name, MaterialAttribute ... attributes) {
        this.name = name;
        this.attributes = new Array<MaterialAttribute>(attributes);
        this.needBlending = false;
        int i = 0;
        while (i < this.attributes.size) {
            if (this.attributes.get(i) instanceof BlendingAttribute) {
                this.needBlending = true;
                break;
            }
            ++i;
        }
    }

    public void bind() {
        int i = 0;
        while (i < this.attributes.size) {
            this.attributes.get(i).bind();
            ++i;
        }
    }

    public void bind(ShaderProgram program) {
        int i = 0;
        while (i < this.attributes.size) {
            this.attributes.get(i).bind(program);
            ++i;
        }
    }

    public String getName() {
        return this.name;
    }

    public Material copy() {
        Array<MaterialAttribute> attributes = new Array<MaterialAttribute>(this.attributes.size);
        int i = 0;
        while (i < attributes.size) {
            attributes.add(this.attributes.get(i).copy());
            ++i;
        }
        Material copy = new Material(this.name, attributes);
        copy.shader = this.shader;
        return copy;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Material other = (Material)obj;
        if (other.attributes.size != this.attributes.size) {
            return false;
        }
        int i = 0;
        while (i < this.attributes.size) {
            if (!this.attributes.get(i).equals(other.attributes.get(i))) {
                return false;
            }
            ++i;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public boolean shaderEquals(Material other) {
        if (this == other) {
            return true;
        }
        int len = this.attributes.size;
        if (len != other.attributes.size) {
            return false;
        }
        int i = 0;
        while (i < len) {
            String str = this.attributes.get((int)i).name;
            if (str == null) {
                return false;
            }
            boolean matchFound = false;
            int j = 0;
            while (j < len) {
                if (str.equals(other.attributes.get((int)j).name)) {
                    matchFound = true;
                    break;
                }
                ++j;
            }
            if (!matchFound) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void setPooled(Material material) {
        this.name = material.name;
        this.shader = material.shader;
        this.needBlending = material.needBlending;
        this.attributes.clear();
        int i = 0;
        int len = material.attributes.size;
        while (i < len) {
            this.attributes.add(material.attributes.get(i).pooledCopy());
            ++i;
        }
    }

    public boolean isNeedBlending() {
        return this.needBlending;
    }

    public void resetShader() {
        this.shader = null;
    }

    public void generateShader(MaterialShaderHandler materialShaderHandler) {
        this.shader = materialShaderHandler.getShader(this);
    }
}

