/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.materials;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.utils.Pool;

public class BlendingAttribute
extends MaterialAttribute {
    public static final String translucent = "translucent";
    public int blendSrcFunc;
    public int blendDstFunc;
    private static final Pool<BlendingAttribute> pool = new Pool<BlendingAttribute>(){

        @Override
        protected BlendingAttribute newObject() {
            return new BlendingAttribute();
        }
    };

    protected BlendingAttribute() {
    }

    public BlendingAttribute(String name) {
        this(name, 770, 771);
    }

    public BlendingAttribute(String name, int srcFunc, int dstFunc) {
        super(name);
        this.blendSrcFunc = srcFunc;
        this.blendDstFunc = dstFunc;
    }

    @Override
    public void bind() {
        Gdx.gl.glBlendFunc(this.blendSrcFunc, this.blendDstFunc);
    }

    @Override
    public void bind(ShaderProgram program) {
        Gdx.gl.glBlendFunc(this.blendSrcFunc, this.blendDstFunc);
    }

    @Override
    public MaterialAttribute copy() {
        return new BlendingAttribute(this.name, this.blendSrcFunc, this.blendDstFunc);
    }

    @Override
    public void set(MaterialAttribute attr) {
        BlendingAttribute blendAttr = (BlendingAttribute)attr;
        this.name = blendAttr.name;
        this.blendDstFunc = blendAttr.blendDstFunc;
        this.blendSrcFunc = blendAttr.blendSrcFunc;
    }

    @Override
    public MaterialAttribute pooledCopy() {
        BlendingAttribute attr = pool.obtain();
        attr.set(this);
        return attr;
    }

    @Override
    public void free() {
        if (this.isPooled) {
            pool.free(this);
        }
    }
}

