/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.wavefront;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.ModelLoaderHints;
import com.badlogic.gdx.graphics.g3d.loaders.StillModelLoader;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.graphics.g3d.model.still.StillSubMesh;
import com.badlogic.gdx.utils.FloatArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class ObjLoader
implements StillModelLoader {
    final FloatArray verts = new FloatArray(300);
    final FloatArray norms = new FloatArray(300);
    final FloatArray uvs = new FloatArray(200);
    final ArrayList<Group> groups = new ArrayList(10);

    public StillModel loadObj(FileHandle file) {
        return this.loadObj(file, false);
    }

    /*
     * Unable to fully structure code
     */
    public StillModel loadObj(FileHandle file, boolean flipV) {
        activeGroup = new Group("default");
        this.groups.add(activeGroup);
        reader = new BufferedReader(new InputStreamReader(file.read()), 4096);
lbl5:
        // 2 sources

        try {
            while ((line = reader.readLine()) != null) {
                block30: {
                    tokens = line.split("\\s+");
                    if (tokens[0].length() == 0 || (firstChar = tokens[0].toLowerCase().charAt(0)) == '#') continue;
                    if (firstChar == 'v') {
                        if (tokens[0].length() == 1) {
                            this.verts.add(Float.parseFloat(tokens[1]));
                            this.verts.add(Float.parseFloat(tokens[2]));
                            this.verts.add(Float.parseFloat(tokens[3]));
                            continue;
                        }
                        if (tokens[0].charAt(1) == 'n') {
                            this.norms.add(Float.parseFloat(tokens[1]));
                            this.norms.add(Float.parseFloat(tokens[2]));
                            this.norms.add(Float.parseFloat(tokens[3]));
                            continue;
                        }
                        if (tokens[0].charAt(1) != 't') continue;
                        this.uvs.add(Float.parseFloat(tokens[1]));
                        this.uvs.add(flipV != false ? 1.0f - Float.parseFloat(tokens[2]) : Float.parseFloat(tokens[2]));
                        continue;
                    }
                    if (firstChar != 'f') break block30;
                    faces = activeGroup.faces;
                    i = 1;
                    while (i < tokens.length - 2) {
                        parts = tokens[1].split("/");
                        faces.add(this.getIndex(parts[0], this.verts.size));
                        if (parts.length > 2) {
                            if (i == 1) {
                                activeGroup.hasNorms = true;
                            }
                            faces.add(this.getIndex(parts[2], this.norms.size));
                        }
                        if (parts.length > 1 && parts[1].length() > 0) {
                            if (i == 1) {
                                activeGroup.hasUVs = true;
                            }
                            faces.add(this.getIndex(parts[1], this.uvs.size));
                        }
                        parts = tokens[++i].split("/");
                        faces.add(this.getIndex(parts[0], this.verts.size));
                        if (parts.length > 2) {
                            faces.add(this.getIndex(parts[2], this.norms.size));
                        }
                        if (parts.length > 1 && parts[1].length() > 0) {
                            faces.add(this.getIndex(parts[1], this.uvs.size));
                        }
                        parts = tokens[++i].split("/");
                        faces.add(this.getIndex(parts[0], this.verts.size));
                        if (parts.length > 2) {
                            faces.add(this.getIndex(parts[2], this.norms.size));
                        }
                        if (parts.length > 1 && parts[1].length() > 0) {
                            faces.add(this.getIndex(parts[1], this.uvs.size));
                        }
                        ++activeGroup.numFaces;
                        --i;
                    }
                    ** GOTO lbl5
                }
                if (firstChar != 'o' && firstChar != 'g') continue;
                activeGroup = tokens.length > 1 ? this.setActiveGroup(tokens[1]) : this.setActiveGroup("default");
            }
            reader.close();
        }
        catch (IOException e) {
            return null;
        }
        i = 0;
        while (i < this.groups.size()) {
            if (this.groups.get((int)i).numFaces < 1) {
                this.groups.remove(i);
                --i;
            }
            ++i;
        }
        if (this.groups.size() < 1) {
            return null;
        }
        numGroups = this.groups.size();
        model = new StillModel(new StillSubMesh[numGroups]);
        g = 0;
        while (g < numGroups) {
            group = this.groups.get(g);
            faces = group.faces;
            numElements = faces.size();
            numFaces = group.numFaces;
            hasNorms = group.hasNorms;
            hasUVs = group.hasUVs;
            finalVerts = new float[numFaces * 3 * (3 + (hasNorms != false ? 3 : 0) + (hasUVs != false ? 2 : 0))];
            i = 0;
            vi = 0;
            while (i < numElements) {
                vertIndex = faces.get(i++) * 3;
                finalVerts[vi++] = this.verts.get(vertIndex++);
                finalVerts[vi++] = this.verts.get(vertIndex++);
                finalVerts[vi++] = this.verts.get(vertIndex);
                if (hasNorms) {
                    normIndex = faces.get(i++) * 3;
                    finalVerts[vi++] = this.norms.get(normIndex++);
                    finalVerts[vi++] = this.norms.get(normIndex++);
                    finalVerts[vi++] = this.norms.get(normIndex);
                }
                if (!hasUVs) continue;
                uvIndex = faces.get(i++) * 2;
                finalVerts[vi++] = this.uvs.get(uvIndex++);
                finalVerts[vi++] = this.uvs.get(uvIndex);
            }
            numIndices = numFaces * 3 >= 32767 ? 0 : numFaces * 3;
            finalIndices = new short[numIndices];
            if (numIndices > 0) {
                i = 0;
                while (i < numIndices) {
                    finalIndices[i] = (short)i;
                    ++i;
                }
            }
            attributes = new ArrayList<VertexAttribute>();
            attributes.add(new VertexAttribute(0, 3, "a_position"));
            if (hasNorms) {
                attributes.add(new VertexAttribute(2, 3, "a_normal"));
            }
            if (hasUVs) {
                attributes.add(new VertexAttribute(3, 2, "a_texCoord0"));
            }
            mesh = new Mesh(true, numFaces * 3, numIndices, attributes.toArray(new VertexAttribute[attributes.size()]));
            mesh.setVertices(finalVerts);
            if (numIndices > 0) {
                mesh.setIndices(finalIndices);
            }
            subMesh = new StillSubMesh(group.name, mesh, 4);
            subMesh.material = new Material("default", new MaterialAttribute[0]);
            model.subMeshes[g] = subMesh;
            ++g;
        }
        if (this.verts.size > 0) {
            this.verts.clear();
        }
        if (this.norms.size > 0) {
            this.norms.clear();
        }
        if (this.uvs.size > 0) {
            this.uvs.clear();
        }
        if (this.groups.size() > 0) {
            this.groups.clear();
        }
        return model;
    }

    private Group setActiveGroup(String name) {
        Group group2;
        for (Group group2 : this.groups) {
            if (!group2.name.equals(name)) continue;
            return group2;
        }
        group2 = new Group(name);
        this.groups.add(group2);
        return group2;
    }

    private int getIndex(String index, int size) {
        if (index == null || index.length() == 0) {
            return 0;
        }
        int idx = Integer.parseInt(index);
        if (idx < 0) {
            return size + idx;
        }
        return idx - 1;
    }

    @Override
    public StillModel load(FileHandle handle, ModelLoaderHints hints) {
        return this.loadObj(handle, hints.flipV);
    }

    private class Group {
        final String name;
        ArrayList<Integer> faces;
        int numFaces;
        boolean hasNorms;
        boolean hasUVs;
        Material mat;

        Group(String name) {
            this.name = name;
            this.faces = new ArrayList(200);
            this.numFaces = 0;
            this.mat = new Material("", new MaterialAttribute[0]);
        }
    }
}

