/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.openctm;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.ModelLoaderHints;
import com.badlogic.gdx.graphics.g3d.loaders.ModelLoader;
import com.badlogic.gdx.graphics.g3d.model.Model;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.graphics.g3d.model.still.StillSubMesh;
import com.badlogic.gdx.utils.GdxRuntimeException;
import darwin.jopenctm.data.AttributeData;
import darwin.jopenctm.io.CtmFileReader;
import java.util.ArrayList;

public class CtmModelLoader
implements ModelLoader {
    @Override
    public Model load(FileHandle file, ModelLoaderHints hints) {
        CtmFileReader reader = new CtmFileReader(file.read());
        try {
            darwin.jopenctm.data.Mesh ctmMesh = reader.decode();
            Mesh mesh = this.convert(ctmMesh);
            StillSubMesh ssm = new StillSubMesh(reader.getFileComment(), mesh, 4);
            StillModel model = new StillModel(new StillSubMesh[]{ssm});
            return model;
        }
        catch (Throwable ex) {
            throw new GdxRuntimeException("An error occured while loading model: " + file.name(), ex);
        }
    }

    private Mesh convert(darwin.jopenctm.data.Mesh ctmMesh) {
        if (ctmMesh.getVertexCount() > Short.MAX_VALUE) {
            throw new GdxRuntimeException("The indices exceed the range of SHORT!");
        }
        ArrayList<VertexAttribute> vas = new ArrayList<VertexAttribute>();
        VertexAttribute position = new VertexAttribute(0, 3, "a_position");
        vas.add(position);
        VertexAttribute normal = null;
        if (ctmMesh.hasNormals()) {
            normal = new VertexAttribute(2, 3, "a_normal");
            vas.add(normal);
        }
        VertexAttribute[] uvs = new VertexAttribute[ctmMesh.getUVCount()];
        if (ctmMesh.getUVCount() > 0) {
            uvs[0] = new VertexAttribute(3, 2, "a_texCoord");
            vas.add(uvs[0]);
            if (ctmMesh.getUVCount() > 1) {
                int i = 1;
                while (i < ctmMesh.getUVCount()) {
                    AttributeData ad = ctmMesh.texcoordinates[i];
                    uvs[i] = new VertexAttribute(3, 2, ad.name);
                    vas.add(uvs[i]);
                    ++i;
                }
            }
        }
        VertexAttribute[] others = new VertexAttribute[ctmMesh.getAttrCount()];
        int i = 0;
        while (i < ctmMesh.getAttrCount()) {
            others[i] = new VertexAttribute(4, 4, ctmMesh.attributs[i].name);
            vas.add(others[i]);
            ++i;
        }
        Mesh m = new Mesh(true, ctmMesh.getVertexCount(), ctmMesh.getTriangleCount() * 3, vas.toArray(new VertexAttribute[0]));
        m.setIndices(CtmModelLoader.convertIndices(ctmMesh.indices));
        int vsize = m.getVertexSize() / 4;
        float[] data = new float[vsize * ctmMesh.getVertexCount()];
        int i2 = 0;
        while (i2 < ctmMesh.getVertexCount()) {
            AttributeData ad;
            VertexAttribute va;
            System.arraycopy(ctmMesh.vertices, i2 * 3, data, i2 * vsize, 3);
            if (normal != null) {
                System.arraycopy(ctmMesh.normals, i2 * 3, data, i2 * vsize + normal.offset / 4, 3);
            }
            VertexAttribute[] vertexAttributeArray = uvs;
            int n = uvs.length;
            int n2 = 0;
            while (n2 < n) {
                va = vertexAttributeArray[n2];
                ad = ctmMesh.texcoordinates[i2];
                System.arraycopy(ad.values, i2 * 2, data, i2 * vsize + va.offset / 4, 2);
                ++n2;
            }
            vertexAttributeArray = others;
            n = others.length;
            n2 = 0;
            while (n2 < n) {
                va = vertexAttributeArray[n2];
                ad = ctmMesh.attributs[i2];
                System.arraycopy(ad.values, i2 * 4, data, i2 * vsize + va.offset / 4, 4);
                ++n2;
            }
            ++i2;
        }
        m.setVertices(data);
        return m;
    }

    private static short[] convertIndices(int[] ind) {
        short[] r = new short[ind.length];
        int i = 0;
        while (i < r.length) {
            r[i] = (short)ind[i];
            ++i;
        }
        return r;
    }
}

