/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.collada;

import com.badlogic.gdx.graphics.Mesh;
import com.badlogic.gdx.graphics.VertexAttribute;
import com.badlogic.gdx.graphics.g3d.loaders.collada.Skin;
import com.badlogic.gdx.graphics.g3d.loaders.collada.Source;
import com.badlogic.gdx.graphics.g3d.model.skeleton.SkeletonSubMesh;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.XmlReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Faces {
    protected static final String VERTEX = "VERTEX";
    protected static final String TEXCOORD = "TEXCOORD";
    protected static final String NORMAL = "NORMAL";
    protected static final String TANGENT = "TEXTANGENT";
    protected static final String BITANGENT = "TEXBINORMAL";
    protected static final String COLOR = "COLOR";
    int count = 0;
    final Map<String, Source> sourcesMap;
    final Map<String, String> mappings;
    Array<XmlReader.Element> inputs;
    Source[] sources;
    Array<VertexIndices> triangles;
    Array<VertexIndices> vertices;
    int numVertices = 0;
    int numIndices = 0;
    int primitiveType = 4;

    public Faces(XmlReader.Element faces, Map<String, String> mappings, Map<String, Source> sources) {
        this.sourcesMap = sources;
        this.mappings = mappings;
        this.parseVertices(faces);
        this.triangulate(faces);
        this.numIndices = this.triangles.size;
    }

    private void parseVertices(XmlReader.Element faces) {
        this.inputs = faces.getChildrenByName("input");
        if (this.inputs == null) {
            throw new GdxRuntimeException("no <input> elements in <triangles>/<polylist>");
        }
        int[] offsets = new int[this.inputs.size];
        int stride = 0;
        this.sources = new Source[this.inputs.size];
        int i = 0;
        while (i < this.inputs.size) {
            XmlReader.Element input = this.inputs.get(i);
            String source = input.getAttribute("source").substring(1);
            if (this.mappings.containsKey(source)) {
                input.setAttribute("source", this.mappings.get(source));
            } else {
                input.setAttribute("source", source);
            }
            source = input.getAttribute("source");
            if (!this.sourcesMap.containsKey(source)) {
                throw new GdxRuntimeException("source '" + source + "'  not in mesh> but in <triangle>");
            }
            this.sources[i] = this.sourcesMap.get(source);
            offsets[i] = Integer.parseInt(input.getAttribute("offset"));
            stride = Math.max(offsets[i], stride);
            ++i;
        }
        ++stride;
        String[] tokens = faces.getChildByName("p").getText().split("\\s+");
        int[] indices = new int[tokens.length];
        int i2 = 0;
        while (i2 < tokens.length) {
            indices[i2] = Integer.parseInt(tokens[i2]);
            ++i2;
        }
        HashMap<VertexIndices, VertexIndices> indicesSet = new HashMap<VertexIndices, VertexIndices>();
        VertexIndices vertex = new VertexIndices(this.inputs.size);
        this.triangles = new Array(indices.length / stride);
        this.vertices = new Array(indices.length / stride);
        int index = 0;
        int i3 = 0;
        while (i3 < indices.length) {
            int j = 0;
            while (j < this.inputs.size) {
                vertex.indices[j] = indices[i3 + offsets[j]];
                vertex.index = index;
                ++j;
            }
            VertexIndices lookup = (VertexIndices)indicesSet.get(vertex);
            if (lookup != null) {
                this.triangles.add(lookup);
            } else {
                this.triangles.add(vertex);
                this.vertices.add(vertex);
                indicesSet.put(vertex, vertex);
                vertex = new VertexIndices(this.inputs.size);
                ++index;
            }
            i3 += stride;
        }
        this.numVertices = index;
    }

    private void triangulate(XmlReader.Element polyList) {
        if (!polyList.getName().equals("polylist")) {
            return;
        }
        XmlReader.Element colladaPolys = polyList.getChildByName("vcount");
        if (colladaPolys == null) {
            throw new GdxRuntimeException("<polylist> does not contain <vcount> element");
        }
        String[] tokens = colladaPolys.getText().split("\\s+");
        int[] polys = new int[tokens.length];
        int vertexCount = 0;
        int i = 0;
        while (i < tokens.length) {
            int verts;
            polys[i] = verts = Integer.parseInt(tokens[i]);
            vertexCount += verts;
            ++i;
        }
        Array<VertexIndices> newVertices = new Array<VertexIndices>(vertexCount);
        int idx = 0;
        int i2 = 0;
        while (i2 < polys.length) {
            int numVertices = polys[i2];
            VertexIndices baseVertex = this.triangles.get(idx++);
            int j = 1;
            while (j < numVertices - 1) {
                newVertices.add(baseVertex);
                newVertices.add(this.triangles.get(idx));
                newVertices.add(this.triangles.get(idx + 1));
                ++idx;
                ++j;
            }
            ++idx;
            ++i2;
        }
        this.triangles = newVertices;
    }

    public Mesh getMesh() {
        float[] verts = new float[this.getVertexSize() * this.numVertices];
        short[] indices = new short[this.numIndices];
        VertexAttribute[] attributes = this.getVertexAttributes();
        int i = 0;
        while (i < this.numIndices) {
            VertexIndices vertex = this.triangles.get(i);
            if (vertex.index > Short.MAX_VALUE || vertex.index < Short.MIN_VALUE) {
                throw new GdxRuntimeException("index to big for short: " + vertex.index);
            }
            indices[i] = (short)vertex.index;
            ++i;
        }
        boolean idx = false;
        int destOffset = 0;
        int i2 = 0;
        while (i2 < this.vertices.size) {
            VertexIndices vertex = this.vertices.get(i2);
            int j = 0;
            while (j < this.sources.length) {
                Source source = this.sources[j];
                float[] data = source.data;
                int index = vertex.indices[j];
                int components = source.components;
                int sourceOffset = index * components;
                int k = 0;
                while (k < components) {
                    verts[destOffset++] = attributes[j].usage == 3 && k == 1 ? 1.0f - data[sourceOffset++] : data[sourceOffset++];
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        Mesh mesh = new Mesh(true, this.vertices.size, indices.length, attributes);
        mesh.setVertices(verts);
        mesh.setIndices(indices);
        return mesh;
    }

    public SkeletonSubMesh getSkeletonSubMesh(Skin skin) {
        float[] verts = new float[this.getVertexSize() * this.numVertices];
        short[] indices = new short[this.numIndices];
        VertexAttribute[] attributes = this.getVertexAttributes();
        int i = 0;
        while (i < this.numIndices) {
            VertexIndices vertex = this.triangles.get(i);
            if (vertex.index > Short.MAX_VALUE || vertex.index < Short.MIN_VALUE) {
                throw new GdxRuntimeException("index to big for short: " + vertex.index);
            }
            indices[i] = (short)vertex.index;
            ++i;
        }
        boolean idx = false;
        int destOffset = 0;
        int i2 = 0;
        while (i2 < this.vertices.size) {
            VertexIndices vertex = this.vertices.get(i2);
            int j = 0;
            while (j < this.sources.length) {
                Source source = this.sources[j];
                float[] data = source.data;
                int index = vertex.indices[j];
                int components = source.components;
                int sourceOffset = index * components;
                int k = 0;
                while (k < components) {
                    verts[destOffset++] = attributes[j].usage == 3 && k == 1 ? 1.0f - data[sourceOffset++] : data[sourceOffset++];
                    ++k;
                }
                ++j;
            }
            ++i2;
        }
        Mesh mesh = new Mesh(false, this.vertices.size, indices.length, attributes);
        mesh.setVertices(verts);
        mesh.setIndices(indices);
        SkeletonSubMesh submesh = new SkeletonSubMesh("", mesh, 4);
        submesh.vertices = verts;
        submesh.indices = indices;
        submesh.skinnedVertices = new float[submesh.vertices.length];
        System.arraycopy(submesh.vertices, 0, submesh.skinnedVertices, 0, submesh.vertices.length);
        submesh.boneAssignments = new int[this.vertices.size][];
        submesh.boneWeights = new float[this.vertices.size][];
        int i3 = 0;
        while (i3 < skin.boneIndex.length) {
            int j = 0;
            while (j < this.vertices.size) {
                if (this.vertices.get((int)j).indices[0] == i3) {
                    submesh.boneAssignments[j] = skin.boneIndex[i3];
                    submesh.boneWeights[j] = skin.boneWeight[i3];
                }
                ++j;
            }
            ++i3;
        }
        return submesh;
    }

    private VertexAttribute[] getVertexAttributes() {
        VertexAttribute[] attributes = new VertexAttribute[this.inputs.size];
        int texUnit = 0;
        int i = 0;
        while (i < this.inputs.size) {
            XmlReader.Element input = this.inputs.get(i);
            String semantic = input.getAttribute("semantic");
            Source source = this.sourcesMap.get(input.getAttribute("source"));
            int usage = this.getVertexAttributeUsage(semantic);
            int components = source.components;
            String alias = this.getVertexAttributeAlias(semantic);
            if (alias.equals("a_texCoord")) {
                alias = String.valueOf(alias) + texUnit++;
            }
            attributes[i] = new VertexAttribute(usage, components, alias);
            ++i;
        }
        return attributes;
    }

    private int getVertexSize() {
        int size = 0;
        int i = 0;
        while (i < this.inputs.size) {
            size += this.sourcesMap.get((Object)this.inputs.get((int)i).getAttribute((String)"source")).components;
            ++i;
        }
        return size;
    }

    private int getVertexAttributeUsage(String attribute) {
        if (attribute.equals(VERTEX)) {
            return 0;
        }
        if (attribute.equals(TEXCOORD)) {
            return 3;
        }
        if (attribute.equals(NORMAL)) {
            return 2;
        }
        return 4;
    }

    private String getVertexAttributeAlias(String attribute) {
        if (attribute.equals(VERTEX)) {
            return "a_position";
        }
        if (attribute.equals(TEXCOORD)) {
            return "a_texCoord";
        }
        if (attribute.equals(NORMAL)) {
            return "a_normal";
        }
        if (attribute.equals(TANGENT)) {
            return "a_tangent";
        }
        if (attribute.equals(BITANGENT)) {
            return "a_binormal";
        }
        if (attribute.equals(COLOR)) {
            return "a_color";
        }
        throw new GdxRuntimeException("can't map semantic '" + attribute + "' to alias, must be VERTEX, TEXCOORD, NORMAL, TANGENT or BITANGENT");
    }

    static class VertexIndices {
        int[] indices;
        int index;

        public VertexIndices(int size) {
            this.indices = new int[size];
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.indices);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            VertexIndices other = (VertexIndices)obj;
            return Arrays.equals(this.indices, other.indices);
        }

        public String toString() {
            return String.valueOf(this.index) + ": " + Arrays.toString(this.indices);
        }
    }
}

