/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.loaders.collada;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.g3d.ModelLoaderHints;
import com.badlogic.gdx.graphics.g3d.loaders.StillModelLoader;
import com.badlogic.gdx.graphics.g3d.loaders.collada.Geometry;
import com.badlogic.gdx.graphics.g3d.materials.Material;
import com.badlogic.gdx.graphics.g3d.materials.MaterialAttribute;
import com.badlogic.gdx.graphics.g3d.model.SubMesh;
import com.badlogic.gdx.graphics.g3d.model.still.StillModel;
import com.badlogic.gdx.graphics.g3d.model.still.StillSubMesh;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.GdxRuntimeException;
import com.badlogic.gdx.utils.XmlReader;
import java.io.InputStream;

public class ColladaLoader
implements StillModelLoader {
    public static StillModel loadStillModel(FileHandle handle) {
        return ColladaLoader.loadStillModel(handle.read());
    }

    public static StillModel loadStillModel(InputStream in) {
        XmlReader xml = new XmlReader();
        XmlReader.Element root = null;
        try {
            root = xml.parse(in);
        }
        catch (Exception e) {
            throw new GdxRuntimeException("Couldn't load Collada model", e);
        }
        Array<Geometry> geos = ColladaLoader.readGeometries(root);
        SubMesh[] meshes = ColladaLoader.createMeshes(geos);
        StillModel model = new StillModel(meshes);
        return model;
    }

    public static Array<Geometry> readGeometries(XmlReader.Element root) {
        XmlReader.Element colladaGeoLibrary = root.getChildByName("library_geometries");
        if (colladaGeoLibrary == null) {
            throw new GdxRuntimeException("not <library_geometries> element in file");
        }
        Array<XmlReader.Element> colladaGeos = colladaGeoLibrary.getChildrenByName("geometry");
        if (colladaGeos.size == 0) {
            throw new GdxRuntimeException("no <geometry> elements in file");
        }
        Array<Geometry> geometries = new Array<Geometry>();
        int i = 0;
        while (i < colladaGeos.size) {
            try {
                geometries.add(new Geometry(colladaGeos.get(i)));
            }
            catch (GdxRuntimeException e) {
                System.out.println("warning: " + e.getMessage());
            }
            ++i;
        }
        return geometries;
    }

    private static StillSubMesh[] createMeshes(Array<Geometry> geos) {
        StillSubMesh[] meshes = new StillSubMesh[geos.size];
        int i = 0;
        while (i < geos.size) {
            StillSubMesh subMesh = new StillSubMesh(geos.get((int)i).id, geos.get(i).getMesh(), 4);
            subMesh.material = new Material("Null Material", new MaterialAttribute[0]);
            meshes[i] = subMesh;
            ++i;
        }
        return meshes;
    }

    @Override
    public StillModel load(FileHandle handle, ModelLoaderHints hints) {
        return ColladaLoader.loadStillModel(handle);
    }
}

