/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.lights;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g3d.lights.DirectionalLight;
import com.badlogic.gdx.graphics.g3d.lights.PointLight;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;

public class LightManager {
    public LightQuality quality;
    public final Array<PointLight> pointLights = new Array(false, 16);
    private final float[] positions;
    private final float[] colors;
    private final float[] intensities;
    public final int maxLightsPerModel;
    public final Color ambientLight = new Color();
    public DirectionalLight dirLight;

    public LightManager() {
        this(4, LightQuality.VERTEX);
    }

    public LightManager(int maxLightsPerModel, LightQuality lightQuality) {
        this.quality = lightQuality;
        this.maxLightsPerModel = maxLightsPerModel;
        this.colors = new float[3 * maxLightsPerModel];
        this.positions = new float[3 * maxLightsPerModel];
        this.intensities = new float[maxLightsPerModel];
    }

    public void addLigth(PointLight light) {
        this.pointLights.add(light);
    }

    public void clear() {
        this.pointLights.clear();
    }

    public void calculateAndApplyLightsToModel(Vector3 center, ShaderProgram shader) {
        this.calculateLights(center.x, center.y, center.z);
        this.applyLights(shader);
    }

    public void calculateLights(float x, float y, float z) {
        int maxSize = this.pointLights.size;
        if (maxSize > this.maxLightsPerModel) {
            int i = 0;
            while (i < maxSize) {
                PointLight light = this.pointLights.get(i);
                light.priority = (int)(256.0f * (light.intensity / light.position.dst(x, y, z)));
                ++i;
            }
            this.pointLights.sort();
        }
        int size = this.maxLightsPerModel > maxSize ? maxSize : this.maxLightsPerModel;
        int i = 0;
        while (i < size) {
            PointLight light = this.pointLights.get(i);
            Vector3 pos = light.position;
            this.positions[3 * i + 0] = pos.x;
            this.positions[3 * i + 1] = pos.y;
            this.positions[3 * i + 2] = pos.z;
            Color col = light.color;
            this.colors[3 * i + 0] = col.r;
            this.colors[3 * i + 1] = col.g;
            this.colors[3 * i + 2] = col.b;
            this.intensities[i] = light.intensity;
            ++i;
        }
        i = size;
        while (i < this.maxLightsPerModel) {
            this.intensities[i] = 0.0f;
            ++i;
        }
    }

    public void applyLights() {
    }

    public void applyLights(ShaderProgram shader) {
        shader.setUniform3fv("lightsPos", this.positions, 0, this.maxLightsPerModel * 3);
        shader.setUniform3fv("lightsCol", this.colors, 0, this.maxLightsPerModel * 3);
        shader.setUniform1fv("lightsInt", this.intensities, 0, this.maxLightsPerModel);
    }

    public void applyGlobalLights() {
    }

    public void applyGlobalLights(ShaderProgram shader) {
        shader.setUniformf("ambient", this.ambientLight.r, this.ambientLight.g, this.ambientLight.b);
        if (this.dirLight != null) {
            Vector3 v = this.dirLight.direction;
            Color c = this.dirLight.color;
            shader.setUniformf("dirLightDir", v.x, v.y, v.z);
            shader.setUniformf("dirLightCol", c.r, c.g, c.b);
        }
    }

    public static enum LightQuality {
        VERTEX,
        FRAGMENT;

    }
}

