/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.g3d.keyframed;

import com.badlogic.gdx.graphics.g3d.Animator;
import com.badlogic.gdx.graphics.g3d.keyframed.Keyframe;
import com.badlogic.gdx.graphics.g3d.keyframed.KeyframeAnimation;
import com.badlogic.gdx.graphics.g3d.loaders.md5.MD5Quaternion;
import com.badlogic.gdx.math.Quaternion;
import com.badlogic.gdx.math.Vector3;

public class KeyframeAnimator
extends Animator {
    public static final int sStride = 8;
    private Keyframe A = null;
    private Keyframe B = null;
    private Keyframe R = null;
    private int numMeshes = 0;
    private float invSampleRate = 0.0f;
    static MD5Quaternion jointAOrient = new MD5Quaternion();
    static MD5Quaternion jointBOrient = new MD5Quaternion();

    public Keyframe getInterpolatedKeyframe() {
        return this.R;
    }

    public KeyframeAnimator(int numMeshes, float sampleRate) {
        this.numMeshes = numMeshes;
        this.R = new Keyframe();
        this.R.vertices = new float[numMeshes][];
        this.R.indices = new short[numMeshes][];
        this.invSampleRate = 1.0f / sampleRate;
    }

    public void setKeyframeDimensions(int idx, int numVertices, int numIndices) {
        this.R.vertices[idx] = new float[numVertices];
        this.R.indices[idx] = new short[numIndices];
    }

    public void setNumTaggedJoints(int num) {
        int i;
        this.R.taggedJointPos = new Vector3[num];
        for (i = 0; i < num; ++i) {
            this.R.taggedJointPos[i] = new Vector3();
        }
        this.R.taggedJoint = new Quaternion[num];
        for (i = 0; i < num; ++i) {
            this.R.taggedJoint[i] = new Quaternion(0.0f, 0.0f, 0.0f, 0.0f);
        }
    }

    @Override
    protected void setInterpolationFrames() {
        this.A = ((KeyframeAnimation)this.mCurrentAnim).keyframes[this.mCurrentFrameIdx];
        this.B = ((KeyframeAnimation)this.mCurrentAnim).keyframes[this.mNextFrameIdx];
    }

    @Override
    protected void interpolate() {
        if (this.mWrapMode == Animator.WrapMode.SingleFrame && this.R.indicesSet) {
            return;
        }
        float t = this.mFrameDelta * this.invSampleRate;
        for (int i = 0; i < this.numMeshes; ++i) {
            int n;
            float[] Rvertices = this.R.vertices[i];
            float[] Avertices = this.A.vertices[i];
            float[] Bvertices = this.B.vertices[i];
            for (n = 0; n < Avertices.length; n += 8) {
                float Ax = Avertices[n];
                float Bx = Bvertices[n];
                float Rx = Ax + (Bx - Ax) * t;
                float Ay = Avertices[n + 1];
                float By = Bvertices[n + 1];
                float Ry = Ay + (By - Ay) * t;
                float Az = Avertices[n + 2];
                float Bz = Bvertices[n + 2];
                float Rz = Az + (Bz - Az) * t;
                Rvertices[n] = Rx;
                Rvertices[n + 1] = Ry;
                Rvertices[n + 2] = Rz;
                Rvertices[n + 3] = Avertices[n + 3];
                Rvertices[n + 4] = Avertices[n + 4];
                Ax = Avertices[n + 5];
                Bx = Bvertices[n + 5];
                Rx = Ax + (Bx - Ax) * t;
                Ay = Avertices[n + 6];
                By = Bvertices[n + 6];
                Ry = Ay + (By - Ay) * t;
                Az = Avertices[n + 7];
                Bz = Bvertices[n + 7];
                Rz = Az + (Bz - Az) * t;
                Rvertices[n + 5] = Rx;
                Rvertices[n + 6] = Ry;
                Rvertices[n + 7] = Rz;
            }
            if (this.R.indicesSet) continue;
            for (n = 0; n < this.A.indices[i].length; ++n) {
                this.R.indices[i][n] = this.A.indices[i][n];
            }
        }
        this.R.indicesSet = true;
        if (this.A.taggedJoint != null) {
            this.interpolateJoints(t);
        }
    }

    private void interpolateJoints(float t) {
        for (int tj = 0; tj < this.A.taggedJoint.length; ++tj) {
            float PAX = this.A.taggedJointPos[tj].x;
            float PAY = this.A.taggedJointPos[tj].y;
            float PAZ = this.A.taggedJointPos[tj].z;
            float PBX = this.B.taggedJointPos[tj].x;
            float PBY = this.B.taggedJointPos[tj].y;
            float PBZ = this.B.taggedJointPos[tj].z;
            this.R.taggedJointPos[tj].x = PAX + (PBX - PAX) * t;
            this.R.taggedJointPos[tj].y = PAY + (PBY - PAY) * t;
            this.R.taggedJointPos[tj].z = PAZ + (PBZ - PAZ) * t;
            KeyframeAnimator.jointAOrient.x = this.A.taggedJoint[tj].x;
            KeyframeAnimator.jointAOrient.y = this.A.taggedJoint[tj].y;
            KeyframeAnimator.jointAOrient.z = this.A.taggedJoint[tj].z;
            KeyframeAnimator.jointAOrient.w = this.A.taggedJoint[tj].w;
            KeyframeAnimator.jointBOrient.x = this.B.taggedJoint[tj].x;
            KeyframeAnimator.jointBOrient.y = this.B.taggedJoint[tj].y;
            KeyframeAnimator.jointBOrient.z = this.B.taggedJoint[tj].z;
            KeyframeAnimator.jointBOrient.w = this.B.taggedJoint[tj].w;
            jointAOrient.slerp(jointBOrient, t);
            this.R.taggedJoint[tj].x = KeyframeAnimator.jointAOrient.x;
            this.R.taggedJoint[tj].y = KeyframeAnimator.jointAOrient.y;
            this.R.taggedJoint[tj].z = KeyframeAnimator.jointAOrient.z;
            this.R.taggedJoint[tj].w = KeyframeAnimator.jointAOrient.w;
        }
    }

    public boolean hasAnimation() {
        return this.mCurrentAnim != null;
    }
}

