/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class PixmapIO {
    public static void writeCIM(FileHandle file, Pixmap pixmap) {
        CIM.write(file, pixmap);
    }

    public static Pixmap readCIM(FileHandle file) {
        return CIM.read(file);
    }

    public static void writePNG(FileHandle file, Pixmap pixmap) {
        try {
            file.writeBytes(PNG.write(pixmap), false);
        }
        catch (IOException ex) {
            throw new GdxRuntimeException("Error writing PNG: " + file, ex);
        }
    }

    private static class PNG {
        static int[] crcTable;
        static final int ZLIB_BLOCK_SIZE = 32000;

        private PNG() {
        }

        static byte[] write(Pixmap pixmap) throws IOException {
            byte[] signature = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
            byte[] header = PNG.createHeaderChunk(pixmap.getWidth(), pixmap.getHeight());
            byte[] data = PNG.createDataChunk(pixmap);
            byte[] trailer = PNG.createTrailerChunk();
            ByteArrayOutputStream png = new ByteArrayOutputStream(signature.length + header.length + data.length + trailer.length);
            png.write(signature);
            png.write(header);
            png.write(data);
            png.write(trailer);
            return png.toByteArray();
        }

        private static byte[] createHeaderChunk(int width, int height) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(13);
            DataOutputStream chunk = new DataOutputStream(baos);
            chunk.writeInt(width);
            chunk.writeInt(height);
            chunk.writeByte(8);
            chunk.writeByte(6);
            chunk.writeByte(0);
            chunk.writeByte(0);
            chunk.writeByte(0);
            return PNG.toChunk("IHDR", baos.toByteArray());
        }

        private static byte[] createDataChunk(Pixmap pixmap) throws IOException {
            int width = pixmap.getWidth();
            int height = pixmap.getHeight();
            int dest = 0;
            byte[] raw = new byte[4 * width * height + height];
            for (int y = 0; y < height; ++y) {
                raw[dest++] = 0;
                for (int x = 0; x < width; ++x) {
                    int pixel = pixmap.getPixel(x, y);
                    int mask = pixel & 0xFFFFFFFF;
                    int rr = mask >> 24 & 0xFF;
                    int gg = mask >> 16 & 0xFF;
                    int bb = mask >> 8 & 0xFF;
                    int aa = mask & 0xFF;
                    raw[dest++] = (byte)rr;
                    raw[dest++] = (byte)gg;
                    raw[dest++] = (byte)bb;
                    raw[dest++] = (byte)aa;
                }
            }
            return PNG.toChunk("IDAT", PNG.toZLIB(raw));
        }

        private static byte[] createTrailerChunk() throws IOException {
            return PNG.toChunk("IEND", new byte[0]);
        }

        private static byte[] toChunk(String id, byte[] raw) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 12);
            DataOutputStream chunk = new DataOutputStream(baos);
            chunk.writeInt(raw.length);
            byte[] bid = new byte[4];
            for (int i = 0; i < 4; ++i) {
                bid[i] = (byte)id.charAt(i);
            }
            chunk.write(bid);
            chunk.write(raw);
            int crc = -1;
            crc = PNG.updateCRC(crc, bid);
            crc = PNG.updateCRC(crc, raw);
            chunk.writeInt(~crc);
            return baos.toByteArray();
        }

        private static void createCRCTable() {
            crcTable = new int[256];
            for (int i = 0; i < 256; ++i) {
                int c = i;
                for (int k = 0; k < 8; ++k) {
                    c = (c & 1) > 0 ? 0xEDB88320 ^ c >>> 1 : c >>> 1;
                }
                PNG.crcTable[i] = c;
            }
        }

        private static int updateCRC(int crc, byte[] raw) {
            if (crcTable == null) {
                PNG.createCRCTable();
            }
            for (byte element : raw) {
                crc = crcTable[(crc ^ element) & 0xFF] ^ crc >>> 8;
            }
            return crc;
        }

        private static byte[] toZLIB(byte[] raw) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(raw.length + 6 + raw.length / 32000 * 5);
            DataOutputStream zlib = new DataOutputStream(baos);
            int tmp = 8;
            zlib.writeByte(tmp);
            zlib.writeByte((31 - (tmp << 8) % 31) % 31);
            int pos = 0;
            while (raw.length - pos > 32000) {
                PNG.writeUncompressedDeflateBlock(zlib, false, raw, pos, '\u7d00');
                pos += 32000;
            }
            PNG.writeUncompressedDeflateBlock(zlib, true, raw, pos, (char)(raw.length - pos));
            zlib.writeInt(PNG.calcADLER32(raw));
            return baos.toByteArray();
        }

        private static void writeUncompressedDeflateBlock(DataOutputStream zlib, boolean last, byte[] raw, int off, char len) throws IOException {
            zlib.writeByte((byte)(last ? 1 : 0));
            zlib.writeByte((byte)(len & 0xFF));
            zlib.writeByte((byte)((len & 0xFF00) >> 8));
            zlib.writeByte((byte)(~len & 0xFF));
            zlib.writeByte((byte)((~len & 0xFF00) >> 8));
            zlib.write(raw, off, len);
        }

        private static int calcADLER32(byte[] raw) {
            int s1 = 1;
            int s2 = 0;
            for (int i = 0; i < raw.length; ++i) {
                int abs = raw[i] >= 0 ? raw[i] : raw[i] + 256;
                s1 = (s1 + abs) % 65521;
                s2 = (s2 + s1) % 65521;
            }
            return (s2 << 16) + s1;
        }
    }

    private static class CIM {
        private static final int BUFFER_SIZE = 32000;
        private static final byte[] writeBuffer = new byte[32000];
        private static final byte[] readBuffer = new byte[32000];

        private CIM() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void write(FileHandle file, Pixmap pixmap) {
            FilterOutputStream out = null;
            try {
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(file.write(false));
                out = new DataOutputStream(deflaterOutputStream);
                ((DataOutputStream)out).writeInt(pixmap.getWidth());
                ((DataOutputStream)out).writeInt(pixmap.getHeight());
                ((DataOutputStream)out).writeInt(Pixmap.Format.toGdx2DPixmapFormat(pixmap.getFormat()));
                ByteBuffer pixelBuf = pixmap.getPixels();
                pixelBuf.position(0);
                pixelBuf.limit(pixelBuf.capacity());
                int remainingBytes = pixelBuf.capacity() % 32000;
                int iterations = pixelBuf.capacity() / 32000;
                byte[] byArray = writeBuffer;
                synchronized (writeBuffer) {
                    for (int i = 0; i < iterations; ++i) {
                        pixelBuf.get(writeBuffer);
                        out.write(writeBuffer);
                    }
                    pixelBuf.get(writeBuffer, 0, remainingBytes);
                    ((DataOutputStream)out).write(writeBuffer, 0, remainingBytes);
                    // ** MonitorExit[var7_9] (shouldn't be in output)
                    pixelBuf.position(0);
                    pixelBuf.limit(pixelBuf.capacity());
                }
            }
            catch (Exception e) {
                throw new GdxRuntimeException("Couldn't write Pixmap to file '" + file + "'", e);
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (Exception e) {}
                }
            }
            {
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static Pixmap read(FileHandle file) {
            FilterInputStream in = null;
            try {
                in = new DataInputStream(new InflaterInputStream(new BufferedInputStream(file.read())));
                int width = ((DataInputStream)in).readInt();
                int height = ((DataInputStream)in).readInt();
                Pixmap.Format format = Pixmap.Format.fromGdx2DPixmapFormat(((DataInputStream)in).readInt());
                Pixmap pixmap = new Pixmap(width, height, format);
                ByteBuffer pixelBuf = pixmap.getPixels();
                pixelBuf.position(0);
                pixelBuf.limit(pixelBuf.capacity());
                Object object = readBuffer;
                synchronized (readBuffer) {
                    int readBytes = 0;
                    while ((readBytes = ((DataInputStream)in).read(readBuffer)) > 0) {
                        pixelBuf.put(readBuffer, 0, readBytes);
                    }
                    // ** MonitorExit[var7_8 /* !! */ ] (shouldn't be in output)
                    pixelBuf.position(0);
                    pixelBuf.limit(pixelBuf.capacity());
                    object = pixmap;
                    return object;
                }
            }
            catch (Exception e) {
                throw new GdxRuntimeException("Couldn't read Pixmap from file '" + file + "'", e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

