/*
 * Enemy.cpp
 *
 *  Created on: 13 jan 2012
 *      Author: Reii
 */

#include "SDL/SDL.h"
#include "Enemy.h"
#include "Globals.h"
#include <string>

using namespace std;

Enemy::Enemy(string filename, bool transparent, bool multi, int x, int y):
Sprite(filename, transparent, multi, x, y){
	setXspeed(7);
	setYspeed(15);
}

Enemy::Enemy(Image* img, bool multi, int x, int y):
Sprite(img, multi, x, y){
	setXspeed(7);
	setYspeed(15);
}

Enemy* Enemy::getInstance(string filename, bool transparent, bool multi, int x, int y){
	return new Enemy(filename, transparent, multi, x, y);
}

Enemy* Enemy::getInstance(Image* img, bool multi, int x, int y){
	return new Enemy(img, multi, x, y);
}

void Enemy::detectBorderCollision(){
	if(getRect().x < globals.getScreen()->clip_rect.x){
		setXspeed(7);
	}
	if(getRect().x+getRect().w > globals.getScreen()->clip_rect.x+globals.getScreen()->clip_rect.w){
		setXspeed(-7);
	}
	if(getRect().y < globals.getScreen()->clip_rect.y){
		setYspeed(15);
	}
	if(getRect().y+getRect().h > globals.getScreen()->clip_rect.y+globals.getScreen()->clip_rect.h){
		setYspeed(-15);
	}
}

void Enemy::tick(vector<Sprite*>& gameobjects){
	moveSprite(getXspeed(), getYspeed());
	detectBorderCollision();

	vector<Sprite*>::iterator iter;
	for(iter = gameobjects.begin() ; iter != gameobjects.end();iter++){
		if(*iter != this && hasCollided(*iter)){
			if(Enemy* e = dynamic_cast<Enemy*>(*iter)){
				setXspeed(-getXspeed());
				setYspeed(-getYspeed());
			}
		}
	}
}

void Enemy::draw(){
	SDL_Rect rect = getRect();
	SDL_BlitSurface(getImage()->getSurface(), NULL, globals.getScreen(), &rect);
}

Enemy::~Enemy(){

}




