/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.slick;

import java.io.UnsupportedEncodingException;
import org.newdawn.slick.Color;
import org.newdawn.slick.Font;
import org.newdawn.slick.SpriteSheet;
import org.newdawn.slick.util.Log;

public class SpriteSheetFont
implements Font {
    private SpriteSheet font;
    private char startingCharacter;
    private int charWidth;
    private int charHeight;
    private int horizontalCount;
    private int numChars;

    public SpriteSheetFont(SpriteSheet font, char startingCharacter) {
        this.font = font;
        this.startingCharacter = startingCharacter;
        this.horizontalCount = font.getHorizontalCount();
        int verticalCount = font.getVerticalCount();
        this.charWidth = font.getWidth() / this.horizontalCount;
        this.charHeight = font.getHeight() / verticalCount;
        this.numChars = this.horizontalCount * verticalCount;
    }

    public void drawString(float x, float y, String text2) {
        this.drawString(x, y, text2, Color.white);
    }

    public void drawString(float x, float y, String text2, Color col) {
        this.drawString(x, y, text2, col, 0, text2.length() - 1);
    }

    public void drawString(float x, float y, String text2, Color col, int startIndex, int endIndex) {
        try {
            byte[] data = text2.getBytes("US-ASCII");
            for (int i = 0; i < data.length; ++i) {
                int index = data[i] - this.startingCharacter;
                if (index >= this.numChars) continue;
                int xPos = index % this.horizontalCount;
                int yPos = index / this.horizontalCount;
                if (i < startIndex && i > endIndex) continue;
                this.font.getSprite(xPos, yPos).draw(x + (float)(i * this.charWidth), y, col);
            }
        }
        catch (UnsupportedEncodingException e) {
            Log.error(e);
        }
    }

    public int getHeight(String text2) {
        return this.charHeight;
    }

    public int getWidth(String text2) {
        return this.charWidth * text2.length();
    }

    public int getLineHeight() {
        return this.charHeight;
    }
}

