/*
 * Decompiled with CFR 0.152.
 */
package items;

import art.Art;
import engine.Point3D;
import engine.Sound;
import entities.GFX;
import entities.Racer;
import game.Game;
import items.Item;

public class ItemTrollMagnet
extends Item {
    private boolean activated;
    private int counter = 100;
    private Racer owner;
    private boolean soundPlayed;

    public ItemTrollMagnet(Game g, Racer owner) {
        super(g);
        this.name = "Troll Magnet";
        this.pic = Art.itemPicMagnet;
        this.owner = owner;
    }

    @Override
    public double getSpeedBoost() {
        if (this.activated) {
            return 6.0;
        }
        return 1.0;
    }

    @Override
    public void tryUse() {
        this.activated = true;
    }

    @Override
    public void update() {
        if (this.activated) {
            if (!this.soundPlayed) {
                this.soundPlayed = true;
                this.game.sound.play3D(Sound.JET, this.game.player1.pos, this.game.player2.pos, this.owner.pos);
            }
            if (this.counter % 4 == 0) {
                this.game.addEntity(new GFX(this.game, this.owner.pos.clone(), 5, new Point3D(0.0, 0.0, 0.0)));
            }
            --this.counter;
        }
    }

    @Override
    public boolean isConsumed() {
        return this.counter < 0;
    }

    @Override
    public String getInfo() {
        return String.valueOf(this.counter) + "/" + 300;
    }
}

