/*
 * Decompiled with CFR 0.152.
 */
package items;

import art.Art;
import engine.Point3D;
import engine.Sound;
import entities.Missile;
import entities.Racer;
import game.Game;
import items.Item;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;

public class ItemMissile
extends Item {
    public static int TYPE_PLAYER1 = 1;
    public static int TYPE_PLAYER2 = 2;
    public static int TYPE_BOT = 3;
    private int ownerType;
    private Racer target;
    private Racer owner;
    private final int lockRange = 400;
    private final double lockAngle = 1.0471975511965976;
    private int lockCounter;
    private int lockTime = -1;
    private boolean fired;

    public ItemMissile(Game g, int ownerType, Racer owner) {
        super(g);
        this.ownerType = ownerType;
        this.owner = owner;
        this.pic = Art.itemPicMissile;
        this.name = "Missile";
    }

    @Override
    public void update() {
        --this.lockCounter;
        if (this.target == null) {
            this.lookForTarget();
        } else {
            this.checkTarget();
        }
    }

    @Override
    public void tryUse() {
        if (!this.fired) {
            this.fired = true;
            Point3D pos = new Point3D(this.owner.pos.x + Math.sin(this.owner.heading) * 20.0, this.owner.pos.y, this.owner.pos.z + Math.cos(this.owner.heading) * 20.0);
            if (this.target != null && this.lockCounter <= 0) {
                this.game.addEntity(new Missile(this.game, pos, this.owner, this.target, this.owner.heading));
            } else {
                this.game.addEntity(new Missile(this.game, pos, this.owner, null, this.owner.heading));
            }
            this.game.sound.play3D(Sound.MISSILE_LAUNCH, this.game.player1.pos, this.game.player2.pos, this.owner.pos);
        }
    }

    public boolean botFire() {
        return this.target != null && this.lockCounter <= 0;
    }

    @Override
    public boolean isConsumed() {
        return this.fired;
    }

    @Override
    public String getInfo() {
        return "";
    }

    private void checkTarget() {
        if (this.inRange(this.target) && this.inAngle(this.target)) {
            return;
        }
        this.target = null;
    }

    private void lookForTarget() {
        int i = 0;
        while (i < this.game.racers.size()) {
            if (this.game.racers.get(i) != this.owner && this.inRange(this.game.racers.get(i)) && this.inAngle(this.game.racers.get(i))) {
                this.target = this.game.racers.get(i);
                this.lockCounter = this.lockTime;
                break;
            }
            ++i;
        }
    }

    private boolean inRange(Racer r) {
        return this.owner.disTo(r) < 400.0;
    }

    public double normalizeAngel(double a) {
        if ((a %= Math.PI * 2) < 0.0) {
            a += Math.PI * 2;
        }
        return a;
    }

    private boolean inAngle(Racer r) {
        double a = Math.atan2(r.pos.x - this.owner.pos.x, r.pos.z - this.owner.pos.z);
        double h = this.owner.heading;
        return Math.abs((a = this.normalizeAngel(a)) - (h = this.normalizeAngel(h))) < 1.0471975511965976;
    }

    @Override
    public void draw(Graphics g) {
        if (this.ownerType == TYPE_BOT) {
            return;
        }
        g.setColor(Color.green);
        int x = 0;
        int y = 0;
        if (this.ownerType == TYPE_PLAYER2) {
            y = this.game.res.height / 2;
        }
        int w = this.game.res.width;
        int h = this.game.res.height / 2;
        int tx = x + w / 2;
        int ty = y + h / 2;
        if (this.target != null) {
            Point p = null;
            Point3D targetMiddle = Point3D.add(this.target.pos, new Point3D(0.0, 10.0, 0.0));
            if (this.ownerType == TYPE_PLAYER1) {
                p = this.game.GE1.pointOnScreen(targetMiddle);
            } else if (this.ownerType == TYPE_PLAYER2) {
                p = this.game.GE2.pointOnScreen(targetMiddle);
            }
            int py = (int)((double)p.y / (double)this.game.INGM_RES.height * (double)this.game.res.height);
            int px = (int)((double)p.x / (double)this.game.INGM_RES.width * (double)this.game.res.width);
            tx = px + x;
            ty = py + y;
        }
        int r1w = 50;
        int r1h = 30;
        int r2w = 200;
        int r2h = 100;
        g.drawLine(x, y, tx - r2w / 2, ty - r2h / 2);
        g.drawLine(x + w, y, tx + r2w / 2, ty - r2h / 2);
        g.drawLine(x, y + h, tx - r2w / 2, ty + r2h / 2);
        g.drawLine(x + w, y + h, tx + r2w / 2, ty + r2h / 2);
        g.drawRect(tx - r2w / 2, ty - r2h / 2, r2w, r2h);
        g.drawLine(tx - r1w / 2, ty - r1h / 2, tx + r1w / 2, ty + r1h / 2);
        g.drawLine(tx + r1w / 2, ty - r1h / 2, tx - r1w / 2, ty + r1h / 2);
        g.drawRect(tx - r1w / 2, ty - r1h / 2, r1w, r1h);
        g.fillRect(tx - r2w / 2, ty + r2h / 2 - 15, r2w, 15);
        g.setColor(Color.black);
        g.setFont(this.game.small);
        if (this.target != null && this.lockCounter <= 0) {
            g.drawString("TARGET LOCKED: " + this.target.getName(), tx - r2w / 2 + 10, ty + r2h / 2);
        } else if (this.target != null && this.lockCounter > 0) {
            g.drawString("LOCKING TARGET " + this.lockCounter, tx - r2w / 2 + 10, ty + r2h / 2);
        } else {
            g.drawString("SEARCHING...", tx - r2w / 2 + 10, ty + r2h / 2);
        }
    }
}

