/*
 * Decompiled with CFR 0.152.
 */
package items;

import art.Art;
import engine.Point3D;
import engine.Sound;
import entities.GFX;
import entities.Racer;
import game.Game;
import items.Item;

public class ItemFusRoDah
extends Item {
    private boolean fired;
    private Racer owner;
    public static double range = 100.0;
    private int counter = 40;

    public ItemFusRoDah(Game g, Racer owner) {
        super(g);
        this.owner = owner;
        this.pic = Art.itemPicFusRoDah;
    }

    @Override
    public void tryUse() {
        if (!this.fired) {
            this.fired = true;
            this.game.sound.play3D(Sound.FUS_RO_DAH, this.game.player1.pos, this.game.player2.pos, this.owner.pos);
        }
    }

    @Override
    public void update() {
        if (this.fired) {
            --this.counter;
        }
        if (this.counter == 0) {
            int i = 0;
            while (i < this.game.racers.size()) {
                Racer r = this.game.racers.get(i);
                if (this.owner.disTo(r) < range && r != this.owner) {
                    Point3D uv = Point3D.mult(1.0 / Point3D.len(Point3D.sub(this.owner.pos, r.pos)), Point3D.sub(this.owner.pos, r.pos));
                    r.vel = Point3D.add(r.vel, Point3D.mult(-4.0, uv));
                }
                ++i;
            }
            int num = 20;
            double h = this.owner.heading;
            double s = 2.0;
            int i2 = 0;
            while (i2 < num) {
                Point3D vel = new Point3D(Math.sin(h) * s, 0.0, Math.cos(h) * s);
                h += Math.PI * 2 / (double)num;
                this.game.addEntity(new GFX(this.game, this.owner.pos.clone(), 3, Point3D.add(vel, this.owner.vel)));
                ++i2;
            }
        }
    }

    @Override
    public boolean isConsumed() {
        return this.fired && this.counter < 0;
    }
}

