/*
 * Decompiled with CFR 0.152.
 */
package items;

import art.Art;
import engine.Point3D;
import entities.Boulder;
import entities.Racer;
import game.Game;
import items.Item;

public class ItemBoulder
extends Item {
    private boolean fired = false;
    private Racer racer;

    public ItemBoulder(Game g, Racer r) {
        super(g);
        this.name = "Rock";
        this.racer = r;
        this.pic = Art.itemPicBoulder;
    }

    @Override
    public void tryUse() {
        if (!this.fired) {
            Point3D pos = new Point3D(this.racer.pos.x + Math.sin(this.racer.heading) * 20.0, this.racer.pos.y, this.racer.pos.z + Math.cos(this.racer.heading) * 20.0);
            Point3D vel = new Point3D(Math.sin(this.racer.heading) * 10.0, 0.0, Math.cos(this.racer.heading) * 10.0);
            this.game.addEntity(new Boulder(this.game, pos, vel));
            this.fired = true;
        }
    }

    @Override
    public boolean isConsumed() {
        return this.fired;
    }

    @Override
    public String getInfo() {
        return "1/1";
    }
}

