/*
 * Decompiled with CFR 0.152.
 */
package entities;

import engine.Point3D;
import engine.Sound;
import engine.Sprite;
import entities.Bot;
import entities.Entity;
import entities.GFX;
import entities.Racer;
import game.Game;

public class Missile
extends Entity {
    private int time = 1240;
    private Racer owner;
    private Racer target;
    private double speed = 7.0;

    public Missile(Game g, Point3D po, Racer owner, Racer target, double heading) {
        super(g, po);
        this.owner = owner;
        this.target = target;
        this.heading = heading;
        this.vel = new Point3D(Math.sin(heading) * this.speed, 0.0, Math.cos(heading) * this.speed);
        this.sprite = new Sprite(this, 13);
    }

    @Override
    public void update() {
        --this.time;
        if (this.time <= 0) {
            this.shallBeRemoved = true;
        }
        if (this.target != null) {
            this.heading = Math.atan2(this.target.pos.x - this.pos.x, this.target.pos.z - this.pos.z);
            this.vel = new Point3D(Math.sin(this.heading) * this.speed, 0.0, Math.cos(this.heading) * this.speed);
        }
        this.move();
    }

    public void move() {
        this.pos.x += this.vel.x;
        this.pos.y += this.vel.y;
        this.pos.z += this.vel.z;
    }

    @Override
    public void collide(Entity entity) {
        if (entity instanceof Racer) {
            entity.dRot = 0.6;
            if (entity instanceof Bot) {
                Bot e = (Bot)entity;
                e.allowCheat = false;
            }
            this.game.addEntity(new GFX(this.game, this.pos, 2, new Point3D(0.0, 0.0, 0.0)));
            this.game.sound.play3D(Sound.EXPLOSION, this.game.player1.pos, this.game.player2.pos, this.pos);
            this.shallBeRemoved = true;
        }
    }
}

