/*
 * Decompiled with CFR 0.152.
 */
package entities;

import engine.GraphicsEngine;
import engine.Point3D;
import engine.Sound;
import engine.Sprite;
import entities.Bot;
import entities.Entity;
import entities.GFX;
import entities.Player;
import entities.Racer;
import game.Game;
import items.Item;
import items.ItemBoulder;
import items.ItemFakeItem;
import items.ItemFusRoDah;
import items.ItemMissile;
import items.ItemTrollMagnet;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class ItemSpawn
extends Entity {
    private int respawnTime = 300;
    private int respawnCounter;

    public ItemSpawn(Game g, Point3D po) {
        super(g, po);
        this.sprite = new Sprite(this, 4);
    }

    @Override
    public void update() {
        --this.respawnCounter;
    }

    @Override
    public void collide(Entity entity) {
        if (entity instanceof Racer && this.respawnCounter < 0 && ((Racer)entity).item == null) {
            ((Racer)entity).item = this.getItem((Racer)entity);
            this.respawnCounter = this.respawnTime;
            this.game.addEntity(new GFX(this.game, new Point3D(entity.pos.x, -10.0, entity.pos.z), 1, new Point3D(0.0, 0.0, 0.0)));
            this.game.sound.play3D(Sound.ITEM_PICKUP, this.game.player1.pos, this.game.player2.pos, entity.pos);
        }
    }

    public Item getItem(Racer racer) {
        int r = (int)(Math.random() * 100.0);
        if (r > 80) {
            return new ItemFakeItem(this.game, racer);
        }
        if (r > 60) {
            return new ItemFusRoDah(this.game, racer);
        }
        if (r > 40) {
            return new ItemTrollMagnet(this.game, racer);
        }
        if (r > 20) {
            return new ItemBoulder(this.game, racer);
        }
        if (racer instanceof Bot) {
            return new ItemMissile(this.game, ItemMissile.TYPE_BOT, racer);
        }
        if (((Player)racer).player == 1) {
            return new ItemMissile(this.game, ItemMissile.TYPE_PLAYER1, racer);
        }
        return new ItemMissile(this.game, ItemMissile.TYPE_PLAYER2, racer);
    }

    @Override
    public void draw(Graphics g, int dy, GraphicsEngine GE, Dimension ingres, Dimension res) {
        if (this.respawnCounter <= 0) {
            this.sprite.draw((Graphics2D)g, dy, GE, ingres, res);
        }
    }
}

