/*
 * Decompiled with CFR 0.152.
 */
package entities;

import engine.Camera;
import engine.GraphicsEngine;
import engine.Point3D;
import engine.Sprite;
import game.Game;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class Entity {
    public Point3D pos;
    protected Sprite sprite;
    public Game game;
    public double heading;
    protected int radius = 5;
    public boolean shallBeRemoved;
    public Point3D vel = new Point3D(0.0, 0.0, 0.0);
    public double dRot = 0.0;

    public Entity(Game g, Point3D po) {
        this.pos = po;
        this.game = g;
    }

    public void setSprite(Sprite s) {
        this.sprite = s;
    }

    public void update() {
    }

    public void draw(Graphics g, int dy, GraphicsEngine GE, Dimension ingres, Dimension res) {
        if (this.sprite != null) {
            this.sprite.draw((Graphics2D)g, dy, GE, ingres, res);
        }
    }

    public boolean collides(Entity e) {
        return this.disTo(e) < (double)(e.radius + this.radius);
    }

    public double disTo(Entity e) {
        return Point3D.len(Point3D.sub(e.pos, this.pos));
    }

    public double disToCam(Camera cam) {
        return Point3D.len(Point3D.sub(cam.pos, this.pos));
    }

    public void collide(Entity entity) {
    }

    public double getSpeed() {
        return Point3D.len(this.vel);
    }
}

