/*
 * Decompiled with CFR 0.152.
 */
package engine;

import art.Art;
import engine.Animation;
import engine.GraphicsEngine;
import entities.Entity;
import entities.Missile;
import entities.Racer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

public class Sprite {
    private double SHRINK_FACTOR = 0.012;
    public static final int TREE = 2;
    public static final int CHECK_POINT = 3;
    public static final int ITEM_SPAWN = 4;
    public static final int MISSILE = 5;
    public static final int MARIO = 1;
    public static final int USAMA = 6;
    public static final int ITEM_PICKUP = 7;
    public static final int SNOWMAN = 8;
    public static final int CACTUS = 9;
    public static final int DICTATORS = 10;
    public static final int EXPLOSION = 11;
    public static final int BIRDIE = 12;
    public static final int MISSILE2 = 13;
    public static final int ITEM_FAKE = 14;
    public static final int GABEN = 15;
    public static final int HAWKING = 16;
    public static final int DOVAHKIIN = 17;
    public static final int SLOTH = 18;
    public static final int VADER = 19;
    public static final int FUS = 20;
    public static final int GOAL = 21;
    public static final int GLUE = 22;
    public static final int SIGN = 23;
    public static final int HOUSE = 24;
    public static final int JET = 25;
    public static final int PYRAMID = 26;
    private Entity entity;
    public Animation animation;

    public Sprite(Entity e, int t) {
        this.entity = e;
        this.setImage(t);
    }

    public void racerRow(GraphicsEngine GE) {
        double yrot = GE.cam.yrot;
        if ((yrot %= Math.PI * 2) < 0.0) {
            yrot += Math.PI * 2;
        }
        double heading = this.entity.heading;
        if ((heading %= Math.PI * 2) < 0.0) {
            heading += Math.PI * 2;
        }
        double dir = heading - yrot;
        if ((dir %= Math.PI * 2) < 0.0) {
            dir += Math.PI * 2;
        }
        if ((dir = Math.toDegrees(dir)) >= 22.5 && dir <= 67.5) {
            this.animation.setRow(7);
        } else if (dir >= 67.5 && dir <= 112.5) {
            this.animation.setRow(6);
        } else if (dir >= 112.5 && dir <= 157.5) {
            this.animation.setRow(5);
        } else if (dir >= 157.5 && dir <= 202.5) {
            this.animation.setRow(4);
        } else if (dir >= 202.5 && dir <= 247.5) {
            this.animation.setRow(3);
        } else if (dir >= 247.5 && dir <= 292.5) {
            this.animation.setRow(2);
        } else if (dir >= 292.5 && dir <= 337.5) {
            this.animation.setRow(1);
        } else {
            this.animation.setRow(0);
        }
        dir = Math.toRadians(dir);
    }

    public void missileRow(GraphicsEngine GE) {
        double yrot = GE.cam.yrot;
        if ((yrot %= Math.PI * 2) < 0.0) {
            yrot += Math.PI * 2;
        }
        double heading = this.entity.heading;
        if ((heading %= Math.PI * 2) < 0.0) {
            heading += Math.PI * 2;
        }
        double dir = heading - yrot;
        if ((dir %= Math.PI * 2) < 0.0) {
            dir += Math.PI * 2;
        }
        if ((dir = Math.toDegrees(dir)) >= 45.0 && dir <= 135.0) {
            this.animation.setRow(1);
        } else if (dir >= 135.0 && dir <= 225.0) {
            this.animation.setRow(3);
        } else if (dir >= 225.0 && dir <= 315.0) {
            this.animation.setRow(0);
        } else {
            this.animation.setRow(2);
        }
        dir = Math.toRadians(dir);
    }

    public void draw(Graphics g, int dy, GraphicsEngine GE, Dimension ingres, Dimension res) {
        this.animation.next();
        if (this.entity instanceof Racer) {
            this.racerRow(GE);
        } else if (this.entity instanceof Missile) {
            this.missileRow(GE);
        }
        this.SHRINK_FACTOR = 1.0 / Math.sqrt(res.width * res.height) * 6.65;
        int w = this.animation.image().getWidth();
        int h = this.animation.image().getHeight();
        double d = this.entity.disToCam(GE.cam);
        int sx = (int)((double)w / (d * this.SHRINK_FACTOR));
        int sy = (int)((double)h / (d * this.SHRINK_FACTOR));
        Point p = GE.pointOnScreen(this.entity.pos);
        int py = (int)((double)p.y / (double)ingres.height * (double)res.height);
        int px = (int)((double)p.x / (double)ingres.width * (double)res.width);
        g.drawImage(this.animation.image(), px - sx / 2, py - sy + dy, sx, sy, null);
    }

    public void setImage(int type) {
        switch (type) {
            case 1: {
                this.animation = new Animation(Art.mario, 0, 5, 1);
                break;
            }
            case 2: {
                this.animation = new Animation(Art.tree, 0, 5, 1);
                break;
            }
            case 3: {
                this.animation = new Animation(Art.checkpoint, 0, 5, 1);
                break;
            }
            case 21: {
                this.animation = new Animation(Art.goal, 0, 5, 1);
                break;
            }
            case 4: {
                this.animation = new Animation(Art.itemSpawn, 0, 5, 1);
                break;
            }
            case 5: {
                this.animation = new Animation(Art.missile, 0, 5, 1);
                break;
            }
            case 6: {
                this.animation = new Animation(Art.usama, 0, 5, 1);
                break;
            }
            case 7: {
                this.animation = new Animation(Art.itemPickup, 0, 5, 11);
                break;
            }
            case 8: {
                this.animation = new Animation(Art.snowman, 0, 10, 1);
                break;
            }
            case 9: {
                this.animation = new Animation(Art.cactus, 0, 10, 1);
                break;
            }
            case 10: {
                this.animation = new Animation(Art.dictators, 0, 5, 1);
                break;
            }
            case 15: {
                this.animation = new Animation(Art.gaben, 0, 5, 1);
                break;
            }
            case 11: {
                this.animation = new Animation(Art.explosion, 0, 5, 19);
                break;
            }
            case 20: {
                this.animation = new Animation(Art.fusGFX, 0, 3, 12);
                break;
            }
            case 22: {
                this.animation = new Animation(Art.glueGFX, 0, 3, 12);
                break;
            }
            case 12: {
                this.animation = new Animation(Art.birdie, 0, 5, 1);
                break;
            }
            case 13: {
                this.animation = new Animation(Art.missile2, 0, 5, 1);
                break;
            }
            case 14: {
                this.animation = new Animation(Art.itemFake, 0, 5, 1);
                break;
            }
            case 16: {
                this.animation = new Animation(Art.hawking, 0, 5, 1);
                break;
            }
            case 17: {
                this.animation = new Animation(Art.dovahkiin, 0, 5, 1);
                break;
            }
            case 18: {
                this.animation = new Animation(Art.sloth, 0, 5, 1);
                break;
            }
            case 19: {
                this.animation = new Animation(Art.vader, 0, 5, 1);
                break;
            }
            case 23: {
                this.animation = new Animation(Art.sign, 0, 5, 1);
                break;
            }
            case 24: {
                this.animation = new Animation(Art.house, 0, 15, 4);
                break;
            }
            case 25: {
                this.animation = new Animation(Art.jetGFX, 0, 3, 7);
                break;
            }
            case 26: {
                this.animation = new Animation(Art.pyramid, 0, 5, 1);
            }
        }
    }
}

