/*
 * Decompiled with CFR 0.152.
 */
package engine;

import engine.Point3D;
import javax.swing.JOptionPane;
import org.newdawn.slick.openal.Audio;
import org.newdawn.slick.openal.AudioLoader;
import org.newdawn.slick.util.ResourceLoader;

public class Sound {
    public float soundVolume = 1.0f;
    public float musicVolume = 1.0f;
    public static Audio TEST;
    public static Audio[] CHARACTER_SELECT;
    public static Audio MENUSONG;
    public static Audio ITEM_PICKUP;
    public static Audio FUS_RO_DAH;
    public static Audio MUSIC;
    public static Audio CRASH;
    public static Audio MISSILE_LAUNCH;
    public static Audio EXPLOSION;
    public static Audio ENGINE;
    public static Audio SPLASH;
    public static Audio JET;
    public static Audio THUNDER;
    public static Audio BEEP;
    public static Audio GO;
    public static Audio BIRDIE_KART;
    double hearingDistance = 400.0;

    public Sound() {
        this.loadAudio();
    }

    public void loadAudio() {
        try {
            TEST = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/test.wav"));
            CHARACTER_SELECT = new Audio[]{AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/dictator_select2.wav")), AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/birdie_select.wav")), AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/usama_select2.wav")), AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/gaben_select.wav")), AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/hawking_select2.wav")), AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/dovahkiin.wav")), AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/sloth_select.wav")), AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/vader_select2.wav"))};
            MENUSONG = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/riff2long.wav"));
            ITEM_PICKUP = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/itemPickup.wav"));
            FUS_RO_DAH = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/fus_ro_dah3.wav"));
            MUSIC = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/lololol.wav"));
            CRASH = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/crash.wav"));
            MISSILE_LAUNCH = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/missile_launch.wav"));
            EXPLOSION = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/explosion.wav"));
            ENGINE = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/engine1s.wav"));
            SPLASH = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/splash.wav"));
            JET = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/jet.wav"));
            JET = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/jet.wav"));
            THUNDER = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/thunder.wav"));
            BEEP = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/beep.wav"));
            GO = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/go.wav"));
            BIRDIE_KART = AudioLoader.getAudio("WAV", ResourceLoader.getResourceAsStream("engine/birdie kart.wav"));
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "ljud fel: " + e.getMessage());
            System.out.println("FELFELFEL");
        }
    }

    public void stop(Audio audio) {
        audio.stop();
    }

    public void play(Audio audio) {
        audio.playAsSoundEffect(1.0f, this.soundVolume, false);
    }

    public void play(Audio audio, float volume) {
        audio.playAsSoundEffect(1.0f, this.soundVolume * volume, false);
    }

    public void playLoop(Audio audio) {
        audio.playAsSoundEffect(1.0f, this.musicVolume, true);
    }

    public void playLoop(Audio audio, float volume) {
        audio.playAsSoundEffect(1.0f, this.musicVolume * volume, true);
    }

    public void play3D(Audio audio, Point3D p1, Point3D p2, Point3D src) {
        this.play3D(audio, p1, p2, src, 1.0f);
    }

    public void play3D(Audio audio, Point3D p1, Point3D p2, Point3D src, float volume) {
        Point3D closest = Point3D.len(Point3D.sub(p1, src)) < Point3D.len(Point3D.sub(p2, src)) ? p1 : p2;
        double dis = Point3D.len(Point3D.sub(closest, src));
        if (dis > this.hearingDistance) {
            return;
        }
        this.play(audio, volume * this.soundVolume * (float)(1.0 - dis / this.hearingDistance));
    }
}

