/*
 * Decompiled with CFR 0.152.
 */
package engine;

public class FastMath {
    private static final float RAD = (float)Math.PI / 180;
    private static final float DEG = 57.295776f;
    private static final int SIN_BITS = 12;
    private static final int SIN_MASK = ~(-1 << SIN_BITS);
    private static final int SIN_COUNT = SIN_MASK + 1;
    private static final float radFull = (float)Math.PI * 2;
    private static final float radToIndex;
    private static final float degFull;
    private static final float degToIndex;
    private static final float[] sin;
    private static final float[] cos;

    static {
        degFull = 360.0f;
        radToIndex = (float)SIN_COUNT / radFull;
        degToIndex = (float)SIN_COUNT / degFull;
        sin = new float[SIN_COUNT];
        cos = new float[SIN_COUNT];
        int i = 0;
        while (i < SIN_COUNT) {
            FastMath.sin[i] = (float)Math.sin(((float)i + 0.5f) / (float)SIN_COUNT * radFull);
            FastMath.cos[i] = (float)Math.cos(((float)i + 0.5f) / (float)SIN_COUNT * radFull);
            ++i;
        }
        i = 0;
        while (i < 360) {
            FastMath.sin[(int)((float)i * FastMath.degToIndex) & FastMath.SIN_MASK] = (float)Math.sin((double)i * Math.PI / 180.0);
            FastMath.cos[(int)((float)i * FastMath.degToIndex) & FastMath.SIN_MASK] = (float)Math.cos((double)i * Math.PI / 180.0);
            i += 90;
        }
    }

    public static final float sin(double rad) {
        return sin[(int)(rad * (double)radToIndex) & SIN_MASK];
    }

    public static final float cos(double rad) {
        return cos[(int)(rad * (double)radToIndex) & SIN_MASK];
    }

    public static final float tan(double rad) {
        return FastMath.sin(rad) / FastMath.cos(rad);
    }

    public static final float sinDeg(float deg) {
        return sin[(int)(deg * degToIndex) & SIN_MASK];
    }

    public static final float cosDeg(float deg) {
        return cos[(int)(deg * degToIndex) & SIN_MASK];
    }
}

