/*
 * Decompiled with CFR 0.152.
 */
package engine;

import java.awt.image.BufferedImage;

public class Animation {
    private int count;
    private int row;
    private int frames;
    private BufferedImage[][] images;
    private int curInt;
    private int sleep;

    public Animation(BufferedImage[][] imgs, int r, int s, int f) {
        this.images = imgs;
        this.row = r;
        this.sleep = s;
        this.frames = f;
    }

    public void setSheet(BufferedImage[][] imgs) {
        this.images = imgs;
    }

    public void setRow(int r) {
        this.row = r;
    }

    public void set(int r, int s, int f) {
        this.row = r;
        this.sleep = s;
        this.frames = f;
    }

    public void next() {
        if (this.count % this.sleep == 0) {
            ++this.curInt;
        }
        if (this.count == Integer.MAX_VALUE) {
            this.count = 0;
        }
        ++this.count;
    }

    public void reset() {
        this.curInt = 0;
        this.count = 0;
    }

    public void stop() {
        this.count = 1;
    }

    public BufferedImage image() {
        return this.images[this.curInt % this.frames][this.row];
    }

    public boolean singleTimeAnimationFinished() {
        return this.curInt >= this.frames - 1;
    }
}

