/*
 * Decompiled with CFR 0.152.
 */
package art;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Art {
    public static BufferedImage naLeaderboard = Art.load("/art/na_leaderboard.png");
    public static BufferedImage usamaLeaderboard = Art.load("/art/usama_leaderboard.png");
    public static BufferedImage marioLeaderboard = Art.load("/art/mario_leaderboard.png");
    public static BufferedImage dictatorsLeaderboard = Art.load("/art/dictators_leaderboard.png");
    public static BufferedImage birdieLeaderboard = Art.load("/art/birdie_leaderboard.png");
    public static BufferedImage speedMeter = Art.load("/art/speedmeter.png");
    public static BufferedImage picNA = Art.load("/art/pic_na.png");
    public static BufferedImage mapWood = Art.load("/art/skummaskogen/track1.png");
    public static BufferedImage mapIcy = Art.load("/art/icyroad/track2.png");
    public static BufferedImage spriteMapIcy = Art.load("/art/icyroad/icy_sprites.png");
    public static BufferedImage picIcy = Art.load("/art/icyroad/pic_icy.png");
    public static BufferedImage woodyPic = Art.load("/art/skummaskogen/woodyPic.png");
    public static BufferedImage mapSprites = Art.load("/art/map_sprites.png");
    public static BufferedImage woodysprites = Art.load("/art/skummaskogen/woodysprites_bot.png");
    public static BufferedImage mapDesert = Art.load("/art/desert/desert_track.png");
    public static BufferedImage picDesert = Art.load("/art/desert/pic_desert.png");
    public static BufferedImage spriteMapDesert = Art.load("/art/desert/desert_sprites.png");
    public static BufferedImage picCity = Art.load("/art/stad/pic_city.png");
    public static BufferedImage spriteMapCity = Art.load("/art/stad/stad_sprites.png");
    public static BufferedImage mapCity = Art.load("/art/stad/stad.png");
    public static BufferedImage car = Art.load("/art/car2.png");
    public static BufferedImage introScreen = Art.load("/art/introscreen.png");
    public static BufferedImage introOJ = Art.load("/art/introOJ.png");
    public static BufferedImage introBirdie = Art.load("/art/introBirdie.png");
    public static BufferedImage charScreen = Art.load("/art/characterscreen.png");
    public static BufferedImage mapScreen = Art.load("/art/mapscreen.png");
    public static BufferedImage noItem = Art.load("/art/no_item.png");
    public static BufferedImage itemPicBoulder = Art.load("/art/item_boulder.png");
    public static BufferedImage itemPicMagnet = Art.load("/art/item_magnet.png");
    public static BufferedImage itemPicMissile = Art.load("/art/item_missile.png");
    public static BufferedImage itemPicFake = Art.load("/art/item_fake.png");
    public static BufferedImage itemPicFusRoDah = Art.load("/art/item_fus_ro_dah.png");
    public static BufferedImage[][] tree = Art.split(Art.load("/art/tree2.png"), 136, 188);
    public static BufferedImage[][] snowman = Art.split(Art.load("/art/snowman.png"), 100, 130);
    public static BufferedImage[][] cactus = Art.split(Art.load("/art/kaktus.png"), 79, 150);
    public static BufferedImage[][] sign = Art.split(Art.load("/art/sign.png"), 50, 120);
    public static BufferedImage[][] house = Art.split(Art.load("/art/house.png"), 300, 1000);
    public static BufferedImage[][] pyramid = Art.split(Art.load("/art/pyramid.png"), 918, 614);
    public static BufferedImage[][] mario = Art.split(Art.load("/art/marios.png"), 40, 40);
    public static BufferedImage[][] usama = Art.split(Art.load("/art/usama.png"), 40, 40);
    public static BufferedImage[][] checkpoint = Art.split(Art.load("/art/chekpoint3.png"), 500, 150);
    public static BufferedImage[][] goal = Art.split(Art.load("/art/goal.png"), 500, 150);
    public static BufferedImage[][] itemSpawn = Art.split(Art.load("/art/itemspawn.png"), 30, 30);
    public static BufferedImage[][] itemFake = Art.split(Art.load("/art/fake_item.png"), 30, 30);
    public static BufferedImage[][] missile = Art.split(Art.load("/art/cannonball.png"), 20, 20);
    public static BufferedImage[][] itemPickup = Art.split(Art.load("/art/item_pickup.png"), 80, 80);
    public static BufferedImage[][] explosion = Art.split(Art.load("/art/explosion.png"), 50, 38);
    public static BufferedImage[][] fusGFX = Art.split(Art.load("/art/fus_ro_dah.png"), 60, 50);
    public static BufferedImage[][] glueGFX = Art.split(Art.load("/art/glue_explosion.png"), 60, 50);
    public static BufferedImage[][] jetGFX = Art.split(Art.load("/art/jet.png"), 16, 20);
    public static BufferedImage[][] dictators = Art.split(Art.load("/art/dictators_back3.png"), 63, 45);
    public static BufferedImage[][] gaben = Art.split(Art.load("/art/gabens.png"), 63, 45);
    public static BufferedImage[][] birdie = Art.split(Art.load("/art/birdie.png"), 37, 30);
    public static BufferedImage[][] hawking = Art.split(Art.load("/art/hawking.png"), 31, 35);
    public static BufferedImage[][] dovahkiin = Art.split(Art.load("/art/dovahkiin.png"), 23, 40);
    public static BufferedImage[][] sloth = Art.split(Art.load("/art/sloths.png"), 33, 45);
    public static BufferedImage[][] vader = Art.split(Art.load("/art/vader_back.png"), 44, 35);
    public static BufferedImage[][] missile2 = Art.split(Art.load("/art/missile.png"), 64, 20);
    public static BufferedImage[][] portraits = Art.split(Art.load("/art/portraits.png"), 50, 50);

    public static BufferedImage emptyImage(int w, int h) {
        return new BufferedImage(w, h, 1);
    }

    public static BufferedImage load(String name) {
        try {
            BufferedImage loaded = ImageIO.read(Art.class.getResource(name));
            BufferedImage img = new BufferedImage(loaded.getWidth(), loaded.getHeight(), 2);
            Graphics g = img.getGraphics();
            g.drawImage(loaded, 0, 0, null, null);
            g.dispose();
            return img;
        }
        catch (IOException e) {
            System.out.println("Hittade inte filen");
            return null;
        }
    }

    public static BufferedImage[][] split(BufferedImage img, int w, int h) {
        int xSlices = img.getWidth() / w;
        int ySlices = img.getHeight() / h;
        BufferedImage[][] imgs = new BufferedImage[xSlices][ySlices];
        int x = 0;
        while (x < xSlices) {
            int y = 0;
            while (y < ySlices) {
                imgs[x][y] = new BufferedImage(w, h, 2);
                Graphics g = imgs[x][y].getGraphics();
                g.drawImage(img, -x * w, -y * h, null);
                g.dispose();
                ++y;
            }
            ++x;
        }
        return imgs;
    }

    public static BufferedImage enlarge(BufferedImage old, int w, int h) {
        BufferedImage img = new BufferedImage(old.getWidth() * w, old.getHeight() * h, 2);
        Graphics g = img.getGraphics();
        int x = 0;
        while (x < old.getWidth()) {
            int y = 0;
            while (y < old.getHeight()) {
                if (old.getRGB(x, y) != 0) {
                    g.setColor(new Color(old.getRGB(x, y)));
                    g.fillRect(x * w, y * h, w, h);
                }
                ++y;
            }
            ++x;
        }
        g.dispose();
        return img;
    }

    private static BufferedImage[][] mirrorsplit(BufferedImage src, int xs, int ys) {
        int xSlices = src.getWidth() / xs;
        int ySlices = src.getHeight() / ys;
        BufferedImage[][] res = new BufferedImage[xSlices][ySlices];
        int x = 0;
        while (x < xSlices) {
            int y = 0;
            while (y < ySlices) {
                res[x][y] = new BufferedImage(xs, ys, 2);
                Graphics g = res[x][y].getGraphics();
                g.drawImage(src, xs, 0, 0, ys, x * xs, y * ys, (x + 1) * xs, (y + 1) * ys, null);
                g.dispose();
                ++y;
            }
            ++x;
        }
        return res;
    }

    public static int getRGB(BufferedImage img, int x, int y) {
        return img.getRGB(x, y) & 0xFFFFFF;
    }

    public static void setPixel(BufferedImage img, int x, int y, Color c) {
        Graphics g = img.getGraphics();
        g.setColor(c);
        g.fillRect(x, y, 1, 1);
        g.dispose();
    }

    public static BufferedImage color(BufferedImage img, Color c) {
        Graphics g = img.getGraphics();
        int x = 0;
        while (x < img.getWidth()) {
            int y = 0;
            while (y < img.getHeight()) {
                if (Art.getRGB(img, x, y) == 0) {
                    g.setColor(c);
                    g.fillRect(x, y, 1, 1);
                }
                ++y;
            }
            ++x;
        }
        g.dispose();
        return img;
    }

    public static void nullPics() {
        mapWood = null;
        mapIcy = null;
        spriteMapIcy = null;
        mapSprites = null;
        woodysprites = null;
        mapDesert = null;
        spriteMapDesert = null;
        spriteMapCity = null;
        mapCity = null;
    }

    public static void reloadPics() {
        mapWood = Art.load("/art/skummaskogen/track1.png");
        mapIcy = Art.load("/art/icyroad/track2.png");
        spriteMapIcy = Art.load("/art/icyroad/icy_sprites.png");
        woodysprites = Art.load("/art/skummaskogen/woodysprites_bot.png");
        mapDesert = Art.load("/art/desert/desert_track.png");
        spriteMapDesert = Art.load("/art/desert/desert_sprites.png");
        spriteMapCity = Art.load("/art/stad/stad_sprites.png");
        mapCity = Art.load("/art/stad/stad.png");
    }

    public static void reloadPicWoods() {
        mapWood = Art.load("/art/skummaskogen/track1.png");
        woodysprites = Art.load("/art/skummaskogen/woodysprites_bot.png");
    }

    public static void reloadPicIce() {
        mapIcy = Art.load("/art/icyroad/track2.png");
        spriteMapIcy = Art.load("/art/icyroad/icy_sprites.png");
    }

    public static void reloadPicDesert() {
        mapDesert = Art.load("/art/desert/desert_track.png");
        spriteMapDesert = Art.load("/art/desert/desert_sprites.png");
    }

    public static void reloadPicCity() {
        spriteMapCity = Art.load("/art/stad/stad_sprites.png");
        mapCity = Art.load("/art/stad/stad.png");
    }
}

