
var audio = [];

audio[0] = new Audio();
audio[0].addEventListener('canplaythrough', audioLoaded, false);
audio[0].loop = true;
audio[0].src = 'tracks/01_ps-332_051230.ogg';

audio[1] = new Audio();
audio[1].addEventListener('canplaythrough', audioLoaded, false);
audio[1].loop = true;
audio[1].src = 'tracks/04_ps-332c_060105.ogg';

audio[2] = new Audio();
audio[2].addEventListener('canplaythrough', audioLoaded, false);
audio[2].loop = true;
audio[2].src = 'tracks/01_rngmnn_-_what_goes_around_comes_around.ogg';

audio[3] = new Audio();
audio[3].addEventListener('canplaythrough', audioLoaded, false);
audio[3].loop = true;
audio[3].src = 'tracks/09_un_-_one_last_look.ogg';
audio[3]._volume = 0.6;

audio[4] = new Audio();
audio[4].addEventListener('canplaythrough', audioLoaded, false);
audio[4].loop = true;
audio[4].src = 'tracks/05_aktivehate_-_ugly_inside.ogg';
audio[4]._volume = 0.1;

audio[5] = new Audio();
audio[5].addEventListener('canplaythrough', audioLoaded, false);
audio[5].loop = true;
audio[5].src = 'tracks/05_aktivehate_-_ugly_inside.ogg';
audio[5]._volume = 0.1;

audio[6] = new Audio();
audio[6].addEventListener('canplaythrough', audioLoaded, false);
audio[6].loop = true;
audio[6].src = 'tracks/13_duncan_avoid_-_mind_breach__danny_kreutzfeldt_version_.ogg';
audio[6]._volume = 0.8;

audio[7] = new Audio();
audio[7].addEventListener('canplaythrough', audioLoaded, false);
audio[7].loop = true;
audio[7].src = 'tracks/02_un_-_the_tempest.ogg';
audio[7]._volume = 0.7;

audio[8] = new Audio();
audio[8].addEventListener('canplaythrough', audioLoaded, false);
audio[8].loop = true;
audio[8].src = 'tracks/kooitriplexcd2_11-p5.ogg';

audio[9] = new Audio();
audio[9].addEventListener('canplaythrough', audioLoaded, false);
audio[9].loop = true;
audio[9].src = 'tracks/01_edgeist_-_dawn.ogg';
audio[9]._volume = 0.7;


var activeaudio = null;
var loadedaudio = 0;
var timeout;

function audioLoaded() {
	loadedaudio++;
	if (loadedaudio == audio.length) init(); //doneLoadingAudio();
}


function playAudio(id) {

	var prev = activeaudio;
	activeaudio = id;
	audio[activeaudio].volume = 0.0;
	audio[activeaudio].play();
	
	if (timeout) {
		clearTimeout(timeout);
	}
	
	function doFade() {
		timeout = setTimeout( function() {
			
			var ready = 0;
			var target = 1.0;
			
			if (audio[activeaudio]._volume) target = audio[activeaudio]._volume;
			
			if ( audio[activeaudio].volume < target ) {
				var vol = audio[activeaudio].volume + 0.05;
				if (vol >= target ) audio[activeaudio].volume = target;
				 else audio[activeaudio].volume = vol;
			} else {
				ready++;
			}
			
			for (i=0; i< audio.length; i++) {
				if (i !== activeaudio) {
					if ( audio[i].volume > 0.0 ) {
						vol = audio[i].volume - 0.05;
						if (vol < 0.0 ) audio[i].volume = 0.0;
						 else audio[i].volume = vol;
					} else {
						//console.log(i + " ready");
						ready++;
						audio[i].pause();
					}
				}
			}

			//console.log(activeaudio + " " + audio.length + " " + ready + " " + audio[activeaudio].volume + " " + target);
			
			if (ready == audio.length) {
				//if (prev) audio[prev].pause();
				//console.log("finished crossfade");
			} else {
				doFade();
			}
		}, 200 );
	}
	
	doFade();
}


// fade functions hacked from buzz.js
/*
function fadeIn( src, volume, duration, callback ) {
	fadeTo( src, volume, duration, callback );
}
        
function fadeOut( src, duration, callback ) {
	fadeTo( src, 0.0, duration, callback );
}
        
function fadeWith( src, dst, volume, duration ) {
	if (flagready) {
		flagready = false;
		fadeOut( src, duration, function() {
			src.pause();
		});
		fadeIn( dst, volume, duration, null );
	} else {
		setTimeout( function() {
			fadeWith( src, dst, volume, duration );
		}
		, default_duration);
	}
}

function fadeTo( src, to, duration, callback ) {
	if ( duration instanceof Function ) {
		callback = duration;
		duration = default_duration;
	} else {
		duration = duration || default_duration;
	}

	var from = src.volume,
		delay = duration / (Math.abs( from - to )*100);
	
	var thistimeout;
	
	function doFade() {
		setTimeout( function() {
			console.log(activeaudio + " " + from + " " + to + " " + src.volume);
			if ( from < to && src.volume < to ) {
				//console.log("vol: "+src.volume);
				var vol = src.volume + 0.01;
				if (vol > 1.0) src.volume = 1.0;
				 else src.volume = vol;
				doFade();
			} else if ( from > to && src.volume > to ) {
				var vol = src.volume - 0.01;
				if (vol < 0.0) src.volume = 0.0;
				 else src.volume = vol;
				doFade();                        
			} else {
				
				ready++;
				if (ready == 2) {
					ready = 0;
					flagready = true;
				}
				
				if ( callback instanceof Function ) {
					callback.apply( src );
				}
			}
		}, delay );
	}
	
	doFade();

}
*/