#version 120

uniform sampler2D texture;

uniform vec2 screen;
uniform vec2 position;
uniform float radius;
uniform vec3 ci;

void main(){
	float posy = screen.y - position.y;
	
	vec2 fc = gl_TexCoord[0].xy * screen; // gl_FragCoord.xy + toffset
	
	float c = radius / ((position.x - fc.x) * (position.x - fc.x) + (posy - fc.y) * (posy - fc.y));
	
	float ax = -4.0 * gl_TexCoord[0].x * gl_TexCoord[0].x + 4.0 * gl_TexCoord[0].x;
	float ay = -4.0 * gl_TexCoord[0].y * gl_TexCoord[0].y + 4.0 * gl_TexCoord[0].y;
	
	gl_FragColor = vec4(c * ci.r, c * ci.g, c * ci.b, ax*ay);
}