#version 120

uniform sampler2D texture;
uniform sampler2D glowTex;

uniform vec2 screen;
uniform vec2 offset;

uniform vec2 targetDim;

uniform float time;
uniform float alpha;

void main(){
	vec2 toffset = vec2(800.0-offset.x, offset.y);
	
	vec2 ouv = gl_TexCoord[0].xy;
	vec2 guv = ouv * targetDim / vec2(800.f, 800.f) + toffset / targetDim;
	
	vec4 gc = texture2D(glowTex, guv);
	
	float ic = abs(0.5-ouv.x);
	//+sin(time/2.0+ouv.x*20.0)/45.0
	vec4 oc = texture2D(texture,
		vec2(
			ouv.x,
			ouv.y //+ gc.a / 8.0//- ic*ic*0.1
	));
	
	float b = (oc.r + oc.g + oc.b) * 0.5;
	
	vec4 final = vec4(oc.rgb + gc.a * b, oc.a * alpha);
	
	gl_FragColor = final;
}