/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import java.util.ArrayList;
import org.lwjgl.Sys;
import org.newdawn.slick.Image;
import peli.Atom;
import peli.Model;

public class Entity {
    protected Image kuva;
    protected Atom[][] rep;
    protected int[][] repInt;
    protected String type;
    protected float speed;
    protected int shields;
    protected boolean alive;
    protected Point middle;
    protected long delta;
    protected long lastTime;
    protected boolean fire;
    protected int batteries;
    protected int points;
    protected float xVector;
    protected float yVector;
    protected String state;
    protected long timer;
    protected float xAddDouble;
    protected float yAddDouble;
    protected float xUnitVector;
    protected float yUnitVector;
    protected float length;
    protected int xAdd;
    protected int yAdd;
    protected boolean hasFired;
    protected Model world;
    protected int xsize;
    protected int ysize;
    protected int zoomlevel;
    protected int xborder;
    protected int yborder;
    protected int current;

    Entity() {
        this.alive = true;
    }

    Entity(int x, int y, String t, Point d, int xsize, int ysize, int zoom) {
        this.current = 0;
        this.xsize = xsize;
        this.ysize = ysize;
        this.zoomlevel = zoom;
        this.xborder = xsize / this.zoomlevel;
        this.yborder = ysize / this.zoomlevel;
        this.yAddDouble = 0.0f;
        this.xAddDouble = 0.0f;
        this.type = t;
        this.lastTime = Sys.getTime();
        this.alive = true;
        this.delta = 0L;
    }

    public ArrayList<Atom> makeRepresentation(int[][] r) {
        ArrayList<Atom> palautus = new ArrayList<Atom>();
        int k = 0;
        while (k < r.length) {
            int j = 0;
            while (j < r[k].length) {
                if (r[k][j] != 0) {
                    palautus.add(new Atom(j, k, r[k][j]));
                }
                ++j;
            }
            ++k;
        }
        return palautus;
    }

    public boolean didItHit(int x, int y) {
        Atom[] atomArray = this.rep[this.current];
        int n = atomArray.length;
        int n2 = 0;
        while (n2 < n) {
            Atom a = atomArray[n2];
            if (a == null) break;
            if (a.x_coord + this.middle.x == x && a.y_coord + this.middle.y == y) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void youWereHit(int material) {
        if (this.type == "Bullet1" || this.type == "Bullet2" || this.type == "Enemy Bullet1" || this.type == "Enemy Bullet2" || this.type == "Enemy Bullet3") {
            this.alive = false;
            return;
        }
        if (material == 2 || material == 5 || material == 1 || material == 4 || material == 0) {
            this.shields -= 1000;
            this.state = "Hit";
        }
        if (material == 3) {
            this.shields -= 2001;
            this.state = "Hit";
        }
        if (this.shields <= 0) {
            this.state = "Destroyed";
        }
    }

    public void setFired() {
        this.hasFired = true;
    }

    public Atom[] getRep() {
        return this.rep[this.current];
    }

    public String getState() {
        return this.state;
    }

    public void setState(String s) {
        this.state = s;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void moveIt() {
        this.length = (float)Math.sqrt(this.xVector * this.xVector + this.yVector * this.yVector);
        this.xUnitVector = this.xVector / this.length;
        this.yUnitVector = this.yVector / this.length;
        if (this.type == "Player") {
            this.xAddDouble += this.xVector;
            this.yAddDouble += this.yVector;
        } else {
            this.xAddDouble += this.xUnitVector * this.speed;
            this.yAddDouble += this.yUnitVector * this.speed;
        }
        this.xAdd = (int)this.xAddDouble;
        this.yAdd = (int)this.yAddDouble;
        this.xAddDouble -= (float)this.xAdd;
        this.yAddDouble -= (float)this.yAdd;
        this.middle.setLocation(this.middle.getX() + (double)this.xAdd, this.middle.getY() + (double)this.yAdd);
    }

    public void Live() {
        if (!this.alive) {
            return;
        }
        this.delta = Sys.getTime() - this.lastTime;
        this.lastTime = Sys.getTime();
    }

    public int getShields() {
        return this.shields;
    }

    public String getType() {
        return this.type;
    }

    public long getTimer() {
        return this.timer;
    }

    public void setTimer(long l) {
        this.timer = l;
    }
}

