/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Font;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.lwjgl.LWJGLException;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.newdawn.slick.Color;
import org.newdawn.slick.TrueTypeFont;
import peli.Atom;
import peli.Entity;
import peli.Hiscoretable;
import peli.Model;

public class View {
    private int zoom_level;
    private static final int HASSHOT = 66;
    private Model world;
    private TrueTypeFont font2;
    private TrueTypeFont font3;
    private TrueTypeFont font4;
    private TrueTypeFont font5;
    private boolean suljetaan;
    String views;
    private int xsize;
    private int ysize;
    private int zoomlevel;
    private Hiscoretable taulu;
    private String nimi;
    boolean t;
    private ObjectOutputStream obj_out;

    View(int xkoko, int ykoko, int zoom) {
        this.world = new Model(xkoko, ykoko, zoom);
        this.zoomlevel = zoom;
        this.xsize = xkoko;
        this.ysize = ykoko;
        this.views = "Start";
        try {
            FileInputStream f_in = new FileInputStream("hiscoretable");
            ObjectInputStream obj_in = new ObjectInputStream(f_in);
            Object obj = obj_in.readObject();
            if (obj instanceof Hiscoretable) {
                this.taulu = (Hiscoretable)obj;
            }
        }
        catch (FileNotFoundException obj_in) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (this.taulu == null) {
            this.taulu = new Hiscoretable();
            try {
                FileOutputStream f_out = new FileOutputStream("hiscoretable");
                this.obj_out = new ObjectOutputStream(f_out);
                this.obj_out.writeObject(this.taulu);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.suljetaan = false;
        this.nimi = new String();
        this.t = false;
    }

    public void changeColor(Atom a) {
        GL11.glColor3f(0.99f, 0.99f, 0.99f);
        if (a.material == 1) {
            GL11.glColor3f(0.99f, 0.99f, 0.99f);
        }
        if (a.material == 2) {
            GL11.glColor3f(0.99f, 0.54f, 0.0f);
        }
        if (a.material == 3) {
            GL11.glColor3f(0.99f, 0.0f, 0.99f);
        }
        if (a.material == 4) {
            GL11.glColor3f(0.99f, 0.99f, 0.0f);
        }
        if (a.material == 5) {
            GL11.glColor3f(0.99f, 0.0f, 0.0f);
        }
    }

    public void start() throws InterruptedException {
        try {
            Display.setDisplayMode(new DisplayMode(this.xsize, this.ysize));
            Display.create();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
            System.exit(0);
        }
        GL11.glMatrixMode(5889);
        GL11.glOrtho(0.0, this.xsize, this.ysize, 0.0, -1.0, 1.0);
        GL11.glMatrixMode(5888);
        Font awtFont = new Font("Times New Roman", 1, 44);
        TrueTypeFont font = new TrueTypeFont(awtFont, false);
        Font awtFont2 = new Font("Tahoma", 1, 13);
        this.font2 = new TrueTypeFont(awtFont2, false);
        Font awtFont3 = new Font("Tahoma", 0, 40);
        this.font3 = new TrueTypeFont(awtFont3, false);
        Font awtFont4 = new Font("Tahoma", 1, 20);
        this.font4 = new TrueTypeFont(awtFont4, false);
        Font awtFont5 = new Font("Tahoma", 0, 15);
        this.font5 = new TrueTypeFont(awtFont5, false);
        try {
            Keyboard.create();
        }
        catch (LWJGLException e1) {
            e1.printStackTrace();
        }
        long delta = 0L;
        long lastTime = Sys.getTime();
        while (!Display.isCloseRequested() && !this.suljetaan) {
            int n;
            delta = Sys.getTime() - lastTime;
            Display.sync(60);
            if (this.views == "Start") {
                this.world.newGame();
                GL11.glClear(16640);
                GL11.glEnable(3042);
                GL11.glBlendFunc(770, 771);
                this.font3.drawString((this.xsize - font.getWidth("Goldwingu!")) / 2, 80.0f, "Goldwingu!", Color.orange);
                String[] tt = new String[]{"Welcome to your destruction!", "Use cursor keys to move your ship.", "Shoot with 'Z' and 'X' keys for normal and supershots.", "Adjust your ships speed with 'C' key,", "and your weapons recharging rate with the 'V' key.", "Be careful not to drain your shields though!", "Powershots are faster and more powerful but limited in number,", "you get more powershots from successful hits from your normal shots."};
                int j = 0;
                String[] stringArray = tt;
                int n2 = tt.length;
                n = 0;
                while (n < n2) {
                    String k = stringArray[n];
                    this.font2.drawString((this.xsize - this.font2.getWidth(k)) / 2, 180 + 20 * ++j, k, Color.pink);
                    ++n;
                }
                this.font2.drawString((this.xsize - this.font2.getWidth("Press spacebar to begin")) / 2, this.ysize / 2 + 20, "Press spacebar to begin", Color.pink);
                GL11.glDisable(3042);
                if (delta > 5000L) {
                    this.views = "Hiscoretable";
                    lastTime = Sys.getTime();
                    delta = Sys.getTime() - lastTime;
                }
                this.processKeyboard();
                Display.update();
            }
            if (this.views == "Game Over") {
                GL11.glClear(16640);
                GL11.glEnable(3042);
                GL11.glBlendFunc(770, 771);
                this.font2.drawString((this.xsize - this.font2.getWidth("Game Over")) / 2, this.ysize / 2, "Game Over", Color.pink);
                this.font2.drawString((this.xsize - this.font2.getWidth("Your final score: " + this.world.getPlayer().getScore())) / 2, this.ysize / 2 + 20, "Your final score: " + this.world.getPlayer().getScore(), Color.pink);
                if (this.taulu.checkScores(this.world.getPlayer().getScore())) {
                    this.font2.drawString((this.xsize - this.font2.getWidth("You made the Highscore table!")) / 2, this.ysize / 2 + 40, "You made the Highscore table!", Color.pink);
                    this.font2.drawString((this.xsize - this.font2.getWidth("Enter your name:")) / 2, this.ysize / 2 + 60, "Enter your name:", Color.pink);
                    this.font2.drawString((this.xsize - this.font2.getWidth(this.nimi)) / 2, this.ysize / 2 + 80, this.nimi, Color.pink);
                    if (this.t) {
                        this.checkHiScore();
                        this.t = false;
                        this.views = "Hiscoretable";
                        lastTime = Sys.getTime();
                        delta = Sys.getTime() - lastTime;
                    }
                } else if (delta > 5000L) {
                    lastTime = Sys.getTime();
                    delta = Sys.getTime() - lastTime;
                    this.world.setState("Playing");
                    this.views = "Start";
                    this.world.newGame();
                }
                GL11.glDisable(3042);
                this.processKeyboard();
                Display.update();
            }
            if (this.views == "Hiscoretable") {
                GL11.glClear(16640);
                GL11.glEnable(3042);
                GL11.glBlendFunc(770, 771);
                this.font3.drawString((this.xsize - font.getWidth("Hiscores")) / 2, 80.0f, "Hiscores", Color.green);
                int j = 0;
                Object[] objectArray = this.taulu.getNames();
                n = objectArray.length;
                int k = 0;
                while (k < n) {
                    String s = objectArray[k];
                    this.font2.drawString((this.xsize - this.font2.getWidth(s)) / 2 - 100, 600 - j * 20, s, Color.green);
                    ++j;
                    ++k;
                }
                j = 0;
                int[] nArray = this.taulu.getScores();
                objectArray = nArray;
                n = nArray.length;
                k = 0;
                while (k < n) {
                    String i = objectArray[k];
                    this.font2.drawString((this.xsize - this.font2.getWidth(String.valueOf((int)i))) / 2 + 100, 600 - j * 20, String.valueOf((int)i), Color.green);
                    ++j;
                    ++k;
                }
                this.processKeyboard();
                GL11.glDisable(3042);
                if (delta > 5000L) {
                    this.views = "Start";
                    lastTime = Sys.getTime();
                    delta = Sys.getTime() - lastTime;
                }
                Display.update();
            }
            if (this.views != "Game") continue;
            GL11.glClear(16640);
            this.drawUI();
            GL11.glColor3f(0.99f, 0.99f, 0.99f);
            block8: for (Entity e : this.world.getAll()) {
                if (e.getState() == "Dormant" && e.getType() != "Havittaja") continue;
                Atom[] atomArray = e.getRep();
                int n3 = atomArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Atom a = atomArray[n4];
                    if (a == null) continue block8;
                    if (e.getState() == "Hit") {
                        GL11.glColor3f(0.99f, 0.0f, 0.0f);
                    } else {
                        this.changeColor(a);
                    }
                    int x1 = (a.x_coord + e.middle.x) * this.zoomlevel;
                    int y1 = (a.y_coord + e.middle.y) * this.zoomlevel;
                    GL11.glBegin(7);
                    GL11.glVertex2f(x1, y1);
                    GL11.glVertex2f(x1 + this.zoomlevel, y1);
                    GL11.glVertex2f(x1 + this.zoomlevel, y1 + this.zoomlevel);
                    GL11.glVertex2f(x1, y1 + this.zoomlevel);
                    GL11.glEnd();
                    lastTime = Sys.getTime();
                    ++n4;
                }
            }
            Display.update();
            this.world.Live();
            if (this.world.getState() == "Game Over") {
                this.views = "Game Over";
            }
            this.processKeyboard();
        }
        Display.destroy();
    }

    private void checkHiScore() {
        int score = this.world.getPlayer().getScore();
        if (this.taulu.checkScores(score)) {
            this.taulu.putNewScore(score, this.nimi);
            this.nimi = "";
            try {
                FileOutputStream f_out = new FileOutputStream("hiscoretable");
                this.obj_out = new ObjectOutputStream(f_out);
                this.obj_out.writeObject(this.taulu);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void processKeyboard() {
        if (Keyboard.isKeyDown(1)) {
            this.suljetaan = true;
            return;
        }
        if (this.views == "Game Over" && this.taulu.checkScores(this.world.getPlayer().getScore())) {
            while (Keyboard.next() && !this.t) {
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 14 && this.nimi.length() > 0) {
                    this.nimi = this.nimi.substring(0, this.nimi.length() - 1);
                } else if (this.nimi.length() < 15) {
                    this.nimi = String.valueOf(this.nimi) + Keyboard.getEventCharacter();
                }
                this.nimi = this.CheckForLetters(this.nimi);
            }
            if (Keyboard.isKeyDown(28)) {
                this.t = true;
            }
        }
        if (this.views == "Hiscoretable" && Keyboard.isKeyDown(57)) {
            this.views = "Start";
        }
        if (this.views == "Start") {
            if (Keyboard.isKeyDown(57)) {
                this.views = "Game";
            }
            if (Keyboard.isKeyDown(44)) {
                this.views = "Hiscoretable";
            }
            return;
        }
        if (this.views == "Game") {
            if (Keyboard.isKeyDown(200)) {
                this.world.getPlayer().setUp();
            }
            if (Keyboard.isKeyDown(208)) {
                this.world.getPlayer().setDown();
            }
            if (Keyboard.isKeyDown(203)) {
                this.world.getPlayer().setLeft();
            }
            if (Keyboard.isKeyDown(205)) {
                this.world.getPlayer().setRight();
            }
            if (Keyboard.isKeyDown(45)) {
                this.world.getPlayer().setShoot2();
            }
            while (Keyboard.next()) {
                if (!Keyboard.getEventKeyState()) continue;
                if (Keyboard.getEventKey() == 46) {
                    this.world.getPlayer().adjustWeaponCharge();
                }
                if (Keyboard.getEventKey() == 47) {
                    this.world.getPlayer().adjustThrusterCharge();
                }
                if (Keyboard.getEventKey() == 44) {
                    this.world.getPlayer().setShoot();
                }
                if (Keyboard.getEventKey() != 25) continue;
                this.world.togglePause();
            }
        }
    }

    private String CheckForLetters(String nimi2) {
        String palautus = new String();
        char[] cArray = nimi2.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (this.isLetter(c)) {
                palautus = String.valueOf(palautus) + c;
            }
            ++n2;
        }
        return palautus;
    }

    private boolean isLetter(char eventCharacter) {
        char[] kirjaimet;
        char[] cArray = kirjaimet = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'x', 'y', '\u00e5', '\u00e4', '\u00f6', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c5', '\u00c4', '\u00d6'};
        int n = kirjaimet.length;
        int n2 = 0;
        while (n2 < n) {
            char f = cArray[n2];
            if (eventCharacter == f) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Color changeTextColor(int color) {
        if (color > 80) {
            return Color.green;
        }
        if (color > 40) {
            return Color.yellow;
        }
        return Color.red;
    }

    public void drawUI() {
        int k;
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        int t = this.world.getPlayer().getWeaponRecharge();
        if (t == 1) {
            this.font2.drawString(0.0f, this.ysize - 16, "Wpns: Low", Color.white);
        }
        if (t == 2) {
            this.font2.drawString(0.0f, this.ysize - 16, "Wpns: Med", Color.white);
        }
        if (t == 3) {
            this.font2.drawString(0.0f, this.ysize - 16, "Wpns: High", Color.white);
        }
        if ((k = this.world.getPlayer().getThrusterRecharge()) == 1) {
            this.font2.drawString(90.0f, this.ysize - 16, "Spd: Low", Color.white);
        }
        if (k == 2) {
            this.font2.drawString(90.0f, this.ysize - 16, "Spd: Med", Color.white);
        }
        if (k == 3) {
            this.font2.drawString(90.0f, this.ysize - 16, "Spd: High", Color.white);
        }
        int p = this.world.getPlayer().getShields() / 60;
        this.font2.drawString(180.0f, this.ysize - 16, "Shld", this.changeTextColor(p));
        int i = 0;
        while (i < p) {
            this.font2.drawString(210 + i, this.ysize - 16, "|", this.changeTextColor(p));
            ++i;
        }
        int s2 = this.world.getPlayer().getShot2Amount();
        if (s2 > 1000) {
            this.font2.drawString(330.0f, this.ysize - 16, "Powershots: >1k", Color.pink);
        } else {
            this.font2.drawString(330.0f, this.ysize - 16, "Powershots: " + s2, Color.pink);
        }
        this.font2.drawString(475.0f, this.ysize - 16, "Score: " + this.world.getPlayer().getScore(), Color.orange);
        if (this.world.getState() == "Between levels") {
            this.font2.drawString((this.xsize - this.font2.getWidth("Level XXX")) / 2, this.ysize / 2, "Level " + (this.world.getLevel() + 1), Color.pink);
            this.font2.drawString((this.xsize - this.font2.getWidth("Get Ready!")) / 2, this.ysize / 2 + 20, "Get Ready!", Color.pink);
        }
        GL11.glDisable(3042);
    }
}

