/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;
import peli.Enemy;
import peli.Entity;
import peli.Model;
import peli.Path;

public class Wave {
    protected ArrayList<Entity> enemies;
    protected ArrayList<Path> paths;
    protected int level;
    protected Model world;
    protected int type;

    Wave(Model w, int type) {
        this.world = w;
        this.type = type;
        this.enemies = new ArrayList();
        this.paths = new ArrayList();
        this.populatePaths(1);
        this.populateEnemies(1);
        this.level = 1;
    }

    public void populatePaths(int level) {
        int xborder = this.world.getXsize() / this.world.getZoomLevel() / 100;
        int yborder = this.world.getYsize() / this.world.getZoomLevel() / 100;
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(-10, 50));
        points.add(new Point(10, 50));
        this.paths.add(new Path(points, "Eka"));
        points.clear();
        points.clear();
        points.add(new Point(0, 100));
        points.add(new Point(100, 0));
        this.paths.add(new Path(points, "toka"));
        points.clear();
        yborder = 5;
        xborder = 5;
        points.add(new Point(xborder * 0, yborder * 5));
        points.add(new Point(xborder * 1, yborder * 4));
        points.add(new Point(xborder * 1, yborder * 3));
        points.add(new Point(xborder * 2, yborder * 2));
        points.add(new Point(xborder * 3, yborder * 1));
        points.add(new Point(xborder * 3, yborder * 0));
        points.add(new Point(xborder * 3, -yborder * 1));
        points.add(new Point(xborder * 2, -yborder * 2));
        points.add(new Point(xborder * 1, -yborder * 3));
        points.add(new Point(xborder * 0, -yborder * 3));
        points.add(new Point(-xborder * 1, -yborder * 3));
        points.add(new Point(-xborder * 2, -yborder * 2));
        points.add(new Point(-xborder * 3, -yborder * 1));
        points.add(new Point(-xborder * 3, yborder * 0));
        points.add(new Point(-xborder * 3, yborder * 1));
        points.add(new Point(-xborder * 2, yborder * 2));
        points.add(new Point(-xborder * 1, yborder * 3));
        points.add(new Point(-xborder * 1, yborder * 3));
        points.add(new Point(xborder * 0, yborder * 3));
        this.paths.add(new Path(points, "kolmas"));
        yborder = 10;
        xborder = 10;
        points.clear();
        points.add(new Point(0, yborder));
        this.paths.add(new Path(points, "neljas"));
        points.clear();
        points.add(new Point(xborder * 5, 0));
        points.add(new Point(0, yborder));
        this.paths.add(new Path(points, "viides"));
        points.clear();
        points.add(new Point(-xborder, 0));
        this.paths.add(new Path(points, "viides"));
    }

    public ArrayList<Entity> getEnemies() {
        return this.enemies;
    }

    public void populateEnemies(int level) {
        int j;
        int s;
        int k;
        Random r = new Random();
        this.enemies.clear();
        if (this.type == 3) {
            int j2 = 0;
            while (j2 < level) {
                this.enemies.add(new Enemy(0, 0, level * j2, this.paths.get(1), this.world, 3));
                ++j2;
            }
        }
        if (this.type == 4 && level > 4) {
            k = 1;
            while (k < level - 4) {
                s = r.nextInt(100);
                this.enemies.add(new Enemy(s + 20, -30, 5000 + k * 4000, this.paths.get(0), this.world, 4));
                this.enemies.add(new Enemy(s, -30, 5000 + k * 4000, this.paths.get(0), this.world, 4));
                this.enemies.add(new Enemy(s + 10, -50, 5000 + k * 4000, this.paths.get(0), this.world, 4));
                ++k;
            }
        }
        if (this.type == 5 && level > 9) {
            k = 1;
            while (k < 2 + level / 10) {
                s = 10 + r.nextInt(50);
                j = 0;
                while (j < level - 8) {
                    this.enemies.add(new Enemy(s, -20, j * 500 + 10000 * k + 5000, this.paths.get(2), this.world, 5));
                    ++j;
                }
                ++k;
            }
        }
        if (this.type == 6) {
            k = 0;
            while (k < level) {
                int maara = 3;
                maara += level / 10;
                j = 0;
                while (j < maara) {
                    this.enemies.add(new Enemy(10 + r.nextInt(100), -(r.nextInt(50) + 20), 4000 * k, this.paths.get(3), this.world, 6));
                    ++j;
                }
                ++k;
            }
        }
        if (this.type == 7 && level > 14) {
            int maara = 1;
            maara += (level - 10) / 2;
            int j3 = 0;
            while (j3 < maara) {
                this.enemies.add(new Enemy(-25, r.nextInt(200), 20000 + 1000 * j3, this.paths.get(5), this.world, 7));
                ++j3;
            }
        }
    }
}

