/*
 * Decompiled with CFR 0.152.
 */
package peli;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;
import org.lwjgl.Sys;
import peli.Atom;
import peli.Bullet;
import peli.Enemy;
import peli.Entity;
import peli.Level;
import peli.Path;
import peli.Player;

public class Model {
    private ArrayList<Entity> bullets;
    private ArrayList<Entity> enemies = new ArrayList();
    private ArrayList<Entity> enemyBullets;
    private ArrayList<Entity> playerAndBullets;
    private ArrayList<Entity> palautus;
    private ArrayList<Entity> additions;
    private Player player;
    private int numberOfBullets = 0;
    private int level;
    private String state;
    private Level taso;
    private long lastTime;
    private long delta;
    private int xsize;
    private int ysize;
    private int zoomlevel;
    private boolean pause = false;
    private boolean tsekataan_viholliset;
    private boolean tsekataan_vihollisammukset;

    Model(int x, int y, int zoom) {
        this.bullets = new ArrayList();
        this.enemyBullets = new ArrayList();
        this.playerAndBullets = new ArrayList();
        this.palautus = new ArrayList();
        this.additions = new ArrayList();
        this.xsize = x;
        this.ysize = y;
        this.zoomlevel = zoom;
        this.player = new Player(this.xsize / this.zoomlevel / 2, this.ysize / this.zoomlevel - 30, this);
        this.state = "Playing";
        this.level = 10;
        this.taso = new Level(this);
        this.enemies = this.taso.getEnemies(this.level);
        this.lastTime = Sys.getTime();
    }

    public ArrayList<Entity> getEnemies() {
        return this.enemies;
    }

    public ArrayList<Entity> getBullets() {
        return this.bullets;
    }

    public int getLevel() {
        return this.level;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void togglePause() {
        this.pause = !this.pause;
    }

    public ArrayList<Entity> getAll() {
        this.palautus.clear();
        this.palautus.addAll(this.enemies);
        this.palautus.addAll(this.bullets);
        this.palautus.addAll(this.enemyBullets);
        this.palautus.add(this.player);
        return this.palautus;
    }

    public void newGame() {
        this.pause = false;
        this.numberOfBullets = 0;
        this.enemies = new ArrayList();
        this.bullets = new ArrayList();
        this.enemyBullets = new ArrayList();
        this.state = "Playing";
        this.player = new Player(this.xsize / this.zoomlevel / 2, this.ysize / this.zoomlevel - 30, this);
        this.level = 1;
        this.taso = new Level(this);
        this.enemies = this.taso.getEnemies(this.level);
        this.lastTime = Sys.getTime();
    }

    public void Live() {
        if (this.pause) {
            return;
        }
        this.delta = Sys.getTime() - this.lastTime;
        if (this.state == "Game Over") {
            return;
        }
        if (this.state == "Playing") {
            this.player.Live();
            for (Entity e : this.enemies) {
                e.Live();
            }
            if (this.additions.size() > 0) {
                this.enemies.addAll(0, this.additions);
                this.additions.clear();
            }
            for (Entity b : this.bullets) {
                b.Live();
            }
            for (Entity eb : this.enemyBullets) {
                eb.Live();
            }
            this.checkCollisions(this.player);
            this.lastTime = Sys.getTime();
        }
        if (this.enemies.isEmpty() && this.state == "Playing") {
            this.state = "Between levels";
        }
        if (this.state == "Between levels") {
            this.player.Live();
        }
        if (this.state == "Between levels" && this.delta > 5000L) {
            this.state = "Playing";
            ++this.level;
            this.enemies = this.taso.getEnemies(this.level);
            this.lastTime = Sys.getTime();
        }
    }

    public void startPlay() {
        this.level = 1;
        this.state = "Playing";
    }

    public String getState() {
        return this.state;
    }

    public void setState(String s) {
        this.state = s;
    }

    public void addEnemyBullet(int x, int y, int t) {
        Bullet eb;
        if (t == 3) {
            eb = new Bullet(x, y, "Enemy Bullet1", this.player.middle, this.xsize, this.ysize);
            this.enemyBullets.add(eb);
        }
        if (t == 4) {
            eb = new Bullet(x, y, "Enemy Bullet2", this.player.middle, this.xsize, this.ysize);
            this.enemyBullets.add(eb);
        }
        if (t == 5) {
            int px = this.player.middle.x;
            int py = this.player.middle.y;
            int j = 0;
            while (j < 3) {
                Bullet eb2 = new Bullet(x, y, "Enemy Bullet1", new Point(px * j, py * j), this.xsize, this.ysize);
                this.enemyBullets.add(eb2);
                ++j;
            }
        }
        if (t == 6) {
            Bullet eb3 = new Bullet(x, y, "Enemy Bullet3", this.player.middle, this.xsize, this.ysize);
            this.enemyBullets.add(eb3);
        }
        if (t == 7) {
            this.makeEnemy(x, y, 10);
        }
    }

    public void addBullet(int b) {
        Bullet bullet;
        if (b == 1) {
            bullet = new Bullet(this.player.middle.x - 3, this.player.middle.y, "Bullet1", this.player.middle, this.xsize, this.ysize);
            this.bullets.add(bullet);
        }
        if (b == 2) {
            bullet = new Bullet(this.player.middle.x - 1, this.player.middle.y, "Bullet2", this.player.middle, this.xsize, this.ysize);
            this.bullets.add(bullet);
        }
        ++this.numberOfBullets;
    }

    public void checkCollisions(Player p) {
        Entity e;
        Iterator<Entity> it;
        this.playerAndBullets.clear();
        this.playerAndBullets.add(p);
        this.playerAndBullets.addAll(this.bullets);
        for (Entity e2 : this.enemies) {
            if (e2.getState() != "Destroyed" && e2.getState() != "Dormant") {
                block1: for (Entity b : this.playerAndBullets) {
                    if (!(b.middle.distance(e2.middle) < 30.0)) continue;
                    Atom[] atomArray = b.getRep();
                    int n = atomArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Atom a = atomArray[n2];
                        if (a == null) continue block1;
                        if (e2.didItHit(a.getX() + b.middle.x, a.getY() + b.middle.y)) {
                            if (b.type == "Bullet1") {
                                p.addShot2Amount();
                            }
                            this.tsekataan_viholliset = true;
                            e2.youWereHit(a.material);
                            if (e2.state == "Destroyed") {
                                p.AddScore(((Enemy)e2).getPoints());
                            }
                            b.youWereHit(0);
                            continue block1;
                        }
                        ++n2;
                    }
                }
                continue;
            }
            this.tsekataan_viholliset = true;
        }
        if (p.getState() != "Destroyed") {
            block3: for (Entity eb : this.enemyBullets) {
                if (!(eb.middle.distance(p.middle) < 30.0)) continue;
                Atom[] atomArray = eb.getRep();
                int n = atomArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Atom a = atomArray[n3];
                    if (a == null) continue block3;
                    if (p.didItHit(a.getX() + eb.middle.x, a.getY() + eb.middle.y)) {
                        this.tsekataan_vihollisammukset = true;
                        eb.youWereHit(0);
                        p.youWereHit(a.material);
                    }
                    ++n3;
                }
            }
        }
        if (this.tsekataan_viholliset) {
            it = this.enemies.iterator();
            while (it.hasNext()) {
                e = it.next();
                if (e.isAlive()) continue;
                it.remove();
            }
            it = this.bullets.iterator();
            while (it.hasNext()) {
                e = it.next();
                if (e.isAlive()) continue;
                it.remove();
            }
            this.tsekataan_viholliset = false;
        }
        if (this.tsekataan_vihollisammukset) {
            it = this.enemies.iterator();
            it = this.enemyBullets.iterator();
            while (it.hasNext()) {
                e = it.next();
                if (e.isAlive()) continue;
                it.remove();
            }
            this.tsekataan_vihollisammukset = false;
        }
    }

    public void makeEnemy(int x, int y, int type) {
        if (type == 10) {
            ArrayList<Point> points = new ArrayList<Point>();
            int xborder = 10;
            int yborder = 10;
            points.add(new Point(0, yborder * 5));
            this.additions.add(new Enemy(x + 10, y + 5, 1000, new Path(points, "H\u00e4vitt\u00e4j\u00e4"), this, 1));
        }
    }

    public ArrayList<Entity> getEnemyBullets() {
        return this.enemyBullets;
    }

    public int getXsize() {
        return this.xsize;
    }

    public int getYsize() {
        return this.ysize;
    }

    public int getZoomLevel() {
        return this.zoomlevel;
    }
}

