
in vec4 Position;
in vec4 Color;
in vec4 Normal;
in vec4 TexCoord;

uniform mat4 matrices[2];
uniform vec4 lightpos;

varying vec4 ShadowCoord;
varying vec3 direction;
varying vec3 place;
varying vec3 norm;
varying float sshadow;
varying vec4 TexCoord1;

void main()
{
    TexCoord1 =  TexCoord;

    ShadowCoord = Position - vec4(lightpos.xyz, 1.0);

    place = vec3(inverse(matrices[0])*vec4(0.0,0.0,0.0,1.0));

    direction = normalize(Position.xyz-place) * (length(Position.xyz-place)/100.0);

    norm = Normal.xyz;

    sshadow = dot(normalize(vec3(Normal.xyz)),normalize(lightpos.xyz - Position.xyz));

    gl_FrontColor = Color*0.5 + 0.6*Color * max(sshadow ,0.1) * lightpos.w * (6.1/(distance(lightpos.xyz,Position.xyz)));

    gl_Position = matrices[1] * matrices[0] * Position;

}
