#version 330
#extension GL_EXT_geometry_shader4 : enable
layout(points) in;
layout(points) out;
layout(max_vertices = 100) out;

out vec4 Position;
out vec4 Color;
out vec4 Normal;
out vec4 TexCoord;


uniform float timer;


mat4 rotx = mat4(1.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

mat4 roty = mat4(0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 1.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

mat4 rotz = mat4(0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 0.0,
                 0.0            , 0.0           , 1.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);



void initialize_matrices(float anglex, float angley, float anglez)
{
     rotx = mat4(1.0            , 0.0           , 0.0           , 0.0,
                 0.0            , cos(anglex)   , -sin(anglex)  , 0.0,
                 0.0            , sin(anglex)   , cos(anglex)   , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

     roty = mat4(cos(angley)    , 0.0           , sin(angley)   , 0.0,
                 0.0            , 1.0           , 0.0           , 0.0,
                 -sin(angley)   , 0.0           , cos(angley)   , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);

     rotz = mat4(cos(anglez)    , -sin(anglez)  , 0.0           , 0.0,
                 sin(anglez)    , cos(anglez)   , 0.0           , 0.0,
                 0.0            , 0.0           , 1.0           , 0.0,
                 0.0            , 0.0           , 0.0           , 1.0);
}


void main()
{
    vec4 pos = gl_PositionIn[0];

    TexCoord = vec4(0.5, 0.5, 1.0, 0.0);
    //Color = vec4(30.0, 12.0, 3.0, 1.0);

    Normal = vec4(0.5, 0.5, 0.0, 0.0);

    float size;

    if(timer<16000.0)
        size = timer/30000.0;
    else
    {
        size = 16/30.0;
    }

    Color = vec4(30.0, 30.0-size*22.5, 30.0-size*54.375, 1.0);

    if(timer>34428.571428571428571428571428569)
    {
        float time = timer-34428.571428571428571428571428569;
        initialize_matrices(0.0, time/(300*57.295779513082320876798154814105), 0.0);

        pos += vec4(-pos.x*sqrt(time)/200.0, -pos.y*sqrt(time)/200.0, sqrt(time)*1.0, 0.0);
        pos = roty * pos;
    }

        //246428.57142857142857142857142857
        for(int i=0;i<4;i++)
        {
            initialize_matrices(size*pos.x/2.0, size*pos.y/2.0, size*pos.z/2.0);

            vec3 displace = vec3(sin(i*4557.34*pos.x)*size, sin(i*453.23*pos.x)*size, sin(i*43.342*pos.x)*size);
            Position = pos + rotx * roty * rotz * vec4(displace, 0.0);
            EmitVertex();
            displace = vec3(-sin(i*4557.34*pos.y)*size, sin(-i*453.23*pos.y)*size, sin(i*43.342*pos.y)*size);
            Position = pos + rotx * roty * rotz * vec4(displace, 0.0);
            EmitVertex();
            displace = vec3(sin(i*4557.34*pos.z)*size, sin(-i*453.23*pos.z)*size, sin(-i*43.342*pos.z)*size);
            Position = pos + rotx * roty * rotz * vec4(displace, 0.0);
            EmitVertex();
        }

    EndPrimitive();

}
