#version 330
#extension GL_EXT_geometry_shader4 : enable
layout(triangles) in;
layout(triangle_strip) out;
layout(max_vertices = 50) out;

out vec4 Position;
out vec4 Color;
out vec4 Normal;
out vec4 TexCoord;

in vec3 norm[];

uniform float timer;

void main()
{
    Color = vec4(1.0, 0.0, 0.0, 1.0);
    TexCoord = vec4(1.0, 1.0, 0.0, 0.0);

    float distance =-8.0 + timer/1000.0;

    vec4 dir1 = gl_PositionIn[1] - gl_PositionIn[0];
    vec4 dir2 = gl_PositionIn[2] - gl_PositionIn[0];

    for(int i=0;i<2;i++){
        vec4 ddir1 = i/4.0*dir1;
        vec4 ddir2 = i/4.0*dir2;
        Normal = normalize(vec4(norm[0], 0.0)*(1-i/3.0)+vec4(norm[1], 0.0)*(i/3.0)+vec4(norm[2], 0.0)*(i/3.0));

        Position = gl_PositionIn[0] + ddir1 + ddir2;
        Position += (Position.x > distance ? (Position.x-distance)*(Position.x-distance)*3.0 : 0.0)*Normal;
        Position.w = 1.0;
        EmitVertex();


        Normal = normalize(vec4(norm[0], 0.0)*(i/3.0)+vec4(norm[1], 0.0)*(1-i/3.0)+vec4(norm[2], 0.0)*(i/3.0));
        ddir1 = dir1 - ddir1;

        Position = gl_PositionIn[0] + ddir1 + ddir2;
        Position += (Position.x > distance ? (Position.x-distance)*(Position.x-distance)*3.0 : 0.0)*Normal;
        Position.w = 1.0;
        EmitVertex();


        Normal = normalize(vec4(norm[0], 0.0)*(i/3.0)+vec4(norm[1], 0.0)*(i/3.0)+vec4(norm[2], 0.0)*(1-i/3.0));
        ddir2 = dir2 - ddir2;
        ddir1 = i/6.0*dir1;

        Position = gl_PositionIn[0] + ddir1 + ddir2;
        Position += (Position.x > distance ? (Position.x-distance)*(Position.x-distance)*3.0 : 0.0)*Normal;
        Position.w = 1.0;
        EmitVertex();

        EndPrimitive();
    }




}
