
float4x4 g_mWorldViewProjection;    

float g_windowWidth;
float g_windowHeight;

float g_time;
float g_timeStep;


float4 g_boxSize;

float g_emitterRad;
float g_emitterDirSpeed;
float g_emitterRotate;

float g_emitterMove;
float g_emitterMoveSpeed;

float g_spread;

float g_spreadScale;
float g_spreadEvolve;

float g_maxAge;

float4 g_emitPos;
float4 g_outputLinesAndOffset;

float g_collisionAtt;


float4 g_grav;

float4 g_emitLineStartPos;
float4 g_emitLineEndPos;


float nois(float3 p) {
	return frac(sin(dot(p ,float3(12.9898,78.233,127.789))) * 43758.5453);
}
/*
float4 n4(float3 p) {
  float3 p3 = float3(p.x, p.y, 0.0);
  return float4(nois(p3), nois(p3+float4(0.0, 1.2, 0.2, 0.0)), nois(p3+float4(3.2, 4.32, 0.0, 0.0)), 0.0);
}
*/
float pnois(float3 p) {
  p.z += frac((floor(p.x)+floor(p.y))*1.0)*0.5;
  float2 eps = float2(1.0, 0.0);
  float3 pfp = p-frac(p);
  float3 fr = smoothstep(0.0, 1.0, frac(p));
  return ((fr.x*nois(pfp+eps.xyy)+(1.0-fr.x)*nois(pfp))*(1.0-fr.y)+(fr.x*nois(pfp+eps.xxy)+(1.0-fr.x)*nois(pfp+eps.yxy))*fr.y)*(1.0-fr.z)+
	 ((fr.x*nois(pfp+eps.xyx)+(1.0-fr.x)*nois(pfp+eps.yyx))*(1.0-fr.y)+(fr.x*nois(pfp+eps.xxx)+(1.0-fr.x)*nois(pfp+eps.yxx))*fr.y)*(fr.z);
}
/*
float pnois2(float3 p) {
  return (pnois(p)+pnois(p+float3(0.0,0.0,0.5)))*0.5;
}
*/
float4 pn4(float3 p) {
  float3 p3 = float3(p.x, p.y, p.z);
  return float4(pnois(p3), pnois(p3+float4(0.0, 1.2, 0.2, 0.0)), pnois(p3+float4(3.2, 4.32, 0.0, 0.0)), 0.0);
}


struct VS_INPUT {
    float4 vPosition : POSITION;
    float2 vTexcoord : TEXCOORD;
};

struct VS_OUTPUT {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vPosSS : TEXCOORD1;
};

VS_OUTPUT vs( const VS_INPUT v ) {
  VS_OUTPUT o;
  

  o.vTexcoord = (v.vTexcoord)+float2(0.50/g_windowWidth, 0.50/g_windowHeight); 
  /*
  float pixIndex = coordsToIndex(o.vTexcoord, float2(g_windowWidth, g_windowHeight)); 
  float2 tCoords = indexToCoords(pixIndex, g_windowWidth);

  if ((pixIndex/g_windowWidth > (g_outputLinesAndOffset.x+g_outputLinesAndOffset.y)) ||
      (pixIndex/g_windowWidth < g_outputLinesAndOffset.y)) {
    discard;
  }
  */
  
  float4 posse = v.vPosition;
  
 // o.vTexcoord.y *= g_outputLinesAndOffset.x/g_windowHeight;
  //posse.y += 2.0*g_outputLinesAndOffset.y/g_windowHeight;
 // posse.y += sin(g_time);
 // o.vTexcoord.y += g_outputLinesAndOffset.y/g_windowHeight;
  posse.y=(1.0*posse.y+g_windowHeight-2.0*g_outputLinesAndOffset.y)/g_windowHeight;
  o.vPosition = mul(posse, g_mWorldViewProjection);
  o.vTexcoord.y = (o.vTexcoord.y+g_outputLinesAndOffset.y)/g_windowHeight; 
  // o.vPosition.y *= 1.0*g_outputLinesAndOffset.x/g_windowHeight;
 // o.vPosition.y = 0.0*g_outputLinesAndOffset.y/g_windowHeight;
 // o.vPosition.y+=sin(g_time);
  o.vPosSS = o.vPosition;
    
  
  
  return o;
}


struct PS_OUT {
  float4 rt0 : COLOR0; // new position
  float4 rt1 : COLOR1; // new velocity
  float4 rt2 : COLOR2; // 
};


float4 g_color = float4(1.0, 1.0, 1.0, 1.0);

float4 g_grid;


texture g_tNoise;
sampler smNoise =
sampler_state {
  Texture = <g_tNoise>;
  MipFilter = POINT;
  MinFilter = LINEAR; // POINT
  MagFilter = LINEAR; // LINEAR  
  AddressU = WRAP;
  AddressV = WRAP;
};

texture g_tPosPrev;
sampler smPosPrev =
sampler_state {
  Texture = <g_tPosPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVelPrev;
sampler smVelPrev =
sampler_state {
  Texture = <g_tVelPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

texture g_tVarPrev;
sampler smVarPrev =
sampler_state {
  Texture = <g_tVarPrev>;
  MipFilter = POINT;
  MinFilter = POINT; // POINT
  MagFilter = POINT; // LINEAR  
  AddressU = BORDER;
  AddressV = BORDER;
};

float4 rotateXZ(float4 p, float a) {
  float4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

float2 indexToCoords(float index, float width) {
  float2 tc;


  float k = index/width;
  tc.x = frac(k);
  tc.y = (k-tc.x)/width;
  return tc;
}

float coordsToIndex(float2 tc, float2 dim) {
  return tc.x*dim.x + ((int)(tc.y*dim.y))*dim.x;
}

float4 turb(sampler s, float2 tc, int fr) {
  float4 r = float4(0.0, 0.0, 0.0, 0.0);
  float m = 0.50;
  for (int i=0; i<fr; i++) {
    r += (tex2D(s, tc)*2.0-1.0)*m;
    tc *= 2.0;
    m *= 0.5;
  }
  return r;
}

PS_OUT ps_pixsim1( VS_OUTPUT In ) {

  PS_OUT o = (PS_OUT)0;
  float2 tcOfs = float2((+0.5)/g_windowWidth.x, (+0.5)/g_windowHeight);
  float4 pos = tex2D(smPosPrev, In.vTexcoord+tcOfs);
  float4 vel = tex2D(smVelPrev, In.vTexcoord+tcOfs);
  float4 var = tex2D(smVarPrev, In.vTexcoord+tcOfs);
  
  float pixIndex = coordsToIndex(In.vTexcoord, float2(g_windowWidth, g_windowHeight)); 
  float2 tCoords = indexToCoords(pixIndex, g_windowWidth);
/*
  if ((pixIndex/g_windowWidth > (g_outputLinesAndOffset.x+g_outputLinesAndOffset.y)) ||
      (pixIndex/g_windowWidth < g_outputLinesAndOffset.y)) {
    discard;
  }
  */
  float fraktio = 0.10;
  
  if (((tCoords.x+g_outputLinesAndOffset.z)>fraktio) ||
      ((tCoords.x)<g_outputLinesAndOffset.z)) {
    discard;
  }
  
  int bInit = 1;
  float4 grav = g_grav; 
  pos.w = g_maxAge;
  if (pos.w < 0.01) { 
    bInit = 1;
  } 

  vel.xyz += grav.xyz*g_timeStep;
  pos.xyz += vel.xyz*g_timeStep;

  if (bInit) {
    pos = g_emitPos+tCoords.x/fraktio*g_emitLineStartPos+(1.0-tCoords.x/fraktio)*g_emitLineEndPos;
  //  pos.w = (noise2.z+1.0)*g_maxAge;
	pos.w = g_maxAge;
	vel.xyz = float3(0.0, 0.0, 0.0);
  }

 // pos.xyz = float3(0.0,0.0,0.0);
 // pos.y = tCoords.y;
 //os.z = 0.0;
  o.rt0 = pos;
  o.rt1 = vel;
  o.rt2 = var;
  return o;
} 


technique Render {
    pass P0 {          
        VertexShader = compile vs_3_0 vs( );
        PixelShader  = compile ps_3_0 ps_pixsim1( );
    }
}

