

float2 height_func_march(float2 p) {
   float2 resx = float2(1.0/1024.0, 0.0);
   float2 resy = float2(0.0, 1.0/1024.0);
   float2 result = 0;
   result.x = tex2D(smHeight, p+resx).g-tex2D(smHeight, p-resx).g;
   result.y = tex2D(smHeight, p+resy).g-tex2D(smHeight, p-resy).g;
   return result;
}

float g_march_depth = 1.0;

float4 rotateXZ(float4 p, float a) {
  float4 r = p;
  
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  
  return r;
}

struct VS_OUTPUT_BASIC_KO {
    float4  vPosition : POSITION;
    float2  vTexcoord : TEXCOORD0;
    float4  vNormal : TEXCOORD1;
    float4  vPosSS : TEXCOORD2;
    float4  vTangent : TEXCOORD3;
    float4  vBiNormal : TEXCOORD4;
    float4  vTexcoordHS : TEXCOORD5;
    float4  vPosSO : TEXCOORD6;
};


VS_OUTPUT_BASIC_KO vs_deferred_draw_march( const VS_INPUT v ) {
  VS_OUTPUT_BASIC_KO o;
  
  float4 vPosTrans = v.vPosition*2.0;
  
 // vPosTrans = rotateXZ(vPosTrans, 5.0*clamp(sin(vPosTrans.y*0.150+g_time*0.4),0.0,1.0));
  o.vPosition = mul(vPosTrans, g_mWorldViewProjection);
  
  o.vPosSS = o.vPosition;
  
  float4 possex = mul(vPosTrans, g_mWorld);
  o.vPosSO = mul(possex, g_mView);
  
  float3 normalResult;
  normalResult = mul(v.vNormal, (float3x3)(g_mWorld));
  normalResult = normalize(normalResult);
  o.vNormal = float4(((mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
 // o.vNormal = float4(normalize(normalResult)*1.0, 0.0);

  float3 tan = v.vTangent;
  float3 bin = v.vBiNormal;
  float2 tc = v.vTexcoord;
  /*
 // float3 nra = abs(v.vNormal);
  float3 nra = abs(normalResult);
   
  if (nra.x > nra.y && nra.x > nra.z) {
   // maxX = 1;
    tan = float3(0.0, 1.0, 0.0);
   // tc = v.vPosition.yz*0.1;
  //  tc = possex.yz*0.1;
  } else if (nra.y > nra.x && nra.y > nra.z) {
   // maxY = 1;
    tan = float3(1.0, 0.0, 0.0);
    // tc = v.vPosition.xz*0.1;
 //   tc = possex.xz*0.1;
  } else {
    // maxZ = 1;
    tan = float3(1.0, 0.0, 0.0);
    // tc = v.vPosition.xy*0.1;
 //   tc = possex.xy*0.1;
  }
  float dp = dot(tan, nra);
  tan = tan-nra*dp;
  bin = cross(tan, normalResult);
  */
  
  normalResult = mul(tan, (float3x3)(g_mWorld));
  o.vTangent = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
 //o.vTangent = float4(normalize(normalResult)*1.0, 0.0);
  normalResult = mul(bin, (float3x3)(g_mWorld));
  o.vBiNormal = float4((normalize(mul(normalResult, (float3x3)(g_mView)))+0.0)*1.0, 0.0);
 //o.vBiNormal = float4(normalize(normalResult)*1.0, 0.0);
  
  float2 localTexCoordOfs;
  
      
  o.vTexcoord = tc*g_texCoordScale.xy*g_diffuseTexCoordScale.xy+g_texCoordOfs.xy+g_diffuseTexCoordOfs.xy;
  o.vTexcoordHS.xy = tc*g_texCoordScale.xy*g_heightTexCoordScale.xy+g_texCoordOfs.xy+g_heightTexCoordOfs.xy;
  o.vTexcoordHS.zw = tc*g_texCoordScale.xy*g_specularTexCoordScale.xy+g_texCoordOfs.xy+g_specularTexCoordOfs.xy;
    
  return o;
}

float zFar = 10000.0;
float zNear = 0.10;
/*
float4 getPointV(float4 vPosSS, float depthV) {
  float clipA = zFar / (zFar - zNear);
  float clipB = zFar*zNear / (zNear - zFar);
  float pointDist = clipB/(depthV-clipA);
  float4 pointV = float4(vPosSS.x*4.0/3.0, vPosSS.y*3.0/4.0, 1.0, 0.0)*pointDist;  
  return pointV;
}
*/


float3 frv0(float3 fv) {
  return frac(fv)*1.0-0.50;
}
float3 frv2(float3 fv) {
  return frac(fv)-0.50;
}
float3 frvk(float3 fv) {
  fv*=0.5;
  return (fv-frac(fv))*2.0-1.0;
}

float torus(float3 v, float R, float r) {
  float b = v.x*v.x*1.0+v.y*v.y+v.z*v.z+R*R-r*r;
  float res=(b*b-4.0*R*R*(v.x*v.x+v.y*v.y));
  return res;
}


float3 fk_kkk(float3 p) {
  return p.z-(1.0-tex2D(smHeight,p.xy).g);
}


float fk(float3 vv) {
  float box = vv.z-(1.0-tex2D(smHeight,vv.xy*0.5+float2(0.25,0.25)).g);
  float3 v, vv2, v2;
 // v.xyz = frv(vv+float3(0.50, 1.0, 0.50)).xyz; 
  v.xyz = frv0(float3(vv.x*0.5, vv.y*0.5+0.50, vv.z*1.0)).xyz; 
  v.z *= 0.50;
 // v2.xy = rotate(v2.xy, 1.54);
  float res;
 // res = v.x*v.x+v.y*v.y+v.z*v.z-0.0625;
  res = torus(v, 0.2, 0.05);
  
  res = min(box, res);
  // res = min(v.x*v.x+v.y*v.y+v.z*v.z-0.1, res); // union with a sphere
  // res = max(v.z-0.5, -res);
 
  return res;
}




MRT_OUT ps_deferred_draw_march( VS_OUTPUT_BASIC_KO In ) {
  MRT_OUT o=(MRT_OUT)0;

  float4 rayTan;
  float4 ray = (In.vPosSO/(In.vPosSO.w));
 // ray.z += 1.0;
  rayTan.x = dot((In.vTangent), ray);
  rayTan.y = dot((In.vBiNormal), ray);
  rayTan.z = dot(-(In.vNormal), ray)*1.0;
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);
  
  float height = tex2D(smHeight, In.vTexcoord).g;
  
  float2 tc = In.vTexcoord;
  tc.y = tc.y;
 // tc.xy *= 0.50;
  
  float hd = 0.0;
  float steps = 32.0f;
  int onceIn = 0;
  float deptho = 1.0; // g_march_depth; //*rayTan.z;
  float dir = 1.0;
  
  float po = max(0.25, rayTan.z);
  float pk = min(0.25, rayTan.z);
  
  for (int i=0; i<steps; i++) {
//    tc += rayTan.xy*deptho*dir/steps*0.1*g_heightIntensity/rayTan.z;
//    hd += g_march_depth*deptho*dir/steps;
    tc += rayTan.xy*1.0*g_march_depth*deptho*dir/steps/po;
    hd += g_march_depth*deptho*dir/steps*4.0*pk;
    float hn = fk(float3(tc.x, tc.y, hd));
    height = hn;
    if (hn < 0) {
      onceIn = 1;
	}
	if (onceIn) {
  	 // rayTan.xy *= 0.75;
	  deptho *= 0.5;
	  if (hn < 0) {
	    dir = -1.0;
	  } else {
	    dir = 1.0;
	  }
	}
  }
  
  if (onceIn == 0) {
    discard;
  }
  
  
 // tc += rayTan.xy*0.002;
  
 // if (tc.x < 0.01 || tc.x > 0.99 || tc.y > -0.01 || tc.y < -0.99) {
 //   discard;
 // }
   
  // float2 tc = In.vTexcoord+rayTan.xy*(0.04*height-0.02)*g_heightIntensity;
 
  //tc = ray.xy;
 
  float4 ort2 = tex2D(smDiffuse, tc)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
 // o.rt2.xy = tc.xy;
  
 // o.rt2.xyz = bn.xyz;
  
 // o.rt2.xyz = ray.xyz;
  
  if (o.rt2.a < 0.005)
    discard;  
  
 // o.rt2.xyz = ray.xyz;
  float4 bumpe = 0;
  float nomV = fk(float3(tc.x, tc.y, hd));
  bumpe.x = fk(float3(tc.x+0.01, tc.y, hd))-nomV;
  bumpe.y = fk(float3(tc.x, tc.y+0.01, hd))-nomV;
  bumpe.z = fk(float3(tc.x, tc.y, hd+0.01))-nomV;
  bumpe = bumpe*g_heightIntensity;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z+0.04*height*g_heightIntensity) / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, tc).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;
  
 // o.rt3.z = 0.0;  
  
  return o;
}

float hk(float2 v) {
  float r=0.25*sin(v.x+g_time)+0.25*cos(v.y)+0.5;
  return r;
}

MRT_OUT ps_deferred_draw_march_f1( VS_OUTPUT_BASIC_KO In ) {
  MRT_OUT o=(MRT_OUT)0;

    
  float4 rayTan;

  float4 ray = In.vPosSO/In.vPosSO.z;
   
  rayTan.x = dot((In.vTangent), ray);
  rayTan.y = dot((In.vBiNormal), ray);
  rayTan.z = -dot((In.vNormal), ray)-1.0;
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);
  
  float height = tex2D(smHeight, In.vTexcoord).g;
  
  float2 tc = In.vTexcoord;
  
  float hd = 0.0;
  float steps = 32.0f;
  int onceIn = 0;
  float deptho = 1.0; // g_march_depth; //*rayTan.z;
  float dir = 1.0;
  for (int i=0; i<steps; i++) {
    tc += rayTan.xy*deptho*dir/steps*0.1*g_heightIntensity/rayTan.z;
    hd += g_march_depth*deptho*dir/steps;
    float hn = 1.0-hk(tc);
    height = hn;
    if (hd > hn) {
      onceIn = 1;
	}
	if (onceIn) {
  	 // rayTan.xy *= 0.75;
	  deptho *= 0.75;
	  if (hd > hn) {
	    dir = -1.0;
	  } else {
	    dir = 1.0;
	  }
	}
  }
  tc += rayTan.xy*0.01;
  
 // if (tc.x < 0.01 || tc.x > 0.99 || tc.y > -0.01 || tc.y < -0.99) {
 //   discard;
 // }
   
  // float2 tc = In.vTexcoord+rayTan.xy*(0.04*height-0.02)*g_heightIntensity;
 
  //tc = ray.xy;
 
  float4 ort2 = tex2D(smDiffuse, tc)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
 // o.rt2.xyz = ray.xyz;
  
  if (o.rt2.a < 0.005)
    discard;  
  
 // o.rt2.xyz = ray.xyz;
    
  float4 bumpe = 0;
  float nomV = hk(tc);
  bumpe.xy = float2(hk(tc+float2(0.01, 0.0))-nomV, hk(tc+float2(0.0, 0.01))-nomV);
  bumpe = bumpe*10.0*g_heightIntensity;
  bumpe.z = 1.0;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z+0.04*height*g_heightIntensity) / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, tc).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;
  
 // o.rt3.z = 0.0;  
  
  return o;
}

float fr(float f) {
  return (frac(f*0.50))*2.0-1.0;
}
float3 frv(float3 fv) {
  return frac(fv*0.5)*2.0-1.0;
}
float frk(float f) {
  f*=0.5;
  return (f-frac(f))*2.0-1.0;
}

float2 rotate(float2 p, float a) {
  float2 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y  = sin(a)*p.x + cos(a)*p.y;
  return r;
}


float hk3a(float3 vv) {
  float3 v;
  vv.xy += frk(vv.z)*float2(3.50, 2.50);
//  v.x = fr(sin(vv.x*2.1)); //0.5*sin(v.x)+0.5;
  v.x = fr(vv.x); //0.5*sin(v.x)+0.5;
  v.z = fr(vv.y);
  v.y = fr(vv.z);
  v.xz = rotate(v.xz, g_time+vv.x+frk(vv.x)*0.1+frk(vv.y));
//  v.yz = rotate(v.yz, g_time+frk(vv.y)*0.123);
  float R = 0.75;
  float r = 0.25;
  float b = v.x*v.x*1.0+v.y*v.y+v.z*v.z+R*R-r*r;
  float res=b*b-4.0*R*R*(v.x*v.x+v.y*v.y)+tex2D(smHeight, float2(v.xy)*0.20)*0.05;
  return res;
}


float hk3_chainz(float3 vv) {
  float3 v, vv2, v2;
  v.xzy = frv(vv).xyz; 
  vv2 = vv;
 // v2.xy = rotate(v2.xy, 1.54);
  vv2.x += 1.0;
  v2.xyz = frv(vv2).xyz; 
  
  v.xz = rotate(v.xz, 0.1*sin(g_time+vv.x+frk(vv.x)*0.1+frk(vv.y)));
  v2.xz = rotate(v2.xz, 0.1*sin(g_time+vv2.x+frk(vv2.x)*0.1+frk(vv2.y)));

  v.yz = rotate(v.yz, g_time+frk(vv.x)*0.1+frk(vv.y));
  v2.yz = rotate(v2.yz, -(g_time+frk(vv2.x)*0.1+frk(vv2.y)));
//  v.yz = rotate(v.yz, g_time+frk(vv.y)*0.123);
  float t1=torus(v, 0.75, 0.25)+tex2D(smHeight, float2(v.xy)*0.20)*0.0;
  float t2=torus(v2, 0.75, 0.25)+tex2D(smHeight, float2(v2.xy)*0.20)*0.0;
  float res=min(t1, t2);
  // res = min(v.x*v.x+v.y*v.y+v.z*v.z-0.1, res); // union with a sphere
  // res = max(v.z-0.5, -res);
  return res;
}

float perlin(float3 v) {
  float res = 0.0;
  float sk = 1.0;
  for (int i=0; i<3; i++) {
	res += sk*(tex2D(smHeight, float2(v.x, v.y)).g-0.5);
	v.x *= 2.0;
	v.y *= 2.0;
	sk *= 0.5;
  }
  res += 0.5;
  return res;
}

float hk3_perlin_chainz(float3 vv) {
//float hk3(float3 vv) {
  vv.z /= g_heightIntensity;
  float3 v, vv2, v2;
  v.xzy = frv(vv).xyz; 
  vv2 = vv;
 // v2.xy = rotate(v2.xy, 1.54);
  vv2.x += 1.0;
  v2.xyz = frv(vv2).xyz; 
  
 // v.yz = rotate(v.yz, g_time+frk(vv.x)*0.1+frk(vv.y));
 // v2.yz = rotate(v2.yz, -(g_time+frk(vv2.x)*0.1+frk(vv2.y)));
//  v.yz = rotate(v.yz, g_time+frk(vv.y)*0.123);
  float t1=torus(v, 0.75, 0.25)+perlin(v.xyz*0.02)*0.09;
  float t2=torus(v2, 0.75, 0.25)+perlin(v2.xyz*0.02)*0.09;
  float res=min(t1, t2);
  // res = min(v.x*v.x+v.y*v.y+v.z*v.z-0.1, res); // union with a sphere
  // res = max(v.z-0.5, -res);
 
  return res;
}


float hk3_ball(float3 vv) {
  vv.z *= 0.25;
  float3 v, vv2, v2;
  v.xzy = frv(vv+float3(0.50, -0.50, 0.0)).xyz; 
  vv2 = vv;
 // v2.xy = rotate(v2.xy, 1.54);
  vv2.x += 1.0;
  v2.xyz = frv(vv2).xyz; 
  float res;
  res = v.x*v.x+v.y*v.y+v.z*v.z-0.3;
  // res = min(v.x*v.x+v.y*v.y+v.z*v.z-0.1, res); // union with a sphere
  // res = max(v.z-0.5, -res);
 
  return res;
}


//float hk3_tex(float3 vv) {
float hk3(float3 vv) {
  // float box = vv.z-(1.0-(0.5+0.25*sin(tex2D(smHeight,vv.xy*0.5+float2(0.25,0.25)).g+g_time)))*g_heightIntensity;
 // float box = vv.z-(1.0-(0.6*tex2D(smHeight,vv.xy).g+0.25*tex2D(smHeight,vv.xy*4.0).g+0.15*tex2D(smHeight,vv.xy*12.0).g))*g_heightIntensity;
  float box = vv.z-(1.0-(tex2D(smHeight,vv.xy).g))*g_heightIntensity;
  float res = box;
  // res = min(v.x*v.x+v.y*v.y+v.z*v.z-0.1, res); // union with a sphere
  // res = max(v.z-0.5, -res);
 
  return res;
}




MRT_OUT ps_deferred_draw_march_f2( VS_OUTPUT_BASIC_KO In ) {
  MRT_OUT o=(MRT_OUT)0;


  float4 rayTan;
  float4 ray = In.vPosSO/In.vPosSO.w;
  float4 rn = normalize(ray);
  float4 nor = (In.vNormal);
  float4 tan = normalize(In.vTangent);
  float4 bin = normalize(In.vBiNormal);
  rayTan.x = dot(tan, rn);
  rayTan.y = dot(bin, rn);
  rayTan.z = dot(-nor, rn)*3.0+0.250;
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);
  
  float height = tex2D(smHeight, In.vTexcoord).g;
  
  float2 tc = In.vTexcoord;
  
  float po = max(0.9, rayTan.z);
  float pk = 1.0/0.9*min(0.9, rayTan.z);
  
  float hd = 0.0;
  float steps = 32.0f;
  int onceIn = 0;
  float deptho = 1.0; 
  float dir = 1.0;
  for (int i=0; i<steps; i++) {
    tc += rayTan.xy*3.0*g_march_depth*deptho*dir/steps/po;
    hd -= g_march_depth*deptho*dir/steps*pk;

    float hn = hk3_perlin_chainz(float3(tc.x, tc.y, hd));
    height = hn;
    if (hn < 0.0) {
      onceIn = 1;
	}
	if (onceIn) {
	  deptho *= 0.5;
	 // deptho = abs(hn)*2.0;
	  if (hn < 0.0) {
	    dir = -1.0;
	  } else {
	    dir = 1.0;
	  }
	}
  }
  if (onceIn == 0) {
    discard;
  }
  
  if (tc.x < -16.0) {
   discard;
  }
  if (tc.y < -16.0) {
   discard;
  }  
  if (tc.x > 16.0) {
   discard;
  }  
  if (tc.y > 16.0) {
   discard;
  }  
  
  tc += rayTan.xy*0.01;
  float4 ort2 = tex2D(smDiffuse, tc)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
 // o.rt2.xyz = ray.xyz;
  
  if (o.rt2.a < 0.005)
    discard;  
  
 // o.rt2.xyz = ray.xyz;
    
  float4 bumpe = 0;
  float nomV = hk3(float3(tc.x, tc.y, hd));
  bumpe.xyz = float3(hk3(float3(tc.x+0.01, tc.y, hd))-nomV, hk3(float3(tc.x, tc.y+0.01, hd))-nomV, hk3(float3(tc.x, tc.y, hd+0.01))-nomV);
  bumpe = bumpe*g_heightIntensity;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z+hd) / In.vPosSS.w;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, tc).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;
  
 // o.rt3.z = 0.0;  
  
  return o;
}


struct MRT_OUT_D {
  float4 rt0 : COLOR0; // depth
  float4 rt1 : COLOR1; // normal
  float4 rt2 : COLOR2; // diffuse
  float4 rt3 : COLOR3; // ambspec
  float  Depth  : DEPTH;
};



MRT_OUT_D ps_deferred_draw_march_torus( VS_OUTPUT_BASIC_KO In ) {
  MRT_OUT_D o=(MRT_OUT_D)0;


  float4 rayTan;
  float4 ray = In.vPosSO/In.vPosSO.w;
  //ray.x *= 9.0/16.0;
  //ray.z *= 2.0;
  float4 rn = normalize(ray);
  float4 nor = (In.vNormal);
  float4 tan = normalize(In.vTangent);
  float4 bin = normalize(In.vBiNormal);
  rayTan.x = dot(tan, rn);
  rayTan.y = dot(bin, rn);
  rayTan.z = dot(-nor, rn)*3.0+0.250;
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);
  
  float height = tex2D(smHeight, In.vTexcoord).g;
  
  float2 tc = In.vTexcoord;
  
  float po = max(0.9, rayTan.z);
  float pk = 1.0/0.9*min(0.9, rayTan.z);
  
  float3 curveMap = float3(1.0/In.vTangent.w, 1.0, 1.0);
  
  float3 v;
  v.xy = rayTan.xy*3.0*g_march_depth/po;
  v.z = -g_march_depth*pk;
  
  float a = 0.5;
  float b = 0.5;
  
  float curveZ = a*v.x*v.x+b*v.y*v.y;
  curveZ = sign(curveZ)*max(abs(curveZ), 0.001);
  
   //v *= curveMap;
  curveZ *= curveMap.z;
  
  float hd = 0.0;
  float steps = 32.0f;
  int onceIn = 0;
  float deptho = 1.0/steps; 
  float dir = 1.0;
  float t = 0.0;
  float3 vp = float3(0.0, 0.0, 0.0);
  for (int i=0; i<steps; i++) {
    t += deptho*dir;
    vp.xy = tc+v.xy*t;
    vp.z = v.z*t; // +curveZ*t*t;

    float hn = hk3_perlin_chainz(vp);
	
		
    if (hn < 0.0) {
      onceIn = 1;
	}
	if (onceIn) {
	  deptho *= 0.5;
	 // deptho = abs(hn)*2.0;
	  if (hn < 0.0) {
	    dir = -1.0;
	  } else {
	    dir = 1.0;
	  }
	}

  }
  
  if (tc.x < -16.0) {
   discard;
  }
  if (tc.y < -16.0) {
   discard;
  }  
  if (tc.x > 16.0) {
   discard;
  }  
  if (tc.y > 16.0) {
   discard;
  }    

  if (onceIn == 0) {
    discard;
  }
  

  vp.xy += rayTan.xy*0.01;
//  float4 ort2 = (0.65*tex2D(smDiffuse, vp.xy)+0.35*tex2D(smDiffuse, vp.xy*4.0))*g_materialDiffuse;
  float4 ort2 = tex2D(smDiffuse, vp.xy)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
 // o.rt2.xyz = ray.xyz;
  
  if (o.rt2.a < 0.005)
    discard;  
  
 // o.rt2.xyz = ray.xyz;
    
  float4 bumpe = 0;
  float nomV = hk3(vp);
  bumpe.xyz = float3(hk3(float3(vp.x+0.01, vp.y, vp.z))-nomV, hk3(float3(vp.x, vp.y+0.01, vp.z))-nomV, hk3(float3(vp.x, vp.y, vp.z+0.01))-nomV);
  bumpe = bumpe*g_heightIntensity;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z-vp.z) / In.vPosSS.w;
  o.Depth = o.rt0;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, vp.xy).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;
  
 // o.rt3.z = 0.0;  
  
  return o;
}



texture g_texHalkeamaFadeInMap;
sampler smHalkeamaFadeIn =
sampler_state {
  Texture = <g_texHalkeamaFadeInMap>;
  MipFilter = LINEAR; // ANISOTROPIC
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};


texture g_texHalkeamaMinorDetails;
sampler smHalkeamaMinDet =
sampler_state {
  Texture = <g_texHalkeamaMinorDetails>;
  MipFilter = LINEAR; // ANISOTROPIC
  MinFilter = LINEAR;
  MagFilter = LINEAR;  
  AddressU = WRAP;
  AddressV = WRAP;
};



float g_halkeamaDepth=-0.15;
float g_halkeamaMul=1.0;
float g_halkeamaMinorDetailsAmp=0.2;
float g_halkeamaMinorDetailsTexMul=3.2;
float g_halkeamaTexFadeIn;
float g_halkeamaTexFadeInSteep;

float hk_halkeama(float3 vv) {
  float hFromTex = 0.5*tex2D(smHeight,vv.xy*0.73).g+0.45*tex2D(smHeight,vv.xy*1.15+float2(0.3,0.4)).g;
  hFromTex = clamp(hFromTex*g_halkeamaMul, 0.0, 1.0);
  
  float fadeInValue = 1.0-tex2D(smHalkeamaFadeIn,vv.xy).g;
  fadeInValue = 1.0-clamp((fadeInValue-g_halkeamaTexFadeIn)*g_halkeamaTexFadeInSteep, 0.0, 1.0);
  
  hFromTex += g_halkeamaMinorDetailsAmp*tex2D(smHalkeamaMinDet,vv.xy*g_halkeamaMinorDetailsTexMul).g;
  float box = vv.z-(1.0-(hFromTex*fadeInValue))*g_halkeamaDepth;
  float res = box;
  return res;
}

MRT_OUT_D ps_deferred_draw_march_halkeama( VS_OUTPUT_BASIC_KO In ) {
  MRT_OUT_D o=(MRT_OUT_D)0;


  float4 rayTan;
  float4 ray = In.vPosSO/In.vPosSO.w;
  //ray.x *= 9.0/16.0;
  //ray.z *= 2.0;
  float4 rn = normalize(ray);
  float4 nor = (In.vNormal);
  float4 tan = normalize(In.vTangent);
  float4 bin = normalize(In.vBiNormal);
  rayTan.x = dot(tan, rn);
  rayTan.y = dot(bin, rn);
  rayTan.z = dot(-nor, rn)*3.0+0.250;
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);
  
  float height = tex2D(smHeight, In.vTexcoord).g;
  
  float2 tc = In.vTexcoord;
  
  float po = max(0.9, rayTan.z);
  float pk = 1.0/0.9*min(0.9, rayTan.z);
  
  //float3 curveMap = float3(1.0/In.vTangent.w, 1.0, 1.0);
  
  float3 v;
  v.xy = rayTan.xy*3.0*g_march_depth/po;
  v.z = -g_march_depth*pk;
  
  float a = 0.0;
  float b = 0.0;
  /*
  float curveZ = a*v.x*v.x+b*v.y*v.y;
  curveZ = sign(curveZ)*max(abs(curveZ), 0.001);
  curveZ *= curveMap.z;
  */
  float hd = 0.0;
  float steps = 64.0f;
  int onceIn = 0;
  float deptho = 1.0/steps; 
  float dir = 1.0;
  float t = 0.0;
  float3 vp = float3(0.0, 0.0, 0.0);
  for (int i=0; i<steps; i++) {
    t += deptho*dir;
    vp.xy = tc+v.xy*t;
    vp.z = v.z*t;//+curveZ*t*t;
    float hn = hk_halkeama(vp);
    if (hn < 0.0) {
      onceIn = 1;
	}
	if (onceIn) {
	  deptho *= 0.5;
	  if (hn < 0.0) {
	    dir = -1.0;
	  } else {
	    dir = 1.0;
	  }
	}
  }
  /*
  if (onceIn == 0) {
    discard;
  }
  */
  
  vp.xy += rayTan.xy*0.025;
//  float4 ort2 = (0.65*tex2D(smDiffuse, vp.xy)+0.35*tex2D(smDiffuse, vp.xy*4.0))*g_materialDiffuse;
  float4 ort2 = tex2D(smDiffuse, vp.xy)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  /*
  if (o.rt2.a < 0.005)
    discard;  
    */
  float4 bumpe = 0;
  float nomV = hk_halkeama(vp);
  bumpe.xyz = float3(hk_halkeama(float3(vp.x+0.01, vp.y, vp.z))-nomV, hk_halkeama(float3(vp.x, vp.y+0.01, vp.z))-nomV, hk_halkeama(float3(vp.x, vp.y, vp.z+0.01))-nomV);
  bumpe.xy = bumpe.xy*g_heightIntensity;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z-0.1-vp.z) / In.vPosSS.w;
  o.Depth = o.rt0;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, vp.xy).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;
  
  return o;

}

MRT_OUT_D ps_deferred_draw_march_f3( VS_OUTPUT_BASIC_KO In ) {
  MRT_OUT_D o=(MRT_OUT_D)0;


  float4 rayTan;
  float4 ray = In.vPosSO/In.vPosSO.w;
  //ray.x *= 9.0/16.0;
  //ray.z *= 2.0;
  float4 rn = normalize(ray);
  float4 nor = (In.vNormal);
  float4 tan = normalize(In.vTangent);
  float4 bin = normalize(In.vBiNormal);
  rayTan.x = dot(tan, rn);
  rayTan.y = dot(bin, rn);
  rayTan.z = dot(-nor, rn)*3.0+0.250;
  rayTan.w = 0.0;
  
  rayTan = normalize(rayTan);
  
  float height = tex2D(smHeight, In.vTexcoord).g;
  
  float2 tc = In.vTexcoord;
  
  float po = max(0.9, rayTan.z);
  float pk = 1.0/0.9*min(0.9, rayTan.z);
  
  float3 curveMap = float3(1.0/In.vTangent.w, 1.0, 1.0);
  
  float3 v;
  v.xy = rayTan.xy*3.0*g_march_depth/po;
  v.z = -g_march_depth*pk;
  
  float a = 0.5;
  float b = 0.5;
  
  float curveZ = a*v.x*v.x+b*v.y*v.y;
  curveZ = sign(curveZ)*max(abs(curveZ), 0.001);
  
   //v *= curveMap;
  curveZ *= curveMap.z;
  
  float hd = 0.0;
  float steps = 32.0f;
  int onceIn = 0;
  float deptho = 1.0/steps; 
  float dir = 1.0;
  float t = 0.0;
  float3 vp = float3(0.0, 0.0, 0.0);
  for (int i=0; i<steps; i++) {
    t += deptho*dir;
    vp.xy = tc+v.xy*t;
    vp.z = v.z*t+curveZ*t*t;

    float hn = hk3(vp);
	
		
    if (hn < 0.0) {
      onceIn = 1;
	}
	if (onceIn) {
	  deptho *= 0.5;
	 // deptho = abs(hn)*2.0;
	  if (hn < 0.0) {
	    dir = -1.0;
	  } else {
	    dir = 1.0;
	  }
	} else if (i>4 && (vp.z+curveZ*t*t) > 0.0) {
	  discard; 
	}

  }
  /*
  float tMax = 1.0;
  float d=v.z*v.z-4.0*curveZ*1.0;
  if (d > 0.0) {
	tMax=min(50.0,(-v.z+sqrt(d))/(-2.0*curveZ));
  }
  d=v.z/curveZ;
  if (d > 0.0) {
	tMax=min(50.0,d);
  }
  
  if (t > min(tMax*0.25, 0.80)) {
    discard;
  }
  */
  
  if (onceIn == 0) {
    discard;
  }
  

  vp.xy += rayTan.xy*0.01;
//  float4 ort2 = (0.65*tex2D(smDiffuse, vp.xy)+0.35*tex2D(smDiffuse, vp.xy*4.0))*g_materialDiffuse;
  float4 ort2 = tex2D(smDiffuse, vp.xy)*g_materialDiffuse;
  ort2.xyz *= g_diffuseIntensity;
  o.rt2 = ort2;
  
 // o.rt2.xyz = ray.xyz;
  
  if (o.rt2.a < 0.005)
    discard;  
  
 // o.rt2.xyz = ray.xyz;
    
  float4 bumpe = 0;
  float nomV = hk3(vp);
  bumpe.xyz = float3(hk3(float3(vp.x+0.01, vp.y, vp.z))-nomV, hk3(float3(vp.x, vp.y+0.01, vp.z))-nomV, hk3(float3(vp.x, vp.y, vp.z+0.01))-nomV);
  bumpe = bumpe*g_heightIntensity;
  bumpe = normalize(bumpe);
       
  o.rt0 = (In.vPosSS.z-0.1-vp.z) / In.vPosSS.w;
  o.Depth = o.rt0;
  o.rt1 = (normalize(In.vNormal*bumpe.z+In.vTangent*bumpe.x+In.vBiNormal*bumpe.y)+1.0)*0.5;
  o.rt1.w = 1.0;
  
  o.rt3.x = g_materialAmbient; // pure ambient
  o.rt3.y = tex2D(smSpecular, vp.xy).g*g_specularIntensity;
  o.rt3.z = g_specularExponent;
  
 // o.rt3.z = 0.0;  
  
  return o;

}

/*
technique march {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_march( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_march( );
    }
}

technique march_f1 {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_march( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_march_f1( );
    }
}

technique march_f2 {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_march( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_march_f2( );
    }
}
*/


technique march_torus {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_march( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_march_f2( );
    }
}

technique march_halkeama {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_march( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_march_halkeama( );
    }
}


technique march_f3 {
    pass P0 {          
        VertexShader = compile vs_3_0 vs_deferred_draw_march( );
        PixelShader  = compile ps_3_0 ps_deferred_draw_march_f3( );
    }
}

