;---------------------------Relocator of SID-Maker of SID-Wizard--------------------------------
relocator ;sets logical address of player to match relocation address - but doesn't move player physically in memory

		lda relocaddr ;calculate difference
		sec
		sbc #>PLAYERADDR
		sta relocdiff
relodata
;-------------------------------------------------------------------------------
;relocate pointertable data (seq.pointers,pattern-pointers,instrument-pointers)

;adjust sequence-pointers in subtune-data 
		ldx TUNEHEADER+SEQAMOPOS
		dex ;make range 1...x to 0...x-1
seqrelp	txa
		ldy #0 ;will count division result
-		cmp #3 ;'divide A by 3' loop
		bcc +
		sec
		sbc #3
		iny
		bne - ;max. 255 - avoid endless loop
		txa ;sequence-number to divide by 3 to get number of actual subtune
		ldy #0 ;counts result
-		cmp #3 ;'divide A by 3' loop
		bcc +
		sec
		sbc #3
		iny
		bne - ;max. 255 - avoid endless loop
+		;result of division in Y, remainder in A
		asl ;multiply remainder by 2, sequence-pointer address inside subtune-data
		sta compzvar2
		tya ;result of division
		asl ;multiply by 8 to get to subtune-data base-address for actual subtune
		asl
		asl
		clc
		adc compzvar2
		tay
		;don't disturb sequence-pointer low-bytes
		iny
		lda (subtuneadd),y
		clc
		adc relocdiff
		sta (subtuneadd),y
		dex
		cpx #$ff
		bne seqrelp
;---------------------
;adjust pointers in pointer-tables: ptnptloadd, ptnpthiadd
		ldy TUNEHEADER+PTAMOUPOS ;amount of instruments
-		lda (ptnpthiadd),y
		clc
		adc relocdiff
		sta (ptnpthiadd),y
		dey
		bne -
;-----------------------
;adjust pointers in pointer-tables: insptloadd, inspthiadd
		ldy TUNEHEADER+INSTAMPOS ;amount of instruments
-		lda (inspthiadd),y
		clc
		adc relocdiff
		sta (inspthiadd),y
		dey
		bne -

;-------------------------------------------------------------------------------
;relocate target addresses of absolute commands in player
		lda #<reloctable1
		sta reltadd+1
		sta reltad2+1
		lda #>reloctable1
		sta reltadd+2
		sta reltad2+2
		
relabsl	ldx #0
reltadd	lda $1111,X ;self-written, actual address of relocation-table
		sta datzptr+0 ;zeropage lo-pointer set
		inx
reltad2	lda $1111,X ;self-written, actual address of relocation-table
		sta datzptr+1 ;zeropage hi-pointer set
		ldy #2 ;we modify only 2nd (hi) address-byte of absolute-addressing 6502 instructions in player code
		lda (datzptr),y
		clc
		adc relocdiff
		sta (datzptr),y
		
		lda reltadd+1 ;go to next relocation-pointer
		clc
		adc #2
		sta reltadd+1
		sta reltad2+1
		lda reltadd+2
		adc #0 ;add Carry
		sta reltadd+2
		sta reltad2+2

		lda reltadd+1 ;check if relocation-table is over or loop
		sec
		sbc #<endreloctable
		bcc relabsl ;loop
		lda reltadd+2
		sbc #>endreloctable
		bcc relabsl ;loop

;-------------------------------------
;relocate bigFX-table entries
		ldx #(ENDBIGFXTB-BIGFXTABLE)-2
-		lda BIGFXTABLE+1,x
		clc
		adc relocdiff
		sta BIGFXTABLE+1,x
		dex
		dex
		bpl -
;-------------------------------
;set SID-header jump-address accordingly
		lda SIDinitadd+0
		clc
		adc relocdiff
		sta SIDinitadd+0
		lda SIDplayadd+0
		clc
		adc relocdiff
		sta SIDplayadd+0
;--------------------------------
;set CIA-init/play addresses in SID accordingly
		lda CIAADDR+1
		clc
		adc relocdiff
		sta CIAADDR+1
		rts


;==============================================================================================================
unrelocate ;set everything back to relative of PLAYERADDR (resume relocation, not to affect further exports)
		lda #0 ;negate relocation-difference
		sec
		sbc relocdiff ;calculate difference backwards
		sta relocdiff ;reset reloc.address
		jsr relodata
		rts
		


;-------------------------variables used by relocator-------------------
relocaddr .byte $40 ;>PLAYERADDR ;hi-address to relocate
relocdiff .byte $00 ;hi-address relative to base address 

;==========================================reloc-table=================================================
;this table contains the absolute-addresses that need to be relocated in player code (SIDBASE is exception).
;whenever any absolute-addressing command is added to player, this needs to be adjusted
reloctable1 
		.word inisub, playsub, mulpsub, volusub
		.word SEQFXLO,INIPTN,MULCNTP,MULTIPW,MULTIFI
		.word TICK_0,HARDRST,NONEWNO,NEWNOTE,TICK_1
		.word PTN_SEQ,ptncode,SETPNUM,SEL_INS,COLUMN1
		.word JMPLEGA,SWONFLT,SWOFFLT,LEGATOO,CNTPLAY
		.word PORTAME,PORTADN,PORTEND,NORMVIB,DOVIBRA
		.word SUBFREQ,PORTAUP,ADDFREQ,STORVHI,SETPWID
		.word RDWFROW,SEWFARP,WRPITCH,WRGHOST,WRWFORM
		.word INST_FX,PATT_FX,INDEXJP,WRITEWF,SETDETU
		.WORD SKIPWFT,SEQFXL2
reloctable2
		;addresses of rest of absolute-addressing commands
		.word a1,a2,a3,a4,a5,a6,a7,a8,a9,a10
		.word a11,a12,a13,a14,a15,a16,a17,a18,a19,a20
		.word a21,a22,a23,a24,a25,a26,a27,a28,a29,a30
		.word a31,a32,a33,a34,a35,a36,a37,a38,a39,a40
		.word a41,a42,a43,a44,a45,a46,a47,a48,a49,a50
		.word a51,a52,a53,a54,a55,a56,a57,a58,a59,a60
		.word a61,a62,a63,a64,a65,a66,a67,a68,a69,a70
		.word a71,a72,a73,a74,a75,a76,a77,a78,a79,a80
		.word a81,a82,a83,a84,a85,a86,a87,a88,a89,a90
		.word a91,a92,a93,a94,a95,a96,a97,a98,a99,a100
reloctable3
		.word a101,a102,a103,a104,a105,a106,a107,a108,a109,a110
		.word a111,a112,a113,a114,a115,a116,a117,a118,a119,a120
		.word a121,a122,a123,a124,a125,a126,a127,a128,a129
		.word a131,a132,a133,a134,a135,a136,a137,a138,a139,a140
		.word a141,a142,a143,a144,a145,a146,a147,a148,a149,a150
		.word a151,a152,a153,a154,a155,a156,a157,a158,a159,a160
		.word a161,a162,a163,a164,a165,a166,a167,a168,a169,a170
		.word a171,a172,a173,a174,a175,a176,a177,a178,a179,a180
		.word a181,a182,a183,a184,a185,a186,a187,a188,a189,a190
		.word a191,a192,a193,a194,a195,a196,a197,a198,a199,a200
		.word a201,a202,a203,a204,a205,a206,a207, a208,a209,a210
		.word a211, a212,a213,a214,a215,a216,a217, a218, a219, a220

reloctable4

.IF FILTKBTRACK_ON
		.word a1b,a37b
.FI		

.IF DELAYSUPPORT_ON
		.word a2b
.FI

.IF FILTKBTRACK_ON
		.word a3b,a4b,a5b
.FI

.IF TEMPOPRGSUPP_ON
		.word TRKTMP2,TRKTMP3
		.word a6b,   a9b,a10b,a61b,a62b,a63b,a72b,a73b,a74b,a75b,a76b, a106b
		.word p_tmpt7,p_tmpp1,p_tmpt8,p_tmpt9,p_tmpp2, p_tmpt1
.ELSE
		.word p_tmpt1
.FI

.IF PACKEDNOPSUPP_ON
		.word PACKNOP
		.word a11b,a12b,a19b
.FI

.IF FASTSPEEDBIND_ON
		.word CHKTMP1,CHKTMP2
		.word p_tmpt2,p_tmpt3
.FI

.IF HARDRESTYPES_ON
		.word a13b,a14b,a15b,a16b,a17b,a18b
		.word p_insl2,p_insh2,p_insl3,p_insh3
.FI

.IF (PWRESETSW_ON+FILTRESETSW_ON)
		.word CHKNOTE
.FI

.IF TRANSPOSESUPP_ON
		.word a20b,a60b, a104b, a105b
.FI

.IF PWRESETSW_ON
		.word a21b
.FI

.IF FILTRESETSW_ON
		.word a22b
.FI

.IF ARPSPEEDSUPP_ON
		.word a23b,a24b,a45b,a46b,a47b,a48b,a49b,a70b,a71b
.ELSE
		.word a50b
.FI

.IF CHORDSUPPORT_ON
		.word LOOPCHD,DOCHORD
		.word a25b,a26b,a51b,a52b,a53b,a54b,a55b,a56b,a57b,a58b,a59b,a68b,a69b
		.word p_chdp1,p_chdt1,p_chdp2,p_chdp3,p_chdt2,p_chdp4
.FI

.IF VIBRATOTYPES_ON
		.word INCVIBR
		.word a27b,a28b,a29b,a30b
.FI

.IF DETUNESUPPORT_ON
		.WORD a130
.FI

.IF FINEFILTSWEEP_ON
		.word a31b,a32b,a33b,a34b,a35b,a36b
.FI

.IF PWKEYBTRACK_ON
		.word a38b,a39b,a40b,a41b,a42b,a43b
.ELSE
		.word a44b
.FI

.IF GATEOFFPTR_ON
		.word SETGOFF
		.word a64b,a65b,a66b,a67b
.FI

.IF DELAYSUPPORT_ON
		.word DELAYER
		.word a77b,a78b,a79b,a80b,a81b,a82b,a83b,a84b
.FI

.IF SUBTUNEJUMP_ON
		.word a85b,a86b,a87b,a88b,a89b,a90b,a91b,a92b,a93b,a94b
.FI	

.IF CALCVIBRATO_ON
		.word a95b            ;,a96b,a97b,a98b,a99b,a100b,a101b
.FI

reloctable5
		.word p_insl1,p_insh1,p_ptnl1,p_ptnh1,p_ptnl2,p_ptnh2
		.word p_insl4,p_insh4,p_insl5,p_insh5,p_subt1,p_subt2
		.word p_subt3,p_tmpt4,p_subt4,p_tmpt5,p_seqt1,p_seqt2
		.word p_seqt3,p_tmpt6

reloctable6
;code to be relocated in SID-data
		.word CIAINIT, p_SIDa1,p_SIDa2,p_SIDa3,p_SIDa4, p_SIDa5,p_SIDa6,p_SIDa7,p_SIDa8, CIAPLAY

endreloctable ;signs end of relocation data, used for counter

;===================================================================================
