irq          ;all music routine, rasterfx and key-requests
		pha  ;store sensitive registers and bank status
		txa
		pha
		tya
		pha
		lda banksel
		pha
		lda #$35 ;only IO area is above RAM
		sta banksel

fspdctr	ldx #0 ;self-written variable ;multispeed frame-position timer
		beq rast1st ;check whether multispeed or singlespeed raster-irq
		
		lda #multilincol    ;row 0 colour of multispeed-rasters
		sta $d020  ;,y ;Y index is just for adding 1 cycle to timing
		ldx #10
		dex
		bne *-1
		nop
;mulpchk	ldy playmod ;if playmode is 0, tune doesn't play
;		beq +       ;check playmode and call multiplay part of the player routine ($1006)
		lda #multibarcol ;colour of multispeed rasters ;instead of NOP here
		sta $d020  ;,x  ;X indexing is needed for 1 cycle plus if timing is critical
		jsr mulpsub ;multiplay part of the player routine ($1006) 
+		ldx #bordercolor
		stx $d020
		jmp dendply
;-------------------------------------------------------------------------------
rast1st	           ;singlespeed playroutine raster + key & cursor handling
		inx  ;x is 0 here from fspdctr branch
		stx syncscr+1 ;vblank-syncronize flag for displayroutine
		lda #(cursprite//$4000 / $40) ;modulo of VIC-banksize divided by spritesize
		sta $fff8   ;cursor-sprite pointer for 26th row
		sta vidram+$3f8
;-------------------		
		ldy #$f4    ;row26 trick comes at $f4, software-based colour-RAM handling
		cpy $d012
		bne *-3
		ldx #8
		lda $d001
		cmp #$e2
		bcc +    ;if cursor at row25, timing changes a bit
		ldx #5
+		dex
		bne *-1
		lda colrpos+$3c0
		sta row25ca+1
row25ca	lda #15          ;set back colors of 25th row (tick colouring) - instead of NOP
		ldx #$1f
		stx $d011 ;doing the 26th row trick
		sty $d018
		ldx colrpos+$3ca
		ldy colrpos+$3d4
		dec banksel
		sta colrpos+$3c0
		stx colrpos+$3ca
		sty colrpos+$3d4
		inc banksel
		lda #fxcol
		sta colrpos+$3c0 ;set char-colors of 26th row
		sta colrpos+$3c1
		sta colrpos+$3c2 
		sta colrpos+$3c3
		sta colrpos+$3c4 ;5,6,7,8,9 are left out, because already colour $0c
		sta colrpos+$3ca
		sta colrpos+$3cb
		sta colrpos+$3cc
		sta colrpos+$3cd
		sta colrpos+$3ce ;0f,10,11,12,13 are already colour $0c
		sta colrpos+$3d4
		sta colrpos+$3d5
		sta colrpos+$3d6
		sta colrpos+$3d7
		sta colrpos+$3d8 ;19,1a,1b,1c,1d are already colour $0c
		
		sta colrpos+$3e1 
		sta colrpos+$3e5
		sta colrpos+$3e6
		
		ldy #3
		ldx #1
		lda #11
		stx $d020 ;separator line below row25
		stx $d021
		dey
		bne *-1 ;Y=0 - background color behind orderlist-numbering positions
		sta $d020
		sty $d021

		lda #$ff ;draw low-border sprites for orderlist (ptr,color in displayer2/'iniscrn')
		eor menumode ;hide cursor if menu is displayed
		sta $d015
		txa ;lda #1
		ldy #$0e
-		sta $d003,y
		dey
		dey
		bpl -
;---------------
		lda #$fa   ;rasterline $FA -open vertical border
		cmp $d012
		bne *-3
		lda #$17
		sta $d011 ;causes opening of vertical border

		jsr cursord ;put cursor to coordinate & flash colour

		ldx #15 ;the lower separator bar colour
		lda #0
		sta $ffff ;idle graphics for the lower border replaces now irq hi-byte
;----------------		
		lda #$fe   ;wait for the singlespeed-play rasterposition
		cmp $d012
		bne *-3
		ldy #11
		dey
		bne *-1
		stx $d020   ;light-grey line under 26th row of display area
		stx $d021
		
		lda #3
		sta $dd00 ;lower border sprites are in other VIC-bank
		
		ldx #9
		dex
		bne *-1
no1strs	lda #playbarcol     ;singlespeed playerbar-colour    
		sta $d020
		;lda #backgroucol ;x is 0 after prev. loop...
		stx $d021 ;sta $d021
		stx $d01b ;sta $d01b ;cursor must be in front of idle-graph (but behind sprites 0..6)
		lda #$15   ;video-ram switching before lower border sprites come
		sta $d018
		lda #$18
		sta $d011   ;open vertical border part 2

playchk	lda playmod 
		beq +        ;if playmode is 0, tune doesn't play
		jsr playsub  ;singlespeed part of the player routine ($1003)
		jmp contirq
+		lda #jambarcol
		sta $d020
		jsr jamplay
		
contirq	;ldx #6 ;not needed, but it would ensure one complete rasterline even if playing is stopped
		;dex
		;bne *-1
		lda #bordercolor ;X is 0 here after loop
		sta $d020
		jsr padapter ;player-adapter, connects player to editor by refreshing counters, etc.
;-----------------
		lda $d011   ;the 1st rasterrow below player and orderlist-sprites
		bpl +
-		lda $d012 ;wait minimum  raster $18, but immediate if we delayed
		cmp #$18 ;earliest raster after (below) orderlist - otherwise higher framespeeds fail
		bmi -
+		lda actwind ;check for cursor display in orderlist
		cmp #1
		bne +
		lda namemode
		bne +
		lda #$fe ;only if we are in orderlist
		sta $d015
		;lda #0 ;X is 0 here after loop
		stx $d027 ;sta $d027
		+
row25back ;set back row25 colours (only the different colors) after row26 trick
		lda #>irq ;it was idle pattern zeroed, now we restore it as IRQ hi-pointer
		sta $ffff
		lda #15
		sta colrpos+$3c0+$21
		sta colrpos+$3c0+$25 
		sta colrpos+$3c0+$26
		ldx #3
-		lda mutesolo-1,x ;-1, because x counts from 3 to 1, not from 2 to 0
		and #1
		tay
		lda msolocol+2,y ;instrument-column mute-solo colours (in datatables.inc)
		pha
		lda msolocol,y  ;mute/solo colour index in datatables.inc
		ldy stplptr-1,x	;step-highlight column indexes (screen-positions)
		sta colrpos+$3c0+1,y ;note-mutesolo color-position indexes
		sta colrpos+$3c1+1,y
		pla
		sta colrpos+$3c2+1,y
		sta colrpos+$3c3+1,y
		dec banksel ;$34
		lda colrpos+$3c0,y ;swapping the step-highlighting colours back
		inc banksel ;$35
		sta colrpos+$3c0,y
		dex
		bne -
		;x should be 0 here as its value is used for $dd00
		;lda #0
		stx $dd00 ;sta $dd00
		lda #$84
		sta $d018
		lda #$18   ;set upper border sprites
		ldy #$10
-		sta $d003,y
		dey
		dey
		bpl -
		
		jsr timecount ;counts the timer if playmode is 1 (songplay mode)
		jsr keyer ;better here if raster-runthrough is detected for multispeed 
		jsr reftpos ;refresh table-base positions in jmtbase to add them in displayer/datawriter
		jsr followplay ;if follow-mode is on, this subroutine overrides key navigation and controls patterns
		jsr display2 ;set refreshers to refresh window displays outside IRQ

dendply	
-		inc fspdctr+1 ;go to next multispeed frame
		lda fspdctr+1
		cmp framesp ;check if reached actual framespeed
		bne nofsini
		lda #0
		sta fspdctr+1 ;and if reached, go with 1st raster again
		
nofsini ldy framesp    ;set the next multispeed-player raster-IRQ to $d012
		lda frmspds,y  ;check framespeed-program lookup table in datatables.inc
		clc
		adc fspdctr+1    ;check actual framespeed count
		tay
		lda framers,y  ;get actual frameraster from table
		sta welf+1
		tax
		bit $d011 ;check if we're in lower raster area ($d011 bit 7 is 0)
		bpl + ;if bit 7 is ON, no need to check
		lda #0
		cmp $d012 ;in case we're still in 2nd raster area, wait for 1st
		bne *-3   ;so to be safe
		beq rra ;jmp rra - $d012=zero branches, we optimized 1 byte 
+		lda $d012
		clc
		adc #2 ;cheat with rastertiming to let 2 raster time for irq
welf	cmp #1 ;check if we possibly ran over the raster with long keyroutines, like copying/pasting long tracks
		bcs -  ;if ran over, leave the intended rasterbar and go to next
rra		stx $d012

retirq	asl $d019
		pla ;written at IRQ entry, stored value of $01 ROM/RAM bank switcher
		sta banksel
		pla
		tay
		pla
		tax
		pla
		rti
;--------------------if restore pressed, NMI vector points here
dummirq	;NMI (Restore key) ends here, used for page-up in VICE
		bit $dc0d
		inc restsig+1 ;signs for keyhandler that restore was pressed. routine zeroes it
		rti

;====================================================================================
