;=========================SOME USEFUL COMMON SUPPORTING ROUTINES===============

;--------------------------------------------------------------------------------------
timecount ;counts the timer if playmode is 1 (songplay mode) - called from IRQ
		lda seconcnt
		bpl nominchg
		lda #frames1second
		sta seconcnt
		lda playmod
		beq retpnt1
		sed ;set decimal mode for timer BCD digits
		lda songtime+1  ;seconds
		clc
		adc #1
		sta songtime+1
		cld  ;disable decimal mode for timer BCD digits
		cmp #$60
		bne nominchg
		lda #0
		sta songtime+1 
		sed ;set decimal mode for timer BCD digits
		lda songtime  ;minutes
		clc
		adc #1
		cld  ;disable decimal mode for timer BCD digits
		cmp #$60
		bne countfull
		lda #0
countfull sta songtime
nominchg dec seconcnt		
retpnt1	rts
		
seconcnt  .byte frames1second		

;------------------------------------------------------------------------------	
resetimer   ;resets the timer 
		lda #0
		sta songtime ;reset minutes
		sta songtime+1 ;reset seconds
		lda #frames1second
		sta seconcnt
		rts

;================================================================================
setptnptr                     ;set pattern-pointers (memory index of display-position calculated by displayer)
        sty ystorew+1 ;for safety
		ldx subwpos1+0 ;actual track
		ldy actptn1,x  ;actual pattern
		lda ptn1pos,x  ;set selected pattern's lo-pointer
		clc
		adc pptrlo,y ;set selected pattern's lo-pointer with display-shift, this real pointer is calculated by displayer
		sta instpt1+1
		sta instpt2+1
		sta pattpt1+1
		sta pattpt4+1
		sta ptnzptr+0 ;zeropage lo-pointer dedicated for pattern-routines inside IRQ
		lda ptn1pos,x  
		lda pptrhi,y
		adc #0 ;add Carry-flag as well
		sta instpt1+2
		sta instpt2+2
		sta pattpt1+2
		sta pattpt4+2
		sta ptnzptr+1 ;zeropage hi-pointer dedicated for pattern-routines inside IRQ	
ystorew ldy #0 ;self-written - restore Y		
		rts

setinsptr ;can be run concurrently in main part and IRQ, because only 1 instrument is selected at a time
		ldx selinst+1   ;load selected instrumet's basepointer to readers/writers
		lda insptlo,x
		sta instpt1+1
		sta instpt2+1
		sta inszptr
		lda inspthi,x
		sta instpt1+2
		sta instpt2+2
		sta inszptr+1
		rts

instpt1	lda $1111,x ;self-written code - instrument/pattern basepointer for X indexing - read
		rts
instpt2	sta $1111,x ;self-written code - instrument/pattern basepointer for X indexing - write
		rts

setseqptr ;set pointer of actual sequence data
		lda subwpos1+1 ;actual track in orderlist
setsep2	asl
		sta olastor+1
		jsr getsubaddr ;subtune orderlist-pointer to A and Y, clear C flag
olastor	adc #0 ;self-written
		tay
		lda SUBTUNES,y  ;READ ORDERLIST LO-ADDRESSES FOR SUBTUNE
        sta seqaddb+1    ;SET ORDERLIST LO-ADDRESSES FOR SUBTUNE
        sta seqaddc+1    ;SET ORDERLIST LO-ADDRESSES FOR SUBTUNE
        sta seqadde+1    ;SET ORDERLIST LO-ADDRESSES FOR SUBTUNE
		iny
        lda SUBTUNES,y  ;READ ORDERLIST HI-ADDRESSES FOR SUBTUNE
        sta seqaddb+2   ;SET ORDERLIST HI-ADDRESSES FOR SUBTUNE
        sta seqaddc+2    ;SET ORDERLIST LO-ADDRESSES FOR SUBTUNE
        sta seqadde+2   ;SET ORDERLIST HI-ADDRESSES FOR SUBTUNE
        rts

		
seqaddb	lda $1111,y ;self-written code - orderlist pointer for X indexing - read
		rts
seqaddc sta $1111,y ;self-written code - orderlist pointer for X indexing - write
		rts

;------------------------------------------------------------------------------
getcurnote ;get note-data in actual track/pattern at cursor position to A
		ldx subwpos1+0 ;actual track
		lda ptncurs,x
		tax            ;X is now the note's position/index in pattern memory
		jmp instpt1

getcurptn ;get orderlist memory index under cursor to A and Y
		lda subwpos2+1 ;orderlist X cursor position 
		lsr
		clc
		adc seqdpos+1  ;add orderlist-displayposition
		tay
		rts

;---------------------------
chkcury ;check, if the cursor is inside the new track's pattern area
		jsr compcur
		bcc insidep
		lda ptnlength,y ;place the cursor to last row of pattern ending upperwards
		sec
		sbc prowpos,x ;substract displayed row position from patternlength, that will be new cursor-position
		sta subwpos3
insidep rts

;------------------------------------------------------------------------------
compcur ;compare cursor+patterndisplay position to patternlength
		ldx subwpos1+0 ;actual tracknumber to X
		ldy actptn1,x   ;actual pattern to Y
		lda prowpos,x   ;actual pattern displayposition to A
		clc ;important to compare in 16 bits
		adc subwpos3+0  ;actual track display's actual row (cursor row)
		bcs + ;if sum of patternlength and cursorpos is bigger than $ff - important to compare in 16 bits
		cmp ptnlength,y ;compare to length of actual pattern
+		rts

;------------------------------------------------------------------------------
writehex1             ;merge typed 1st hexa digit with existing data
		and #$0f
		sta wrhxad2+1
wrhxad1	lda #0 ;self-written
		asl
		asl
		asl
		asl
wrhxad2	ora #0 ;self-written
		rts

writehex2             ;merge typed 2nd hexa digit with existing data
		and #$f0
wrhxad3	ora #0 ;self-written
		rts


;------------------------------------------------------------------------------
getsubaddr ;get subtune orderlist-pointer to A and Y, clear C flag
		lda selsubt+1
mul8toY	asl
        asl
        asl        ;GET SUBTUNE ADDRESS FROM ACCU MULTIPLIED 8
        tay
        clc
retoldi rts

;-----------------------------------------------
calcsubsp1 ;subtune given in A, outputs speed1 in A, pos. in Y
		lda selsubt+1
		;and #$3f
		asl
		asl
		asl
		clc
		adc #6
		tay
		lda subtunes,y ;why not subtunes+6 instead? Maybe many things are built on this already, maybe not..
		rts


;------------------------------------------------------------------------------
calcmwpos  ;calculate main inst.window instrument data position
		asl
		asl
		adc subwpos3+2
		tax
		lda mainstrw,x
		tax
		rts


;------------------------------------------------------------------------------
ihexdis lda (inszptr),y  
		iny
hexdis2	pha   ;input:accu, output: nybbles in Accu and X-register 
		and #$0f
		tax
		pla
div16	lsr
		lsr
		lsr
		lsr
		rts


;------------------------------------------------------------------------------
chptful	;check if pattern is full, A and X preserved, carry bit is 0 if pattern is full
		pha
		txa
		pha
		ldx subwpos1+0 ;actual tracknumber to X
		ldy actptn1,x   ;actual pattern to Y
		lda ptnsize,y ;precheck if pattern is not full, later checks in code are obsolete
		cmp #maxptnlen ;checking not #$ff because 4 byte insertion is possible with new bigfx
		pla
		tax
		pla
		rts

;-------------------------------
getlast	;get memory position of last row data to X - relative to displayposition
		ldy subwpos1+0 ;actual track
		ldx actptn1,y  ;actual pattern
		lda ptnlength,x 
detmemp	sec  ;get memory position given (accu) row data to X - relative to displayposition
		sbc prowpos,y ;accu here is row-pos. of row relative to displayposition
		tay
		dey   ;? patternlength change done afterwards in caller
		ldx #0 ;starts as 0, beginning of display area, accumulates the mem-amount in X
xdetlop	cpy #0 ;test Y
		beq retget2
		jsr instpt1
		bpl decyer
		inx
		jsr instpt1
		bpl decyer
		inx
		jsr instpt1
		and #$e0
		bne decyer
		inx
decyer	inx
		dey
		bne xdetlop
retget2	rts
		
;-------------------------------------------------------------------
multip3	;multiply value in Accu by 3, the result into Accu, original value to X
		stx vidzptr
		sty vidzptr+1
		tax
		;and #$3f ;max. amount of table-rows
multi3b	sta mul3sto+1
		asl
		clc
mul3sto	adc #0 ;self-written
		clc
		rts

div3acu	ldy #0 ;divide accu by 3, result in Y and Accu
-		sec
		cmp #3
		bcc +
		sbc #3
		iny
		bne -
+		tya
		rts

;------------------------------------------------------------------------------
getitbi	;get actual instrument table row pointer to X
		lda #WFTABLEPOS  ;WF/ARP table position relative to instrument-base (globalconstants.inc)
		ldy subwpos1+2 ;actual instrument subwindow
		dey  ;transform from 1..3 to 0..2
		beq + ;if WAVEFORM-ARP table
		tya
		clc
		adc #$0a-1 ;PW/Cutoff-table pointer (relative to instrument basepointer)
		tax
		jsr instpt1 ;get relative PW/Cutoff-table pointer
+		sta ipostor+1

		lda wfarpos,y
		clc
		adc subwpos3+2 ;Y cursor-coordinate in instrument-subtable
		jsr multi3b ;multiply A by 3, clear Carry-flag
ipostor	adc #0 ;self-written
		tax
getiret	rts

reftpos ;refresh table-base positions in jmtbase to add them in displayer/datawriter
		;jsr setinsptr   ;load selected instrumet's basepointer to zeropage pointers
		ldx #$0a ;index to PW-table pointer
		jsr instpt1
		sta jmtbase+2
		inx ;index to filtertable-pointer
		jsr instpt1
		sta jmtbase+3
		rts

jmtbase	.byte 0,WFTABLEPOS,$11,$12 ;table-basepointers to add to $FE jumpaddress calculation
        ;(helps player by pre-calculating real table-positions at typing)

;------------------------------------------------------------------------------
getctpos
		ldx selchor+1  ;gets actual chorddata position to X, value to A
		lda chdptrlo,x
		clc
		adc chorpos
		adc subwpos1+3 
		tax
		lda chords,x
		rts

gettpos ldx seltemp+1   ;check if tempoprogram-length has been reached
		lda temptrlo,x
		clc
		adc temppos
		adc subwpos1+4 
		tax
		lda TEMPOTBL,x
		rts


;------------------------------------------------------------------------------
sseqend	 ;set position to end of orderlist, if there is $00 under cursor (when moving cursor to shorter sequence)
		jsr setseqptr  ;set the datapointer for actual orderlist position
		 ;test if $ff is at previous place or $fe is in actual place in orderlist
		jsr getcurptn ;get orderlist memory index under cursor to A and Y
		dey
		jsr seqaddb ;get previous data, check if $ff
		iny
		cmp #$ff
		beq retsseq
		jsr seqaddb ;get data under orderlist cursor into A, index in orderlist is Y
		bne retsseq ;if not zero, do nothing
		ldy #0    ;seek for $fe/$ff endsignals from beginning of sequence
seqslop	jsr seqaddb  ;maybe slow this way, maybe not that much
		cmp #$fe
		beq +
		cmp #$ff
		beq +
		iny
		cpy #seqlength
		bne seqslop
		ldy #0 ;if not found, position 0 seems to be safe
+		tya  ;Y and A holds the endsignal position here
		pha
		sec
		sbc seqdpos+1 ;the distance of seq endsignal-position from display-position
		bcc +   ;if end not inside screen (no need to check bigger, just smaller)
		asl
		sta subwpos2+1 ;set cursor to end
		pla
		rts
+		pla
		sta seqdpos+1
		lda #0
		sta subwpos2+1
retsseq	rts


;------------------------------------------------------------------------------
jmptopt	;jump to pattern under orderlist cursor, y holds track number
		sty jptysto+1
		tya
		jsr setsep2  ;set pointer of sequence data selected by Y
		
		jsr getcurptn ;get orderlist memory index under cursor to A and Y
		tax
		dey
		jsr seqaddb ;get data before cursorposition, check, if $ff
		iny
		cmp #$ff   ;if it's loop-position value, don't change selected pattern
		beq jptret ;+
		
jptysto	ldy #0 ;self-written
		lda followp+1 ;if followplay is on, don´t disturb pointers
		bne jptret
seqadde	lda $1111,x
		beq jptret ;+   ;if zero pattern, no go.
		cmp #maxptnamount+1
		bcs jptret ;+   ;if bigger than the allowed number of patterns
		sta actptn1,y
		lda #0
		sta prowpos,y
jptret	rts


;------------------------------------------------------------------------------
getdelamount ;gets the amount of data (Y) to delete at pattern-memory position (given in X)
		ldy #1 ;stays 1 if only note column exists, otherwise increases up to 4
getdla2	stx ptdelpx+1
		cmp #0
		bpl dodelpt  ;if only note column, delete only one byte
		inx
		iny ;1/2
		jsr instpt1 ; read and test instrument column
		bpl dodelpt
		inx
		iny ;2/3
		jsr instpt1 ;read and test fxtype column
		and #$e0
		bne dodelpt
		iny ;3/4
dodelpt	
ptdelpx	ldx #0 ;self-written, stored X
		rts
		
;==============================================================================
