;===============================================
;add SPLASH-SCREEN for SID-Wizard decompression
;-----------------------------------------------
*=$0801
.binary "../binary/SID-Wizard-packed.prg",2
endpacked

VideoRAM=$0400
CharROM1=$d000
CharROM2=$d800
Bitmap=$6000
BitmapCol=$5c00

;-------------------------------------------------------------------------------
;splash-screen displayer

SPLASHER lda #$A0
		 sta $080d ;restore exomizer launcher destructed byte
;--------------------------
         SEI
		 LDX #>CharROM1
         LDA $D018
         AND #$0F
         CMP #5
         BEQ +
         LDX #>CharROM2
+        STX CASER+1 ;character-ROM address

;-------------------------------------------------------------------------------
;Convert VIDEORAM-characters to bitmap ($0400..$0800 --> $2000..$4000)
CHTOBMP  LDA #$33 ;switch to Char-RAM
         STA 1
         LDA #0
         STA 4
         LDA #>Bitmap ;base address (hi) of the targeted bitmap
         STA 5
         LDA #>VideoRAM   ;videoram-hi pointer
         STA VMEM+2
         LDX #0
LP0      LDA #0
         STA 2
         STA 3
VMEM     LDA VideoRAM,X ;self-written  - get the next character videoram
         CLC
         ASL A       ;and multiply by 8 to get character's address
         ROL 3
         ASL A
         ROL 3
         ASL A
         ROL 3
         STA 2
CASER    LDA #>CharROM1 ;self-written - base address of character-ROM
         CLC
         ADC 3
         STA 3
         LDY #7
LP1      LDA (2),Y   ;copy character from character ROM
         STA (4),Y   ;paste character to bitmap
         DEY
         BPL LP1
         LDA 4
         CLC
         ADC #8      ;increase bitmap-pointer by 8 (one character in BMP mode)
         STA 4
         LDA 5
         ADC #0
         STA 5
         INX         ;increase VideoRAM pointer-lo
         BNE LP0     
         INC VMEM+2  ;increase VideoRAM pointer-hi
         LDA VMEM+2  
         CMP #>(VideoRAM+$400)  ;and check, if all VideoRAM has been taken over
         BNE LP0     ;if not, just continue
;-------------------------------------------------------------------------------
;set the colour of the bitmap (VIDEORAM HI-NYBBLEs) to the selected bordercolour
         LDA #$35
         STA $01
         LDA $D021
		 AND #$0F
         STA 6
         LDY #0
LP3      LDA $D800,Y
		 ASL
		 ASL
		 ASL
		 ASL
		 ORA 6
		 STA BitmapCol,Y
		 LDA $D900,Y
		 ASL
		 ASL
		 ASL
		 ASL
		 ORA 6
         STA BitmapCol+$100,Y
         LDA $DA00,Y
		 ASL
		 ASL
		 ASL
		 ASL
		 ORA 6
         STA BitmapCol+$200,Y
         LDA $DB00,Y
		 ASL
		 ASL
		 ASL
		 ASL
		 ORA 6
         STA BitmapCol+$300,Y
         INY
         BNE LP3

;------------------------copy bitmap-data
		lda #<SplashBitmap
		sta 2
		lda #>SplashBitmap
		sta 3
		lda #<(Bitmap+5*40*8+12*8)
		sta 4
		lda #>(Bitmap+5*40*8+12*8)
		sta 5
		ldx #14 ;counts rows
-		ldy #$7f
-		lda (2),y
		sta (4),y
		dey
		bpl -
		lda 2
		clc
		adc #16*8
		sta 2
		bcc +
		inc 3
+		lda 4
		clc
		adc #$40
		sta 4
		lda 5
		adc #$01
		sta 5
		dex ;counts rows
		bpl --
;------------------init/copy bitmap colors
		lda #<SplashColorMap
		sta 2
		lda #>SplashColorMap
		sta 3
		lda #<(BitmapCol+5*40+12)
		sta 4
		lda #>(BitmapCol+5*40+12)
		sta 5
		ldx #14
-		ldy #15
-		lda (2),y
		sta (4),y
		dey
		bpl -
		lda 2
		clc
		adc #16
		sta 2
		bcc +
		inc 3
+		lda 4
		clc
		adc #40
		sta 4
		bcc +
		inc 5
+		dex
		bpl --

;-------------------------------------------------------
;vblank-synchronized switching from VIDEORAM to BITMAP (prevent glitches)
         LDA #$FF
         CMP $D012
         BNE *-3
         LDA #$3B
         STA $D011 ;set bitmap mode
         LDA #( 7*16 + 1*8 )
         STA $D018 ;set bitmap and video-ram pointers
         LDA #2
         STA $DD00 ;set VIC-bank
         
;------------------------------------------------
		lda #$37
		sta 1
		jmp $080d ;go to perform decompression
		
ENDSPLASHER ;sign end of splash-code

;--------------------------------------bitmap-data-------------------
SplashBitmap
.binary"graph/splash4-bitmap.bin"
SplashColorMap
.binary"graph/splash4-colormap.bin"
;-------------------------------------------------------------------------------
;modify Starter to point to splash displayer
*=$0801
		.word ss,1
		.null $9e,^SPLASHER ;Sys SPLASHER
ss		.word 0
;===============================================================================
