#include <malloc.h>
#include <conio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <dos.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>

#include "kdm.h"

#define MAXMENUFILES 256

extern long ramplookup[64];

extern long showwavemode;
extern char lasty1[320], lasty2[320];

extern long splc[NUMCHANNELS], sinc[NUMCHANNELS];
extern long swavenum[NUMCHANNELS];

extern long frqtable[256];
char midivoltable[128] =
{
#if 1   //See VOLSCALE.BAS
	  4,  4,  5,  5,  6,  6,  6,  7,  8,  8,  9,  9, 10, 10, 11, 11,
	 12, 13, 13, 14, 15, 15, 16, 17, 17, 18, 19, 20, 21, 21, 22, 23,
	 24, 25, 26, 27, 28, 28, 29, 30, 32, 33, 34, 35, 36, 37, 38, 39,
	 41, 42, 43, 44, 46, 47, 49, 50, 51, 53, 54, 56, 58, 59, 61, 62,
	 64, 66, 68, 70, 72, 73, 75, 77, 80, 82, 84, 86, 88, 90, 93, 95,
	 98,100,103,105,108,111,114,116,119,122,125,128,132,135,138,141,
	145,148,152,156,160,163,167,171,176,180,184,188,193,197,202,207,
	212,217,222,227,232,238,244,249,255,255,255,255,255,255,255,255,
#else
	  4,  4,  4,  5,  5,  5,  5,  5,  6,  6,  6,  6,  7,  7,  7,  8,
	  8,  8,  9,  9, 10, 10, 10, 11, 11, 12, 12, 13, 13, 14, 15, 15,
	 16, 17, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31,
	 32, 33, 35, 36, 38, 40, 41, 43, 45, 47, 49, 52, 54, 56, 59, 61,
	 64, 67, 70, 73, 76, 79, 83, 87, 91, 95, 99,103,108,112,117,123,
	128,134,140,146,152,159,166,173,181,189,197,206,215,225,235,245,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,
	255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255
#endif
};

extern char *snd, kwvname[20];

static long xsamplerate;
static char xsoundcardtype, xnumspeakers, xbytespersample;
static char xintspersec, xquality;

static char lastat = 0x90;
static long octave = 0;
static char quant[15] = {1,2,3,4,5,6,8,10,12,15,20,24,30,40,60};
static char freqspot[256] =
{
	0,
	120,255,117,255,114,111,255,108,255,105,255,102,
	99,255,96,255,93,90,255,87,255,84,255,81,
	78,255,75,255,72,69,255,66,255,63,255,60,
	57,255,54,255,51,48,255,45,255,42,255,39,
	36,255,33,255,30,27,255,24,255,21,255,18,
	15
};

void (__interrupt __far *oldkeyhandler)();
void __interrupt __far keyhandler(void);

static char screeninfo[4000], tempbuf[65536];
static long tempbuflong[256];
static long otimetop, otimeplc;

static char asksaveinsts = 0;

static char menuname[MAXMENUFILES][32];
static long menunamecnt, menuhighlight = 0;

static long curkdmfile = 0, curmodinst = 0;

short int mousx, mousy, moustat, bstatus, obstatus;
volatile unsigned char readch, oldreadch, extended, keystatus[256];

char okeystatus[256];
#define NUMSCANTONOTES 45
signed char scantonote[NUMSCANTONOTES][2] =
{
	0x3a,-2,0x2a,-1,0x2c,0,0x1f,1,0x2d,2,0x20,3,0x2e,4,0x2f,5,
	0x22,6,0x30,7,0x23,8,0x31,9,0x24,10,0x32,11,
	0x33,12,0x29,10,0xf,11,0x10,12,0x26,13,0x3,13,0x34,14,0x11,14,
	0x27,15,0x4,15,0x35,16,0x12,16,0x36,17,0x1c,18,
	0x13,17,0x6,18,0x14,19,0x7,20,0x15,21,0x8,22,
	0x16,23,0x17,24,0xa,25,0x18,26,0xb,27,0x19,28,
	0x1a,29,0xd,30,0x1b,31,0xe,32,0x2b,33,
};

static long modleng[MAXMENUFILES], modrepstart[MAXMENUFILES];
static long modrepleng[MAXMENUFILES], modfinetune[MAXMENUFILES];

static long fiddlemode = 0;

static char scantoasc[128] =
{
	0,0,'1','2','3','4','5','6','7','8','9','0','-','=',0,0,
	'q','w','e','r','t','y','u','i','o','p','[',']',0,0,'a','s',
	'd','f','g','h','j','k','l',';',39,'`',0,92,'z','x','c','v',
	'b','n','m',',','.','/',0,'*',0,32,0,0,0,0,0,0,
	0,0,0,0,0,0,0,'7','8','9','-','4','5','6','+','1',
	'2','3','0','.',0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};
static char scantoascwithshift[128] =
{
	0,0,'!','@','#','$','%','^','&','*','(',')','_','+',0,0,
	'Q','W','E','R','T','Y','U','I','O','P','{','}',0,0,'A','S',
	'D','F','G','H','J','K','L',':',34,'~',0,'|','Z','X','C','V',
	'B','N','M','<','>','?',0,'*',0,32,0,0,0,0,0,0,
	0,0,0,0,0,0,0,'7','8','9','-','4','5','6','+','1',
	'2','3','0','.',0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
};

#pragma aux setvmode =\
	"int 0x10",\
	parm [eax]\

#pragma aux printchrasm =\
	"rep stosw",\
	parm [edi][ecx][eax]\

#pragma aux savescreen =\
	"mov esi, 0xb8000",\
	"mov edi, offset screeninfo",\
	"mov ecx, 1000",\
	"rep movsd",\
	modify [ecx esi edi]\

#pragma aux restorescreen =\
	"mov esi, offset screeninfo",\
	"mov edi, 0xb8000",\
	"mov ecx, 1000",\
	"rep movsd",\
	modify [ecx esi edi]\

#pragma aux setupmouse =\
	"mov ax, 0",\
	"int 33h",\
	"mov moustat,1",\
	modify [eax]\

#pragma aux readmouse =\
	"mov ax, 11d",\
	"int 33h",\
	"sar cx, 1",\
	"sar dx, 1",\
	"mov mousx, cx",\
	"mov mousy, dx",\
	"mov ax, 5d",\
	"int 33h",\
	"mov bx, bstatus",\
	"mov obstatus, bx",\
	"mov bstatus, ax",\
	modify [eax ecx edx]\

#pragma aux interruptend =\
	"mov al, 20h",\
	"out 20h, al",\
	modify [eax]\

#pragma aux readkey =\
	"in al, 0x60",\
	"mov readch, al",\
	"in al, 0x61",\
	"or al, 0x80",\
	"out 0x61, al",\
	"and al, 0x7f",\
	"out 0x61, al",\
	modify [eax]\

#pragma aux write16 =\
	"mov esi, edi",\
	"movsb",\
	parm [edi]\
	modify exact [esi edi]\

#pragma aux vlin16 =\
	"mov esi, edi",\
	"begvlin16: movsb",\
	"add esi, 79",\
	"add edi, 79",\
	"dec ecx",\
	"jnz begvlin16",\
	parm [edi][ecx]\
	modify exact [ecx esi edi]\

#pragma aux hlin16 =\
	"mov esi, edi",\
	"rep movsb",\
	parm [edi][ecx]\
	modify exact [ecx esi edi]\
	value [edi]\

#pragma aux drawpixel16 =\
	"mov ecx, edi",\
	"and ecx, 7",\
	"mov eax, 00008000h",\
	"shr eax, cl",\
	"mov edx, 0x3ce",\
	"add eax, 8",\
	"out dx, ax",\
	"shr edi, 3",\
	"add edi, 0xa0000",\
	"mov esi, edi",\
	"movsb",\
	parm [edi]\
	modify exact [eax ecx edx esi edi]\

#pragma aux setcolor16 =\
	"shl eax, 8",\
	"mov edx, 0x3ce",\
	"out dx, ax",\
	parm [eax]\
	modify exact [eax edx]\

#pragma aux fillscreen16 =\
	"mov edx, 0x3ce",\
	"shl eax, 8",\
	"out dx, ax",\
	"mov eax, 0xff08",\
	"out dx, ax",\
	"shr ecx, 5",\
	"add edi, 0xa0000",\
	"rep stosd",\
	parm [edi][eax][ecx]\
	modify exact [eax ecx edx edi]\

#pragma aux mulscale16 =\
	"imul ebx",\
	"shrd eax, edx, 16",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\

#pragma aux mulscale24 =\
	"imul ebx",\
	"shrd eax, edx, 24",\
	parm nomemory [eax][ebx]\
	modify exact [eax edx]\

#pragma aux clearbuf =\
	"snot: mov dword ptr [edi], eax",\
	"add edi, 4",\
	"loop snot",\
	parm [edi][ecx][eax]\

#pragma aux copybuf =\
	"snot: mov eax, dword ptr [esi]",\
	"mov dword ptr [edi], eax",\
	"add esi, 4",\
	"add edi, 4",\
	"loop snot",\
	parm [esi][edi][ecx]\
	modify [eax]\

#pragma aux koutp =\
	"out dx, al",\
	parm [edx][eax]\

#pragma aux koutpw =\
	"out dx, ax",\
	parm [edx][eax]\

#pragma aux kinp =\
	"xor eax, eax",\
	"in al, dx",\
	parm [edx]\

main(int argc, char **argv)
{
	char ch, buffer[80], *osnd;
	long i, j, k, toptextscreen, curtrack, swaptrack, column;

	initgroupfile("stuff.dat");

	xsamplerate = 44100;
	xnumspeakers = 2;
	xbytespersample = 2;
	xsoundcardtype = 1;
	xintspersec = 120;
	xquality = 1;
	globtempo = 120;

	i = 1;
	while (i < argc)
	{
		strcpy(buffer,argv[i]);

		j = 0;
		while (buffer[j] == 32) j++;

		if ((buffer[j] == 'r') || (buffer[j] == 'R'))
		{
			j++;
			xsamplerate = 0;
			while ((buffer[j] >= 48) && (buffer[j] <= 57))
			{
				xsamplerate *= 10;
				xsamplerate += buffer[j]-48;
				j++;
			}
		}
		else if (((buffer[j] == 's') || (buffer[j] == 'S')) && ((buffer[j+1] == 'b') || (buffer[j+1] == 'B')))
		{
			xsoundcardtype = 1;
		}
		else if (((buffer[j] == 'p') || (buffer[j] == 'P')) && ((buffer[j+1] == 'a') || (buffer[j+1] == 'A')) && ((buffer[j+2] == 's') || (buffer[j+2] == 'S')))
		{
			xsoundcardtype = 2;
		}
		else if (((buffer[j] == 'p') || (buffer[j] == 'P')) && ((buffer[j+1] == 'c') || (buffer[j+1] == 'C')))
		{
			xsoundcardtype = 13;
		}
		else if ((buffer[j] == 'm') || (buffer[j] == 'M')) xnumspeakers = 1;
		else if ((buffer[j] == 's') || (buffer[j] == 'S')) xnumspeakers = 2;
		else if (buffer[j] == '8') xbytespersample = 1;
		else if ((buffer[j] == '1') && (buffer[j+1] == '6')) xbytespersample = 2;
		else if (((buffer[j] == 'l') || (buffer[j] == 'L')) && ((buffer[j+1] == 'o') || (buffer[j+1] == 'O'))) xquality = 0;
		else if (((buffer[j] == 'h') || (buffer[j] == 'H')) && ((buffer[j+1] == 'i') || (buffer[j+1] == 'I'))) xquality = 1;
		else if ((buffer[j] == 't') || (buffer[j] == 'T'))
		{
			j++;
			globtempo = 0;
			while ((buffer[j] >= 48) && (buffer[j] <= 57))
			{
				globtempo *= 10;
				globtempo += buffer[j]-48;
				j++;
			}
		}
		i++;
	}

	setvmode(0x3);
	outp(0x3d4,0xa); outp(0x3d5,inp(0x3d5) | 0x0f);   //Turn cursor off
	outp(0x3d4,0xb); outp(0x3d5,inp(0x3d5) & 0xf0);

	setupmouse();

	oldkeyhandler = _dos_getvect(0x9);
	_disable(); _dos_setvect(0x9, keyhandler); _enable();

	clearbuf(FP_OFF(keystatus),256>>2,0L);
	clearbuf(FP_OFF(okeystatus),256>>2,0L);

	newsong();

	if (snd == 0)   //allocate rest of memory (must do this before initsb)
	{
		totsndmem = 16777216L;
		while ((snd = (char *)malloc(totsndmem)) == 0) totsndmem -= 4096L;
	}

	initsb(xsoundcardtype,1,xsamplerate,xnumspeakers,xbytespersample,xintspersec,xquality);
	midiinit();

	toptextscreen = 0;
	curtrack = 0;
	swaptrack = -1;
	column = 0;

	drawmainscreen(toptextscreen,curtrack,column);

	while (keystatus[1] != 2)
	{
		if (keystatus[0x2b])  // backslash
		{
			keystatus[0x2b] = 0;
			preparesndbuf();
		}

		if (keystatus[0x31])  //N (new)
		{
			keystatus[0x31] = 0;
			savescreen();
			printstr(33,11,"Ŀ",0x40);
			printstr(33,12," New song? ",0x40);
			printstr(33,13,"",0x40);
			while (1)
			{
				if (keystatus[0x15])  //Y
				{
					keystatus[0x15] = 0;

					musicoff();
					keystatus[0x31] = 0;
					newsong();
					drawmainscreen(toptextscreen,curtrack,column);
					break;
				}
				if (keystatus[0x31]|keystatus[1]) //N,ESC
				{
					keystatus[0x31] = 0;
					keystatus[1] = 0;
					restorescreen();
					break;
				}
			}
		}
		if (keystatus[0x26])  //L (load)
		{
			keystatus[0x26] = 0;
			loadmenu();
			drawmainscreen(toptextscreen,curtrack,column);
		}
		if (keystatus[0x1f])  //S (save)
		{
			musicoff();
			keystatus[0x1f] = 0;
			savescreen();
			savemenu();
			restorescreen();
		}


		if (keystatus[0x9c])  //K. Enter (record)
		{
			musicoff();
			keystatus[0x9c] = 0;

			savescreen();
			printstr(32,10,"Ŀ",0x4f);
			printstr(32,11," Recording... ",0x4f);
			printstr(32,12,"Ĵ",0x4f);
			printstr(32,13," Measure: 0   ",0x4f);
			printstr(32,14,"    Beat: 0   ",0x4f);
			printstr(32,15,"",0x4f);

			record(curtrack);

			restorescreen();
			musicoff();
		}
		if (keystatus[0x39])  //Space (play)
		{
			keystatus[0x39] = 0;
			if ((musicstatus != 1) || (notecnt >= numnotes))
			{
				notecnt = 0;
				timecount = nttime[notecnt];
				musicrepeat = 0;
				musicstatus = 1;
			}
			else
			{
				musicoff();
			}
		}

		if (keystatus[0xd3])        //Delete
		{
			musicoff();
			keystatus[0xd3] = 0;

			for(i=numnotes-1;i>=0;i--)
				if (nttrack[i] == curtrack)
				{
					numnotes--;
					for(j=i;j<numnotes;j++)
					{
						nttime[j] = nttime[j+1];
						nttrack[j] = nttrack[j+1];
						ntfreq[j] = ntfreq[j+1];
						ntvol1[j] = ntvol1[j+1];
						ntvol2[j] = ntvol2[j+1];
						ntfrqeff[j] = ntfrqeff[j+1];
						ntvoleff[j] = ntvoleff[j+1];
						ntpaneff[j] = ntpaneff[j+1];
					}
				}

			trinst[curtrack] = 0;
			trquant[curtrack] = 4;
			trvol1[curtrack] = 64;
			trvol2[curtrack] = 64;

			drawmainscreen(toptextscreen,curtrack,column);
		}

		if (keystatus[0x12])  //E (edit track)
		{
			keystatus[0x12] = 0;
			edittrack(curtrack);
			drawmainscreen(toptextscreen,curtrack,column);
		}

		if (keystatus[0x32])  //M (move/swap tracks)
		{
			musicoff();
			keystatus[0x32] = 0;

			if (swaptrack == -1)
			{
				swaptrack = curtrack;
			}
			else
			{
				if (swaptrack != curtrack)
				{
					swaptracks(swaptrack,curtrack);
					drawmainscreen(toptextscreen,curtrack,column);
				}
				swaptrack = -1;
			}
		}

		fiddlecheck((long)trinst[curtrack],trvol1[curtrack],trvol2[curtrack]);
		if (keystatus[0x21])  //F (fiddle)
		{
			musicoff();
			keystatus[0x21] = 0;

			savescreen();
			printstr(32,11,"Ŀ",0x20);
			printstr(32,12," Fiddle mode! ",0x20);
			printstr(32,13,"",0x20);

			fiddlemode = 1;
			while (keystatus[1] == 0)
				fiddlecheck((long)trinst[curtrack],trvol1[curtrack],trvol2[curtrack]);
			fiddlemode = 0;

			keystatus[1] = 0;

			restorescreen();
			musicoff();
		}

		if (keystatus[0x11])  //W (show wave mode)
		{
			keystatus[0x11] = 0;
			showwave((long)trinst[curtrack]);
			drawmainscreen(toptextscreen,curtrack,column);
		}

		if (keystatus[0x17])  //I (edit Instruments)
		{
			musicoff();
			keystatus[0x17] = 0;
			i = editinsts((long)trinst[curtrack]);
			if (i >= 0) trinst[curtrack] = i;
			drawmainscreen(toptextscreen,curtrack,column);
		}

		for(i=0x2;i<=0xb;i++)     // Numbers
		{
			if (keystatus[i])
			{
				keystatus[i] = 0;
				j = i-1;
				if (j == 10) j = 0;

				switch(column)
				{
					case 0:
						for(i=0;i<NUMCHANNELS;i++)
							if ((splc[i] < 0) && (swavenum[i] == trinst[curtrack]))
								splc[i] = 0;

						k = trinst[curtrack];
						k = (k*10)+j;
						if (k >= 256) k %= 100;
						trinst[curtrack] = k;
						break;
					case 2:
						k = trvol1[curtrack];
						k = (k*10)+j;
						if (k >= 256) k %= 100;

						for(i=0;i<numnotes;i++)
							if ((nttrack[i] == curtrack) && (ntvol1[i] > 0))
								ntvol1[i] += (k-trvol1[curtrack]);

						trvol1[curtrack] = k;
						break;
					case 3:
						k = trvol2[curtrack];
						k = (k*10)+j;
						if (k >= 256) k %= 100;

						for(i=0;i<numnotes;i++)
							if ((nttrack[i] == curtrack) && (ntvol2[i] > 0))
								ntvol2[i] += (k-trvol2[curtrack]);

						trvol2[curtrack] = k;
						break;
				}
				drawmainscreen(toptextscreen,curtrack,column);
			}
		}

		if (keystatus[0x4a])  // -
		{
			keystatus[0x4a] = 0;
			switch(column)
			{
				case 0:
					if (trinst[curtrack])
					{
						for(i=0;i<NUMCHANNELS;i++)
							if ((splc[i] < 0) && (swavenum[i] == trinst[curtrack]))
								splc[i] = 0;

						trinst[curtrack]--;
					}
					break;
				case 1:
					for(i=1;i<15;i++)
						if (trquant[curtrack] == quant[i])
						{
							trquant[curtrack] = quant[i-1];
							break;
						}
					break;
				case 2:
					if (trvol1[curtrack])
					{
						for(i=0;i<numnotes;i++)
							if ((nttrack[i] == curtrack) && (ntvol1[i] > 0))
								ntvol1[i]--;
						trvol1[curtrack]--;
					}
					break;
				case 3:
					if (trvol2[curtrack] > 0)
					{
						for(i=0;i<numnotes;i++)
							if ((nttrack[i] == curtrack) && (ntvol2[i] > 0))
								ntvol2[i]--;
						trvol2[curtrack]--;
					}
					break;
			}
			drawmainscreen(toptextscreen,curtrack,column);
		}
		if (keystatus[0x4e])  // +
		{
			keystatus[0x4e] = 0;
			switch(column)
			{
				case 0:
					if (trinst[curtrack] < MAXWAVES-1)
					{
						for(i=0;i<NUMCHANNELS;i++)
							if ((splc[i] < 0) && (swavenum[i] == trinst[curtrack]))
								splc[i] = 0;

						trinst[curtrack]++;
					}
					break;
				case 1:
					for(i=0;i<14;i++)
						if (trquant[curtrack] == quant[i])
						{
							trquant[curtrack] = quant[i+1];
							break;
						}
					break;
				case 2:
					if (trvol1[curtrack] < 255)
					{
						for(i=0;i<numnotes;i++)
							if ((nttrack[i] == curtrack) && (ntvol1[i] > 0))
								ntvol1[i]++;
						trvol1[curtrack]++;
					}
					break;
				case 3:
					if (trvol2[curtrack] < 255)
					{
						for(i=0;i<numnotes;i++)
							if ((nttrack[i] == curtrack) && (ntvol1[i] > 0))
								ntvol2[i]++;
						trvol2[curtrack]++;
					}
					break;
			}
			drawmainscreen(toptextscreen,curtrack,column);
		}

		if (keystatus[0x33])  // <,
		{
			if (trvol1[curtrack] < 255)
			{
				for(i=0;i<numnotes;i++)
					if ((nttrack[i] == curtrack) && (ntvol1[i] > 0))
						ntvol1[i]++;
				trvol1[curtrack]++;
			}
			if (trvol2[curtrack] > 0)
			{
				for(i=0;i<numnotes;i++)
					if ((nttrack[i] == curtrack) && (ntvol2[i] > 0))
						ntvol2[i]--;
				trvol2[curtrack]--;
			}
			drawmainscreen(toptextscreen,curtrack,column);
		}
		if (keystatus[0x34])  // >.
		{
			if (trvol1[curtrack] > 0)
			{
				for(i=0;i<numnotes;i++)
					if ((nttrack[i] == curtrack) && (ntvol1[i] > 0))
						ntvol1[i]--;
				trvol1[curtrack]--;
			}
			if (trvol2[curtrack] < 255)
			{
				for(i=0;i<numnotes;i++)
					if ((nttrack[i] == curtrack) && (ntvol1[i] > 0))
						ntvol2[i]++;
				trvol2[curtrack]++;
			}
			drawmainscreen(toptextscreen,curtrack,column);
		}

		if ((keystatus[0xcb]) && (column > 0))  //Left
		{
			keystatus[0xcb] = 0;
			column--;
			drawmainscreen(toptextscreen,curtrack,column);
		}
		if ((keystatus[0xcd]) && (column < 3))  //Right
		{
			keystatus[0xcd] = 0;
			column++;
			drawmainscreen(toptextscreen,curtrack,column);
		}
		if ((keystatus[0xc8]) && (curtrack > 0))  //Up
		{
			keystatus[0xc8] = 0;
			curtrack--;
			if (curtrack < toptextscreen)
				toptextscreen--;
			drawmainscreen(toptextscreen,curtrack,column);
		}
		if ((keystatus[0xd0]) && (curtrack < MAXTRACKS-1))  //Down
		{
			keystatus[0xd0] = 0;
			curtrack++;
			if (curtrack >= toptextscreen+21)
				toptextscreen++;
			drawmainscreen(toptextscreen,curtrack,column);
		}
		if ((keystatus[0xc9]) && (curtrack > 0))           //PGUP
		{
			keystatus[0xc9] = 0;
			curtrack -= 20;
			if (curtrack < 0) curtrack = 0;
			if (curtrack < toptextscreen) toptextscreen = curtrack;
			drawmainscreen(toptextscreen,curtrack,column);
		}
		if ((keystatus[0xd1]) && (curtrack < MAXTRACKS-1))  //PGDN
		{
			keystatus[0xd1] = 0;
			curtrack += 20;
			if (curtrack > MAXTRACKS-1) curtrack = MAXTRACKS-1;
			if (curtrack >= toptextscreen+21) toptextscreen = curtrack-20;
			drawmainscreen(toptextscreen,curtrack,column);
		}

		if (keystatus[1] == 1)
		{
			keystatus[1] = 0;
			savescreen();
			printstr(23,11,"Ŀ",0x40);
			printstr(23,12," Are you sure you want to quit? ",0x40);
			printstr(23,13,"",0x40);
			while (1)
			{
				if (keystatus[0x15])  //Y
				{
					keystatus[0x15] = 0;
					keystatus[1] = 2;
					break;
				}
				if (keystatus[0x31]|keystatus[1]) //N,ESC
				{
					keystatus[0x31] = 0;
					keystatus[1] = 0;
					break;
				}
			}
			restorescreen();
		}
	}
	musicoff();

	osnd = snd; snd = 0; uninitsb(); snd = osnd; //Fake uninitsb to not free
	midiuninit();
	_dos_setvect(0x9, oldkeyhandler);
	setvmode(0x3);
	outp(0x3d4,0xa); outp(0x3d5,inp(0x3d5) | 0x0f);   //Turn cursor off
	outp(0x3d4,0xb); outp(0x3d5,inp(0x3d5) & 0xf0);

	if (asksaveinsts != 0)
	{
		printf("Update KWV?\n");
		ch = 0;
		do
		{
			ch = getch();
		}
		while ((ch != 'y') && (ch != 'Y') && (ch != 'n') && (ch != 'N'));
		if ((ch == 'y') || (ch == 'Y'))
		{
			savewaves();
			printf("KWV updated\n");
		}
		else
		{
			printf("KWV NOT updated\n");
		}
	}
	free(snd);
}

drawmainscreen(long top, long curtrack, long column)
{
	char *ptr, buffer[82];
	long i, j, leng;

	printstr(0,0,"Ŀ",7);
	printstr(0,1," Track  Instrument              Quantize  Volume1  Volume2               ",7);
	printstr(0,2,"Ĵ",7);
	for(i=0;i<21;i++)
	{
		strcpy(buffer,"                                                                        ");

		buffer[6] = ((i+top)%10)+48;
		if ((i+top) >= 10) buffer[5] = (((i+top)/10)%10)+48;
		if ((i+top) >= 100) buffer[4] = (((i+top)/100)%10)+48;
		if ((i+top) >= 1000) buffer[3] = (((i+top)/1000)%10)+48;

		for(j=0;j<16;j++)
			if (instname[trinst[i+top]][j] >= 32)
				buffer[j+10] = instname[trinst[i+top]][j];

		buffer[31] = (trinst[i+top]%10)+48;
		if (trinst[i+top] >= 10) buffer[30] = ((trinst[i+top]/10)%10)+48;
		if (trinst[i+top] >= 100) buffer[29] = ((trinst[i+top]/100)%10)+48;

		buffer[38] = (trquant[i+top]%10)+48;
		if (trquant[i+top] >= 10) buffer[37] = ((trquant[i+top]/10)%10)+48;
		if (trquant[i+top] >= 100) buffer[36] = ((trquant[i+top]/100)%10)+48;

		buffer[49] = (trvol1[i+top]%10)+48;
		if (trvol1[i+top] >= 10) buffer[48] = ((trvol1[i+top]/10)%10)+48;
		if (trvol1[i+top] >= 100) buffer[47] = ((trvol1[i+top]/100)%10)+48;

		buffer[59] = (trvol2[i+top]%10)+48;
		if (trvol2[i+top] >= 10) buffer[58] = ((trvol2[i+top]/10)%10)+48;
		if (trvol2[i+top] >= 100) buffer[57] = ((trvol2[i+top]/100)%10)+48;

		printstr(0,(short)i+3,buffer,7);

		if (i+top == curtrack)
		{
			switch(column)
			{
				case 0: ptr = (char *)((i+3)*160+59+0xb8000); leng = 3; break;
				case 1: ptr = (char *)((i+3)*160+71+0xb8000); leng = 8; break;
				case 2: ptr = (char *)((i+3)*160+93+0xb8000); leng = 7; break;
				case 3: ptr = (char *)((i+3)*160+113+0xb8000); leng = 7; break;
			}

			for(j=0;j<leng;j++)
			{
				*ptr = 0x70;
				ptr += 2;
			}
		}
	}
	printstr(0,24,"",7);
}

drawinstscreen(long top, long curwave)
{
	char buffer[82];
	long i, j;

	printstr(0,0,"Ŀ",7);
	printstr(0,1," Wave #  Name                  Length    RepStart  RepLeng   Fine-Tune   ",7);
	printstr(0,2,"Ĵ",7);
	for(i=0;i<21;i++)
	{
		strcpy(buffer,"                                                                         ");

		buffer[7] = ((i+top)%10)+48;
		if ((i+top) >= 10) buffer[6] = (((i+top)/10)%10)+48;
		if ((i+top) >= 100) buffer[5] = (((i+top)/100)%10)+48;
		if ((i+top) >= 1000) buffer[4] = (((i+top)/1000)%10)+48;

		if (wavleng[i+top] > 0)
		{
			for(j=0;j<16;j++)
				if (instname[i+top][j] >= 32)
					buffer[j+11] = instname[i+top][j];

			j = wavleng[i+top];
			buffer[41] = (j%10)+48;
			if (j >= 10) buffer[40] = ((j/10)%10)+48;
			if (j >= 100) buffer[39] = ((j/100)%10)+48;
			if (j >= 1000) buffer[38] = ((j/1000)%10)+48;
			if (j >= 10000) buffer[37] = ((j/10000)%10)+48;
			if (j >= 100000) buffer[36] = ((j/100000)%10)+48;
			if (j >= 1000000) buffer[35] = ((j/1000000)%10)+48;
			if (j >= 10000000) buffer[34] = ((j/10000000)%10)+48;

			j = repstart[i+top];
			buffer[52] = (j%10)+48;
			if (j >= 10) buffer[51] = ((j/10)%10)+48;
			if (j >= 100) buffer[50] = ((j/100)%10)+48;
			if (j >= 1000) buffer[49] = ((j/1000)%10)+48;
			if (j >= 10000) buffer[48] = ((j/10000)%10)+48;
			if (j >= 100000) buffer[47] = ((j/100000)%10)+48;
			if (j >= 1000000) buffer[46] = ((j/1000000)%10)+48;
			if (j >= 10000000) buffer[45] = ((j/10000000)%10)+48;

			j = repleng[i+top];
			buffer[63] = (j%10)+48;
			if (j >= 10) buffer[62] = ((j/10)%10)+48;
			if (j >= 100) buffer[61] = ((j/100)%10)+48;
			if (j >= 1000) buffer[60] = ((j/1000)%10)+48;
			if (j >= 10000) buffer[59] = ((j/10000)%10)+48;
			if (j >= 100000) buffer[58] = ((j/100000)%10)+48;
			if (j >= 1000000) buffer[57] = ((j/1000000)%10)+48;
			if (j >= 10000000) buffer[56] = ((j/10000000)%10)+48;

			j = finetune[i+top];
			if (j < 0)
			{
				j = -j;
				if (j >= 10000) buffer[67] = '-';
				else if (j >= 1000) buffer[68] = '-';
				else if (j >= 100) buffer[69] = '-';
				else if (j >= 10) buffer[70] = '-';
				else buffer[71] = '-';
			}
			buffer[72] = (j%10)+48;
			if (j >= 10) buffer[71] = ((j/10)%10)+48;
			if (j >= 100) buffer[70] = ((j/100)%10)+48;
			if (j >= 1000) buffer[69] = ((j/1000)%10)+48;
			if (j >= 10000) buffer[68] = ((j/10000)%10)+48;
		}

		if (i+top == curwave)
			printstr(0,(short)i+3,buffer,0x70);
		else
			printstr(0,(short)i+3,buffer,7);
	}
	printstr(0,24,"",7);
}

printchr(short x, short y, char character, char attribute, short len)
{
	short pos;

	pos = (y*80+x)<<1;
	printchrasm(0xb8000+(long)pos,(long)len,((long)attribute<<8)+(long)character);
}

printstr(short x, short y, char string[81], char attribute)
{
	char character;
	short i, pos;

	pos = (y*80+x)<<1;
	i = 0;
	while (string[i] != 0)
	{
		character = string[i];
		printchrasm(0xb8000+(long)pos,1L,((long)attribute<<8)+(long)character);
		i++;
		pos+=2;
	}
}

deletewave(long curwave)
{
	long i, j, k, daleng;

	daleng = wavleng[curwave];
	if (daleng <= 0) return;

	j = 0;                         //Get space for new sound
	for(i=0;i<curwave;i++)
		j += wavleng[i];
	k = j;
	for(i=curwave;i<MAXWAVES;i++)
		k += wavleng[i];
	if (k > j)
	{
		for(i=j;i<k;i++)
			snd[i] = snd[i+daleng];
	}

	totsndbytes -= daleng;
	snd[totsndbytes] = snd[totsndbytes+1] = 128;
	wavleng[curwave] = 0;

	wavoffs[0] = FP_OFF(snd);
	for(i=1;i<MAXWAVES;i++)
		wavoffs[i] = wavoffs[i-1]+wavleng[i-1];

	for(i=0;i<16;i++)
		instname[curwave][i] = 32;

	if (curwave < MAXWAVES-1)
		asksaveinsts = 1;
}

insertwave(long curwave, char *wavename, long daleng)
{
	long i, j, k;

	if (wavleng[curwave] > 0)
		deletewave(curwave);

	if (totsndbytes+daleng > totsndmem)
	{
		strcpy(instname[curwave],"Out of memory");
		return(-1);
	}

	j = 0;                         //Get space for new sound
	for(i=0;i<curwave;i++)
		j += wavleng[i];
	k = j;
	for(i=curwave;i<MAXWAVES;i++)
		k += wavleng[i];
	if (k > j)
	{
		for(i=k-1;i>=j;i--)
			snd[i+daleng] = snd[i];
	}

	i = 0;
	while ((wavename[i] != 0) && (i < 16))
	{
		instname[curwave][i] = wavename[i];
		i++;
	}
	while (i < 16)
	{
		instname[curwave][i] = 32;
		i++;
	}

	totsndbytes += daleng;
	snd[totsndbytes] = snd[totsndbytes+1] = 128;
	wavleng[curwave] = daleng;

	wavoffs[0] = FP_OFF(snd);
	for(i=1;i<MAXWAVES;i++)
		wavoffs[i] = wavoffs[i-1]+wavleng[i-1];

	j = 0;
	for(i=0;i<curwave;i++)
		j += wavleng[i];

	if (curwave < MAXWAVES-1)
		asksaveinsts = 1;

	return(j);
}

updatewave(long curwave)
{
	long i, j, k, fil, menutop, leng, curhertz;
	char header[44];

	menunamecnt = 0;
	//getfilenames("SUBD");
	getfilenames("*.WAV");
	getfilenames("*.VOC");
	getfilenames("*.RAW");
	getfilenames("*.MOD");
	getfilenames("*.KWV");
	sortfilenames();

	if (menunamecnt == 0)
	{
		printf("No files found\n");
		return(-2);
	}

	menutop = menuhighlight-8;
	if (menutop >= menunamecnt-15) menutop = menunamecnt-15;
	if (menutop < 0) menutop = 0;

	while (keystatus[1] == 0)
	{
		drawupdatemenu(menutop,menuhighlight);

		if ((keystatus[0xc8]) && (menuhighlight > 0))
		{
			keystatus[0xc8] = 0;
			menuhighlight--;
			if (menuhighlight < menutop) menutop--;
		}
		if ((keystatus[0xd0]) && (menuhighlight < menunamecnt-1))
		{
			keystatus[0xd0] = 0;
			menuhighlight++;
			if (menuhighlight >= menutop+15) menutop++;
		}
		if (keystatus[0x1c])
		{
			keystatus[0x1c] = 0;
			//load menuname[menuhighlight] into snd[curwave] position

			i = 0;
			while ((menuname[menuhighlight][i] != 0) && (i < 16))
				i++;
			if ((menuname[menuhighlight][i-3] == 'M') && (menuname[menuhighlight][i-2] == 'O') && (menuname[menuhighlight][i-1] == 'D'))
			{
				loadmodwave(curwave,menuname[menuhighlight]);
				asksaveinsts = 1;
				return(0);
			}
			if ((menuname[menuhighlight][i-3] == 'K') && (menuname[menuhighlight][i-2] == 'W') && (menuname[menuhighlight][i-1] == 'V'))
			{
				loadkwvwave(curwave,menuname[menuhighlight]);
				asksaveinsts = 1;
				return(0);
			}

			if ((fil = open(menuname[menuhighlight],O_BINARY|O_RDWR,S_IREAD)) == -1)
				return(0);

			if (((menuname[menuhighlight][i-3] == 'W') || (menuname[menuhighlight][i-3] == 'w')) &&
				 ((menuname[menuhighlight][i-2] == 'A') || (menuname[menuhighlight][i-2] == 'a')) &&
				 ((menuname[menuhighlight][i-1] == 'V') || (menuname[menuhighlight][i-1] == 'v')))
			{
				read(fil,header,44);
				if (header[22] == 2) { close(fil); return(0); }
				if (header[34] == 16) { close(fil); return(0); }
				curhertz = ((long)header[24])+(((long)header[25])<<8)+(((long)header[26])<<16)+(((long)header[27])<<24);
				i = ((long)header[16])+(((long)header[17])<<8)+(((long)header[18])<<16)+(((long)header[19])<<24);
				if (i != 16) { lseek(fil,i+20,SEEK_SET); read(fil,&header[36],8); }
				leng = ((long)header[40])+(((long)header[41])<<8)+(((long)header[42])<<16)+(((long)header[43])<<24);
				leng = min(max(leng,0),totsndmem-totsndbytes);
				leng = min(leng,filelength(fil)-tell(fil));
				j = insertwave(curwave,menuname[menuhighlight],leng);
				read(fil,&snd[j],leng);
				close(fil);
				finetune[curwave] = (curhertz*748)/11025-748;
				return(0);
			}

			if (((menuname[menuhighlight][i-3] == 'V') || (menuname[menuhighlight][i-3] == 'v')) &&
				 ((menuname[menuhighlight][i-2] == 'O') || (menuname[menuhighlight][i-2] == 'o')) &&
				 ((menuname[menuhighlight][i-1] == 'C') || (menuname[menuhighlight][i-1] == 'c')))
			{
				read(fil,header,26);
				lseek(fil,((long)header[20])+(((long)header[21])<<8),SEEK_SET);
				leng = 0; curhertz = 0;
				while (!keystatus[1])
				{
					read(fil,header,4);
					i = ((long)header[1])+(((long)header[2])<<8)+(((long)header[3])<<16);
					switch(header[0])
					{
						case 0: close(fil); return(0);
						case 1:
							read(fil,header,2);
							if (header[1]) { close(fil); return(0); }
							curhertz = 1000000/(256-header[0]);
							i -= 2;
						case 2:
							k = min(i,(totsndmem-totsndbytes)-leng);
							j = insertwave(curwave,menuname[menuhighlight],k);
							leng += read(fil,&snd[j],k);
							finetune[curwave] = (curhertz*748)/11025-748;
							close(fil); return(0);
							break;
						case 3:
							read(fil,header,3);
							//if (curhertz)
							//{
							//   i = ((long)header[0])+(((long)header[1])<<8);
							//   i = i*(1000000/(256-header[2]))/curhertz;
							//   for(i=min(i,(totsndmem-totsndbytes)-leng);i>0;i--) buf[leng++] = 128;
							//}
							break;
						case 8:
							read(fil,header,4);
							if (header[2]|header[3]) { close(fil); return(0); }
							i = ((long)header[0])+(((long)header[1])<<8);
							curhertz = 256000000/(65536-i);
							break;
						case 9:
							read(fil,header,12);
							curhertz = ((long)header[0])+(((long)header[1])<<8)+(((long)header[2])<<16)+(((long)header[3])<<24);
							if (header[4] != 8) { close(fil); return(0); }
							if (header[5] != 1) { close(fil); return(0); }
							k = min(i-12,(totsndmem-totsndbytes)-leng);
							j = insertwave(curwave,menuname[menuhighlight],k);
							leng += read(fil,&snd[j],k);
							finetune[curwave] = (curhertz*748)/11025-748;
							if (header[6]|header[7]) { close(fil); return(0); }
							close(fil); return(0);
							break;
						default: lseek(fil,i,SEEK_CUR); break;
					}
				}
				close(fil);
				return(0);
			}

				//RAW
			leng = filelength(fil);
			j = insertwave(curwave,menuname[menuhighlight],leng);
			read(fil,&snd[j],leng);
			close(fil);
			return(0);
		}
	}
	keystatus[1] = 0;

	return(0);
}

drawupdatemenu(long menutop, long curfile)
{
	char buffer[81];
	long i, j;

	printstr(30,4,"Ŀ",4);
	for(i=0;i<15;i++)
	{
		strcpy(buffer,"                              ");

		if (i+menutop < menunamecnt)
		{
			j = 0;
			while ((menuname[i+menutop][j] != 0) && (j < 30))
			{
				buffer[j+2] = menuname[i+menutop][j];
				j++;
			}
		}

		if (i+menutop == curfile)
			printstr(30,(short)i+5,buffer,0x40);
		else
			printstr(30,(short)i+5,buffer,4);
	}
	printstr(30,20,"",4);
}

getfilenames(char kind[6])
{
	short type;
	struct find_t fileinfo;

	if (strcmp(kind,"SUBD") == 0)
	{
		strcpy(kind,"*.*");
		if (_dos_findfirst(kind,_A_SUBDIR,&fileinfo) != 0)
			return(-1);
		type = 1;
	}
	else
	{
		if (_dos_findfirst(kind,_A_NORMAL,&fileinfo) != 0)
			return(-1);
		type = 0;
	}
	do
	{
		if ((!type) || (fileinfo.attrib&16))
			if ((fileinfo.name[0] != '.') || (fileinfo.name[1] != 0))
			{
				if (menunamecnt < MAXMENUFILES)
				{
					strcpy(menuname[menunamecnt],fileinfo.name);
					menuname[menunamecnt][16] = type;
					menunamecnt++;
				}
				//else
				//   printmessage("Too many files! (max=MAXMENUFILES)");
			}
	}
	while (_dos_findnext(&fileinfo) == 0);

	return(0);
}

sortfilenames()
{
	char sortbuffer[32];
	long i, j, k, m;

	for(i=1;i<menunamecnt;i++)
		for(j=0;j<i;j++)
		{
			 k = 0;
			 while ((menuname[i][k] == menuname[j][k]) && (menuname[i][k] != 0) && (menuname[j][k] != 0))
				 k++;
			if (menuname[i][k] < menuname[j][k])
			{
				memcpy(&sortbuffer[0],&menuname[i][0],sizeof(menuname[0]));
				memcpy(&menuname[i][0],&menuname[j][0],sizeof(menuname[0]));
				memcpy(&menuname[j][0],&sortbuffer[0],sizeof(menuname[0]));
			}
		}
}

draw256screen(long sndstart, long sndend, long curwave, long viewside)
{
	long i, x1, x2, x, y, totsndleng;

	totsndleng = wavleng[curwave];
	clearbuf(0xa0000,16000L,0L);

	if (viewside == 0) i = sndstart-160; else i = sndend-160;

	x1 = sndstart-i;
	x2 = (sndend-1)-i;

	if ((x1 >= 0) && (x1 < 320))
		for(y=0;y<128;y++)
			*(char *)(0xa0000+x1+(y*320)) = 4;

	if ((x2 >= 0) && (x2 < 320))
		for(y=0;y<128;y++)
			*(char *)(0xa0000+x2+(y*320)) = 4;

	if (x1 < 0) x1 = 0;
	if (x2 >= 320) x2 = 319;
	for(x=x1;x<x2;x++)
	{
		*(char *)(0xa0000+x+0) = 4;
		*(char *)(0xa0000+x+(128*320)) = 4;
	}

	for(x=0;x<320;x++)
	{
		*(char *)(0xa0000+x+(64*320)) = 8;
		if ((i >= 0) && (i < totsndleng))
			*(char *)(0xa0000+x+((snd[i+wavoffs[curwave]-FP_OFF(snd)]>>1)*320)) = 7;
		i++;
	}
}

loadmodwave(long curwave, char *filename)
{
	char snotbuf[256];
	long i, j, k, fil, numpatterns, menutop, daleng, damodversion, modcurpos;

	if ((fil = open(filename,O_BINARY|O_RDWR,S_IREAD)) == -1)
		return;

	lseek(fil,1080L,SEEK_SET);
	read(fil,&damodversion,4);
		//0x2e4b2e4d = "M.K.", 0x34544c46 = "FLT4", 0x38544c46 = "FLT8"
	if ((damodversion == 0x2e4b2e4d) || (damodversion == 0x34544c46) || (damodversion == 0x38544c46))
		damodversion = 31;
	else
		damodversion = 15;
	lseek(fil,0L,SEEK_SET);

	read(fil,&snotbuf[0],20);                  //name

	menunamecnt = 0;
	for(i=0;i<damodversion;i++)
	{
		read(fil,&menuname[i][0],22);
		read(fil,&snotbuf[0],8);

		modleng[i] = ((((long)snotbuf[0]<<8)+(long)snotbuf[1])<<1);
		modrepstart[i] = ((((long)snotbuf[4]<<8)+(long)snotbuf[5])<<1);
		modrepleng[i] = ((((long)snotbuf[6]<<8)+(long)snotbuf[7])<<1);

		j = 22;
		while ((menuname[i][j-1] <= 32) && (j > 0))
			j--;
		while (j < 23)
			menuname[i][j++] = 32;

		if (modleng[i] >= 1000000) menuname[i][j++] = ((modleng[i]/1000000)%10)+48;
		if (modleng[i] >= 100000) menuname[i][j++] = ((modleng[i]/100000)%10)+48;
		if (modleng[i] >= 10000) menuname[i][j++] = ((modleng[i]/10000)%10)+48;
		if (modleng[i] >= 1000) menuname[i][j++] = ((modleng[i]/1000)%10)+48;
		if (modleng[i] >= 100) menuname[i][j++] = ((modleng[i]/100)%10)+48;
		if (modleng[i] >= 10) menuname[i][j++] = ((modleng[i]/10)%10)+48;
		menuname[i][j++] = (modleng[i]%10)+48;
		menuname[i][j] = 0;

		if (modleng[i] > 1)
			menunamecnt = i+1;
	}

	read(fil,&snotbuf[0],2);                  //leng/amiga byte
	read(fil,&snotbuf[0],128);                //arrangement
	numpatterns = 0;
	for(i=0;i<128;i++)
		if (snotbuf[i] > numpatterns)
			numpatterns = snotbuf[i];

	if (damodversion == 31)
		read(fil,&snotbuf[0],4);                  //id

	lseek(fil,(numpatterns+1)<<10,SEEK_CUR);  //Skip 1024-byte patterns

	if (curmodinst >= menunamecnt) curmodinst = menunamecnt-1;
	menutop = curmodinst-8;
	if (menutop >= menunamecnt-15) menutop = menunamecnt-15;
	if (menutop < 0) menutop = 0;

	while (keystatus[1] == 0)
	{
		drawupdatemenu(menutop,curmodinst);

		if ((keystatus[0xc8]) && (curmodinst > 0))
		{
			musicoff();
			keystatus[0xc8] = 0;
			curmodinst--;
			if (curmodinst < menutop) menutop--;
		}
		if ((keystatus[0xd0]) && (curmodinst < menunamecnt-1))
		{
			musicoff();
			keystatus[0xd0] = 0;
			curmodinst++;
			if (curmodinst >= menutop+15) menutop++;
		}
		if (keystatus[0x39])
		{
			musicoff();
			keystatus[0x39] = 0;

			modcurpos = tell(fil);

			j = 0;
			for(i=0;i<curmodinst;i++)
				j += modleng[i];

			lseek(fil,j,SEEK_CUR);   //Skip previous sounds

			daleng = modleng[curmodinst];

			if (daleng > 2)
			{
				k = insertwave(MAXWAVES-1,menuname[curmodinst],daleng);

				for(i=0;i<daleng;i+=256)
				{
					if (i+256 < daleng)
					{
						read(fil,snotbuf,256);
						for(j=0;j<256;j++)
							snd[k+i+j] = ((snotbuf[j]+128)&255);
					}
					else
					{
						read(fil,snotbuf,daleng-i);
						for(j=0;j<daleng-i;j++)
							snd[k+i+j] = ((snotbuf[j]+128)&255);
					}
				}

				repstart[MAXWAVES-1] = modrepstart[curmodinst];
				repleng[MAXWAVES-1] = modrepleng[curmodinst];
				if (repleng[MAXWAVES-1] < 4) repleng[MAXWAVES-1] = 0;
				finetune[MAXWAVES-1] = 0;

				startwave((long)MAXWAVES-1,2048L,128L,128L,0L,0L,0L);
			}

			lseek(fil,modcurpos,SEEK_SET);
		}

		if (keystatus[0x1c])
		{
			musicoff();
			keystatus[0x1c] = 0;

			j = 0;
			for(i=0;i<curmodinst;i++)
				j += modleng[i];

			lseek(fil,j,SEEK_CUR);   //Skip previous sounds

			daleng = modleng[curmodinst];

			if (daleng > 2)
			{
				k = insertwave(curwave,menuname[curmodinst],daleng);

				for(i=0;i<daleng;i+=256)
				{
					if (i+256 < daleng)
					{
						read(fil,&snotbuf[0],256);
						for(j=0;j<256;j++)
							snd[k+i+j] = ((snotbuf[j]+128)&255);
					}
					else
					{
						read(fil,&snotbuf[0],daleng-i);
						for(j=0;j<daleng-i;j++)
							snd[k+i+j] = ((snotbuf[j]+128)&255);
					}
				}

				repstart[curwave] = modrepstart[curmodinst];
				repleng[curwave] = modrepleng[curmodinst];
				if (repleng[curwave] < 4) repleng[curwave] = 0;
				finetune[curwave] = 0;
			}
			close(fil);

			if (wavleng[MAXWAVES-1] > 0)
				deletewave(MAXWAVES-1);

			for(i=0;i<32;i++)
				for(j=0;j<32;j++)
					menuname[i][j] = 0;

			return;
		}
	}
	keystatus[1] = 0;
	close(fil);

	musicoff();

	if (wavleng[MAXWAVES-1] > 0)
	  deletewave(MAXWAVES-1);

	for(i=0;i<32;i++)
		for(j=0;j<32;j++)
			menuname[i][j] = 0;
}

loadkwvwave(long curwave, char *filename)
{
	char snotbuf[256];
	long i, j, k, fil, menutop, daleng, danumwaves, modcurpos, dawaversionum;

	if ((fil = open(filename,O_BINARY|O_RDWR,S_IREAD)) == -1)
		return;

	read(fil,&dawaversionum,4); if (dawaversionum != 0) return;
	read(fil,&danumwaves,4);

	menunamecnt = 0;
	for(i=0;i<danumwaves;i++)
	{
		read(fil,&menuname[menunamecnt][0],16);
		read(fil,&modleng[menunamecnt],4);
		read(fil,&modrepstart[menunamecnt],4);
		read(fil,&modrepleng[menunamecnt],4);
		read(fil,&modfinetune[menunamecnt],4);

		j = 16;
		while ((menuname[menunamecnt][j-1] <= 32) && (j > 0))
			j--;
		while (j < 17)
			menuname[menunamecnt][j++] = 32;

		daleng = modleng[menunamecnt];
		if (daleng >= 1000000) menuname[menunamecnt][j++] = ((daleng/1000000)%10)+48;
		if (daleng >= 100000) menuname[menunamecnt][j++] = ((daleng/100000)%10)+48;
		if (daleng >= 10000) menuname[menunamecnt][j++] = ((daleng/10000)%10)+48;
		if (daleng >= 1000) menuname[menunamecnt][j++] = ((daleng/1000)%10)+48;
		if (daleng >= 100) menuname[menunamecnt][j++] = ((daleng/100)%10)+48;
		if (daleng >= 10) menuname[menunamecnt][j++] = ((daleng/10)%10)+48;
		menuname[menunamecnt][j++] = (daleng%10)+48;
		menuname[menunamecnt][j] = 0;

		if (modleng[menunamecnt] > 0)
			menunamecnt++;
	}

	if (curmodinst >= menunamecnt) curmodinst = menunamecnt-1;
	menutop = curmodinst-8;
	if (menutop >= menunamecnt-15) menutop = menunamecnt-15;
	if (menutop < 0) menutop = 0;

	while (keystatus[1] == 0)
	{
		drawupdatemenu(menutop,curmodinst);

		if ((keystatus[0xc8]) && (curmodinst > 0))
		{
			musicoff();
			keystatus[0xc8] = 0;
			curmodinst--;
			if (curmodinst < menutop) menutop--;
		}
		if ((keystatus[0xd0]) && (curmodinst < menunamecnt-1))
		{
			musicoff();
			keystatus[0xd0] = 0;
			curmodinst++;
			if (curmodinst >= menutop+15) menutop++;
		}
		if (keystatus[0x39])
		{
			musicoff();
			keystatus[0x39] = 0;

			modcurpos = tell(fil);

			j = 0;
			for(i=0;i<curmodinst;i++)
				j += modleng[i];

			lseek(fil,j,SEEK_CUR);   //Skip previous sounds

			daleng = modleng[curmodinst];

			if (daleng > 0)
			{
				k = insertwave(MAXWAVES-1,menuname[curmodinst],daleng);

				read(fil,&snd[k],daleng);

				repstart[MAXWAVES-1] = modrepstart[curmodinst];
				repleng[MAXWAVES-1] = modrepleng[curmodinst];
				if (repleng[MAXWAVES-1] < 4) repleng[MAXWAVES-1] = 0;
				finetune[MAXWAVES-1] = modfinetune[curmodinst];

				startwave((long)MAXWAVES-1,mulscale24(frqtable[30],finetune[MAXWAVES-1]+748),128L,128L,0L,0L,0L);
			}

			lseek(fil,modcurpos,SEEK_SET);
		}

		if (keystatus[0x1c])
		{
			musicoff();
			keystatus[0x1c] = 0;

			j = 0;
			for(i=0;i<curmodinst;i++)
				j += modleng[i];

			lseek(fil,j,SEEK_CUR);   //Skip previous sounds

			daleng = modleng[curmodinst];

			if (daleng > 0)
			{
				k = insertwave(curwave,menuname[curmodinst],daleng);

				read(fil,&snd[k],daleng);

				repstart[curwave] = modrepstart[curmodinst];
				repleng[curwave] = modrepleng[curmodinst];
				if (repleng[curwave] < 4) repleng[curwave] = 0;
				finetune[curwave] = modfinetune[curmodinst];
			}
			close(fil);

			if (wavleng[MAXWAVES-1] > 0)
				deletewave(MAXWAVES-1);

			for(i=0;i<32;i++)
				for(j=0;j<32;j++)
					menuname[i][j] = 0;

			return;
		}
	}
	keystatus[1] = 0;
	close(fil);

	musicoff();

	if (wavleng[MAXWAVES-1] > 0)
	  deletewave(MAXWAVES-1);

	for(i=0;i<32;i++)
		for(j=0;j<32;j++)
			menuname[i][j] = 0;
}

void __interrupt __far keyhandler()
{
	oldreadch = readch;
	readkey();
	if ((readch|1) == 0xe1)
		extended = 128;
	else
	{
		if (oldreadch != readch)
		{
			if ((readch&128) == 0)
			{
				if (keystatus[(readch&127)+extended] == 0)
					keystatus[(readch&127)+extended] = 1;
			}
			else
				keystatus[(readch&127)+extended] = 0;
		}
		extended = 0;
	}
	interruptend();
}

savewaves()
{
	long i, fil, dawaversionum;

	if ((fil = open(kwvname,O_BINARY|O_CREAT|O_TRUNC|O_WRONLY,S_IWRITE)) == -1)
	{
		printf("Could not save kwv\n");
		uninitsb();
		midiuninit();
		uninitgroupfile();
		exit(0);
	}
	dawaversionum = 0;
	write(fil,&dawaversionum,4);

	numwaves = MAXWAVES;
	while ((wavleng[numwaves-1] == 0) && (numwaves > 0)) numwaves--;

	write(fil,&numwaves,4);

	totsndbytes = 0;
	for(i=0;i<numwaves;i++)
	{
		write(fil,&instname[i][0],16);
		write(fil,&wavleng[i],4);
		write(fil,&repstart[i],4);
		write(fil,&repleng[i],4);
		write(fil,&finetune[i],4);
		totsndbytes += wavleng[i];
	}

	write(fil,&snd[0],totsndbytes);

	close(fil);
}

fiddlecheck(long fiddlewave, char vol1, char vol2)
{
	long freq, dafreq, vol, i;

	while (getnote(&freq,&vol) == 1)
	{
		dafreq = mulscale24(frqtable[freq],finetune[fiddlewave]+748);

		if (vol == 0)
		{
			for(i=0;i<NUMCHANNELS;i++)
				if (splc[i] < 0)
					if (swavenum[i] == fiddlewave)
						if (sinc[i] == dafreq)
							splc[i] = 0;
		}
		else
		{
			startwave(fiddlewave,dafreq,min(((long)vol*(long)vol1)>>5,255),min(((long)vol*(long)vol2)>>5,255),0L,0L,0L);
		}
	}
}

static long sustainmode = 0;
static char midinotestat[128], omidinotestat[128];
getnote(long *freq, long *vol)
{
	long i, dat, daoct;
	char k;

		//Hack for right pedal
	for(i=0;i<128;i++)
		if (((midinotestat[i]) && (!omidinotestat[i]) && (sustainmode)) ||
			 ((!midinotestat[i]) && (omidinotestat[i]) && (!sustainmode)))
		{
			omidinotestat[i] = midinotestat[i];
			*freq = ((i-35)&255);
			*vol = midinotestat[i];
			return(1);
		}

	if ((dat = midiin()) >= 0)
	{
		if (dat&128) { lastat = dat; }
		else
		{
			if (lastat == 0x90)
			{
				if ((dat >= 21) && (dat <= 108))
				{
					do { *vol = midiin(); } while ((*vol < 0) && (keystatus[1] == 0));
					*freq = ((dat-35)&255);
					if (sustainmode == 0)
					{
						if (*vol > 0)
						{
							*vol = midivoltable[*vol];
							omidinotestat[dat] = midinotestat[dat] = *vol;
							return(1);
						}
						else
						{
							omidinotestat[dat] = midinotestat[dat] = 0;
							return(1);
						}
					}
					else
					{
						if (*vol > 0)
						{
							if (omidinotestat[dat])
							{
								omidinotestat[dat] = 0;
								midinotestat[dat] = midivoltable[*vol];
								*vol = 0;
								return(1);
							}
							else
							{
								*vol = midivoltable[*vol];
								omidinotestat[dat] = midinotestat[dat] = *vol;
								return(1);
							}
						}
						else
						{
							midinotestat[dat] = 0;
						}
					}
				}
			}
			else if (lastat == 0xb0)
			{
				if (dat == 0x40) //Right pedal
				{
					do { dat = midiin(); } while ((dat < 0) && (keystatus[1] == 0));
					if (dat == 127) sustainmode = 1;
					if (dat == 0) sustainmode = 0;
				}
			}
			else if (lastat == 0xc0)
			{
				//Instrument was changed to dat
			}
		}
	}

	if ((keystatus[0x4a]) && (octave > -24))
	{
		keystatus[0x4a] = 0;
		octave -= 12;
	}
	if ((keystatus[0x4e]) && (octave < 24))
	{
		keystatus[0x4e] = 0;
		octave += 12;
	}

	if (fiddlemode == 1)
	{
		daoct = octave;
		if (keystatus[0x1d]) daoct -= 12;
		if (keystatus[0x9d]) daoct += 12;
		if (daoct < -24) daoct = -24;
		if (daoct > 24) daoct = 24;

		for(i=0;i<NUMSCANTONOTES;i++)
		{
			k = keystatus[scantonote[i][0]];
			if (k > okeystatus[scantonote[i][0]])
			{
				okeystatus[scantonote[i][0]] = k;
				*freq = 25+daoct+scantonote[i][1];
				*vol = 64;
				return(1);
			}
			else if (k < okeystatus[scantonote[i][0]])
			{
				okeystatus[scantonote[i][0]] = k;
				*freq = 25+daoct+scantonote[i][1];
				*vol = 0;
				return(1);
			}
		}
	}

	return(0);
}

swapwaves(long swapwave1, long swapwave2)
{
	char tempchar, *charptr1, *charptr2, *bakcharptr1, *bakcharptr2;
	long i, j, templong, numbytes1, numbytes2, numbytes3;

	outp(67,182); outp(66,16); outp(66,16);

	if (swapwave1 == swapwave2)
		return(0);

	if (swapwave1 > swapwave2)
		templong = swapwave1, swapwave1 = swapwave2, swapwave2 = templong;

	// charptr1  numbytes1    numbytes3     charptr2  numbytes2
	//         /                                  /
	//  Ŀ
	//     TILE1     -----walls between-----  TILE2 
	//  

		//Swap memory
	numbytes1 = wavleng[swapwave1];
	numbytes2 = wavleng[swapwave2];

	charptr1 = (char *)FP_OFF(snd);
	for(i=0;i<swapwave1;i++)
		charptr1 += wavleng[i];

	numbytes3 = 0;
	for(i=swapwave1;i<swapwave2;i++)
		numbytes3 += wavleng[i];

	charptr2 = charptr1 + numbytes3;

	numbytes3 -= numbytes1;     //num bytes in between

	if (numbytes1 >= numbytes2)
	{
		outp(97,inp(97)|3);
		bakcharptr1 = charptr1;
		for(i=0;i<numbytes1;i++)
			tempbuf[i] = *bakcharptr1++;

		outp(97,inp(97)&252);
		bakcharptr1 = charptr1;
		bakcharptr2 = charptr2;
		for(i=0;i<numbytes2;i++)
			*bakcharptr1++ = *bakcharptr2++;

		outp(97,inp(97)|3);
		bakcharptr2 = charptr1+numbytes1;
		for(i=0;i<numbytes3;i++)
			*bakcharptr1++ = *bakcharptr2++;

		outp(97,inp(97)&252);
		for(i=0;i<numbytes1;i++)
			*bakcharptr1++ = tempbuf[i];
	}
	else
	{

		outp(97,inp(97)|3);
		bakcharptr1 = charptr2;
		for(i=0;i<numbytes2;i++)
			tempbuf[i] = *bakcharptr1++;

		outp(97,inp(97)&252);
		bakcharptr1 = charptr2+numbytes2-1;
		bakcharptr2 = charptr1+numbytes1-1;
		for(i=0;i<numbytes1;i++)
			*bakcharptr1-- = *bakcharptr2--;

		outp(97,inp(97)|3);
		bakcharptr2 = charptr2-1;
		for(i=0;i<numbytes3;i++)
			*bakcharptr1-- = *bakcharptr2--;

		outp(97,inp(97)&252);
		bakcharptr1 = charptr1;
		for(i=0;i<numbytes2;i++)
			*bakcharptr1++ = tempbuf[i];
	}

		//Swap attributes
	templong = wavleng[swapwave1]; wavleng[swapwave1] = wavleng[swapwave2]; wavleng[swapwave2] = templong;
	templong = repstart[swapwave1]; repstart[swapwave1] = repstart[swapwave2]; repstart[swapwave2] = templong;
	templong = repleng[swapwave1]; repleng[swapwave1] = repleng[swapwave2]; repleng[swapwave2] = templong;
	templong = finetune[swapwave1]; finetune[swapwave1] = finetune[swapwave2]; finetune[swapwave2] = templong;

	for(i=0;i<16;i++)
	{
		tempchar = instname[swapwave1][i];
		instname[swapwave1][i] = instname[swapwave2][i];
		instname[swapwave2][i] = tempchar;
	}

	for(i=swapwave1+1;i<=swapwave2;i++)
		wavoffs[i] = wavoffs[i-1]+wavleng[i-1];

	return(1);
}

swaptracks(long swaptrack1, long swaptrack2)
{
	long i, j, templong;

	outp(67,182); outp(66,16); outp(66,16);

	if (swaptrack1 == swaptrack2)
		return(0);

	if (swaptrack1 > swaptrack2)
		templong = swaptrack1, swaptrack1 = swaptrack2, swaptrack2 = templong;

		//Swap attributes
	templong = trinst[swaptrack1]; trinst[swaptrack1] = trinst[swaptrack2]; trinst[swaptrack2] = templong;
	templong = trquant[swaptrack1]; trquant[swaptrack1] = trquant[swaptrack2]; trquant[swaptrack2] = templong;
	templong = trvol1[swaptrack1]; trvol1[swaptrack1] = trvol1[swaptrack2]; trvol1[swaptrack2] = templong;
	templong = trvol2[swaptrack1]; trvol2[swaptrack1] = trvol2[swaptrack2]; trvol2[swaptrack2] = templong;

	for(i=0;i<numnotes;i++)
	{
		if (nttrack[i] == swaptrack1)
			nttrack[i] = swaptrack2;
		else if (nttrack[i] == swaptrack2)
			nttrack[i] = swaptrack1;
	}

	return(1);
}

editinsts(long curwave)
{
	char buffer[81];
	long i, j, k, daleng, toptextscreen, sndstart, sndend, fil;
	long viewside, x, y, totsndoffs, totsndleng, average, swapwave;
	long orepstart, orepleng, notestat;
	long danumspeaks, dabytespersamp, dasamplerat;

	toptextscreen = 0;
	if (curwave < toptextscreen) toptextscreen = curwave;
	if (curwave >= toptextscreen+21) toptextscreen = curwave-20;

	swapwave = -1;

	while (keystatus[1] == 0)
	{
		drawinstscreen(toptextscreen,curwave);

		if (keystatus[0x1c])
		{
			keystatus[0x1c] = 0;
			musicoff();
			return(curwave);
		}
		if ((keystatus[0x39]) && (wavleng[curwave] > 0))
		{
			keystatus[0x39] = 0;
			startwave(curwave,mulscale24(frqtable[30],finetune[curwave]+748),128L,128L,0L,0L,0L);
		}

		if (keystatus[0xc])  //-
		{
			keystatus[0xc] = 0;
			if (keystatus[0x2a])
				finetune[curwave] -= 100;
			else if (keystatus[0x36])
				finetune[curwave] -= 10;
			else
				finetune[curwave]--;

			asksaveinsts = 1;
			drawinstscreen(toptextscreen,curwave);
		}
		if (keystatus[0xd])  //=
		{
			keystatus[0xd] = 0;
			if (keystatus[0x2a])
				finetune[curwave] += 100;
			else if (keystatus[0x36])
				finetune[curwave] += 10;
			else
				finetune[curwave]++;

			asksaveinsts = 1;
			drawinstscreen(toptextscreen,curwave);
		}

		if (keystatus[0x16])  //U (Update wave)
		{
			musicoff();
			keystatus[0x16] = 0;
			savescreen();
			updatewave(curwave);
			restorescreen();
		}

		if (keystatus[0x31])  //N (Name wave)
		{
			musicoff();
			keystatus[0x31] = 0;

			j = 16;
			while ((instname[curwave][j-1] <= 32) && (j > 0))
				j--;

			while ((keystatus[1] == 0) && (keystatus[0x1c] == 0))
			{
				for(i=0;i<j;i++)
					buffer[i] = instname[curwave][i];
				buffer[j] = '_';
				buffer[j+1] = ' ';
				buffer[j+2] = 0;
				printstr(11,(short)(curwave-toptextscreen+3),buffer,0x70);

				if (j < 16)
				{
					if ((keystatus[0x2a]|keystatus[0x36]) == 0)
					{
						for(i=0;i<128;i++)
							if ((keystatus[i]) && (scantoasc[i] > 0))
							{
								keystatus[i] = 0;
								instname[curwave][j++] = scantoasc[i];
							}
					}
					else
					{
						for(i=0;i<128;i++)
							if ((keystatus[i]) && (scantoascwithshift[i] > 0))
							{
								keystatus[i] = 0;
								instname[curwave][j++] = scantoascwithshift[i];
							}
					}
				}

				if (keystatus[0xe])
				{
					keystatus[0xe] = 0;
					if (j > 0) instname[curwave][--j] = 32;
				}
			}
			asksaveinsts = 1;
			drawinstscreen(toptextscreen,curwave);

			keystatus[1] = 0;
			keystatus[0x1c] = 0;
		}

		if ((keystatus[0x13]) && (wavleng[curwave] > 0))  //R (set repeats)
		{
			musicoff();
			keystatus[0x13] = 0;

			setvmode(0x13);

			notestat = 0;
			orepstart = repstart[curwave];
			orepleng = repleng[curwave];

			totsndoffs = 0;
			for(i=0;i<curwave;i++)
				totsndoffs += wavleng[i];
			totsndleng = wavleng[curwave];

			sndstart = repstart[curwave];
			sndend = sndstart+repleng[curwave];
			if (sndend > totsndleng) sndend = totsndleng;
			viewside = 0;

			draw256screen(sndstart,sndend,curwave,viewside);

			while (keystatus[1] == 0)
			{
				if (moustat == 1)
				{
					readmouse();
					if (bstatus&6)
					{
						if (keystatus[0xcb]) mousx -= 32;
						if (keystatus[0xcd]) mousx += 32;
						sndend += mousx;
						if (sndend <= sndstart) sndend = sndstart+1;
						if (sndend > totsndleng) sndend = totsndleng;
						viewside = 1;
					}
					if (bstatus&1)
					{
						if (keystatus[0xcb]) mousx -= 32;
						if (keystatus[0xcd]) mousx += 32;
						sndstart += mousx;
						if (sndstart < 0) sndstart = 0;
						if (sndstart > sndend) sndstart = sndend;
						viewside = 0;
					}

					if ((mousx != 0) || (bstatus != obstatus))
						draw256screen(sndstart,sndend,curwave,viewside);
				}
				if (keystatus[0x2e])  //C: Clean wave for smoother repeat
				{
					keystatus[0x2e] = 0;

					repstart[curwave] = sndstart;
					repleng[curwave] = sndend-sndstart;
					if (repleng[curwave] < 4) repleng[curwave] = 0;

					if ((repstart[curwave] >= (samplerate>>11)) && (repleng[curwave] >= (samplerate>>11)))
					{
						outp(97,inp(97)|3);
						j = sndstart-(samplerate>>11)+totsndoffs;
						k = sndend-(samplerate>>11)+totsndoffs;
						for(i=(samplerate>>11)-1;i>=0;i--)
							snd[k+i] += mulscale16(snd[j+i]-snd[k+i],ramplookup[(samplerate>>11)-1-i]);
						outp(97,inp(97)&252);
					}

					draw256screen(sndstart,sndend,curwave,viewside);
				}
				if (keystatus[0x39])
				{
					keystatus[0x39] = 0;
					if (notestat == 0)
					{
						repstart[curwave] = sndstart;
						repleng[curwave] = sndend-sndstart;
						if (repleng[curwave] < 4) repleng[curwave] = 0;
						startwave(curwave,2048L,128L,128L,0L,0L,0L);
						notestat = 1;
					}
					else
					{
						musicoff();
						notestat = 0;
					}
				}
				if (keystatus[0x1c])
				{
					keystatus[0x1c] = 0;

					repstart[curwave] = sndstart;
					repleng[curwave] = sndend-sndstart;
					if (repleng[curwave] < 4) repleng[curwave] = 0;
					orepstart = sndstart;
					orepleng = sndend-sndstart;

					asksaveinsts = 1;
					break;
				}
			}
			keystatus[1] = 0;

			if (notestat > 0) { musicoff(); notestat = 0; }

			repstart[curwave] = orepstart;
			repleng[curwave] = orepleng;
			if (repleng[curwave] < 4) repleng[curwave] = 0;

			setvmode(0x3);
			outp(0x3d4,0xa); outp(0x3d5,inp(0x3d5) | 0x0f);   //Turn cursor off
			outp(0x3d4,0xb); outp(0x3d5,inp(0x3d5) & 0xf0);

			drawinstscreen(toptextscreen,curwave);
		}

		if ((keystatus[0x2f]) && (wavleng[curwave] > 0))  //V (view wave)
		{
			musicoff();
			keystatus[0x2f] = 0;

			setvmode(0x13);

			totsndoffs = 0;
			for(i=0;i<curwave;i++)
				totsndoffs += wavleng[i];
			totsndleng = wavleng[curwave];

			notestat = 0;

			sndstart = 0;
			sndend = totsndleng;
			viewside = 0;

			draw256screen(sndstart,sndend,curwave,viewside);

			while (keystatus[1] == 0)
			{
				if (moustat == 1)
				{
					readmouse();
					if (bstatus&6)
					{
						if (keystatus[0xcb]) mousx -= 32;
						if (keystatus[0xcd]) mousx += 32;
						sndend += mousx;
						if (sndend <= sndstart) sndend = sndstart+1;
						if (sndend > totsndleng) sndend = totsndleng;
						viewside = 1;
					}
					if (bstatus&1)
					{
						if (keystatus[0xcb]) mousx -= 32;
						if (keystatus[0xcd]) mousx += 32;
						sndstart += mousx;
						if (sndstart < 0) sndstart = 0;
						if (sndstart > sndend) sndstart = sndend;
						viewside = 0;
					}

					if ((mousx != 0) || (bstatus != obstatus))
						draw256screen(sndstart,sndend,curwave,viewside);
				}


				if (keystatus[0x2e])      //C
				{
					keystatus[0x2e] = 0;

					outp(97,inp(97)|3);
					average = 0;
					for(i=sndstart;i<sndend;i++)
						average += snd[i+totsndoffs];

					average /= sndend-sndstart;

					for(i=sndstart;i<sndend;i++)
					{
						j = ((long)snd[i+totsndoffs]) + (128-average);
						if (j < 0) j = 0;
						if (j > 255) j = 255;
						snd[i+totsndoffs] = (char)j;
					}

					outp(97,inp(97)&252);

					draw256screen(sndstart,sndend,curwave,viewside);
				}
				if (keystatus[0x39])
				{
					keystatus[0x39] = 0;
					if ((notestat == 0) || (repleng[curwave] == 0))
					{
						wavoffs[curwave] += sndstart;
						wavleng[curwave] = sndend-sndstart;
						startwave(curwave,2048L,128L,128L,0L,0L,0L);
						wavoffs[curwave] -= sndstart;
						wavleng[curwave] = totsndleng;
						notestat = 1;
					}
					else
					{
						musicoff();
						notestat = 0;
					}
				}
				if (keystatus[0x1c])
				{
					keystatus[0x1c] = 0;

					if (sndstart > 0)
					{
						for(i=0;i<sndend-sndstart;i++)
							snd[i+totsndoffs] = snd[i+totsndoffs+sndstart];
					}

					daleng = totsndleng-(sndend-sndstart);
					if (daleng > 0)
					{
						for(i=totsndoffs+wavleng[curwave];i<totsndbytes;i++)
							snd[i-daleng] = snd[i];
					}

					totsndbytes -= daleng;
					snd[totsndbytes] = snd[totsndbytes+1] = 128;
					wavleng[curwave] = (sndend-sndstart);

					repstart[curwave] = min(repstart[curwave],wavleng[curwave]);
					repleng[curwave] = min(repleng[curwave],wavleng[curwave]-repstart[curwave]);

					wavoffs[0] = FP_OFF(snd);
					for(i=1;i<MAXWAVES;i++)
						wavoffs[i] = wavoffs[i-1]+wavleng[i-1];

					asksaveinsts = 1;
					break;
				}
			}
			keystatus[1] = 0;

			if (notestat > 0) { musicoff(); notestat = 0; }

			setvmode(0x3);
			outp(0x3d4,0xa); outp(0x3d5,inp(0x3d5) | 0x0f);   //Turn cursor off
			outp(0x3d4,0xb); outp(0x3d5,inp(0x3d5) & 0xf0);

			drawinstscreen(toptextscreen,curwave);
		}
		if (keystatus[0x32])  //M (move/swap waves)
		{
			musicoff();
			keystatus[0x32] = 0;

			if (swapwave == -1)
			{
				swapwave = curwave;
			}
			else
			{
				if (swapwave != curwave)
				{
					swapwaves(swapwave,curwave);
					asksaveinsts = 1;
				}
				swapwave = -1;
			}
		}

		fiddlecheck(curwave,64,64);
		if (keystatus[0x21])  //F (fiddle)
		{
			musicoff();
			keystatus[0x21] = 0;

			savescreen();
			printstr(32,11,"Ŀ",0x20);
			printstr(32,12," Fiddle mode! ",0x20);
			printstr(32,13,"",0x20);

			fiddlemode = 1;
			while (keystatus[1] == 0)
				fiddlecheck(curwave,64,64);
			fiddlemode = 0;

			keystatus[1] = 0;

			restorescreen();
			musicoff();
		}

		if (keystatus[0x11])  //W (show wave mode)
		{
			keystatus[0x11] = 0;
			showwave(curwave);
			drawinstscreen(toptextscreen,curwave);
		}

		if ((keystatus[0xc8]) && (curwave > 0))  //Up
		{
			musicoff();
			keystatus[0xc8] = 0;
			curwave--;
			if (curwave < toptextscreen) toptextscreen = curwave;
		}
		if ((keystatus[0xd0]) && (curwave < MAXWAVES-2))  //Down
		{
			musicoff();
			keystatus[0xd0] = 0;
			curwave++;
			if (curwave >= toptextscreen+21) toptextscreen = curwave-20;
		}
		if ((keystatus[0xc9]) && (curwave > 0))           //PGUP
		{
			musicoff();
			keystatus[0xc9] = 0;
			curwave -= 20;
			if (curwave < 0) curwave = 0;
			if (curwave < toptextscreen) toptextscreen = curwave;
		}
		if ((keystatus[0xd1]) && (curwave < MAXWAVES-2))  //PGDN
		{
			musicoff();
			keystatus[0xd1] = 0;
			curwave += 20;
			if (curwave > MAXWAVES-2) curwave = MAXWAVES-2;
			if (curwave >= toptextscreen+21) toptextscreen = curwave-20;
		}
		if (keystatus[0xd3])        //Delete
		{
			keystatus[0xd3] = 0;
			if (wavleng[curwave] > 0) deletewave(curwave);
		}
		if (keystatus[0x58])        //F12 (capture current inst to .WAV file)
		{
			keystatus[0x58] = 0;

			for(j=8;(j > 0) && (instname[curwave][j-1] <= 32);j--);
			for(i=0;i<j;i++)
			{
				buffer[i] = instname[curwave][i];
				if (buffer[i] == '.') { j = i; break; }
			}
			buffer[j++] = '.'; buffer[j++] = 'w'; buffer[j++] = 'a';
			buffer[j++] = 'v'; buffer[j++] = 0;

			if ((fil = open(buffer,O_BINARY|O_CREAT|O_TRUNC|O_WRONLY,S_IWRITE)) >= 0)
			{
				danumspeaks = dabytespersamp = 1;
				dasamplerat = ((finetune[curwave]+748)*11025)/748;

				buffer[0] = 'R'; buffer[1] = 'I'; buffer[2] = 'F'; buffer[3] = 'F';
				i = wavleng[curwave]+36;
				buffer[4] = (i&255); buffer[5] = ((i>>8)&255); buffer[6] = ((i>>16)&255); buffer[7] = ((i>>24)&255);
				buffer[8] = 'W'; buffer[9] = 'A'; buffer[10] = 'V'; buffer[11] = 'E';
				buffer[12] = 'f'; buffer[13] = 'm'; buffer[14] = 't'; buffer[15] = ' ';
				buffer[16] = 16; buffer[17] = 0; buffer[18] = 0; buffer[19] = 0;
				buffer[20] = 1; buffer[21] = 0;
				buffer[22] = danumspeaks; buffer[23] = 0;
				i = dasamplerat;
				buffer[24] = (i&255); buffer[25] = ((i>>8)&255); buffer[26] = ((i>>16)&255); buffer[27] = ((i>>24)&255);
				i = (dasamplerat<<(danumspeaks+dabytespersamp-2));
				buffer[28] = (i&255); buffer[29] = ((i>>8)&255); buffer[30] = ((i>>16)&255); buffer[31] = ((i>>24)&255);
				buffer[32] = danumspeaks*dabytespersamp; buffer[33] = 0;
				buffer[34] = (dabytespersamp<<3); buffer[35] = 0;
				buffer[36] = 'd'; buffer[37] = 'a'; buffer[38] = 't'; buffer[39] = 'a';
				i = wavleng[curwave];
				buffer[40] = (i&255); buffer[41] = ((i>>8)&255); buffer[42] = ((i>>16)&255); buffer[43] = ((i>>24)&255);
				write(fil,buffer,44);
				write(fil,(void *)wavoffs[curwave],wavleng[curwave]);
				close(fil);
			}
		}
	}
	musicoff();
	keystatus[0x1] = 0;
	return(-1);
}

record(long curtrack)
{
	char tempchar, buffer[81];
	long danumnotes, freq, dafreq, vol, i, j, templong, quanter, otimecount;

	danumnotes = numnotes;

	quanter = 120/trquant[curtrack];

	lastat = 0x90;
	otimecount = 0;
	timecount = 0;
	notecnt = 0;
	musicrepeat = 0;
	musicstatus = 1;
	fiddlemode = 1;

	while (keystatus[0x9c] == 0)
	{
		if ((timecount%60) == 0)
			outp(97,inp(97)|3);

		i = timecount/quanter;
		if (i > otimecount)
		{
			otimecount = i;

			j = (i/trquant[curtrack]);
			buffer[0] = 32;
			buffer[1] = 32;
			buffer[2] = 32;
			buffer[3] = 0;
			if (j >= 100)
			{
				buffer[0] = ((j/100)%10)+48;
				buffer[1] = ((j/10)%10)+48;
				buffer[2] = (j%10)+48;
			}
			else if (j >= 10)
			{
				buffer[0] = ((j/10)%10)+48;
				buffer[1] = (j%10)+48;
			}
			else
			{
				buffer[0] = (j%10)+48;
			}
			printstr(43,13,buffer,0x4f);         //Measure

			j = (i%trquant[curtrack]);
			buffer[0] = 32;
			buffer[1] = 32;
			buffer[2] = 32;
			buffer[3] = 0;
			if (j >= 100)
			{
				buffer[0] = ((j/100)%10)+48;
				buffer[1] = ((j/10)%10)+48;
				buffer[2] = (j%10)+48;
			}
			else if (j >= 10)
			{
				buffer[0] = ((j/10)%10)+48;
				buffer[1] = (j%10)+48;
			}
			else
			{
				buffer[0] = (j%10)+48;
			}
			printstr(43,14,buffer,0x4f);         //Beat
		}

		if (getnote(&freq,&vol) == 1)
		{
			dafreq = mulscale24(frqtable[freq],finetune[trinst[curtrack]]+748);

			if (vol == 0)
			{
				for(i=0;i<NUMCHANNELS;i++)
					if (splc[i] < 0)
						if (swavenum[i] == trinst[curtrack])
							if (sinc[i] == dafreq)
								splc[i] = 0;
				ntvol1[danumnotes] = 0;
				ntvol2[danumnotes] = 0;
			}
			else
			{
				startwave(trinst[curtrack],dafreq,(vol*trvol1[curtrack])>>6,(vol*trvol2[curtrack])>>6,0L,0L,0L);
				ntvol1[danumnotes] = vol; //trvol1[curtrack];
				ntvol2[danumnotes] = vol; //trvol2[curtrack];
			}
			nttime[danumnotes] = timecount;
			nttrack[danumnotes] = curtrack;
			ntfreq[danumnotes] = freq;
			ntfrqeff[danumnotes] = 0;
			ntvoleff[danumnotes] = 0;
			ntpaneff[danumnotes] = 0;
			danumnotes++;
		}

		outp(97,inp(97)&252);

		if (keystatus[0x1])
		{
			keystatus[0x1] = 0;
			musicoff();
			return;
		}
	}
	keystatus[0x9c] = 0;

	musicoff();

	for(i=numnotes;i<danumnotes;i++)
		nttime[i] = ((nttime[i]+(quanter>>1))/quanter)*quanter;

	numnotes = danumnotes;

	for(i=1;i<numnotes;i++)
		for(j=0;j<i;j++)
			if (nttime[i] < nttime[j])
			{
				templong = nttime[i]; nttime[i] = nttime[j]; nttime[j] = templong;
				tempchar = nttrack[i]; nttrack[i] = nttrack[j]; nttrack[j] = tempchar;
				tempchar = ntfreq[i]; ntfreq[i] = ntfreq[j]; ntfreq[j] = tempchar;
				tempchar = ntvol1[i]; ntvol1[i] = ntvol1[j]; ntvol1[j] = tempchar;
				tempchar = ntvol2[i]; ntvol2[i] = ntvol2[j]; ntvol2[j] = tempchar;
				tempchar = ntfrqeff[i]; ntfrqeff[i] = ntfrqeff[j]; ntfrqeff[j] = tempchar;
				tempchar = ntvoleff[i]; ntvoleff[i] = ntvoleff[j]; ntvoleff[j] = tempchar;
				tempchar = ntpaneff[i]; ntpaneff[i] = ntpaneff[j]; ntpaneff[j] = tempchar;
			}
}

newsong()
{
	long i;

	musicoff();
	kdmversionum = 0;
	numnotes = 0;
	for(i=0;i<MAXTRACKS;i++)
	{
		trinst[i] = 0;
		trquant[i] = 4;
		trvol1[i] = 64;
		trvol2[i] = 64;
	}
	for(i=0;i<MAXNOTES;i++)
	{
		nttime[i] = 0L;
		nttrack[i] = 0;
		ntfreq[i] = 35;
		ntvol1[i] = 0;
		ntvol2[i] = 0;
		ntfrqeff[i] = 0;
		ntvoleff[i] = 0;
		ntpaneff[i] = 0;
	}
}

savesong(char *filename)
{
	long fil;

	filename = strupr(filename);
	if (strstr(filename,".KDM") == 0) strcat(filename,".KDM");
	if ((fil = open(filename,O_BINARY|O_TRUNC|O_CREAT|O_WRONLY,S_IWRITE)) == -1)
	{
		printf("I cannot save %s.",filename);
		uninitgroupfile();
		exit(0);
	}
	kdmversionum = 0;
	write(fil,&kdmversionum,4);
	write(fil,&numnotes,4);

	numtracks = MAXTRACKS-1;
	while ((trinst[numtracks-1] == 0) && (numtracks > 0))
		numtracks--;

	write(fil,&numtracks,4);
	write(fil,trinst,numtracks);
	write(fil,trquant,numtracks);
	write(fil,trvol1,numtracks);
	write(fil,trvol2,numtracks);
	write(fil,nttime,numnotes<<2);
	write(fil,nttrack,numnotes);
	write(fil,ntfreq,numnotes);
	write(fil,ntvol1,numnotes);
	write(fil,ntvol2,numnotes);
	write(fil,ntfrqeff,numnotes);
	write(fil,ntvoleff,numnotes);
	write(fil,ntpaneff,numnotes);
	close(fil);
}

loadmenu()
{
	long i, j, k, menutop;
	char filename[80];

	menunamecnt = 0;
	//getfilenames("SUBD");
	getfilenames("*.KDM");
	sortfilenames();

	if (menunamecnt == 0)
	{
		printf("No files found\n");
		return(-2);
	}

	menutop = curkdmfile-8;
	if (menutop >= menunamecnt-15) menutop = menunamecnt-15;
	if (menutop < 0) menutop = 0;

	while (keystatus[1] == 0)
	{
		drawupdatemenu(menutop,curkdmfile);

		if ((keystatus[0xc8]) && (curkdmfile > 0))
		{
			keystatus[0xc8] = 0;
			curkdmfile--;
			if (curkdmfile < menutop) menutop--;
		}
		if ((keystatus[0xd0]) && (curkdmfile < menunamecnt-1))
		{
			keystatus[0xd0] = 0;
			curkdmfile++;
			if (curkdmfile >= menutop+15) menutop++;
		}
		if (keystatus[0x1c])
		{
			keystatus[0x1c] = 0;
			newsong();
			strcpy(filename,menuname[curkdmfile]);
			loadsong(filename);
			for(i=0;filename[i]!='.';i++);
			filename[i+1] = 'K'; filename[i+2] = 'W'; filename[i+3] = 'V';
			loadwaves(filename);
			return(0);
		}
	}
	keystatus[1] = 0;
	return(0);
}

savemenu()
{
	char dafilename[81], buffer[81];
	long i, j, k, menutop;

	menunamecnt = 0;
	//getfilenames("SUBD");
	getfilenames("*.KDM");
	sortfilenames();

	if (menunamecnt == 0)
	{
		printf("No files found\n");
		return(-2);
	}

	menutop = curkdmfile-8;
	if (menutop >= menunamecnt-15) menutop = menunamecnt-15;
	if (menutop < 0) menutop = 0;

	while (keystatus[1] == 0)
	{
		drawupdatemenu(menutop,curkdmfile);

		if ((keystatus[0xc8]) && (curkdmfile > 0))
		{
			keystatus[0xc8] = 0;
			curkdmfile--;
			if (curkdmfile < menutop) menutop--;
		}
		if ((keystatus[0xd0]) && (curkdmfile < menunamecnt-1))
		{
			keystatus[0xd0] = 0;
			curkdmfile++;
			if (curkdmfile >= menutop+15) menutop++;
		}
		if (keystatus[0x1c])
		{
			keystatus[0x1c] = 0;
			savesong(menuname[curkdmfile]);
			return(0);
		}
		if (keystatus[0x39])
		{
			keystatus[0x39] = 0;

			restorescreen();
			printstr(32,10,"Ŀ",0x70);
			printstr(32,11,"  Save song:  ",0x70);
			printstr(32,12,"Ĵ",0x70);
			printstr(32,13,"              ",0x70);
			printstr(32,14,"",0x70);

			dafilename[0] = 0;
			j = 0;
			while (keystatus[0x1c] == 0)
			{
				for(i=0;i<j;i++)
					buffer[i] = dafilename[i];
				buffer[j] = '_';
				buffer[j+1] = ' ';
				buffer[j+2] = 0;
				printstr(34,13,buffer,0x70);

				if (j < 8)
				{
					if ((keystatus[0x2a]|keystatus[0x36]) == 0)
					{
						for(i=0;i<128;i++)
							if ((keystatus[i]) && (scantoasc[i] > 0))
							{
								keystatus[i] = 0;
								dafilename[j++] = scantoasc[i];
							}
					}
					else
					{
						for(i=0;i<128;i++)
							if ((keystatus[i]) && (scantoascwithshift[i] > 0))
							{
								keystatus[i] = 0;
								dafilename[j++] = scantoascwithshift[i];
							}
					}
				}

				if (keystatus[0xe])
				{
					keystatus[0xe] = 0;
					if (j > 0) dafilename[--j] = 32;
				}
				if (keystatus[1])
				{
					keystatus[1] = 0;
					return(0);
				}
			}
			keystatus[0x1c] = 0;

			dafilename[j] = 0;
			savesong(dafilename);
			return(0);
		}
	}
	keystatus[1] = 0;
	return(0);
}

qsetmode640480()
{
	long i;

	setvmode(0x12);
	koutp(0x3ce,0x0); koutp(0x3cf,15);  //set/reset
	koutp(0x3ce,0x1); koutp(0x3cf,15);  //enable set/reset
	fillscreen16(0L,7L,640L*480L);
}

drawline16(long x0, long y0, long x1, long y1, char col)
{
	long i, xdime, ydime, cnt, pinc, p;
	char lmask, rmask;

	if ((x0 < 0) && (x1 < 0)) return;
	if ((x0 >= 640) && (x1 >= 640)) return;
	if ((y0 < 0) && (y1 < 0)) return;
	if ((y0 >= 480) && (y1 >= 480)) return;

	setcolor16((long)col);
	/*if (x0 == x1)
	{
		if (y1 < y0) i = y0, y0 = y1, y1 = i;
		if (y0 < 0) y0 = 0;
		if (y1 >= 480) y1 = 480-1;
		ydime = y1-y0+1;
		p = ((y0*640 + x0)>>3)+0xa0000;
		koutp(0x3ce,0x8); koutp(0x3cf,1<<(x0&7^7));  //bit mask
		vlin16(p,ydime);
		return;
	}
	if (y0 == y1)
	{
		if (x1 < x0) i = x0, x0 = x1, x1 = i;
		if (x0 < 0) x0 = 0;
		if (x1 >= 640) x1 = 639;

		lmask = (0x00ff>>(x0&7)); rmask = (0xff80>>(x1&7));

		p = ((y0*640 + x0)>>3)+0xa0000;

		koutp(0x3ce,8);
		if ((x0|7) == (x1|7))
			{ koutp(0x3cf,lmask&rmask); write16(p); }
		else
		{
			koutp(0x3cf,lmask); write16(p++);

			xdime = (((x1|7)-(x0|7))>>3)-1;
			if (xdime > 0) { koutp(0x3cf,0xff); p = hlin16(p,xdime); }

			koutp(0x3cf,rmask); write16(p);
		}
		return;
	}*/

	if ((x0 < 0) && (x0 != x1)) y0 -= ((y1-y0)*x0) / (x1-x0), x0 = 0;
	if ((x1 < 0) && (x0 != x1)) y1 -= ((y1-y0)*x1) / (x1-x0), x1 = 0;
	if ((y0 < 0) && (y0 != y1)) x0 -= ((x1-x0)*y0) / (y1-y0), y0 = 0;
	if ((y1 < 0) && (y0 != y1)) x1 -= ((x1-x0)*y1) / (y1-y0), y1 = 0;
	if ((x0 >= 640) && (x0 != x1)) y0 += ((y1-y0)*(640-1-x0)) / (x1-x0), x0 = 640-1;
	if ((x1 >= 640) && (x0 != x1)) y1 += ((y1-y0)*(640-1-x1)) / (x1-x0), x1 = 640-1;
	if ((y0 >= 480) && (y0 != y1)) x0 += ((x1-x0)*(480-1-y0)) / (y1-y0), y0 = 480-1;
	if ((y1 >= 480) && (y0 != y1)) x1 += ((x1-x0)*(480-1-y1)) / (y1-y0), y1 = 480-1;

	if ((x0 < 0) && (x1 < 0)) return;
	if ((x0 >= 640) && (x1 >= 640)) return;
	if ((y0 < 0) && (y1 < 0)) return;
	if ((y0 >= 480) && (y1 >= 480)) return;

	if (x1 > x0) xdime = x1-x0+1; else xdime = x0-x1+1;
	if (y1 > y0) ydime = y1-y0+1; else ydime = y0-y1+1;

	if (xdime >= ydime)
	{
		if (x1 < x0)
		{
			i = x0; x0 = x1; x1 = i;
			i = y0; y0 = y1; y1 = i;
		}
		p = y0*640 + x0;
		cnt = 0;
		if (y1 > y0) pinc = 640; else pinc = -640;
		for(i=xdime;i>0;i--)
		{
			drawpixel16(p);
			cnt += ydime;
			if (cnt >= xdime) cnt -= xdime, p += pinc;
			p++;
		}
	}
	else
	{
		if (y1 < y0)
		{
			i = x0; x0 = x1; x1 = i;
			i = y0; y0 = y1; y1 = i;
		}
		p = y0*640 + x0;
		cnt = 0;
		if (x1 > x0) pinc = 1; else pinc = -1;
		for(i=ydime;i>0;i--)
		{
			drawpixel16(p);
			cnt += xdime;
			if (cnt >= ydime) cnt -= ydime, p += pinc;
			p += 640;
		}
	}
}

drawnotescreen(long curtrack, long boxxsiz, long timetop, long timeplc)
{
	long i, j, x, x1, x2;

	x1 = (otimeplc%480)+80+1;
	x2 = x1 + boxxsiz-2;

	if ((timetop != otimetop) || ((timeplc/480) != (otimeplc/480)))
	{
		if (timetop == otimetop)
			drawbox(boxxsiz,otimeplc,otimetop,7);
		else
			fillscreen16(0,7L,640L*480L);

		i = 0;
		while ((nttime[i] < timetop) && (i < numnotes))
			i++;

		for(j=0;j<3;j++)
		{
			drawstaff(curtrack,boxxsiz,j<<7,timetop!=otimetop);
			while ((nttime[i] < j*480+480+timetop) && (i < numnotes))
			{
				if (nttrack[i] == curtrack)
					drawnote(i,j<<7);
				i++;
			}
		}
		otimetop = timetop;
		otimeplc = timeplc;
	}
	else
	{
		j = (timeplc-timetop)/480;

		i = 0;
		while ((nttime[i] < j*480+timetop) && (i < numnotes))
			i++;

		drawbox(boxxsiz,otimeplc,otimetop,7);

		drawstaff(curtrack,boxxsiz,j<<7,timetop!=otimetop);
		while ((nttime[i] < j*480+480+timetop) && (i < numnotes))
		{
			if (nttrack[i] == curtrack)
			{
				x = (nttime[i]%480)+80;
				if ((x1 <= x+5) && (x2 >= x-1))
					drawnote(i,j<<7);
			}
			i++;
		}
		otimetop = timetop;
		otimeplc = timeplc;
	}

	drawbox(boxxsiz,timeplc,timetop,15);
}

drawstaff(long curtrack, long boxxsiz, long yoff, char drawstat)
{
	long i, j;

	if ((drawstat == 1) && (trquant[curtrack] <= 48))
		for(i=80;i<=560;i+=boxxsiz)
			drawline16(i,yoff+45,i,yoff+105,3);

	for(i=0;i<5;i++)
	{
		drawline16(80,yoff+105-i*6,560,yoff+105-i*6,8);
		drawline16(80,yoff+105-36-i*6,560,yoff+105-36-i*6,8);
	}

	if (drawstat == 1)
		for(i=80;i<=560;i+=120)
			drawline16(i,yoff+45,i,yoff+105,8);
}

drawnote(long notenum, long yoff)
{
	long i, x, y, sharp;

	x = (nttime[notenum]%480)+80;

	i = (long)freqspot[ntfreq[notenum]];
	sharp = 0;
	if (i == 255)                          //Sharp
	{
		i = (long)freqspot[ntfreq[notenum]-1];
		sharp = 1;
	}
	y = i+yoff;

	if (ntvol1[notenum] > 0)
	{
		if (ntfrqeff[notenum]) drawline16(x+5,y-2,x+8,y-5,8);
		if (ntvoleff[notenum]) drawline16(x+5,y-2,x+8,y-2,8);
		if (ntpaneff[notenum]) drawline16(x+5,y-2,x+8,y+1,8);

		if (sharp == 1)
		{
			drawline16(x-1,y-7,x+3,y-7,8);
			drawline16(x-1,y-9,x+3,y-9,8);
			drawline16(x+2,y-6,x+2,y-10,8);
			drawline16(x+0,y-6,x+0,y-10,8);
		}
		drawline16(x+0,y-3,x+0,y-2,8);
		drawline16(x+1,y-4,x+1,y-1,8);
		drawline16(x+2,y-5,x+2,y-0,8);
		drawline16(x+3,y-5,x+3,y-0,8);
		drawline16(x+4,y-4,x+4,y-1,8);
		drawline16(x+5,y-12,x+5,y-2,8);
	}
	else
	{
		if (sharp == 1)
		{
			drawline16(x-1,y-7,x+3,y-7,4);
			drawline16(x-1,y-9,x+3,y-9,4);
			drawline16(x+2,y-6,x+2,y-10,4);
			drawline16(x+0,y-6,x+0,y-10,4);
		}
		drawline16(x+1,y-4,x+3,y-2,4);
		drawline16(x+1,y-2,x+3,y-4,4);
	}
}

drawbox(long boxxsiz, long timeplc, long timetop, char col)
{
	long x1, y1, x2, y2;

	x1 = (timeplc%480)+80+1;
	y1 = ((timeplc-timetop)/480)*128;
	x2 = x1 + boxxsiz-2;
	y2 = y1 + 127;

	drawline16(x1,y1,x2,y1,col);
	drawline16(x1,y2,x2,y2,col);
	drawline16(x1,y1,x1,y2,col);
	drawline16(x2,y1,x2,y2,col);
}

static long oldtime = -1, oldmeas = 480;
edittrack(long curtrack)
{
	long i, j, k, l, timetop, timeplc, boxxsiz, templong, freq, vol, good;
	long dafreq, daeff, timemark1, timemark2, timemarktrack;

	qsetmode640480();

	timetop = 0;
	timeplc = 0;
	otimetop = -1;
	otimeplc = -1;

	timemark1 = -1;
	timemark2 = -1;
	timemarktrack = -1;
	fiddlemode = 1;

	daeff = 0;

	boxxsiz = (120/trquant[curtrack]);

	drawnotescreen(curtrack,boxxsiz,timetop,timeplc);

	lastat = 0x90;
	while ((keystatus[1] == 0) && (keystatus[0x9c] == 0))
	{
		if (musicstatus == 1)
		{
			templong = (timecount/boxxsiz)*boxxsiz;
			if (timeplc != templong)
			{
				timeplc = templong;

				while (timeplc < timetop)
					timetop -= 480;
				while (timeplc >= timetop+480*3)
					timetop += 480;

				drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
			}
			if (notecnt >= numnotes)
			{
				musicoff();
			}

		}

		if (getnote(&freq,&vol) == 1)
		{
			dafreq = mulscale24(frqtable[freq],finetune[trinst[curtrack]]+748);

			if (vol == 0)
			{
				for(i=0;i<NUMCHANNELS;i++)
					if (splc[i] < 0)
						if (swavenum[i] == trinst[curtrack])
							if (sinc[i] == dafreq)
								splc[i] = 0;

				if (musicstatus > 0)
				{
					insertnote(((timecount+((boxxsiz*3)>>3))/boxxsiz)*boxxsiz,(char)curtrack,(char)freq,0,0,0,0,0);
					otimetop = -1;
				}
			}
			else
			{
				startwave(trinst[curtrack],dafreq,min((trvol1[curtrack]*vol)>>6,255),min((trvol2[curtrack]*vol)>>6,255),0L,0L,0L);

					//First search if note already exists there...
				good = 0;
				if (musicstatus == 0)
				{
					i = 0;
					while ((nttime[i] < timeplc) && (i < numnotes)) i++;
					while ((nttime[i] < timeplc+boxxsiz) && (i < numnotes))
					{
						if ((nttrack[i] == curtrack) && (ntfreq[i] == freq))
						{
							if (ntvol1[i] > 0)
								ntvol1[i] = 0;
							else
								{ deletenote(i); i--; }
							otimetop = -1;
							good = 1;
						}
						i++;
					}
				}

					//If no notes on same track & frequency found, then add note
				if (good == 0)
				{
					if (musicstatus > 0)
						insertnote(((timecount+((boxxsiz*3)>>3))/boxxsiz)*boxxsiz,(char)curtrack,(char)freq,trvol1[curtrack],trvol2[curtrack],0,0,0);
					else
						insertnote(timeplc,(char)curtrack,(char)freq,trvol1[curtrack],trvol2[curtrack],0,0,0);
				}
			}
			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}

		if (keystatus[0x29])  //'
		{
			keystatus[0x29] = 0;

			if (daeff == 0) daeff = 1;
			fillscreen16(0L,7L,640L*480L);
			for(i=0;i<255;i++)
				drawline16((i<<1)+64,(eff[daeff-1][i]*480)>>17,((i+1)<<1)+64,(eff[daeff-1][i+1]*480)>>17,0);

			while (keystatus[1] == 0)
			{
				if (keystatus[0xc9])  //PGUP
				{
					keystatus[0xc9] = 0;
					if (daeff > 1) daeff--;
					fillscreen16(0L,7L,640L*480L);
					for(i=0;i<255;i++)
						drawline16((i<<1)+64,(eff[daeff-1][i]*480)>>17,((i+1)<<1)+64,(eff[daeff-1][i+1]*480)>>17,0);
				}
				if (keystatus[0xd1])  //PGDN
				{
					keystatus[0xd1] = 0;
					if (daeff < MAXEFFECTS) daeff++;
					fillscreen16(0L,7L,640L*480L);
					for(i=0;i<255;i++)
						drawline16((i<<1)+64,(eff[daeff-1][i]*480)>>17,((i+1)<<1)+64,(eff[daeff-1][i+1]*480)>>17,0);
				}
			}
			keystatus[1] = 0;

			otimetop = -1;
			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}

		if (keystatus[0x39])  //Space (play)
		{
			keystatus[0x39] = 0;
			if ((musicstatus != 1) || (notecnt >= numnotes))
			{
				musicoff();

				notecnt = 0;
				while ((nttime[notecnt] < timeplc) && (notecnt < numnotes))
					notecnt++;
				timecount = nttime[notecnt];
				musicrepeat = 0;
				musicstatus = 1;
			}
			else
			{
				musicoff();
			}
		}

			//Added: 09/08/2000
			//   Step 1: Go to drum/snare track
			//   Step 2: Press Insert once for each measure, making sure the
			//          cursor is BEFORE the next notedown which will become
			//          aligned to the next measure. (uses linear interpolation :)
		if (keystatus[0xd2]) //Insert (auto-interpolate measures)
		{
			musicoff();
			keystatus[0xd2] = 0;

			i = 0;
			while (((nttime[i] < timeplc) || (nttrack[i] != curtrack) ||
					 (ntvol1[i] == 0)) && (i < numnotes)) i++;
			if (i < numnotes)
			{
				if ((oldtime != -1) && (nttime[i] > oldtime))
				{
					j = nttime[i];

					for(i=0;nttime[i]<oldtime;i++);

						//Scale times from:
						//   0 / oldtime / j           / ?         to:
						//   0 / oldmeas / oldmeas+120 / ?
					while (nttime[i] < j)
					{
						nttime[i] = (nttime[i]-oldtime)*120/(j-oldtime)+oldtime;
						i++;
					}
					while (i < numnotes) { nttime[i] += oldmeas+120-j; i++; }

					oldmeas += 120;
				}
				oldtime = oldmeas;

				timeplc = oldmeas+60;
				if (timeplc >= timetop+480*3) timetop += 480;
			}
			else oldtime = -1;

			otimetop = otimeplc = -1;
			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}
		if (keystatus[0xc7]) //Home (move notes: press twice), Added: 09/08/2000
		{
			keystatus[0xc7] = 0;
			if (oldtime < 0)
				oldtime = timeplc;
			else
			{
				for(i=0;i<numnotes;i++)
					if ((nttrack[i] == curtrack) && (nttime[i] == oldtime))
						nttime[i] = timeplc;

					//Ensure that notes are still sorted by time
				for(i=0;i<numnotes-1;i++)
				{
					if (nttime[i] <= nttime[i+1]) continue;
					j = i;
					do
					{
						k = nttime[j]; nttime[j] = nttime[j+1]; nttime[j+1] = k;
						k = nttrack[j]; nttrack[j] = nttrack[j+1]; nttrack[j+1] = k;
						k = ntfreq[j]; ntfreq[j] = ntfreq[j+1]; ntfreq[j+1] = k;
						k = ntvol1[j]; ntvol1[j] = ntvol1[j+1]; ntvol1[j+1] = k;
						k = ntvol2[j]; ntvol2[j] = ntvol2[j+1]; ntvol2[j+1] = k;
						k = ntfrqeff[j]; ntfrqeff[j] = ntfrqeff[j+1]; ntfrqeff[j+1] = k;
						k = ntvoleff[j]; ntvoleff[j] = ntvoleff[j+1]; ntvoleff[j+1] = k;
						k = ntpaneff[j]; ntpaneff[j] = ntpaneff[j+1]; ntpaneff[j+1] = k;
						j++;
					} while ((j < numnotes-1) && (nttime[j] > nttime[j+1]));
				}
				oldtime = -1;
			}
			otimetop = otimeplc = -1;
			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}
		if (keystatus[0xcf]) //End (quantize current track), Added: 09/08/2000
		{
			keystatus[0xcf] = 0;
			j = 120/trquant[curtrack];
			for(i=0;i<numnotes;i++)
				if (nttrack[i] == curtrack)
					nttime[i] = ((nttime[i]+(j>>1))/j)*j;

			otimetop = otimeplc = -1;
			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}

#if 0    //This code works, but it's not very helpful
		if (keystatus[0xc7])        //Home (Insert) (Added: 09/08/2000)
		{
			musicoff();
			keystatus[0xc7] = 0;

			i = 0;
			while ((nttime[i] < timeplc) && (i < numnotes)) i++;
			while (i < numnotes) { nttime[i]--; i++; }

			otimetop = otimeplc = -1;
			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}
		if (keystatus[0xcf])        //End (Delete) (Added: 09/08/2000)
		{
			musicoff();
			keystatus[0xcf] = 0;

			i = 0;
			while ((nttime[i] < timeplc) && (i < numnotes)) i++;
			while (i < numnotes) { nttime[i]++; i++; }

			otimetop = otimeplc = -1;
			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}
#endif

		if (keystatus[0xd3])        //Delete
		{
			musicoff();
			keystatus[0xd3] = 0;

			i = 0;
			while ((nttime[i] < timeplc) && (i < numnotes))
				i++;
			while ((nttime[i] < timeplc+boxxsiz) && (i < numnotes))
			{
				if (nttrack[i] == curtrack)
				{
					deletenote(i);
					otimetop = -1;
					i--;
				}
				i++;
			}

			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}

		if (keystatus[0x2])    //1
		{
			keystatus[0x2] = 0;
			timemark1 = timeplc;
		}
		if (keystatus[0x3])    //2
		{
			keystatus[0x3] = 0;
			timemark2 = timeplc;
			timemarktrack = curtrack;
		}
		if (keystatus[0x4])    //3
		{
			keystatus[0x4] = 0;

			if (timemark1 > timemark2)
				templong = timemark1, timemark1 = timemark2, timemark2 = templong;

			if ((timeplc > timemark2) || (timeplc < timemark1-(timemark2-timemark1)))
			{
				i = 0;
				while ((nttime[i] < timemark1) && (i < numnotes))
					i++;

				while ((nttime[i] <= timemark2) && (i < numnotes))
				{
					if (nttrack[i] == timemarktrack)
					{
						j = insertnote(timeplc+(nttime[i]-timemark1),(char)curtrack,ntfreq[i],ntvol1[i],ntvol2[i],ntfrqeff[i],ntvoleff[i],ntpaneff[i]);
						if (j < i)
							i++;
						otimetop = -1;
					}
					i++;
				}
			}

			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}

		j = 0;
		if (keystatus[0x3b]) { keystatus[0x3b] = 0; j = 1; }
		if (keystatus[0x3c]) { keystatus[0x3c] = 0; j = 2; }
		if (keystatus[0x3d]) { keystatus[0x3d] = 0; j = 3; }
		if (j)   //F1-F3 (effects)
		{
			i = 0; l = 0;
			while ((nttime[i] < timeplc) && (i < numnotes)) i++;
			while ((nttime[i] < timeplc+boxxsiz) && (i < numnotes))
			{
				if ((nttrack[i] == curtrack) && (ntvol1[i] > 0))
					tempbuflong[l++] = i;
				i++;
			}

			if (l)
			{
				daeff = 0;
				for(i=0;i<l;i++)
					if (tempbuflong[i] >= 0)
					{
						switch(j)
						{
							case 1: daeff = ntfrqeff[tempbuflong[i]]; break;
							case 2: daeff = ntvoleff[tempbuflong[i]]; break;
							case 3: daeff = ntpaneff[tempbuflong[i]]; break;
						}
						if (daeff) break;
					}

				good = 3;
				while (keystatus[1] == 0)
				{
					if (good&1)
					{
						good &= ~1;
						fillscreen16(0L,7L,640L*480L);
						if (daeff == 0)
							drawline16(64,480>>1,640-64,480>>1,4);
						else
							for(k=0;k<255;k++)
								drawline16((k<<1)+64,(eff[daeff-1][k]*480)>>17,((k+1)<<1)+64,(eff[daeff-1][k+1]*480)>>17,0);
						for(i=0;i<l;i++)
						  if (tempbuflong[i] >= 0)
							  drawnote(tempbuflong[i],0L);
					}
					if (good&2)
					{
						good &= ~2;
						musicoff();
						for(i=0;i<l;i++)
							if (tempbuflong[i] >= 0)
							{
								dafreq = mulscale24(frqtable[ntfreq[tempbuflong[i]]],finetune[trinst[curtrack]]+748);
								switch(j)
								{
									case 1:
										startwave(trinst[curtrack],dafreq,trvol1[curtrack],trvol2[curtrack],
											daeff,ntvoleff[tempbuflong[i]],ntpaneff[tempbuflong[i]]);
										break;
									case 2:
										startwave(trinst[curtrack],dafreq,trvol1[curtrack],trvol2[curtrack],
											ntfrqeff[tempbuflong[i]],daeff,ntpaneff[tempbuflong[i]]);
										break;
									case 3:
										startwave(trinst[curtrack],dafreq,trvol1[curtrack],trvol2[curtrack],
											ntfrqeff[tempbuflong[i]],ntvoleff[tempbuflong[i]],daeff);
										break;
								}
							}
					}

					if (getnote(&freq,&vol))
						if (vol > 0)
						{
							for(i=0;i<l;i++)
								if (ntfreq[tempbuflong[i]&0x7fffffff] == freq)
									{ tempbuflong[i] ^= 0x80000000; break; }
							good |= 3;
						}

					if (keystatus[0xc9])  //PGUP
					{
						keystatus[0xc9] = 0;
						if (daeff > 0) daeff--;
						good |= 3;
					}
					if (keystatus[0xd1])  //PGDN
					{
						keystatus[0xd1] = 0;
						if (daeff < MAXEFFECTS) daeff++;
						good |= 3;
					}
					if (keystatus[0x39])
					{
						keystatus[0x39] = 0;
						musicoff();
					}
					if (keystatus[0x1c])
					{
						keystatus[0x1c] = 0;
						for(i=0;i<l;i++)
							if (tempbuflong[i] >= 0)
							{
								switch(j)
								{
									case 1: ntfrqeff[tempbuflong[i]] = daeff; break;
									case 2: ntvoleff[tempbuflong[i]] = daeff; break;
									case 3: ntpaneff[tempbuflong[i]] = daeff; break;
								}
							}
						break;
					}
				}
				keystatus[1] = 0;
				musicoff();

				otimetop = -1;
				drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
			}
		}

		if ((keystatus[0xc9]) && (curtrack > 0))           //PGUP
		{
			keystatus[0xc9] = 0;
			curtrack--;

			boxxsiz = (120/trquant[curtrack]);
			timeplc = (timeplc/boxxsiz)*boxxsiz;

			otimetop = -1;
			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}
		if ((keystatus[0xd1]) && (curtrack < MAXTRACKS-1))  //PGDN
		{
			keystatus[0xd1] = 0;
			curtrack++;

			boxxsiz = (120/trquant[curtrack]);
			timeplc = (timeplc/boxxsiz)*boxxsiz;

			otimetop = -1;
			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}

		if (keystatus[0xc])        //L. - (shift notes up)
		{
			musicoff();
			keystatus[0xc] = 0;
			for(i=0;i<numnotes;i++)
				if (nttrack[i] == curtrack)
					ntfreq[i]++;

			otimetop = -1;
			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}
		if (keystatus[0xd])        //L. + (shift notes down)
		{
			musicoff();
			keystatus[0xd] = 0;
			for(i=0;i<numnotes;i++)
				if (nttrack[i] == curtrack)
					ntfreq[i]--;

			otimetop = -1;
			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}

		if ((keystatus[0xc8]) && (timeplc >= 480))
		{
			keystatus[0xc8] = 0;

			timeplc -= 480;
			if (timeplc < timetop)
				timetop -= 480;

			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}
		if (keystatus[0xd0])
		{
			keystatus[0xd0] = 0;

			timeplc += 480;
			if (timeplc >= timetop+480*3)
				timetop += 480;

			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}
		if ((keystatus[0xcb]) && (timeplc >= boxxsiz))
		{
			musicoff();
			keystatus[0xcb] = 0;

			timeplc -= boxxsiz;
			if (timeplc < timetop)
				timetop -= 480;

			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}
		if (keystatus[0xcd])
		{
			musicoff();
			keystatus[0xcd] = 0;

			timeplc += boxxsiz;
			if (timeplc >= timetop+480*3)
				timetop += 480;

			drawnotescreen(curtrack,boxxsiz,timetop,timeplc);
		}
	}
	keystatus[1] = 0;
	keystatus[0x9c] = 0;
	fiddlemode = 0;

	setvmode(0x3);
	outp(0x3d4,0xa); outp(0x3d5,inp(0x3d5) | 0x0f);   //Turn cursor off
	outp(0x3d4,0xb); outp(0x3d5,inp(0x3d5) & 0xf0);
}

insertnote(long timeplc, char curtrack, char freq, char vol1, char vol2, char dafrqeff, char davoleff, char dapaneff)
{
	long i, j;

	i = 0;
	while ((nttime[i] < timeplc) && (i < numnotes))
		i++;

	numnotes++;
	for(j=numnotes-1;j>i;j--)
	{
		nttime[j] = nttime[j-1];
		nttrack[j] = nttrack[j-1];
		ntfreq[j] = ntfreq[j-1];
		ntvol1[j] = ntvol1[j-1];
		ntvol2[j] = ntvol2[j-1];
		ntfrqeff[j] = ntfrqeff[j-1];
		ntvoleff[j] = ntvoleff[j-1];
		ntpaneff[j] = ntpaneff[j-1];
	}

	nttime[i] = timeplc;
	nttrack[i] = curtrack;
	ntfreq[i] = freq;
	ntvol1[i] = vol1;
	ntvol2[i] = vol2;
	ntfrqeff[i] = dafrqeff;
	ntvoleff[i] = davoleff;
	ntpaneff[i] = dapaneff;

	return(i);
}

deletenote(long notenum)
{
	long i;

	numnotes--;
	for(i=notenum;i<numnotes;i++)
	{
		nttime[i] = nttime[i+1];
		nttrack[i] = nttrack[i+1];
		ntfreq[i] = ntfreq[i+1];
		ntvol1[i] = ntvol1[i+1];
		ntvol2[i] = ntvol2[i+1];
		ntfrqeff[i] = ntfrqeff[i+1];
		ntvoleff[i] = ntvoleff[i+1];
		ntpaneff[i] = ntpaneff[i+1];
	}
}

showwave(long curwave)
{
	long i;

	setvmode(0x13);
	koutp(0x3c4,0x4); koutp(0x3c5,0x6);
	koutp(0x3d4,0x14); koutp(0x3d5,0x0);
	koutp(0x3d4,0x17); koutp(0x3d5,0xe3);
	koutp(0x3c4,2); koutp(0x3c5,15);
	koutp(0x3d4,0x9); koutp(0x3d5,kinp(0x3d5)&~1);
	clearbuf(0xa0000,8000L,0L);

	for(i=0;i<320;i++)
	{
		lasty1[i] = 255;
		lasty2[i] = 255;
	}

	showwavemode = 1;
	fiddlemode = 1;
	while (keystatus[1] == 0)
	{
		fiddlecheck(curwave,64,64);

		if (keystatus[0x46])  //Scroll lock (pause)
		{
			keystatus[0x46] = 0;
			showwavemode ^= 1;
		}
		if (keystatus[0x39])  //Space (play)
		{
			keystatus[0x39] = 0;
			if ((musicstatus != 1) || (notecnt >= numnotes))
			{
				notecnt = 0;
				timecount = nttime[notecnt];
				musicrepeat = 0;
				musicstatus = 1;
			}
			else
			{
				musicoff();
			}
		}
		if (keystatus[0x37])  //Keyp. /
		{
			keystatus[0x37] = 0;
			if (keystatus[0x36]|keystatus[0x2a])
				finetune[curwave] -= 10;
			else
				finetune[curwave]--;
			asksaveinsts = 1;
		}
		if (keystatus[0xb5])  //Keyp. *
		{
			keystatus[0xb5] = 0;
			if (keystatus[0x36]|keystatus[0x2a])
				finetune[curwave] += 10;
			else
				finetune[curwave]++;
			asksaveinsts = 1;
		}
	}
	fiddlemode = 0;
	showwavemode = 0;

	setvmode(0x3);
	outp(0x3d4,0xa); outp(0x3d5,inp(0x3d5) | 0x0f);   //Turn cursor off
	outp(0x3d4,0xb); outp(0x3d5,inp(0x3d5) & 0xf0);

	keystatus[1] = 0;
}
