uniform float WobbleScale;
uniform float WobbleHeight;
uniform float WobblePhase;

void main( void )
{
   // convert carthesion to spherical coordinates
   float radius = length(gl_Vertex);
   float sigma = 0;
   if ( gl_Vertex.y + gl_Vertex.x != 0)
      sigma = atan( gl_Vertex.y, gl_Vertex.x );
   float theta = acos( gl_Vertex.z / radius );
   
    vec4 ObjVert= gl_Vertex;
    ObjVert.xyz *= 1.0 + WobbleHeight * sin( WobbleScale * sigma + WobblePhase)
                                * sin( WobbleScale * theta + WobblePhase);
    gl_Position = gl_ModelViewProjectionMatrix * ObjVert;

    gl_TexCoord[0] = gl_MultiTexCoord0;
}