uniform int AUTO_NrLights;
// Depth
uniform bool AUTO_CastsSolid[4];
//uniform sampler2DShadow AUTO_SolidShadowMap[4];
uniform sampler2DShadow AUTO_SolidShadowMap0;
uniform sampler2DShadow AUTO_SolidShadowMap1;

uniform float AUTO_Epsilon;
// Opacity
uniform bool AUTO_CastsTrans[4];
uniform sampler2D AUTO_TransDepthMap0;
uniform sampler2D AUTO_TransDepthMap1;
uniform sampler2D AUTO_TransOpacityMap0;
uniform sampler2D AUTO_TransOpacityMap1;
uniform float AUTO_MaxDepth[4];
uniform float AUTO_ShadowAmbient[4];

varying vec4 ShadowCoord[4];

uniform sampler2D Texture;

float lookup0( float x, float y)
{
	float depth = shadow2DProj(AUTO_SolidShadowMap0, ShadowCoord[0] + vec4(x, y, AUTO_Epsilon,0) ).x;
	return depth != 1.0 ? AUTO_ShadowAmbient[0] : 1.0;
}

float lookup1( float x, float y)
{
	float depth = shadow2DProj(AUTO_SolidShadowMap1, ShadowCoord[1] + vec4(x, y, AUTO_Epsilon,0) ).x;
	return depth != 1.0 ? AUTO_ShadowAmbient[1] : 1.0;
}


void main()
{
	if (AUTO_NrLights == 0)
		gl_FragColor = vec4( gl_Color.rgb, gl_Color.a);
	else 
	{
		float theShade;
		float theTotal = 0;
		if ( ShadowCoord[0].w <= 0)
			theTotal += 1.0/AUTO_NrLights;
		else
		{
			if ( AUTO_CastsSolid[0] )
			{
				theShade = lookup0( 0., 0.);			
			} 
			else theShade = 1.0;

			if (theShade == 1.0 && AUTO_CastsTrans[0])
			{
				float theFirstLayer = texture2DProj(AUTO_TransDepthMap0, ShadowCoord[0])[0];				
				float theCurDepth = (ShadowCoord[0].z/ShadowCoord[0].w - theFirstLayer)/(AUTO_MaxDepth[0]-theFirstLayer);				

				if ( theCurDepth > 0.02)  // first thin slice is always lit
				{ // stagger the layers a bit, compared to the layer generation.
					// This means the first part of a layer will not self-shadow, the other will.

					int theCompIndex = step(0.12, theCurDepth) + step(0.35, theCurDepth) + step(0.65, theCurDepth);
					theShade = mix( AUTO_ShadowAmbient[0], 1.0, 1-texture2D(AUTO_TransOpacityMap0, ShadowCoord[0].xy/ShadowCoord[0].w)[theCompIndex]);	
				}
			}
			theTotal += theShade/AUTO_NrLights;
		}


		if ( AUTO_NrLights > 1)
		{
			if ( ShadowCoord[1].w <= 0)
				theTotal += 1.0/AUTO_NrLights;
			else
			{
				if ( AUTO_CastsSolid[1] )
				{
					theShade = lookup1( 0., 0.);
				} 
				else theShade = 1.0;

				if (theShade == 1.0 && AUTO_CastsTrans[1])
				{
					float theFirstLayer = texture2DProj(AUTO_TransDepthMap1, ShadowCoord[1])[0];
					float theCurDepth = (ShadowCoord[1].z/ShadowCoord[1].w - theFirstLayer)/(AUTO_MaxDepth[1]-theFirstLayer);
						
					if ( theCurDepth > 0.02)  // first thin slice is always lit
					{ // stagger the layers a bit, compared to the layer generation.
						// This means the first part of a layer will not self-shadow, the other will.

						int theCompIndex = step(0.12, theCurDepth) + step(0.35, theCurDepth) + step(0.65, theCurDepth);
						theShade = mix( AUTO_ShadowAmbient[0], 1.0, 1-texture2D(AUTO_TransOpacityMap1, ShadowCoord[1].xy/ShadowCoord[1].w)[theCompIndex]);	
					}
				}
				theTotal += theShade/AUTO_NrLights;
			}
		}

		gl_FragColor = vec4( theTotal * gl_Color.rgb, gl_Color.a) * texture2D( Texture, vec2( gl_TexCoord[0].s, gl_TexCoord[0].t) ) ;

	}
}