// ThreeCanvas.js r45dev - http://github.com/mrdoob/three.js
var THREE=THREE||{};if(!self.Int32Array)self.Int32Array=Array,self.Float32Array=Array;THREE.Color=function(a){a!==void 0&&this.setHex(a);return this};
THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,copy:function(a){this.r=a.r;this.g=a.g;this.b=a.b;return this},setRGB:function(a,b,c){this.r=a;this.g=b;this.b=c;return this},setHSV:function(a,b,c){var d,e,g;if(c==0)this.r=this.g=this.b=0;else switch(d=Math.floor(a*6),e=a*6-d,a=c*(1-b),g=c*(1-b*e),b=c*(1-b*(1-e)),d){case 1:this.r=g;this.g=c;this.b=a;break;case 2:this.r=a;this.g=c;this.b=b;break;case 3:this.r=a;this.g=g;this.b=c;break;case 4:this.r=b;this.g=a;this.b=c;break;case 5:this.r=
c;this.g=a;this.b=g;break;case 6:case 0:this.r=c,this.g=b,this.b=a}return this},setHex:function(a){a=Math.floor(a);this.r=(a>>16&255)/255;this.g=(a>>8&255)/255;this.b=(a&255)/255;return this},getHex:function(){return~~(this.r*255)<<16^~~(this.g*255)<<8^~~(this.b*255)},getContextStyle:function(){return"rgb("+Math.floor(this.r*255)+","+Math.floor(this.g*255)+","+Math.floor(this.b*255)+")"},clone:function(){return(new THREE.Color).setRGB(this.r,this.g,this.b)}};
THREE.Vector2=function(a,b){this.x=a||0;this.y=b||0};
THREE.Vector2.prototype={constructor:THREE.Vector2,set:function(a,b){this.x=a;this.y=b;return this},copy:function(a){this.x=a.x;this.y=a.y;return this},clone:function(){return new THREE.Vector2(this.x,this.y)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a):this.set(0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.lengthSq())},normalize:function(){return this.divideScalar(this.length())},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){var b=this.x-a.x,a=this.y-a.y;return b*b+a*a},setLength:function(a){return this.normalize().multiplyScalar(a)},
equals:function(a){return a.x==this.x&&a.y==this.y}};THREE.Vector3=function(a,b,c){this.x=a||0;this.y=b||0;this.z=c||0};
THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(a,b,c){this.x=a;this.y=b;this.z=c;return this},setX:function(a){this.x=a;return this},setY:function(a){this.y=a;return this},setZ:function(a){this.z=a;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;return this},clone:function(){return new THREE.Vector3(this.x,this.y,this.z)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;return this},
addScalar:function(a){this.x+=a;this.y+=a;this.z+=a;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-b.z;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;return this},multiply:function(a,b){this.x=a.x*b.x;this.y=a.y*b.y;this.z=a.z*b.z;return this},multiplySelf:function(a){this.x*=a.x;this.y*=a.y;this.z*=a.z;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;return this},divideSelf:function(a){this.x/=a.x;this.y/=a.y;this.z/=a.z;return this},
divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a):this.set(0,0,0);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.lengthSq())},lengthManhattan:function(){return this.x+this.y+this.z},normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},
cross:function(a,b){this.x=a.y*b.z-a.z*b.y;this.y=a.z*b.x-a.x*b.z;this.z=a.x*b.y-a.y*b.x;return this},crossSelf:function(a){return this.set(this.y*a.z-this.z*a.y,this.z*a.x-this.x*a.z,this.x*a.y-this.y*a.x)},distanceTo:function(a){return Math.sqrt(this.distanceToSquared(a))},distanceToSquared:function(a){return(new THREE.Vector3).sub(this,a).lengthSq()},setPositionFromMatrix:function(a){this.x=a.n14;this.y=a.n24;this.z=a.n34},setRotationFromMatrix:function(a){var b=Math.cos(this.y);this.y=Math.asin(a.n13);
Math.abs(b)>1.0E-5?(this.x=Math.atan2(-a.n23/b,a.n33/b),this.z=Math.atan2(-a.n12/b,a.n11/b)):(this.x=0,this.z=Math.atan2(a.n21,a.n22))},isZero:function(){return this.lengthSq()<1.0E-4}};THREE.Vector4=function(a,b,c,d){this.x=a||0;this.y=b||0;this.z=c||0;this.w=d!==void 0?d:1};
THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w!==void 0?a.w:1},clone:function(){return new THREE.Vector4(this.x,this.y,this.z,this.w)},add:function(a,b){this.x=a.x+b.x;this.y=a.y+b.y;this.z=a.z+b.z;this.w=a.w+b.w;return this},addSelf:function(a){this.x+=a.x;this.y+=a.y;this.z+=a.z;this.w+=a.w;return this},sub:function(a,b){this.x=a.x-b.x;this.y=a.y-b.y;this.z=a.z-
b.z;this.w=a.w-b.w;return this},subSelf:function(a){this.x-=a.x;this.y-=a.y;this.z-=a.z;this.w-=a.w;return this},multiplyScalar:function(a){this.x*=a;this.y*=a;this.z*=a;this.w*=a;return this},divideScalar:function(a){a?(this.x/=a,this.y/=a,this.z/=a,this.w/=a):(this.z=this.y=this.x=0,this.w=1);return this},negate:function(){return this.multiplyScalar(-1)},dot:function(a){return this.x*a.x+this.y*a.y+this.z*a.z+this.w*a.w},lengthSq:function(){return this.dot(this)},length:function(){return Math.sqrt(this.lengthSq())},
normalize:function(){return this.divideScalar(this.length())},setLength:function(a){return this.normalize().multiplyScalar(a)},lerpSelf:function(a,b){this.x+=(a.x-this.x)*b;this.y+=(a.y-this.y)*b;this.z+=(a.z-this.z)*b;this.w+=(a.w-this.w)*b;return this}};THREE.Ray=function(a,b){this.origin=a||new THREE.Vector3;this.direction=b||new THREE.Vector3};
THREE.Ray.prototype={constructor:THREE.Ray,intersectScene:function(a){return this.intersectObjects(a.objects)},intersectObjects:function(a){var b,c,d=[];b=0;for(c=a.length;b<c;b++)d=d.concat(this.intersectObject(a[b]));d.sort(function(a,b){return a.distance-b.distance});return d},intersectObject:function(a){function b(a,b,c){var d;d=c.clone().subSelf(a).dot(b);if(d<=0)return null;a=a.clone().addSelf(b.clone().multiplyScalar(d));return c.distanceTo(a)}function c(a,b,c,d){var d=d.clone().subSelf(b),
c=c.clone().subSelf(b),e=a.clone().subSelf(b),a=d.dot(d),b=d.dot(c),d=d.dot(e),f=c.dot(c),c=c.dot(e),e=1/(a*f-b*b),f=(f*d-b*c)*e,a=(a*c-b*d)*e;return f>0&&a>0&&f+a<1}if(a instanceof THREE.Particle){var d=b(this.origin,this.direction,a.matrixWorld.getPosition());if(d==null||d>a.scale.x)return[];return[{distance:d,point:a.position,face:null,object:a}]}else if(a instanceof THREE.Mesh){d=b(this.origin,this.direction,a.matrixWorld.getPosition());if(d==null||d>a.geometry.boundingSphere.radius*Math.max(a.scale.x,
Math.max(a.scale.y,a.scale.z)))return[];var e,g,f,h,j,l,o,i,n,k,p=a.geometry,q=p.vertices,u=[],d=0;for(e=p.faces.length;d<e;d++)if(g=p.faces[d],n=this.origin.clone(),k=this.direction.clone(),l=a.matrixWorld,f=l.multiplyVector3(g.centroid.clone()).subSelf(n),i=f.dot(k),!(i<=0)&&(f=l.multiplyVector3(q[g.a].position.clone()),h=l.multiplyVector3(q[g.b].position.clone()),j=l.multiplyVector3(q[g.c].position.clone()),l=g instanceof THREE.Face4?l.multiplyVector3(q[g.d].position.clone()):null,o=a.matrixRotationWorld.multiplyVector3(g.normal.clone()),
i=k.dot(o),a.doubleSided||(a.flipSided?i>0:i<0)))if(i=o.dot((new THREE.Vector3).sub(f,n))/i,n=n.addSelf(k.multiplyScalar(i)),g instanceof THREE.Face3)c(n,f,h,j)&&(g={distance:this.origin.distanceTo(n),point:n,face:g,object:a},u.push(g));else if(g instanceof THREE.Face4&&(c(n,f,h,l)||c(n,h,j,l)))g={distance:this.origin.distanceTo(n),point:n,face:g,object:a},u.push(g);u.sort(function(a,b){return a.distance-b.distance});return u}else return[]}};
THREE.Rectangle=function(){function a(){g=d-b;f=e-c}var b,c,d,e,g,f,h=!0;this.getX=function(){return b};this.getY=function(){return c};this.getWidth=function(){return g};this.getHeight=function(){return f};this.getLeft=function(){return b};this.getTop=function(){return c};this.getRight=function(){return d};this.getBottom=function(){return e};this.set=function(f,g,o,i){h=!1;b=f;c=g;d=o;e=i;a()};this.addPoint=function(f,g){h?(h=!1,b=f,c=g,d=f,e=g):(b=b<f?b:f,c=c<g?c:g,d=d>f?d:f,e=e>g?e:g);a()};this.add3Points=
function(f,g,o,i,n,k){h?(h=!1,b=f<o?f<n?f:n:o<n?o:n,c=g<i?g<k?g:k:i<k?i:k,d=f>o?f>n?f:n:o>n?o:n,e=g>i?g>k?g:k:i>k?i:k):(b=f<o?f<n?f<b?f:b:n<b?n:b:o<n?o<b?o:b:n<b?n:b,c=g<i?g<k?g<c?g:c:k<c?k:c:i<k?i<c?i:c:k<c?k:c,d=f>o?f>n?f>d?f:d:n>d?n:d:o>n?o>d?o:d:n>d?n:d,e=g>i?g>k?g>e?g:e:k>e?k:e:i>k?i>e?i:e:k>e?k:e);a()};this.addRectangle=function(f){h?(h=!1,b=f.getLeft(),c=f.getTop(),d=f.getRight(),e=f.getBottom()):(b=b<f.getLeft()?b:f.getLeft(),c=c<f.getTop()?c:f.getTop(),d=d>f.getRight()?d:f.getRight(),e=e>
f.getBottom()?e:f.getBottom());a()};this.inflate=function(f){b-=f;c-=f;d+=f;e+=f;a()};this.minSelf=function(f){b=b>f.getLeft()?b:f.getLeft();c=c>f.getTop()?c:f.getTop();d=d<f.getRight()?d:f.getRight();e=e<f.getBottom()?e:f.getBottom();a()};this.intersects=function(a){return Math.min(d,a.getRight())-Math.max(b,a.getLeft())>=0&&Math.min(e,a.getBottom())-Math.max(c,a.getTop())>=0};this.empty=function(){h=!0;e=d=c=b=0;a()};this.isEmpty=function(){return h}};THREE.Matrix3=function(){this.m=[]};
THREE.Matrix3.prototype={constructor:THREE.Matrix3,transpose:function(){var a,b=this.m;a=b[1];b[1]=b[3];b[3]=a;a=b[2];b[2]=b[6];b[6]=a;a=b[5];b[5]=b[7];b[7]=a;return this},transposeIntoArray:function(a){var b=this.m;a[0]=b[0];a[1]=b[3];a[2]=b[6];a[3]=b[1];a[4]=b[4];a[5]=b[7];a[6]=b[2];a[7]=b[5];a[8]=b[8];return this}};
THREE.Matrix4=function(a,b,c,d,e,g,f,h,j,l,o,i,n,k,p,q){this.set(a!==void 0?a:1,b||0,c||0,d||0,e||0,g!==void 0?g:1,f||0,h||0,j||0,l||0,o!==void 0?o:1,i||0,n||0,k||0,p||0,q!==void 0?q:1);this.flat=Array(16);this.m33=new THREE.Matrix3};
THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(a,b,c,d,e,g,f,h,j,l,o,i,n,k,p,q){this.n11=a;this.n12=b;this.n13=c;this.n14=d;this.n21=e;this.n22=g;this.n23=f;this.n24=h;this.n31=j;this.n32=l;this.n33=o;this.n34=i;this.n41=n;this.n42=k;this.n43=p;this.n44=q;return this},identity:function(){this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1);return this},copy:function(a){this.set(a.n11,a.n12,a.n13,a.n14,a.n21,a.n22,a.n23,a.n24,a.n31,a.n32,a.n33,a.n34,a.n41,a.n42,a.n43,a.n44);return this},lookAt:function(a,
b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;g.sub(a,b).normalize();if(g.length()===0)g.z=1;d.cross(c,g).normalize();d.length()===0&&(g.x+=1.0E-4,d.cross(c,g).normalize());e.cross(g,d).normalize();this.n11=d.x;this.n12=e.x;this.n13=g.x;this.n21=d.y;this.n22=e.y;this.n23=g.y;this.n31=d.z;this.n32=e.z;this.n33=g.z;return this},multiplyVector3:function(a){var b=a.x,c=a.y,d=a.z,e=1/(this.n41*b+this.n42*c+this.n43*d+this.n44);a.x=(this.n11*b+this.n12*c+this.n13*d+this.n14)*e;
a.y=(this.n21*b+this.n22*c+this.n23*d+this.n24)*e;a.z=(this.n31*b+this.n32*c+this.n33*d+this.n34)*e;return a},multiplyVector4:function(a){var b=a.x,c=a.y,d=a.z,e=a.w;a.x=this.n11*b+this.n12*c+this.n13*d+this.n14*e;a.y=this.n21*b+this.n22*c+this.n23*d+this.n24*e;a.z=this.n31*b+this.n32*c+this.n33*d+this.n34*e;a.w=this.n41*b+this.n42*c+this.n43*d+this.n44*e;return a},rotateAxis:function(a){var b=a.x,c=a.y,d=a.z;a.x=b*this.n11+c*this.n12+d*this.n13;a.y=b*this.n21+c*this.n22+d*this.n23;a.z=b*this.n31+
c*this.n32+d*this.n33;a.normalize();return a},crossVector:function(a){var b=new THREE.Vector4;b.x=this.n11*a.x+this.n12*a.y+this.n13*a.z+this.n14*a.w;b.y=this.n21*a.x+this.n22*a.y+this.n23*a.z+this.n24*a.w;b.z=this.n31*a.x+this.n32*a.y+this.n33*a.z+this.n34*a.w;b.w=a.w?this.n41*a.x+this.n42*a.y+this.n43*a.z+this.n44*a.w:1;return b},multiply:function(a,b){var c=a.n11,d=a.n12,e=a.n13,g=a.n14,f=a.n21,h=a.n22,j=a.n23,l=a.n24,o=a.n31,i=a.n32,n=a.n33,k=a.n34,p=a.n41,q=a.n42,u=a.n43,s=a.n44,K=b.n11,P=b.n12,
y=b.n13,L=b.n14,M=b.n21,r=b.n22,m=b.n23,z=b.n24,A=b.n31,R=b.n32,S=b.n33,E=b.n34,I=b.n41,G=b.n42,H=b.n43,N=b.n44;this.n11=c*K+d*M+e*A+g*I;this.n12=c*P+d*r+e*R+g*G;this.n13=c*y+d*m+e*S+g*H;this.n14=c*L+d*z+e*E+g*N;this.n21=f*K+h*M+j*A+l*I;this.n22=f*P+h*r+j*R+l*G;this.n23=f*y+h*m+j*S+l*H;this.n24=f*L+h*z+j*E+l*N;this.n31=o*K+i*M+n*A+k*I;this.n32=o*P+i*r+n*R+k*G;this.n33=o*y+i*m+n*S+k*H;this.n34=o*L+i*z+n*E+k*N;this.n41=p*K+q*M+u*A+s*I;this.n42=p*P+q*r+u*R+s*G;this.n43=p*y+q*m+u*S+s*H;this.n44=p*L+q*
z+u*E+s*N;return this},multiplyToArray:function(a,b,c){this.multiply(a,b);c[0]=this.n11;c[1]=this.n21;c[2]=this.n31;c[3]=this.n41;c[4]=this.n12;c[5]=this.n22;c[6]=this.n32;c[7]=this.n42;c[8]=this.n13;c[9]=this.n23;c[10]=this.n33;c[11]=this.n43;c[12]=this.n14;c[13]=this.n24;c[14]=this.n34;c[15]=this.n44;return this},multiplySelf:function(a){this.multiply(this,a);return this},multiplyScalar:function(a){this.n11*=a;this.n12*=a;this.n13*=a;this.n14*=a;this.n21*=a;this.n22*=a;this.n23*=a;this.n24*=a;this.n31*=
a;this.n32*=a;this.n33*=a;this.n34*=a;this.n41*=a;this.n42*=a;this.n43*=a;this.n44*=a;return this},determinant:function(){var a=this.n11,b=this.n12,c=this.n13,d=this.n14,e=this.n21,g=this.n22,f=this.n23,h=this.n24,j=this.n31,l=this.n32,o=this.n33,i=this.n34,n=this.n41,k=this.n42,p=this.n43,q=this.n44;return d*f*l*n-c*h*l*n-d*g*o*n+b*h*o*n+c*g*i*n-b*f*i*n-d*f*j*k+c*h*j*k+d*e*o*k-a*h*o*k-c*e*i*k+a*f*i*k+d*g*j*p-b*h*j*p-d*e*l*p+a*h*l*p+b*e*i*p-a*g*i*p-c*g*j*q+b*f*j*q+c*e*l*q-a*f*l*q-b*e*o*q+a*g*o*q},
transpose:function(){var a;a=this.n21;this.n21=this.n12;this.n12=a;a=this.n31;this.n31=this.n13;this.n13=a;a=this.n32;this.n32=this.n23;this.n23=a;a=this.n41;this.n41=this.n14;this.n14=a;a=this.n42;this.n42=this.n24;this.n24=a;a=this.n43;this.n43=this.n34;this.n43=a;return this},clone:function(){var a=new THREE.Matrix4;a.n11=this.n11;a.n12=this.n12;a.n13=this.n13;a.n14=this.n14;a.n21=this.n21;a.n22=this.n22;a.n23=this.n23;a.n24=this.n24;a.n31=this.n31;a.n32=this.n32;a.n33=this.n33;a.n34=this.n34;
a.n41=this.n41;a.n42=this.n42;a.n43=this.n43;a.n44=this.n44;return a},flatten:function(){this.flat[0]=this.n11;this.flat[1]=this.n21;this.flat[2]=this.n31;this.flat[3]=this.n41;this.flat[4]=this.n12;this.flat[5]=this.n22;this.flat[6]=this.n32;this.flat[7]=this.n42;this.flat[8]=this.n13;this.flat[9]=this.n23;this.flat[10]=this.n33;this.flat[11]=this.n43;this.flat[12]=this.n14;this.flat[13]=this.n24;this.flat[14]=this.n34;this.flat[15]=this.n44;return this.flat},flattenToArray:function(a){a[0]=this.n11;
a[1]=this.n21;a[2]=this.n31;a[3]=this.n41;a[4]=this.n12;a[5]=this.n22;a[6]=this.n32;a[7]=this.n42;a[8]=this.n13;a[9]=this.n23;a[10]=this.n33;a[11]=this.n43;a[12]=this.n14;a[13]=this.n24;a[14]=this.n34;a[15]=this.n44;return a},flattenToArrayOffset:function(a,b){a[b]=this.n11;a[b+1]=this.n21;a[b+2]=this.n31;a[b+3]=this.n41;a[b+4]=this.n12;a[b+5]=this.n22;a[b+6]=this.n32;a[b+7]=this.n42;a[b+8]=this.n13;a[b+9]=this.n23;a[b+10]=this.n33;a[b+11]=this.n43;a[b+12]=this.n14;a[b+13]=this.n24;a[b+14]=this.n34;
a[b+15]=this.n44;return a},setTranslation:function(a,b,c){this.set(1,0,0,a,0,1,0,b,0,0,1,c,0,0,0,1);return this},setScale:function(a,b,c){this.set(a,0,0,0,0,b,0,0,0,0,c,0,0,0,0,1);return this},setRotationX:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(1,0,0,0,0,b,-a,0,0,a,b,0,0,0,0,1);return this},setRotationY:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,0,a,0,0,1,0,0,-a,0,b,0,0,0,0,1);return this},setRotationZ:function(a){var b=Math.cos(a),a=Math.sin(a);this.set(b,-a,0,0,a,b,0,0,
0,0,1,0,0,0,0,1);return this},setRotationAxis:function(a,b){var c=Math.cos(b),d=Math.sin(b),e=1-c,g=a.x,f=a.y,h=a.z,j=e*g,l=e*f;this.set(j*g+c,j*f-d*h,j*h+d*f,0,j*f+d*h,l*f+c,l*h-d*g,0,j*h-d*f,l*h+d*g,e*h*h+c,0,0,0,0,1);return this},setPosition:function(a){this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},getPosition:function(){if(!this.position)this.position=new THREE.Vector3;this.position.set(this.n14,this.n24,this.n34);return this.position},getColumnX:function(){if(!this.columnX)this.columnX=
new THREE.Vector3;this.columnX.set(this.n11,this.n21,this.n31);return this.columnX},getColumnY:function(){if(!this.columnY)this.columnY=new THREE.Vector3;this.columnY.set(this.n12,this.n22,this.n32);return this.columnY},getColumnZ:function(){if(!this.columnZ)this.columnZ=new THREE.Vector3;this.columnZ.set(this.n13,this.n23,this.n33);return this.columnZ},setRotationFromEuler:function(a,b){var c=a.x,d=a.y,e=a.z,g=Math.cos(c),c=Math.sin(c),f=Math.cos(d),d=Math.sin(d),h=Math.cos(e),e=Math.sin(e);switch(b){case "YXZ":var j=
f*h,l=f*e,o=d*h,i=d*e;this.n11=j+i*c;this.n12=o*c-l;this.n13=g*d;this.n21=g*e;this.n22=g*h;this.n23=-c;this.n31=l*c-o;this.n32=i+j*c;this.n33=g*f;break;case "ZXY":j=f*h;l=f*e;o=d*h;i=d*e;this.n11=j-i*c;this.n12=-g*e;this.n13=o+l*c;this.n21=l+o*c;this.n22=g*h;this.n23=i-j*c;this.n31=-g*d;this.n32=c;this.n33=g*f;break;case "ZYX":j=g*h;l=g*e;o=c*h;i=c*e;this.n11=f*h;this.n12=o*d-l;this.n13=j*d+i;this.n21=f*e;this.n22=i*d+j;this.n23=l*d-o;this.n31=-d;this.n32=c*f;this.n33=g*f;break;case "YZX":j=g*f;l=
g*d;o=c*f;i=c*d;this.n11=f*h;this.n12=i-j*e;this.n13=o*e+l;this.n21=e;this.n22=g*h;this.n23=-c*h;this.n31=-d*h;this.n32=l*e+o;this.n33=j-i*e;break;case "XZY":j=g*f;l=g*d;o=c*f;i=c*d;this.n11=f*h;this.n12=-e;this.n13=d*h;this.n21=j*e+i;this.n22=g*h;this.n23=l*e-o;this.n31=o*e-l;this.n32=c*h;this.n33=i*e+j;break;default:j=g*h,l=g*e,o=c*h,i=c*e,this.n11=f*h,this.n12=-f*e,this.n13=d,this.n21=l+o*d,this.n22=j-i*d,this.n23=-c*f,this.n31=i-j*d,this.n32=o+l*d,this.n33=g*f}return this},setRotationFromQuaternion:function(a){var b=
a.x,c=a.y,d=a.z,e=a.w,g=b+b,f=c+c,h=d+d,a=b*g,j=b*f;b*=h;var l=c*f;c*=h;d*=h;g*=e;f*=e;e*=h;this.n11=1-(l+d);this.n12=j-e;this.n13=b+f;this.n21=j+e;this.n22=1-(a+d);this.n23=c-g;this.n31=b-f;this.n32=c+g;this.n33=1-(a+l);return this},scale:function(a){var b=a.x,c=a.y,a=a.z;this.n11*=b;this.n12*=c;this.n13*=a;this.n21*=b;this.n22*=c;this.n23*=a;this.n31*=b;this.n32*=c;this.n33*=a;this.n41*=b;this.n42*=c;this.n43*=a;return this},compose:function(a,b,c){var d=THREE.Matrix4.__m1,e=THREE.Matrix4.__m2;
d.identity();d.setRotationFromQuaternion(b);e.setScale(c.x,c.y,c.z);this.multiply(d,e);this.n14=a.x;this.n24=a.y;this.n34=a.z;return this},decompose:function(a,b,c){var d=THREE.Matrix4.__v1,e=THREE.Matrix4.__v2,g=THREE.Matrix4.__v3;d.set(this.n11,this.n21,this.n31);e.set(this.n12,this.n22,this.n32);g.set(this.n13,this.n23,this.n33);a=a instanceof THREE.Vector3?a:new THREE.Vector3;b=b instanceof THREE.Quaternion?b:new THREE.Quaternion;c=c instanceof THREE.Vector3?c:new THREE.Vector3;c.x=d.length();
c.y=e.length();c.z=g.length();a.x=this.n14;a.y=this.n24;a.z=this.n34;d=THREE.Matrix4.__m1;d.copy(this);d.n11/=c.x;d.n21/=c.x;d.n31/=c.x;d.n12/=c.y;d.n22/=c.y;d.n32/=c.y;d.n13/=c.z;d.n23/=c.z;d.n33/=c.z;b.setFromRotationMatrix(d);return[a,b,c]},extractPosition:function(a){this.n14=a.n14;this.n24=a.n24;this.n34=a.n34},extractRotation:function(a,b){var c=1/b.x,d=1/b.y,e=1/b.z;this.n11=a.n11*c;this.n21=a.n21*c;this.n31=a.n31*c;this.n12=a.n12*d;this.n22=a.n22*d;this.n32=a.n32*d;this.n13=a.n13*e;this.n23=
a.n23*e;this.n33=a.n33*e}};
THREE.Matrix4.makeInvert=function(a,b){var c=a.n11,d=a.n12,e=a.n13,g=a.n14,f=a.n21,h=a.n22,j=a.n23,l=a.n24,o=a.n31,i=a.n32,n=a.n33,k=a.n34,p=a.n41,q=a.n42,u=a.n43,s=a.n44;b===void 0&&(b=new THREE.Matrix4);b.n11=j*k*q-l*n*q+l*i*u-h*k*u-j*i*s+h*n*s;b.n12=g*n*q-e*k*q-g*i*u+d*k*u+e*i*s-d*n*s;b.n13=e*l*q-g*j*q+g*h*u-d*l*u-e*h*s+d*j*s;b.n14=g*j*i-e*l*i-g*h*n+d*l*n+e*h*k-d*j*k;b.n21=l*n*p-j*k*p-l*o*u+f*k*u+j*o*s-f*n*s;b.n22=e*k*p-g*n*p+g*o*u-c*k*u-e*o*s+c*n*s;b.n23=g*j*p-e*l*p-g*f*u+c*l*u+e*f*s-c*j*s;b.n24=
e*l*o-g*j*o+g*f*n-c*l*n-e*f*k+c*j*k;b.n31=h*k*p-l*i*p+l*o*q-f*k*q-h*o*s+f*i*s;b.n32=g*i*p-d*k*p-g*o*q+c*k*q+d*o*s-c*i*s;b.n33=e*l*p-g*h*p+g*f*q-c*l*q-d*f*s+c*h*s;b.n34=g*h*o-d*l*o-g*f*i+c*l*i+d*f*k-c*h*k;b.n41=j*i*p-h*n*p-j*o*q+f*n*q+h*o*u-f*i*u;b.n42=d*n*p-e*i*p+e*o*q-c*n*q-d*o*u+c*i*u;b.n43=e*h*p-d*j*p-e*f*q+c*j*q+d*f*u-c*h*u;b.n44=d*j*o-e*h*o+e*f*i-c*j*i-d*f*n+c*h*n;b.multiplyScalar(1/a.determinant());return b};
THREE.Matrix4.makeInvert3x3=function(a){var b=a.m33,c=b.m,d=a.n33*a.n22-a.n32*a.n23,e=-a.n33*a.n21+a.n31*a.n23,g=a.n32*a.n21-a.n31*a.n22,f=-a.n33*a.n12+a.n32*a.n13,h=a.n33*a.n11-a.n31*a.n13,j=-a.n32*a.n11+a.n31*a.n12,l=a.n23*a.n12-a.n22*a.n13,o=-a.n23*a.n11+a.n21*a.n13,i=a.n22*a.n11-a.n21*a.n12,a=a.n11*d+a.n21*f+a.n31*l;a==0&&console.error("THREE.Matrix4.makeInvert3x3: Matrix not invertible.");a=1/a;c[0]=a*d;c[1]=a*e;c[2]=a*g;c[3]=a*f;c[4]=a*h;c[5]=a*j;c[6]=a*l;c[7]=a*o;c[8]=a*i;return b};
THREE.Matrix4.makeFrustum=function(a,b,c,d,e,g){var f;f=new THREE.Matrix4;f.n11=2*e/(b-a);f.n12=0;f.n13=(b+a)/(b-a);f.n14=0;f.n21=0;f.n22=2*e/(d-c);f.n23=(d+c)/(d-c);f.n24=0;f.n31=0;f.n32=0;f.n33=-(g+e)/(g-e);f.n34=-2*g*e/(g-e);f.n41=0;f.n42=0;f.n43=-1;f.n44=0;return f};THREE.Matrix4.makePerspective=function(a,b,c,d){var e,a=c*Math.tan(a*Math.PI/360);e=-a;return THREE.Matrix4.makeFrustum(e*b,a*b,e,a,c,d)};
THREE.Matrix4.makeOrtho=function(a,b,c,d,e,g){var f,h,j,l;f=new THREE.Matrix4;h=b-a;j=c-d;l=g-e;f.n11=2/h;f.n12=0;f.n13=0;f.n14=-((b+a)/h);f.n21=0;f.n22=2/j;f.n23=0;f.n24=-((c+d)/j);f.n31=0;f.n32=0;f.n33=-2/l;f.n34=-((g+e)/l);f.n41=0;f.n42=0;f.n43=0;f.n44=1;return f};THREE.Matrix4.__v1=new THREE.Vector3;THREE.Matrix4.__v2=new THREE.Vector3;THREE.Matrix4.__v3=new THREE.Vector3;THREE.Matrix4.__m1=new THREE.Matrix4;THREE.Matrix4.__m2=new THREE.Matrix4;
THREE.Object3D=function(){this.id=THREE.Object3DCount++;this.name="";this.parent=void 0;this.children=[];this.up=new THREE.Vector3(0,1,0);this.position=new THREE.Vector3;this.rotation=new THREE.Vector3;this.eulerOrder="XYZ";this.scale=new THREE.Vector3(1,1,1);this.flipSided=this.doubleSided=this.dynamic=!1;this.renderDepth=null;this.rotationAutoUpdate=!0;this.matrix=new THREE.Matrix4;this.matrixWorld=new THREE.Matrix4;this.matrixRotationWorld=new THREE.Matrix4;this.matrixWorldNeedsUpdate=this.matrixAutoUpdate=
!0;this.quaternion=new THREE.Quaternion;this.useQuaternion=!1;this.boundRadius=0;this.boundRadiusScale=1;this.visible=!0;this.receiveShadow=this.castShadow=!1;this.frustumCulled=!0;this._vector=new THREE.Vector3};
THREE.Object3D.prototype={constructor:THREE.Object3D,translate:function(a,b){this.matrix.rotateAxis(b);this.position.addSelf(b.multiplyScalar(a))},translateX:function(a){this.translate(a,this._vector.set(1,0,0))},translateY:function(a){this.translate(a,this._vector.set(0,1,0))},translateZ:function(a){this.translate(a,this._vector.set(0,0,1))},lookAt:function(a){this.matrix.lookAt(a,this.position,this.up);this.rotationAutoUpdate&&this.rotation.setRotationFromMatrix(this.matrix)},add:function(a){if(this.children.indexOf(a)===
-1){a.parent!==void 0&&a.parent.removeChild(a);a.parent=this;this.children.push(a);for(var b=this;b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.addChildRecurse(a)}},remove:function(a){var b=this,c=this.children.indexOf(a);if(c!==-1){a.parent=void 0;for(this.children.splice(c,1);b.parent!==void 0;)b=b.parent;b!==void 0&&b instanceof THREE.Scene&&b.removeChildRecurse(a)}},getChildByName:function(a,b){var c,d,e;c=0;for(d=this.children.length;c<d;c++){e=this.children[c];if(e.name===
a)return e;if(b&&(e=e.getChildByName(a,b),e!==void 0))return e}},updateMatrix:function(){this.matrix.setPosition(this.position);this.useQuaternion?this.matrix.setRotationFromQuaternion(this.quaternion):this.matrix.setRotationFromEuler(this.rotation,this.eulerOrder);if(this.scale.x!==1||this.scale.y!==1||this.scale.z!==1)this.matrix.scale(this.scale),this.boundRadiusScale=Math.max(this.scale.x,Math.max(this.scale.y,this.scale.z));this.matrixWorldNeedsUpdate=!0},update:function(a,b,c){this.matrixAutoUpdate&&
this.updateMatrix();if(this.matrixWorldNeedsUpdate||b)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixRotationWorld.extractRotation(this.matrixWorld,this.scale),this.matrixWorldNeedsUpdate=!1,b=!0;for(var a=0,d=this.children.length;a<d;a++)this.children[a].update(this.matrixWorld,b,c)},addChild:function(a){console.warn("DEPRECATED: Object3D.addChild() is now Object3D.add()");this.add(a)},removeChild:function(a){console.warn("DEPRECATED: Object3D.removeChild() is now Object3D.remove()");
this.remove(a)}};THREE.Object3DCount=0;
THREE.Projector=function(){function a(){var a=j[h]=j[h]||new THREE.RenderableVertex;h++;return a}function b(a,b){return b.z-a.z}function c(a,b){var c=0,d=1,e=a.z+a.w,f=b.z+b.w,g=-a.z+a.w,h=-b.z+b.w;return e>=0&&f>=0&&g>=0&&h>=0?!0:e<0&&f<0||g<0&&h<0?!1:(e<0?c=Math.max(c,e/(e-f)):f<0&&(d=Math.min(d,e/(e-f))),g<0?c=Math.max(c,g/(g-h)):h<0&&(d=Math.min(d,g/(g-h))),d<c?!1:(a.lerpSelf(b,c),b.lerpSelf(a,1-d),!0))}var d,e,g=[],f,h,j=[],l,o,i=[],n,k=[],p,q,u=[],s,K,P=[],y=[],L=[],M=new THREE.Vector4,r=new THREE.Vector4,
m=new THREE.Matrix4,z=new THREE.Matrix4,A=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],R=new THREE.Vector4,S=new THREE.Vector4;this.projectVector=function(a,b){m.multiply(b.projectionMatrix,b.matrixWorldInverse);m.multiplyVector3(a);return a};this.unprojectVector=function(a,b){m.multiply(b.matrixWorld,THREE.Matrix4.makeInvert(b.projectionMatrix));m.multiplyVector3(a);return a};this.projectObjects=function(a,c,f){var h,k;e=y.length=0;
h=a.objects;a=0;for(c=h.length;a<c;a++){k=h[a];var l;if(!(l=!k.visible))if(l=k instanceof THREE.Mesh)if(l=k.frustumCulled){a:{l=void 0;for(var i=k.matrixWorld,j=-k.geometry.boundingSphere.radius*Math.max(k.scale.x,Math.max(k.scale.y,k.scale.z)),o=0;o<6;o++)if(l=A[o].x*i.n14+A[o].y*i.n24+A[o].z*i.n34+A[o].w,l<=j){l=!1;break a}l=!0}l=!l}if(!l)l=g[e]=g[e]||new THREE.RenderableObject,e++,d=l,M.copy(k.position),m.multiplyVector3(M),d.object=k,d.z=M.z,y.push(d)}f&&y.sort(b);return y};this.projectScene=
function(d,e,g){var H=e.near,N=e.far,O,U,D,y,v,J,F,w,C,t,B,T,M,da,Y,aa,V;K=q=n=o=L.length=0;e.matrixAutoUpdate&&e.update(void 0,!0);d.update(void 0,!1,e);m.multiply(e.projectionMatrix,e.matrixWorldInverse);A[0].set(m.n41-m.n11,m.n42-m.n12,m.n43-m.n13,m.n44-m.n14);A[1].set(m.n41+m.n11,m.n42+m.n12,m.n43+m.n13,m.n44+m.n14);A[2].set(m.n41+m.n21,m.n42+m.n22,m.n43+m.n23,m.n44+m.n24);A[3].set(m.n41-m.n21,m.n42-m.n22,m.n43-m.n23,m.n44-m.n24);A[4].set(m.n41-m.n31,m.n42-m.n32,m.n43-m.n33,m.n44-m.n34);A[5].set(m.n41+
m.n31,m.n42+m.n32,m.n43+m.n33,m.n44+m.n34);for(O=0;O<6;O++)C=A[O],C.divideScalar(Math.sqrt(C.x*C.x+C.y*C.y+C.z*C.z));C=this.projectObjects(d,e,!0);d=0;for(O=C.length;d<O;d++)if(t=C[d].object,t.visible)if(B=t.matrixWorld,T=t.matrixRotationWorld,M=t.materials,da=t.overdraw,h=0,t instanceof THREE.Mesh){Y=t.geometry;y=Y.vertices;aa=Y.faces;Y=Y.faceVertexUvs;U=0;for(D=y.length;U<D;U++)f=a(),f.positionWorld.copy(y[U].position),B.multiplyVector3(f.positionWorld),f.positionScreen.copy(f.positionWorld),m.multiplyVector4(f.positionScreen),
f.positionScreen.x/=f.positionScreen.w,f.positionScreen.y/=f.positionScreen.w,f.visible=f.positionScreen.z>H&&f.positionScreen.z<N;y=0;for(U=aa.length;y<U;y++){D=aa[y];if(D instanceof THREE.Face3)if(v=j[D.a],J=j[D.b],F=j[D.c],v.visible&&J.visible&&F.visible&&(t.doubleSided||t.flipSided!=(F.positionScreen.x-v.positionScreen.x)*(J.positionScreen.y-v.positionScreen.y)-(F.positionScreen.y-v.positionScreen.y)*(J.positionScreen.x-v.positionScreen.x)<0))w=i[o]=i[o]||new THREE.RenderableFace3,o++,l=w,l.v1.copy(v),
l.v2.copy(J),l.v3.copy(F);else continue;else if(D instanceof THREE.Face4)if(v=j[D.a],J=j[D.b],F=j[D.c],w=j[D.d],v.visible&&J.visible&&F.visible&&w.visible&&(t.doubleSided||t.flipSided!=((w.positionScreen.x-v.positionScreen.x)*(J.positionScreen.y-v.positionScreen.y)-(w.positionScreen.y-v.positionScreen.y)*(J.positionScreen.x-v.positionScreen.x)<0||(J.positionScreen.x-F.positionScreen.x)*(w.positionScreen.y-F.positionScreen.y)-(J.positionScreen.y-F.positionScreen.y)*(w.positionScreen.x-F.positionScreen.x)<
0)))V=k[n]=k[n]||new THREE.RenderableFace4,n++,l=V,l.v1.copy(v),l.v2.copy(J),l.v3.copy(F),l.v4.copy(w);else continue;l.normalWorld.copy(D.normal);T.multiplyVector3(l.normalWorld);l.centroidWorld.copy(D.centroid);B.multiplyVector3(l.centroidWorld);l.centroidScreen.copy(l.centroidWorld);m.multiplyVector3(l.centroidScreen);F=D.vertexNormals;v=0;for(J=F.length;v<J;v++)w=l.vertexNormalsWorld[v],w.copy(F[v]),T.multiplyVector3(w);v=0;for(J=Y.length;v<J;v++)if(V=Y[v][y]){F=0;for(w=V.length;F<w;F++)l.uvs[v][F]=
V[F]}l.meshMaterials=M;l.faceMaterials=D.materials;l.overdraw=da;l.z=l.centroidScreen.z;L.push(l)}}else if(t instanceof THREE.Line){z.multiply(m,B);y=t.geometry.vertices;v=a();v.positionScreen.copy(y[0].position);z.multiplyVector4(v.positionScreen);U=1;for(D=y.length;U<D;U++)if(v=a(),v.positionScreen.copy(y[U].position),z.multiplyVector4(v.positionScreen),J=j[h-2],R.copy(v.positionScreen),S.copy(J.positionScreen),c(R,S))R.multiplyScalar(1/R.w),S.multiplyScalar(1/S.w),B=u[q]=u[q]||new THREE.RenderableLine,
q++,p=B,p.v1.positionScreen.copy(R),p.v2.positionScreen.copy(S),p.z=Math.max(R.z,S.z),p.materials=t.materials,L.push(p)}else if(t instanceof THREE.Particle&&(r.set(t.matrixWorld.n14,t.matrixWorld.n24,t.matrixWorld.n34,1),m.multiplyVector4(r),r.z/=r.w,r.z>0&&r.z<1))B=P[K]=P[K]||new THREE.RenderableParticle,K++,s=B,s.x=r.x/r.w,s.y=r.y/r.w,s.z=r.z,s.rotation=t.rotation.z,s.scale.x=t.scale.x*Math.abs(s.x-(r.x+e.projectionMatrix.n11)/(r.w+e.projectionMatrix.n14)),s.scale.y=t.scale.y*Math.abs(s.y-(r.y+
e.projectionMatrix.n22)/(r.w+e.projectionMatrix.n24)),s.materials=t.materials,L.push(s);g&&L.sort(b);return L}};THREE.Quaternion=function(a,b,c,d){this.set(a||0,b||0,c||0,d!==void 0?d:1)};
THREE.Quaternion.prototype={constructor:THREE.Quaternion,set:function(a,b,c,d){this.x=a;this.y=b;this.z=c;this.w=d;return this},copy:function(a){this.x=a.x;this.y=a.y;this.z=a.z;this.w=a.w;return this},setFromEuler:function(a){var b=0.5*Math.PI/360,c=a.x*b,d=a.y*b,e=a.z*b,a=Math.cos(d),d=Math.sin(d),b=Math.cos(-e),e=Math.sin(-e),g=Math.cos(c),c=Math.sin(c),f=a*b,h=d*e;this.w=f*g-h*c;this.x=f*c+h*g;this.y=d*b*g+a*e*c;this.z=a*e*g-d*b*c;return this},setFromAxisAngle:function(a,b){var c=b/2,d=Math.sin(c);
this.x=a.x*d;this.y=a.y*d;this.z=a.z*d;this.w=Math.cos(c);return this},setFromRotationMatrix:function(a){var b=Math.pow(a.determinant(),1/3);this.w=Math.sqrt(Math.max(0,b+a.n11+a.n22+a.n33))/2;this.x=Math.sqrt(Math.max(0,b+a.n11-a.n22-a.n33))/2;this.y=Math.sqrt(Math.max(0,b-a.n11+a.n22-a.n33))/2;this.z=Math.sqrt(Math.max(0,b-a.n11-a.n22+a.n33))/2;this.x=a.n32-a.n23<0?-Math.abs(this.x):Math.abs(this.x);this.y=a.n13-a.n31<0?-Math.abs(this.y):Math.abs(this.y);this.z=a.n21-a.n12<0?-Math.abs(this.z):Math.abs(this.z);
this.normalize();return this},calculateW:function(){this.w=-Math.sqrt(Math.abs(1-this.x*this.x-this.y*this.y-this.z*this.z));return this},inverse:function(){this.x*=-1;this.y*=-1;this.z*=-1;return this},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},normalize:function(){var a=Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w);a==0?this.w=this.z=this.y=this.x=0:(a=1/a,this.x*=a,this.y*=a,this.z*=a,this.w*=a);return this},multiplySelf:function(a){var b=
this.x,c=this.y,d=this.z,e=this.w,g=a.x,f=a.y,h=a.z,a=a.w;this.x=b*a+e*g+c*h-d*f;this.y=c*a+e*f+d*g-b*h;this.z=d*a+e*h+b*f-c*g;this.w=e*a-b*g-c*f-d*h;return this},multiply:function(a,b){this.x=a.x*b.w+a.y*b.z-a.z*b.y+a.w*b.x;this.y=-a.x*b.z+a.y*b.w+a.z*b.x+a.w*b.y;this.z=a.x*b.y-a.y*b.x+a.z*b.w+a.w*b.z;this.w=-a.x*b.x-a.y*b.y-a.z*b.z+a.w*b.w;return this},multiplyVector3:function(a,b){b||(b=a);var c=a.x,d=a.y,e=a.z,g=this.x,f=this.y,h=this.z,j=this.w,l=j*c+f*e-h*d,o=j*d+h*c-g*e,i=j*e+g*d-f*c,c=-g*
c-f*d-h*e;b.x=l*j+c*-g+o*-h-i*-f;b.y=o*j+c*-f+i*-g-l*-h;b.z=i*j+c*-h+l*-f-o*-g;return b}};THREE.Quaternion.slerp=function(a,b,c,d){var e=a.w*b.w+a.x*b.x+a.y*b.y+a.z*b.z;if(Math.abs(e)>=1)return c.w=a.w,c.x=a.x,c.y=a.y,c.z=a.z,c;var g=Math.acos(e),f=Math.sqrt(1-e*e);if(Math.abs(f)<0.0010)return c.w=0.5*(a.w+b.w),c.x=0.5*(a.x+b.x),c.y=0.5*(a.y+b.y),c.z=0.5*(a.z+b.z),c;e=Math.sin((1-d)*g)/f;d=Math.sin(d*g)/f;c.w=a.w*e+b.w*d;c.x=a.x*e+b.x*d;c.y=a.y*e+b.y*d;c.z=a.z*e+b.z*d;return c};
THREE.Vertex=function(a){this.position=a||new THREE.Vector3};THREE.Face3=function(a,b,c,d,e,g){this.a=a;this.b=b;this.c=c;this.normal=d instanceof THREE.Vector3?d:new THREE.Vector3;this.vertexNormals=d instanceof Array?d:[];this.color=e instanceof THREE.Color?e:new THREE.Color;this.vertexColors=e instanceof Array?e:[];this.vertexTangents=[];this.materials=g instanceof Array?g:[g];this.centroid=new THREE.Vector3};
THREE.Face4=function(a,b,c,d,e,g,f){this.a=a;this.b=b;this.c=c;this.d=d;this.normal=e instanceof THREE.Vector3?e:new THREE.Vector3;this.vertexNormals=e instanceof Array?e:[];this.color=g instanceof THREE.Color?g:new THREE.Color;this.vertexColors=g instanceof Array?g:[];this.vertexTangents=[];this.materials=f instanceof Array?f:[f];this.centroid=new THREE.Vector3};THREE.UV=function(a,b){this.u=a||0;this.v=b||0};
THREE.UV.prototype={constructor:THREE.UV,set:function(a,b){this.u=a;this.v=b;return this},copy:function(a){this.u=a.u;this.v=a.v;return this},clone:function(){return new THREE.UV(this.u,this.v)}};
THREE.Geometry=function(){this.id=THREE.GeometryCount++;this.vertices=[];this.colors=[];this.faces=[];this.edges=[];this.faceUvs=[[]];this.faceVertexUvs=[[]];this.morphTargets=[];this.morphColors=[];this.skinWeights=[];this.skinIndices=[];this.boundingSphere=this.boundingBox=null;this.dynamic=this.hasTangents=!1};
THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(a){var b=new THREE.Matrix4;b.extractRotation(a,new THREE.Vector3(1,1,1));for(var c=0,d=this.vertices.length;c<d;c++)a.multiplyVector3(this.vertices[c].position);c=0;for(d=this.faces.length;c<d;c++){var e=this.faces[c];b.multiplyVector3(e.normal);for(var g=0,f=e.vertexNormals.length;g<f;g++)b.multiplyVector3(e.vertexNormals[g]);a.multiplyVector3(e.centroid)}},computeCentroids:function(){var a,b,c;a=0;for(b=this.faces.length;a<
b;a++)c=this.faces[a],c.centroid.set(0,0,0),c instanceof THREE.Face3?(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.divideScalar(3)):c instanceof THREE.Face4&&(c.centroid.addSelf(this.vertices[c.a].position),c.centroid.addSelf(this.vertices[c.b].position),c.centroid.addSelf(this.vertices[c.c].position),c.centroid.addSelf(this.vertices[c.d].position),c.centroid.divideScalar(4))},computeFaceNormals:function(a){var b,
c,d,e,g,f,h=new THREE.Vector3,j=new THREE.Vector3;d=0;for(e=this.faces.length;d<e;d++){g=this.faces[d];if(a&&g.vertexNormals.length){h.set(0,0,0);b=0;for(c=g.vertexNormals.length;b<c;b++)h.addSelf(g.vertexNormals[b]);h.divideScalar(3)}else b=this.vertices[g.a],c=this.vertices[g.b],f=this.vertices[g.c],h.sub(f.position,c.position),j.sub(b.position,c.position),h.crossSelf(j);h.isZero()||h.normalize();g.normal.copy(h)}},computeVertexNormals:function(){var a,b,c,d;if(this.__tmpVertices==void 0){d=this.__tmpVertices=
Array(this.vertices.length);a=0;for(b=this.vertices.length;a<b;a++)d[a]=new THREE.Vector3;a=0;for(b=this.faces.length;a<b;a++)if(c=this.faces[a],c instanceof THREE.Face3)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];else if(c instanceof THREE.Face4)c.vertexNormals=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3]}else{d=this.__tmpVertices;a=0;for(b=this.vertices.length;a<b;a++)d[a].set(0,0,0)}a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof
THREE.Face3?(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal)):c instanceof THREE.Face4&&(d[c.a].addSelf(c.normal),d[c.b].addSelf(c.normal),d[c.c].addSelf(c.normal),d[c.d].addSelf(c.normal));a=0;for(b=this.vertices.length;a<b;a++)d[a].normalize();a=0;for(b=this.faces.length;a<b;a++)c=this.faces[a],c instanceof THREE.Face3?(c.vertexNormals[0].copy(d[c.a]),c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c])):c instanceof THREE.Face4&&(c.vertexNormals[0].copy(d[c.a]),
c.vertexNormals[1].copy(d[c.b]),c.vertexNormals[2].copy(d[c.c]),c.vertexNormals[3].copy(d[c.d]))},computeTangents:function(){function a(a,b,c,d,e,g,m){h=a.vertices[b].position;j=a.vertices[c].position;l=a.vertices[d].position;o=f[e];i=f[g];n=f[m];k=j.x-h.x;p=l.x-h.x;q=j.y-h.y;u=l.y-h.y;s=j.z-h.z;K=l.z-h.z;P=i.u-o.u;y=n.u-o.u;L=i.v-o.v;M=n.v-o.v;r=1/(P*M-y*L);R.set((M*k-L*p)*r,(M*q-L*u)*r,(M*s-L*K)*r);S.set((P*p-y*k)*r,(P*u-y*q)*r,(P*K-y*s)*r);z[b].addSelf(R);z[c].addSelf(R);z[d].addSelf(R);A[b].addSelf(S);
A[c].addSelf(S);A[d].addSelf(S)}var b,c,d,e,g,f,h,j,l,o,i,n,k,p,q,u,s,K,P,y,L,M,r,m,z=[],A=[],R=new THREE.Vector3,S=new THREE.Vector3,E=new THREE.Vector3,I=new THREE.Vector3,G=new THREE.Vector3;b=0;for(c=this.vertices.length;b<c;b++)z[b]=new THREE.Vector3,A[b]=new THREE.Vector3;b=0;for(c=this.faces.length;b<c;b++)g=this.faces[b],f=this.faceVertexUvs[0][b],g instanceof THREE.Face3?a(this,g.a,g.b,g.c,0,1,2):g instanceof THREE.Face4&&(a(this,g.a,g.b,g.c,0,1,2),a(this,g.a,g.b,g.d,0,1,3));var H=["a","b",
"c","d"];b=0;for(c=this.faces.length;b<c;b++){g=this.faces[b];for(d=0;d<g.vertexNormals.length;d++)G.copy(g.vertexNormals[d]),e=g[H[d]],m=z[e],E.copy(m),E.subSelf(G.multiplyScalar(G.dot(m))).normalize(),I.cross(g.vertexNormals[d],m),e=I.dot(A[e]),e=e<0?-1:1,g.vertexTangents[d]=new THREE.Vector4(E.x,E.y,E.z,e)}this.hasTangents=!0},computeBoundingBox:function(){var a;if(this.vertices.length>0){this.boundingBox={x:[this.vertices[0].position.x,this.vertices[0].position.x],y:[this.vertices[0].position.y,
this.vertices[0].position.y],z:[this.vertices[0].position.z,this.vertices[0].position.z]};for(var b=1,c=this.vertices.length;b<c;b++){a=this.vertices[b];if(a.position.x<this.boundingBox.x[0])this.boundingBox.x[0]=a.position.x;else if(a.position.x>this.boundingBox.x[1])this.boundingBox.x[1]=a.position.x;if(a.position.y<this.boundingBox.y[0])this.boundingBox.y[0]=a.position.y;else if(a.position.y>this.boundingBox.y[1])this.boundingBox.y[1]=a.position.y;if(a.position.z<this.boundingBox.z[0])this.boundingBox.z[0]=
a.position.z;else if(a.position.z>this.boundingBox.z[1])this.boundingBox.z[1]=a.position.z}}},computeBoundingSphere:function(){for(var a=0,b=0,c=this.vertices.length;b<c;b++)a=Math.max(a,this.vertices[b].position.length());this.boundingSphere={radius:a}},computeEdgeFaces:function(){function a(a,b){return Math.min(a,b)+"_"+Math.max(a,b)}function b(a,b,c){a[b]===void 0?(a[b]={set:{},array:[]},a[b].set[c]=1,a[b].array.push(c)):a[b].set[c]===void 0&&(a[b].set[c]=1,a[b].array.push(c))}var c,d,e,g,f,h=
{};c=0;for(d=this.faces.length;c<d;c++)f=this.faces[c],f instanceof THREE.Face3?(e=a(f.a,f.b),b(h,e,c),e=a(f.b,f.c),b(h,e,c),e=a(f.a,f.c),b(h,e,c)):f instanceof THREE.Face4&&(e=a(f.b,f.d),b(h,e,c),e=a(f.a,f.b),b(h,e,c),e=a(f.a,f.d),b(h,e,c),e=a(f.b,f.c),b(h,e,c),e=a(f.c,f.d),b(h,e,c));c=0;for(d=this.edges.length;c<d;c++){f=this.edges[c];e=f.vertexIndices[0];g=f.vertexIndices[1];f.faceIndices=h[a(e,g)].array;for(e=0;e<f.faceIndices.length;e++)g=f.faceIndices[e],f.faces.push(this.faces[g])}}};
THREE.GeometryCount=0;THREE.Camera=function(a,b,c,d,e){THREE.Object3D.call(this);this.fov=a||50;this.aspect=b||1;this.near=c!==void 0?c:0.1;this.far=d!==void 0?d:2E3;this.target=e||new THREE.Object3D;this.useTarget=!0;this.matrixWorldInverse=new THREE.Matrix4;this.projectionMatrix=null;this.updateProjectionMatrix()};THREE.Camera.prototype=new THREE.Object3D;THREE.Camera.prototype.constructor=THREE.Camera;THREE.Camera.prototype.supr=THREE.Object3D.prototype;
THREE.Camera.prototype.translate=function(a,b){this.matrix.rotateAxis(b);b.multiplyScalar(a);this.position.addSelf(b);this.target.position.addSelf(b)};
THREE.Camera.prototype.updateProjectionMatrix=function(){if(this.fullWidth){var a=this.fullWidth/this.fullHeight,b=Math.tan(this.fov*Math.PI/360)*this.near,c=-b,d=a*c,a=Math.abs(a*b-d),c=Math.abs(b-c);this.projectionMatrix=THREE.Matrix4.makeFrustum(d+this.x*a/this.fullWidth,d+(this.x+this.width)*a/this.fullWidth,b-(this.y+this.height)*c/this.fullHeight,b-this.y*c/this.fullHeight,this.near,this.far)}else this.projectionMatrix=THREE.Matrix4.makePerspective(this.fov,this.aspect,this.near,this.far)};
THREE.Camera.prototype.setViewOffset=function(a,b,c,d,e,g){this.fullWidth=a;this.fullHeight=b;this.x=c;this.y=d;this.width=e;this.height=g;this.updateProjectionMatrix()};
THREE.Camera.prototype.update=function(a,b,c){if(this.useTarget)this.matrix.lookAt(this.position,this.target.position,this.up),this.matrix.setPosition(this.position),a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse),b=!0;else if(this.matrixAutoUpdate&&this.updateMatrix(),b||this.matrixWorldNeedsUpdate)a?this.matrixWorld.multiply(a,this.matrix):this.matrixWorld.copy(this.matrix),this.matrixWorldNeedsUpdate=
!1,b=!0,THREE.Matrix4.makeInvert(this.matrixWorld,this.matrixWorldInverse);for(a=0;a<this.children.length;a++)this.children[a].update(this.matrixWorld,b,c)};THREE.OrthoCamera=function(a,b,c,d,e,g,f){THREE.Camera.call(this,45,1,e,g,f);this.left=a;this.right=b;this.top=c;this.bottom=d;this.updateProjectionMatrix()};THREE.OrthoCamera.prototype=new THREE.Camera;THREE.OrthoCamera.prototype.constructor=THREE.OrthoCamera;
THREE.OrthoCamera.prototype.updateProjectionMatrix=function(){this.projectionMatrix=THREE.Matrix4.makeOrtho(this.left,this.right,this.top,this.bottom,this.near,this.far)};THREE.Light=function(a){THREE.Object3D.call(this);this.color=new THREE.Color(a)};THREE.Light.prototype=new THREE.Object3D;THREE.Light.prototype.constructor=THREE.Light;THREE.Light.prototype.supr=THREE.Object3D.prototype;THREE.AmbientLight=function(a){THREE.Light.call(this,a)};THREE.AmbientLight.prototype=new THREE.Light;
THREE.AmbientLight.prototype.constructor=THREE.AmbientLight;THREE.DirectionalLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,1,0);this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0};THREE.DirectionalLight.prototype=new THREE.Light;THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight;THREE.PointLight=function(a,b,c){THREE.Light.call(this,a);this.position=new THREE.Vector3(0,0,0);this.intensity=b!==void 0?b:1;this.distance=c!==void 0?c:0};
THREE.PointLight.prototype=new THREE.Light;THREE.PointLight.prototype.constructor=THREE.PointLight;
THREE.Material=function(a){this.id=THREE.MaterialCount++;a=a||{};this.opacity=a.opacity!==void 0?a.opacity:1;this.transparent=a.transparent!==void 0?a.transparent:!1;this.blending=a.blending!==void 0?a.blending:THREE.NormalBlending;this.depthTest=a.depthTest!==void 0?a.depthTest:!0;this.depthWrite=a.depthWrite!==void 0?a.depthWrite:!0;this.polygonOffset=a.polygonOffset!==void 0?a.polygonOffset:!1;this.polygonOffsetFactor=a.polygonOffsetFactor!==void 0?a.polygonOffsetFactor:0;this.polygonOffsetUnits=
a.polygonOffsetUnits!==void 0?a.polygonOffsetUnits:0;this.alphaTest=a.alphaTest!==void 0?a.alphaTest:0};THREE.MaterialCount=0;THREE.NoShading=0;THREE.FlatShading=1;THREE.SmoothShading=2;THREE.NoColors=0;THREE.FaceColors=1;THREE.VertexColors=2;THREE.NormalBlending=0;THREE.AdditiveBlending=1;THREE.SubtractiveBlending=2;THREE.MultiplyBlending=3;THREE.AdditiveAlphaBlending=4;
THREE.LineBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.linewidth=a.linewidth!==void 0?a.linewidth:1;this.linecap=a.linecap!==void 0?a.linecap:"round";this.linejoin=a.linejoin!==void 0?a.linejoin:"round";this.vertexColors=a.vertexColors?a.vertexColors:!1;this.fog=a.fog!==void 0?a.fog:!0};THREE.LineBasicMaterial.prototype=new THREE.Material;THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial;
THREE.MeshBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:
!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:
!1};THREE.MeshBasicMaterial.prototype=new THREE.Material;THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial;
THREE.MeshLambertMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?
a.fog:!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?
a.morphTargets:!1};THREE.MeshLambertMaterial.prototype=new THREE.Material;THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial;
THREE.MeshPhongMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.ambient=a.ambient!==void 0?new THREE.Color(a.ambient):new THREE.Color(328965);this.specular=a.specular!==void 0?new THREE.Color(a.specular):new THREE.Color(1118481);this.shininess=a.shininess!==void 0?a.shininess:30;this.map=a.map!==void 0?a.map:null;this.lightMap=a.lightMap!==void 0?a.lightMap:null;this.envMap=a.envMap!==void 0?a.envMap:null;
this.combine=a.combine!==void 0?a.combine:THREE.MultiplyOperation;this.reflectivity=a.reflectivity!==void 0?a.reflectivity:1;this.refractionRatio=a.refractionRatio!==void 0?a.refractionRatio:0.98;this.fog=a.fog!==void 0?a.fog:!0;this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1;this.wireframeLinecap=a.wireframeLinecap!==void 0?a.wireframeLinecap:"round";this.wireframeLinejoin=
a.wireframeLinejoin!==void 0?a.wireframeLinejoin:"round";this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.skinning=a.skinning!==void 0?a.skinning:!1;this.morphTargets=a.morphTargets!==void 0?a.morphTargets:!1};THREE.MeshPhongMaterial.prototype=new THREE.Material;THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial;
THREE.MeshDepthMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading!==void 0?a.shading:THREE.SmoothShading;this.wireframe=a.wireframe!==void 0?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth!==void 0?a.wireframeLinewidth:1};THREE.MeshDepthMaterial.prototype=new THREE.Material;THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial;
THREE.MeshNormalMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.shading=a.shading?a.shading:THREE.FlatShading;this.wireframe=a.wireframe?a.wireframe:!1;this.wireframeLinewidth=a.wireframeLinewidth?a.wireframeLinewidth:1};THREE.MeshNormalMaterial.prototype=new THREE.Material;THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial;THREE.MeshFaceMaterial=function(){};
THREE.ParticleBasicMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.map=a.map!==void 0?a.map:null;this.size=a.size!==void 0?a.size:1;this.sizeAttenuation=a.sizeAttenuation!==void 0?a.sizeAttenuation:!0;this.vertexColors=a.vertexColors!==void 0?a.vertexColors:!1;this.fog=a.fog!==void 0?a.fog:!0};THREE.ParticleBasicMaterial.prototype=new THREE.Material;THREE.ParticleBasicMaterial.prototype.constructor=THREE.ParticleBasicMaterial;
THREE.ParticleCanvasMaterial=function(a){THREE.Material.call(this,a);a=a||{};this.color=a.color!==void 0?new THREE.Color(a.color):new THREE.Color(16777215);this.program=a.program!==void 0?a.program:function(){}};THREE.ParticleCanvasMaterial.prototype=new THREE.Material;THREE.ParticleCanvasMaterial.prototype.constructor=THREE.ParticleCanvasMaterial;
THREE.Texture=function(a,b,c,d,e,g){this.id=THREE.TextureCount++;this.image=a;this.mapping=b!==void 0?b:new THREE.UVMapping;this.wrapS=c!==void 0?c:THREE.ClampToEdgeWrapping;this.wrapT=d!==void 0?d:THREE.ClampToEdgeWrapping;this.magFilter=e!==void 0?e:THREE.LinearFilter;this.minFilter=g!==void 0?g:THREE.LinearMipMapLinearFilter;this.offset=new THREE.Vector2(0,0);this.repeat=new THREE.Vector2(1,1);this.needsUpdate=!1};
THREE.Texture.prototype={constructor:THREE.Texture,clone:function(){var a=new THREE.Texture(this.image,this.mapping,this.wrapS,this.wrapT,this.magFilter,this.minFilter);a.offset.copy(this.offset);a.repeat.copy(this.repeat);return a}};THREE.TextureCount=0;THREE.MultiplyOperation=0;THREE.MixOperation=1;THREE.CubeReflectionMapping=function(){};THREE.CubeRefractionMapping=function(){};THREE.LatitudeReflectionMapping=function(){};THREE.LatitudeRefractionMapping=function(){};
THREE.SphericalReflectionMapping=function(){};THREE.SphericalRefractionMapping=function(){};THREE.UVMapping=function(){};THREE.RepeatWrapping=0;THREE.ClampToEdgeWrapping=1;THREE.MirroredRepeatWrapping=2;THREE.NearestFilter=3;THREE.NearestMipMapNearestFilter=4;THREE.NearestMipMapLinearFilter=5;THREE.LinearFilter=6;THREE.LinearMipMapNearestFilter=7;THREE.LinearMipMapLinearFilter=8;THREE.ByteType=9;THREE.UnsignedByteType=10;THREE.ShortType=11;THREE.UnsignedShortType=12;THREE.IntType=13;
THREE.UnsignedIntType=14;THREE.FloatType=15;THREE.AlphaFormat=16;THREE.RGBFormat=17;THREE.RGBAFormat=18;THREE.LuminanceFormat=19;THREE.LuminanceAlphaFormat=20;THREE.Particle=function(a){THREE.Object3D.call(this);this.materials=a instanceof Array?a:[a]};THREE.Particle.prototype=new THREE.Object3D;THREE.Particle.prototype.constructor=THREE.Particle;THREE.Line=function(a,b,c){THREE.Object3D.call(this);this.geometry=a;this.materials=b instanceof Array?b:[b];this.type=c!=void 0?c:THREE.LineStrip};
THREE.LineStrip=0;THREE.LinePieces=1;THREE.Line.prototype=new THREE.Object3D;THREE.Line.prototype.constructor=THREE.Line;
THREE.Mesh=function(a,b){THREE.Object3D.call(this);this.geometry=a;this.materials=b&&b.length?b:[b];this.overdraw=!1;if(this.geometry&&(this.geometry.boundingSphere||this.geometry.computeBoundingSphere(),this.boundRadius=a.boundingSphere.radius,this.geometry.morphTargets.length)){this.morphTargetBase=-1;this.morphTargetForcedOrder=[];this.morphTargetInfluences=[];this.morphTargetDictionary={};for(var c=0;c<this.geometry.morphTargets.length;c++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[c].name]=
c}};THREE.Mesh.prototype=new THREE.Object3D;THREE.Mesh.prototype.constructor=THREE.Mesh;THREE.Mesh.prototype.supr=THREE.Object3D.prototype;THREE.Mesh.prototype.getMorphTargetIndexByName=function(a){if(this.morphTargetDictionary[a]!==void 0)return this.morphTargetDictionary[a];console.log("THREE.Mesh.getMorphTargetIndexByName: morph target "+a+" does not exist. Returning 0.");return 0};
THREE.Bone=function(a){THREE.Object3D.call(this);this.skin=a;this.skinMatrix=new THREE.Matrix4;this.hasNoneBoneChildren=!1};THREE.Bone.prototype=new THREE.Object3D;THREE.Bone.prototype.constructor=THREE.Bone;THREE.Bone.prototype.supr=THREE.Object3D.prototype;
THREE.Bone.prototype.update=function(a,b,c){this.matrixAutoUpdate&&(b|=this.updateMatrix());if(b||this.matrixWorldNeedsUpdate)a?this.skinMatrix.multiply(a,this.matrix):this.skinMatrix.copy(this.matrix),this.matrixWorldNeedsUpdate=!1,b=!0;var d,e=this.children.length;if(this.hasNoneBoneChildren){this.matrixWorld.multiply(this.skin.matrixWorld,this.skinMatrix);for(d=0;d<e;d++)a=this.children[d],a instanceof THREE.Bone?a.update(this.skinMatrix,b,c):a.update(this.matrixWorld,!0,c)}else for(d=0;d<e;d++)this.children[d].update(this.skinMatrix,
b,c)};THREE.Bone.prototype.addChild=function(a){if(this.children.indexOf(a)===-1&&(a.parent!==void 0&&a.parent.removeChild(a),a.parent=this,this.children.push(a),!(a instanceof THREE.Bone)))this.hasNoneBoneChildren=!0};THREE.Scene=function(){THREE.Object3D.call(this);this.matrixAutoUpdate=!1;this.collisions=this.overrideMaterial=this.fog=null;this.objects=[];this.lights=[];this.__objectsAdded=[];this.__objectsRemoved=[]};THREE.Scene.prototype=new THREE.Object3D;THREE.Scene.prototype.constructor=THREE.Scene;
THREE.Scene.prototype.supr=THREE.Object3D.prototype;THREE.Scene.prototype.add=function(a){this.supr.add.call(this,a);this.addChildRecurse(a)};THREE.Scene.prototype.addChildRecurse=function(a){if(a instanceof THREE.Light)this.lights.indexOf(a)===-1&&this.lights.push(a);else if(!(a instanceof THREE.Camera||a instanceof THREE.Bone)&&this.objects.indexOf(a)===-1)this.objects.push(a),this.__objectsAdded.push(a);for(var b=0;b<a.children.length;b++)this.addChildRecurse(a.children[b])};
THREE.Scene.prototype.remove=function(a){this.supr.remove.call(this,a);this.removeChildRecurse(a)};THREE.Scene.prototype.removeChildRecurse=function(a){if(a instanceof THREE.Light){var b=this.lights.indexOf(a);b!==-1&&this.lights.splice(b,1)}else a instanceof THREE.Camera||(b=this.objects.indexOf(a),b!==-1&&(this.objects.splice(b,1),this.__objectsRemoved.push(a)));for(b=0;b<a.children.length;b++)this.removeChildRecurse(a.children[b])};
THREE.Scene.prototype.addChild=function(a){console.warn("DEPRECATED: Scene.addChild() is now Scene.add()");this.add(a)};THREE.Scene.prototype.addObject=function(a){console.warn("DEPRECATED: Scene.addObject() is now Scene.add()");this.add(a)};THREE.Scene.prototype.addLight=function(a){console.warn("DEPRECATED: Scene.addLight() is now Scene.add()");this.add(a)};THREE.Scene.prototype.removeChild=function(a){console.warn("DEPRECATED: Scene.removeChild() is now Scene.remove()");this.remove(a)};
THREE.Scene.prototype.removeObject=function(a){console.warn("DEPRECATED: Scene.removeObject() is now Scene.remove()");this.remove(a)};THREE.Scene.prototype.removeLight=function(a){console.warn("DEPRECATED: Scene.removeLight() is now Scene.remove()");this.remove(a)};
THREE.CanvasRenderer=function(a){function b(a){if(u!=a)k.globalAlpha=u=a}function c(a){if(s!=a){switch(a){case THREE.NormalBlending:k.globalCompositeOperation="source-over";break;case THREE.AdditiveBlending:k.globalCompositeOperation="lighter";break;case THREE.SubtractiveBlending:k.globalCompositeOperation="darker"}s=a}}function d(a){if(K!=a)k.strokeStyle=K=a}function e(a){if(P!=a)k.fillStyle=P=a}var g=this,f=null,h=new THREE.Projector,a=a||{},j=a.canvas!==void 0?a.canvas:document.createElement("canvas"),
l,o,i,n,k=j.getContext("2d"),p=new THREE.Color(0),q=0,u=1,s=0,K=null,P=null,y=null,L=null,M=null,r,m,z,A,R=new THREE.RenderableVertex,S=new THREE.RenderableVertex,E,I,G,H,N,O,U,D,oa,v,J,F,w=new THREE.Color(0),C=new THREE.Color(0),t=new THREE.Color(0),B=new THREE.Color(0),T=new THREE.Color(0),ya=[],da,Y,aa,V,Da,Ea,Fa,Ga,Ha,Ia,ja=new THREE.Rectangle,Z=new THREE.Rectangle,X=new THREE.Rectangle,za=!1,ba=new THREE.Color,$=new THREE.Color,sa=new THREE.Color,ta=new THREE.Color,Q=new THREE.Vector3,pa,qa,
Aa,ca,ra,ua,a=16;pa=document.createElement("canvas");pa.width=pa.height=2;qa=pa.getContext("2d");qa.fillStyle="rgba(0,0,0,1)";qa.fillRect(0,0,2,2);Aa=qa.getImageData(0,0,2,2);ca=Aa.data;ra=document.createElement("canvas");ra.width=ra.height=a;ua=ra.getContext("2d");ua.translate(-a/2,-a/2);ua.scale(a,a);a--;this.domElement=j;this.sortElements=this.sortObjects=this.autoClear=!0;this.data={vertices:0,faces:0};this.setSize=function(a,b){l=a;o=b;i=Math.floor(l/2);n=Math.floor(o/2);j.width=l;j.height=o;
ja.set(-i,-n,i,n);Z.set(-i,-n,i,n);u=1;s=0;M=L=y=P=K=null};this.setClearColor=function(a,b){p.copy(a);q=b;Z.set(-i,-n,i,n)};this.setClearColorHex=function(a,b){p.setHex(a);q=b;Z.set(-i,-n,i,n)};this.clear=function(){k.setTransform(1,0,0,-1,i,n);Z.isEmpty()||(Z.minSelf(ja),Z.inflate(2),q<1&&k.clearRect(Math.floor(Z.getX()),Math.floor(Z.getY()),Math.floor(Z.getWidth()),Math.floor(Z.getHeight())),q>0&&(c(THREE.NormalBlending),b(1),e("rgba("+Math.floor(p.r*255)+","+Math.floor(p.g*255)+","+Math.floor(p.b*
255)+","+q+")"),k.fillRect(Math.floor(Z.getX()),Math.floor(Z.getY()),Math.floor(Z.getWidth()),Math.floor(Z.getHeight()))),Z.empty())};this.render=function(a,l){function j(a){var b,c,d,e=a.lights;$.setRGB(0,0,0);sa.setRGB(0,0,0);ta.setRGB(0,0,0);a=0;for(b=e.length;a<b;a++)c=e[a],d=c.color,c instanceof THREE.AmbientLight?($.r+=d.r,$.g+=d.g,$.b+=d.b):c instanceof THREE.DirectionalLight?(sa.r+=d.r,sa.g+=d.g,sa.b+=d.b):c instanceof THREE.PointLight&&(ta.r+=d.r,ta.g+=d.g,ta.b+=d.b)}function o(a,b,c,d){var e,
f,g,h,k=a.lights,a=0;for(e=k.length;a<e;a++)f=k[a],g=f.color,f instanceof THREE.DirectionalLight?(h=c.dot(f.position),h<=0||(h*=f.intensity,d.r+=g.r*h,d.g+=g.g*h,d.b+=g.b*h)):f instanceof THREE.PointLight&&(h=c.dot(Q.sub(f.position,b).normalize()),h<=0||(h*=f.distance==0?1:1-Math.min(b.distanceTo(f.position)/f.distance,1),h!=0&&(h*=f.intensity,d.r+=g.r*h,d.g+=g.g*h,d.b+=g.b*h)))}function p(a,f,g){b(g.opacity);c(g.blending);var h,l,o,j,Ba,m;if(g instanceof THREE.ParticleBasicMaterial){if(g.map)j=g.map.image,
Ba=j.width>>1,m=j.height>>1,g=f.scale.x*i,o=f.scale.y*n,h=g*Ba,l=o*m,X.set(a.x-h,a.y-l,a.x+h,a.y+l),ja.intersects(X)&&(k.save(),k.translate(a.x,a.y),k.rotate(-f.rotation),k.scale(g,-o),k.translate(-Ba,-m),k.drawImage(j,0,0),k.restore())}else g instanceof THREE.ParticleCanvasMaterial&&(h=f.scale.x*i,l=f.scale.y*n,X.set(a.x-h,a.y-l,a.x+h,a.y+l),ja.intersects(X)&&(d(g.color.getContextStyle()),e(g.color.getContextStyle()),k.save(),k.translate(a.x,a.y),k.rotate(-f.rotation),k.scale(h,l),g.program(k),k.restore()))}
function q(a,e,f,g){b(g.opacity);c(g.blending);k.beginPath();k.moveTo(a.positionScreen.x,a.positionScreen.y);k.lineTo(e.positionScreen.x,e.positionScreen.y);k.closePath();if(g instanceof THREE.LineBasicMaterial){a=g.linewidth;if(y!=a)k.lineWidth=y=a;a=g.linecap;if(L!=a)k.lineCap=L=a;a=g.linejoin;if(M!=a)k.lineJoin=M=a;d(g.color.getContextStyle());k.stroke();X.inflate(g.linewidth*2)}}function s(a,d,e,f,h,k,i,j,n){g.data.vertices+=3;g.data.faces++;b(j.opacity);c(j.blending);E=a.positionScreen.x;I=a.positionScreen.y;
G=d.positionScreen.x;H=d.positionScreen.y;N=e.positionScreen.x;O=e.positionScreen.y;K(E,I,G,H,N,O);if(j instanceof THREE.MeshBasicMaterial)if(j.map)j.map.mapping instanceof THREE.UVMapping&&(V=i.uvs[0],Ca(E,I,G,H,N,O,V[f].u,V[f].v,V[h].u,V[h].v,V[k].u,V[k].v,j.map));else if(j.envMap){if(j.envMap.mapping instanceof THREE.SphericalReflectionMapping)a=l.matrixWorldInverse,Q.copy(i.vertexNormalsWorld[0]),Da=(Q.x*a.n11+Q.y*a.n12+Q.z*a.n13)*0.5+0.5,Ea=-(Q.x*a.n21+Q.y*a.n22+Q.z*a.n23)*0.5+0.5,Q.copy(i.vertexNormalsWorld[1]),
Fa=(Q.x*a.n11+Q.y*a.n12+Q.z*a.n13)*0.5+0.5,Ga=-(Q.x*a.n21+Q.y*a.n22+Q.z*a.n23)*0.5+0.5,Q.copy(i.vertexNormalsWorld[2]),Ha=(Q.x*a.n11+Q.y*a.n12+Q.z*a.n13)*0.5+0.5,Ia=-(Q.x*a.n21+Q.y*a.n22+Q.z*a.n23)*0.5+0.5,Ca(E,I,G,H,N,O,Da,Ea,Fa,Ga,Ha,Ia,j.envMap)}else j.wireframe?fa(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(j.color);else if(j instanceof THREE.MeshLambertMaterial)j.map&&!j.wireframe&&(j.map.mapping instanceof THREE.UVMapping&&(V=i.uvs[0],Ca(E,I,G,H,N,O,V[f].u,V[f].v,
V[h].u,V[h].v,V[k].u,V[k].v,j.map)),c(THREE.SubtractiveBlending)),za?!j.wireframe&&j.shading==THREE.SmoothShading&&i.vertexNormalsWorld.length==3?(C.r=t.r=B.r=$.r,C.g=t.g=B.g=$.g,C.b=t.b=B.b=$.b,o(n,i.v1.positionWorld,i.vertexNormalsWorld[0],C),o(n,i.v2.positionWorld,i.vertexNormalsWorld[1],t),o(n,i.v3.positionWorld,i.vertexNormalsWorld[2],B),T.r=(t.r+B.r)*0.5,T.g=(t.g+B.g)*0.5,T.b=(t.b+B.b)*0.5,aa=va(C,t,B,T),la(E,I,G,H,N,O,0,0,1,0,0,1,aa)):(ba.r=$.r,ba.g=$.g,ba.b=$.b,o(n,i.centroidWorld,i.normalWorld,
ba),w.r=Math.max(0,Math.min(j.color.r*ba.r,1)),w.g=Math.max(0,Math.min(j.color.g*ba.g,1)),w.b=Math.max(0,Math.min(j.color.b*ba.b,1)),j.wireframe?fa(w,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(w)):j.wireframe?fa(j.color,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(j.color);else if(j instanceof THREE.MeshDepthMaterial)da=l.near,Y=l.far,C.r=C.g=C.b=1-ka(a.positionScreen.z,da,Y),t.r=t.g=t.b=1-ka(d.positionScreen.z,da,Y),B.r=B.g=B.b=1-ka(e.positionScreen.z,da,Y),
T.r=(t.r+B.r)*0.5,T.g=(t.g+B.g)*0.5,T.b=(t.b+B.b)*0.5,aa=va(C,t,B,T),la(E,I,G,H,N,O,0,0,1,0,0,1,aa);else if(j instanceof THREE.MeshNormalMaterial)w.r=ma(i.normalWorld.x),w.g=ma(i.normalWorld.y),w.b=ma(i.normalWorld.z),j.wireframe?fa(w,j.wireframeLinewidth,j.wireframeLinecap,j.wireframeLinejoin):ga(w)}function u(a,d,e,f,h,j,k,i,n){g.data.vertices+=4;g.data.faces++;b(i.opacity);c(i.blending);if(i.map||i.envMap)s(a,d,f,0,1,3,k,i,n),s(h,e,j,1,2,3,k,i,n);else if(E=a.positionScreen.x,I=a.positionScreen.y,
G=d.positionScreen.x,H=d.positionScreen.y,N=e.positionScreen.x,O=e.positionScreen.y,U=f.positionScreen.x,D=f.positionScreen.y,oa=h.positionScreen.x,v=h.positionScreen.y,J=j.positionScreen.x,F=j.positionScreen.y,i instanceof THREE.MeshBasicMaterial)P(E,I,G,H,N,O,U,D),i.wireframe?fa(i.color,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):ga(i.color);else if(i instanceof THREE.MeshLambertMaterial)za?!i.wireframe&&i.shading==THREE.SmoothShading&&k.vertexNormalsWorld.length==4?(C.r=t.r=B.r=
T.r=$.r,C.g=t.g=B.g=T.g=$.g,C.b=t.b=B.b=T.b=$.b,o(n,k.v1.positionWorld,k.vertexNormalsWorld[0],C),o(n,k.v2.positionWorld,k.vertexNormalsWorld[1],t),o(n,k.v4.positionWorld,k.vertexNormalsWorld[3],B),o(n,k.v3.positionWorld,k.vertexNormalsWorld[2],T),aa=va(C,t,B,T),K(E,I,G,H,U,D),la(E,I,G,H,U,D,0,0,1,0,0,1,aa),K(oa,v,N,O,J,F),la(oa,v,N,O,J,F,1,0,1,1,0,1,aa)):(ba.r=$.r,ba.g=$.g,ba.b=$.b,o(n,k.centroidWorld,k.normalWorld,ba),w.r=Math.max(0,Math.min(i.color.r*ba.r,1)),w.g=Math.max(0,Math.min(i.color.g*
ba.g,1)),w.b=Math.max(0,Math.min(i.color.b*ba.b,1)),P(E,I,G,H,N,O,U,D),i.wireframe?fa(w,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):ga(w)):(P(E,I,G,H,N,O,U,D),i.wireframe?fa(i.color,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):ga(i.color));else if(i instanceof THREE.MeshNormalMaterial)w.r=ma(k.normalWorld.x),w.g=ma(k.normalWorld.y),w.b=ma(k.normalWorld.z),P(E,I,G,H,N,O,U,D),i.wireframe?fa(w,i.wireframeLinewidth,i.wireframeLinecap,i.wireframeLinejoin):ga(w);else if(i instanceof
THREE.MeshDepthMaterial)da=l.near,Y=l.far,C.r=C.g=C.b=1-ka(a.positionScreen.z,da,Y),t.r=t.g=t.b=1-ka(d.positionScreen.z,da,Y),B.r=B.g=B.b=1-ka(f.positionScreen.z,da,Y),T.r=T.g=T.b=1-ka(e.positionScreen.z,da,Y),aa=va(C,t,B,T),K(E,I,G,H,U,D),la(E,I,G,H,U,D,0,0,1,0,0,1,aa),K(oa,v,N,O,J,F),la(oa,v,N,O,J,F,1,0,1,1,0,1,aa)}function K(a,b,c,d,e,f){k.beginPath();k.moveTo(a,b);k.lineTo(c,d);k.lineTo(e,f);k.lineTo(a,b);k.closePath()}function P(a,b,c,d,e,f,g,h){k.beginPath();k.moveTo(a,b);k.lineTo(c,d);k.lineTo(e,
f);k.lineTo(g,h);k.lineTo(a,b);k.closePath()}function fa(a,b,c,e){if(y!=b)k.lineWidth=y=b;if(L!=c)k.lineCap=L=c;if(M!=e)k.lineJoin=M=e;d(a.getContextStyle());k.stroke();X.inflate(b*2)}function ga(a){e(a.getContextStyle());k.fill()}function Ca(a,b,c,d,f,g,h,i,j,l,o,n,m){if(m.image.width!=0){if(m.needsUpdate==!0||ya[m.id]==void 0){var p=m.wrapS==THREE.RepeatWrapping,q=m.wrapT==THREE.RepeatWrapping;ya[m.id]=k.createPattern(m.image,p&&q?"repeat":p&&!q?"repeat-x":!p&&q?"repeat-y":"no-repeat");m.needsUpdate=
!1}e(ya[m.id]);var p=m.offset.x/m.repeat.x,q=m.offset.y/m.repeat.y,r=(m.image.width-1)*m.repeat.x,m=(m.image.height-1)*m.repeat.y,h=(h+p)*r,i=(i+q)*m,j=(j+p)*r,l=(l+q)*m,o=(o+p)*r,n=(n+q)*m;c-=a;d-=b;f-=a;g-=b;j-=h;l-=i;o-=h;n-=i;p=1/(j*n-o*l);m=(n*c-l*f)*p;l=(n*d-l*g)*p;c=(j*f-o*c)*p;d=(j*g-o*d)*p;a=a-m*h-c*i;b=b-l*h-d*i;k.save();k.transform(m,l,c,d,a,b);k.fill();k.restore()}}function la(a,b,c,d,e,f,g,h,i,j,l,m,o){var n,p;n=o.width-1;p=o.height-1;g*=n;h*=p;i*=n;j*=p;l*=n;m*=p;c-=a;d-=b;e-=a;f-=b;
i-=g;j-=h;l-=g;m-=h;p=1/(i*m-l*j);n=(m*c-j*e)*p;j=(m*d-j*f)*p;c=(i*e-l*c)*p;d=(i*f-l*d)*p;a=a-n*g-c*h;b=b-j*g-d*h;k.save();k.transform(n,j,c,d,a,b);k.clip();k.drawImage(o,0,0);k.restore()}function va(a,b,c,d){var e=~~(a.r*255),f=~~(a.g*255),a=~~(a.b*255),g=~~(b.r*255),h=~~(b.g*255),b=~~(b.b*255),i=~~(c.r*255),j=~~(c.g*255),c=~~(c.b*255),k=~~(d.r*255),l=~~(d.g*255),d=~~(d.b*255);ca[0]=e<0?0:e>255?255:e;ca[1]=f<0?0:f>255?255:f;ca[2]=a<0?0:a>255?255:a;ca[4]=g<0?0:g>255?255:g;ca[5]=h<0?0:h>255?255:h;
ca[6]=b<0?0:b>255?255:b;ca[8]=i<0?0:i>255?255:i;ca[9]=j<0?0:j>255?255:j;ca[10]=c<0?0:c>255?255:c;ca[12]=k<0?0:k>255?255:k;ca[13]=l<0?0:l>255?255:l;ca[14]=d<0?0:d>255?255:d;qa.putImageData(Aa,0,0);ua.drawImage(pa,0,0);return ra}function ka(a,b,c){a=(a-b)/(c-b);return a*a*(3-2*a)}function ma(a){a=(a+1)*0.5;return a<0?0:a>1?1:a}function ha(a,b){var c=b.x-a.x,d=b.y-a.y,e=c*c+d*d;e!=0&&(e=1/Math.sqrt(e),c*=e,d*=e,b.x+=c,b.y+=d,a.x-=c,a.y-=d)}var wa,Ja,x,ea,ia,na,xa,W;this.autoClear?this.clear():k.setTransform(1,
0,0,-1,i,n);g.data.vertices=0;g.data.faces=0;f=h.projectScene(a,l,this.sortElements);(za=a.lights.length>0)&&j(a);wa=0;for(Ja=f.length;wa<Ja;wa++){x=f[wa];X.empty();if(x instanceof THREE.RenderableParticle){r=x;r.x*=i;r.y*=n;ea=0;for(ia=x.materials.length;ea<ia;)W=x.materials[ea++],W.opacity!=0&&p(r,x,W,a)}else if(x instanceof THREE.RenderableLine){if(r=x.v1,m=x.v2,r.positionScreen.x*=i,r.positionScreen.y*=n,m.positionScreen.x*=i,m.positionScreen.y*=n,X.addPoint(r.positionScreen.x,r.positionScreen.y),
X.addPoint(m.positionScreen.x,m.positionScreen.y),ja.intersects(X)){ea=0;for(ia=x.materials.length;ea<ia;)W=x.materials[ea++],W.opacity!=0&&q(r,m,x,W,a)}}else if(x instanceof THREE.RenderableFace3){if(r=x.v1,m=x.v2,z=x.v3,r.positionScreen.x*=i,r.positionScreen.y*=n,m.positionScreen.x*=i,m.positionScreen.y*=n,z.positionScreen.x*=i,z.positionScreen.y*=n,x.overdraw&&(ha(r.positionScreen,m.positionScreen),ha(m.positionScreen,z.positionScreen),ha(z.positionScreen,r.positionScreen)),X.add3Points(r.positionScreen.x,
r.positionScreen.y,m.positionScreen.x,m.positionScreen.y,z.positionScreen.x,z.positionScreen.y),ja.intersects(X)){ea=0;for(ia=x.meshMaterials.length;ea<ia;)if(W=x.meshMaterials[ea++],W instanceof THREE.MeshFaceMaterial){na=0;for(xa=x.faceMaterials.length;na<xa;)(W=x.faceMaterials[na++])&&W.opacity!=0&&s(r,m,z,0,1,2,x,W,a)}else W.opacity!=0&&s(r,m,z,0,1,2,x,W,a)}}else if(x instanceof THREE.RenderableFace4&&(r=x.v1,m=x.v2,z=x.v3,A=x.v4,r.positionScreen.x*=i,r.positionScreen.y*=n,m.positionScreen.x*=
i,m.positionScreen.y*=n,z.positionScreen.x*=i,z.positionScreen.y*=n,A.positionScreen.x*=i,A.positionScreen.y*=n,R.positionScreen.copy(m.positionScreen),S.positionScreen.copy(A.positionScreen),x.overdraw&&(ha(r.positionScreen,m.positionScreen),ha(m.positionScreen,A.positionScreen),ha(A.positionScreen,r.positionScreen),ha(z.positionScreen,R.positionScreen),ha(z.positionScreen,S.positionScreen)),X.addPoint(r.positionScreen.x,r.positionScreen.y),X.addPoint(m.positionScreen.x,m.positionScreen.y),X.addPoint(z.positionScreen.x,
z.positionScreen.y),X.addPoint(A.positionScreen.x,A.positionScreen.y),ja.intersects(X))){ea=0;for(ia=x.meshMaterials.length;ea<ia;)if(W=x.meshMaterials[ea++],W instanceof THREE.MeshFaceMaterial){na=0;for(xa=x.faceMaterials.length;na<xa;)(W=x.faceMaterials[na++])&&W.opacity!=0&&u(r,m,z,A,R,S,x,W,a)}else W.opacity!=0&&u(r,m,z,A,R,S,x,W,a)}Z.addRectangle(X)}k.setTransform(1,0,0,1,0,0)}};
THREE.RenderableVertex=function(){this.positionWorld=new THREE.Vector3;this.positionScreen=new THREE.Vector4;this.visible=!0};THREE.RenderableVertex.prototype.copy=function(a){this.positionWorld.copy(a.positionWorld);this.positionScreen.copy(a.positionScreen)};
THREE.RenderableFace3=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableFace4=function(){this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.v3=new THREE.RenderableVertex;this.v4=new THREE.RenderableVertex;this.centroidWorld=new THREE.Vector3;this.centroidScreen=new THREE.Vector3;this.normalWorld=new THREE.Vector3;this.vertexNormalsWorld=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];this.faceMaterials=this.meshMaterials=null;this.overdraw=!1;this.uvs=[[]];this.z=null};
THREE.RenderableObject=function(){this.z=this.object=null};THREE.RenderableParticle=function(){this.rotation=this.z=this.y=this.x=null;this.scale=new THREE.Vector2;this.materials=null};THREE.RenderableLine=function(){this.z=null;this.v1=new THREE.RenderableVertex;this.v2=new THREE.RenderableVertex;this.materials=null};
