uniform sampler2D tex0;
uniform float time;
varying vec2 texcoord;
varying vec3 spdvec;

const float steps = 16.0;

void main()
{
	vec2 xy = texcoord.xy;
	vec3 dir = normalize(-1.0+2.0*texture2D(tex0, xy).rgb)*(0.25*spdvec)/steps;
	vec3 color = vec3(0.0);

	for (float i = 0.0; i < steps; i += 1.0) {
		color += texture2D(tex0, xy).xyz;
		//xy += dir.xy*dir.z*(0.75f+0.5f*sin(time));
		xy += dir.xy*dir.z*(0.75+pow(0.5,4.0)*smoothstep( 0.2, 0.7, sin(time)) );
	}
	
	color /= steps;

	gl_FragColor = vec4(color, 1.0);
}
