SetupWindow(800, 600, "Hello World");

w = new World();
sphere = new WorldObject(w, "data/primitives/torus_knot.dae");
sphere.SetProgram("data/shaders/envmapping.cg");
sphere.SetParameters({"DiffuseMap":"data/textures/checkerboard.png"});

fb = new Framebuffer(800, 600, 0, PixelFormatR8G8B8A8, true, true);
filters = new Filters();

w.SetCameraPosition(30, 30, 30);
w.SetCameraTarget(0, 0, 0);

while (Update()) 
{
	Print(GetFPS() + "\n");
	sphere.SetRotation(GetTime()*40, 0, 0, 1);
	
	PushFramebuffer(fb);
    Clear(0,0,0,1);
    w.Render();
    PopFramebuffer();
    
    filters.Glow(fb, 0.5, 10);
    fb.Blit();
}