
SetupWindow(800, 600, "Collision demo");

w = new World();
scene = new WorldObject(w, "scene.dae{Path=data/collision_demo}");
player = new WorldObject(w, "player.dae{Path=data/collision_demo}");

player.SetParameters({"DiffuseMap": "data/textures/checkerboard.png"});

cs = new CollisionScene("scene.dae{Path=data/collision_demo}");

playerPos = [0, 0, 10];

w.SetCameraPosition(-60, -200, 200);

while (Update())
{
	deltaTime = GetFrameTime();

	ClearDepth(1.0);
	ClearColor(0.4, 0.45, 0.65, 1.0);
	
	oldPos = playerPos.slice();
		
	if (KeyDown(KeyUpArrow)) playerPos[1] += deltaTime * 50;
	if (KeyDown(KeyDownArrow)) playerPos[1] -= deltaTime * 50;
	if (KeyDown(KeyRightArrow)) playerPos[0] += deltaTime * 50;
	if (KeyDown(KeyLeftArrow)) playerPos[0] -= deltaTime * 50;
	
	playerBox = new BoxAligned([playerPos[0]-18, playerPos[1]-5, playerPos[2]+2], [playerPos[0]+18, playerPos[1]+5, playerPos[2]+10]);
	
	tempBox = cs.Solve(playerBox, oldPos);
	playerBox = new BoxAligned(tempBox.Min, tempBox.Max);
	playerPos = playerBox.GetCenter();
	playerPos[2] = 0;	
	
	player.SetPosition(playerPos[0], playerPos[1], playerPos[2]);
	
	w.Render();
}