#include "Connection.h"

#include <stdio.h>
#include <string.h>
#include <sys/types.h>

#ifndef _WIN32
#include <sys/socket.h>
#include <netdb.h>
#include <arpa/inet.h>
#include <unistd.h>
#endif
#include <fcntl.h>
#include <errno.h>
#include <cassert>

#include <iostream>
#include <sstream>
#include <exception>

#ifdef _WIN32
#pragma comment(lib, "Ws2_32.lib")
#include <winsock2.h>
#endif

class TCPConnection : public Connection {
public:
    int fd;
    std::stringstream buffer;
#ifdef _WIN32
    SOCKET _socket;
#endif

    TCPConnection();
    ~TCPConnection();
    void connect(const char *hostname, const char *port);
    int write(char *buf, int len);
    int write(std::string string);
    int read(char *buf, int len);
    std::string readall();
    std::string readLine();
    void close();
    void flush();
    bool isConnected() const;
    int readLine2(char* const buf, int max);
};
