#include "TCPConnection.h"
#include "vec2.h"
#include "GameState.h"
#include <iostream>
#include <sstream>
#include <cassert>

using namespace std;

template <typename T>
class GameConnection {
public:
    T *connection;
    bool started;
    
    GameConnection(T *conn) {
        connection = conn;
        started = false;
    }

    void sendName(string name) {
        string tmp = string("NAME ") + name + string("\n");
        cout << "setname " << tmp << endl;
        connection->write(tmp);
    }

    void sendWind(vec2 d) {

        std::stringstream tmp;
        tmp << "WIND ";
        tmp << d.x << " " << d.y << "\n";
        connection->write(tmp.str());
        std::string line = connection->readLine();
        while (line.empty())
            line = connection->readLine();
        assert(line == "OK");
    }

    void waitForStart() {
        if (!started) {
            string line;
            while (line.empty() || line != "START") {
                line = connection->readLine();
            }
            started = true;
        }
    }
    
    GameState* getState() {


        connection->write("GET_STATE\n");
        connection->flush();

        GameState *state = new GameState();

        while (connection->isConnected()) {
            //cout << "TEST 2" << endl;
            std::string line = connection->readLine();
            //logfile << line << endl;
            stringstream ss(line);
            //cout << "LINE: " << line << endl;

            if (!line.empty()) {
                string key;
                ss >> key;

                if (key == "BEGIN_STATE") {
                    int iteration;
                    ss >> iteration;
                    state->iteration = iteration;
                    //cout << "Receiving data for iteration " << iteration << endl;
                } else if (key == "END_STATE") {
                    //cout << "Done" << endl;
                    break;
                } else if (key == "THUNDERSTORM") {
                    float px, py, vx, vy, vapor;
                    ss >> px >> py >> vx >> vy >> vapor;
                    //state->addThunderStorm(px, py, vx, vy, vapor);
                    state->addThunderStorm(vec2(px, py), vec2(vx, vy), vapor);

                } else if (key == "RAINCLOUD") {
                    float px, py, vx, vy, vapor;
                    ss >> px >> py >> vx >> vy >> vapor;
                    state->addRainCloud(vec2(px, py), vec2(vx, vy), vapor);

                } else if (key == "YOU") {
                    int index;
                    ss >> index;
                    //cout << "my index " << index << endl;
                    state->myIndex(index);
                }
            }
        }
        return state;
    }

    GameState *getState2() {
        GameState *state = new GameState();

        const int buflen = 1024;
        char buf[buflen+1];
        char* args;

        int len;
        int player = -1;
        int tci = 0;

        connection->write(buf, sprintf(buf, "GET_STATE\n"));
        //_send(buf, sprintf(buf, "GET_STATE\n"));
        do {
            len = connection->readLine2(buf, buflen+1);
            //printf("%s\n", buf);
            args = strchr(buf, ' ');
            if (args != NULL) {
                *args = 0;
                args++;
            }
            if (!strcmp(buf,"BEGIN_STATE"))
                sscanf(args,"%d", &state->iteration);
            if (!strcmp(buf,"YOU"))
                sscanf(args,"%zd", &state->myindex);
            if (!strcmp(buf,"THUNDERSTORM")) {
                float x, y, vx, vy, vap;
                ThunderStorm *s = new ThunderStorm();
                sscanf(args,"%f %f %f %f %f", &s->p.x, &s->p.y, &s->v.x, &s->v.y, &s->vapor);
                state->clouds.push_back(s);
                //if (tci == player)
                    //s.me = c;
                //else
                    //s.tc.push_back(new ThunderStorm(c);
                //tci++;
            }
            if (!strcmp(buf,"RAINCLOUD")) {
                RainCloud *s = new RainCloud();
                sscanf(args,"%f %f %f %f %f", &s->p.x, &s->p.y, &s->v.x, &s->v.y, &s->vapor);
                //sscanf(args,"%f %f %f %f %f", c.pos.x, c.pos.y, c.vel.x, c.vel.y, c.vap);
                state->clouds.push_back(s);
                //s.rc.push_back(c);
            }
            if (!strcmp(buf,"END_STATE"))
                break;
        } while (len > 0);

        return state;
    }
};
